package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpExtReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpExtRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 索赔补发订单扩展字段服务接口
*
* @author xiuji
* @since 2022-10-28
*/
@Api(tags = {"索赔补发订单扩展字段服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-IPlatformOrderSpExtQueryApi",
        name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
        path = "/v1/platform/spExt",
        url = "${yundt.cube.center.transform.api:}")
public interface IPlatformOrderSpExtQueryApi {

    /**
    * 根据id查询索赔补发订单扩展字段
    *
    * @param id 索赔补发订单扩展字段id
    * @return   索赔补发订单扩展字段数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询索赔补发订单扩展字段", notes = "根据id查询索赔补发订单扩展字段")
    RestResponse<PlatformOrderSpExtRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 索赔补发订单扩展字段分页数据
    *
    * @param filter   索赔补发订单扩展字段查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 索赔补发订单扩展字段分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "索赔补发订单扩展字段分页数据", notes = "根据filter查询条件查询索赔补发订单扩展字段数据，filter=PlatformOrderSpExtReqDto")
    RestResponse<PageInfo<PlatformOrderSpExtRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据id查询索赔补发订单扩展字段
     *
     * @return   索赔补发订单扩展字段数据
     */
    @GetMapping("/queryByPlatformOrderId")
    @ApiOperation(value = "根据id查询索赔补发订单扩展字段", notes = "根据id查询索赔补发订单扩展字段")
    RestResponse<PlatformOrderSpExtRespDto> queryByPlatformOrderId(@RequestParam("platformOrderId") Long platformOrderId);
}
