/**
 * @(#) PlatformOrderType.java 1.0 2022/3/10/010
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 平台订单类型枚举
 *
 * @author zimu
 * @date 2022/3/10/010
 * @since 1.0.0
 */
public enum PlatformOrderType {


    // 订单类型 0-大B订单 1-积分订单 2-普通订单
    TYPE_0(0, "大B订单"),
    TYPE_1(1, "积分订单"),
    TYPE_2(2, "普通订单"),
    ;

    PlatformOrderType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public final int code;
    public final String desc;
    public static final Map<Integer, PlatformOrderType> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    public static final Map<Integer, String> CODE_DESC_MAP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));

    public static PlatformOrderType forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
