package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpAuditPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpAuditReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpAuditRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 索赔补发订单审核记录服务接口
*
* @author xiuji
* @since 2022-10-28
*/
@Api(tags = {"索赔补发订单审核记录服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-IPlatformOrderSpAuditQueryApi",
        name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
        path = "/v1/platform/spAudit",
        url = "${yundt.cube.center.transform.api:}")
public interface IPlatformOrderSpAuditQueryApi {

    /**
    * 根据id查询索赔补发订单审核记录
    *
    * @param id 索赔补发订单审核记录id
    * @return   索赔补发订单审核记录数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询索赔补发订单审核记录", notes = "根据id查询索赔补发订单审核记录")
    RestResponse<PlatformOrderSpAuditRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 索赔补发订单审核记录分页数据
    *
    * @return 索赔补发订单审核记录分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "索赔补发订单审核记录分页数据", notes = "查询索赔补发订单审核记录数据")
    RestResponse<PageInfo<PlatformOrderSpAuditRespDto>> queryByPage(@RequestBody PlatformOrderSpAuditPageQueryReqDto pageQueryReqDto);

}
