/**
 * @(#) IPCPOrderApi.java 1.0 2022/3/8/008
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAuditOptReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * pcp销售订单服务
 *
 * @author zimu
 * @date 2022/3/8/008
 * @since 1.0.0
 */
@Api(tags = {"pcp销售订单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-transform-api-IPlatformOrderApi",
        name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
        path = "/v1/pcp/order",
        url = "${yundt.cube.center.transform.api:}"
)
public interface IPcpOrderApi {

    /**
     * （提供第三方）新增pcp销售订单转单流
     *
     * @param pcpOrderReqDto pcp销售订单请求对象
     * @return 处理结果
     */
    @PostMapping("/transform/addProcess")
    @ApiOperation(value = "（提供第三方）新增pcp销售订单转单流", notes = "（提供第三方）新增pcp销售订单转单流")
    RestResponse<Long> addPcpOrderProcess(@RequestBody PcpOrderReqDto pcpOrderReqDto);

    /**
     * （提供第三方营养家）新增pcp销售订单转单流
     *
     * @param pcpOrderReqDtos pcp销售订单请求对象
     * @return 处理结果
     */
    @PostMapping("/transform/yyj/addProcess")
    @ApiOperation(value = "（提供第三方营养家）新增pcp销售订单转单流", notes = "（提供第三方营养家）新增pcp销售订单转单流")
    RestResponse<Void> addPcpYyjOrderProcess(@RequestBody List<PcpOrderReqDto> pcpOrderReqDtos);

    /**
     * 保存pcp销售订单转单数据
     *
     * @param pcpOrderReqDto pcp销售订单请求对象
     * @return 处理结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "保存pcp销售订单转单数据", notes = "保存pcp销售订单转单数据")
    RestResponse<Long> savePcpOrder(@RequestBody PcpOrderReqDto pcpOrderReqDto);

    /**
     * pcp销售订单-转单操作
     *
     * @param pcpOrderReqDto pcp销售订单请求对象
     * @return 处理结果
     */
    @PostMapping("/opt/transform/")
    @ApiOperation(value = "pcp销售订单-转单操作", notes = "pcp销售订单-转单操作")
    RestResponse<Void> transformPcpOrder(@RequestBody PcpOrderReqDto pcpOrderReqDto);

    /**
     * pcp销售订单-转单操作
     *
     * @param id 平台订单id
     * @return 处理结果
     */
    @PostMapping("/transform/{id}")
    @ApiOperation(value = "pcp销售订单-转单操作", notes = "pcp销售订单-转单操作")
    RestResponse<Void> transformPcpOrder(@PathVariable("id") Long id);

    /**
     * pcp销售订单-作废操作
     *
     * @param pcpOrderReqDto pcp销售订单请求对象
     * @return 处理结果
     */
    @PostMapping("/abolish")
    @ApiOperation(value = "pcp销售订单-作废操作", notes = "新增pcp销售订单-作废操作")
    RestResponse<Void> abolishPcpOrder(@RequestBody PcpOrderReqDto pcpOrderReqDto);

    /**
     * （提供第三方）取消平台订单
     *
     * @param platformOrderCancelReqDto 平台订单号
     * @return 处理结果
     */
    @PostMapping("/platformOrder/cancel/")
    @ApiOperation(value = "（提供第三方）取消平台订单", notes = "（提供第三方）取消平台订单")
    RestResponse<Void> cancelPlatformOrder(@RequestBody PlatformOrderCancelReqDto platformOrderCancelReqDto);

    /**
     * （提供第三方）财务未后置订单校验
     *
     * @param pcpOrderReqDto pcp销售订单请求对象
     * @return 处理结果
     */
    @PostMapping("/transform/checkPcpOrder")
    @ApiOperation(value = "（提供第三方）财务未后置订单校验", notes = "（提供第三方）财务未后置订单校验")
    RestResponse<Boolean> checkPcpOrder(@RequestBody PcpOrderReqDto pcpOrderReqDto);

    @PostMapping("/transform/logisticsAudit")
    @ApiOperation(value = "物流商审核操作", notes = "物流商审核操作")
    RestResponse<Void> logisticsAudit(@RequestBody PlatformOrderAuditOptReqDto auditOptReqDto);

    @PostMapping("/transform/warehouseAudit")
    @ApiOperation(value = "仓库审核操作", notes = "仓库审核操作")
    RestResponse<Void> warehouseAudit(@RequestBody PlatformOrderAuditOptReqDto auditOptReqDto);

    @PostMapping("/transform/yyjRefTransformOpt")
    @ApiOperation(value = "营养家重新转单操作-批量", notes = "营养家重新转单操作-批量 parentPlatformNo：渠道父单号；refTransform 是否直接转单 TRUE:是，FALSE:否")
    RestResponse<Void> yyjRefTransformOpt(@RequestParam("parentPlatformNo") String parentPlatformNo,
                                          @RequestParam("refTransform") Boolean refTransform);

}
