package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* PCP订单渠道表服务接口
*
* @author yuangui
* @since 2022-04-01
*/
@Api(tags = {"PCP订单渠道表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-IPcpOrderChannelApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/orderChannel",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPcpOrderChannelApi {

/**
* 新增PCP订单渠道表
*
* @param addReqDto PCP订单渠道表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增PCP订单渠道表", notes = "新增PCP订单渠道表")
RestResponse<Long> addPcpOrderChannel(@RequestBody @Validated(PcpOrderChannelReqDto.Add.class) PcpOrderChannelReqDto addReqDto);

    /**
    * 修改PCP订单渠道表
    *
    * @param modifyReqDto PCP订单渠道表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改PCP订单渠道表", notes = "修改PCP订单渠道表")
    RestResponse<Void> modifyPcpOrderChannel(@RequestBody @Validated(PcpOrderChannelReqDto.Edit.class) PcpOrderChannelReqDto modifyReqDto);

    /**
    * 删除PCP订单渠道表
    *
    * @param ids        PCP订单渠道表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除PCP订单渠道表", notes = "删除PCP订单渠道表")
    RestResponse<Void> removePcpOrderChannel(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
