package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderRemarkReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRemarkRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 平台订单备注表服务接口
*
* @author zimu
* @since 2022-03-08
*/
@Api(tags = {"平台订单备注表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-IPlatformOrderRemarkApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/orderRemark",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPlatformOrderRemarkApi {

/**
* 新增平台订单备注表
*
* @param addReqDto 平台订单备注表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增平台订单备注表", notes = "新增平台订单备注表")
RestResponse<Long> addPlatformOrderRemark(@RequestBody PlatformOrderRemarkReqDto addReqDto);

    /**
    * 修改平台订单备注表
    *
    * @param modifyReqDto 平台订单备注表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改平台订单备注表", notes = "修改平台订单备注表")
    RestResponse<Void> modifyPlatformOrderRemark(@RequestBody PlatformOrderRemarkReqDto modifyReqDto);

    /**
    * 删除平台订单备注表
    *
    * @param ids        平台订单备注表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除平台订单备注表", notes = "删除平台订单备注表")
    RestResponse<Void> removePlatformOrderRemark(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
