package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpAuditReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpAuditRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 索赔补发订单审核记录服务接口
*
* @author xiuji
* @since 2022-10-28
*/
@Api(tags = {"索赔补发订单审核记录服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-transform-api-IPlatformOrderSpAuditApi",
        name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
        path = "/v1/platform/spAudit",
        url = "${yundt.cube.center.transform.api:}")
public interface IPlatformOrderSpAuditApi {

    /**
    * 新增索赔补发订单审核记录
    *
    * @param addReqDto 索赔补发订单审核记录请求对象
    * @return 处理结果
    */
    @PostMapping("/add")
    @ApiOperation(value = "新增索赔补发订单审核记录", notes = "新增索赔补发订单审核记录")
    RestResponse<Long> addPlatformOrderSpAudit(@RequestBody PlatformOrderSpAuditReqDto addReqDto);

    /**
    * 修改索赔补发订单审核记录
    *
    * @param modifyReqDto 索赔补发订单审核记录请求对象
    * @return 处理结果
    */
    @PostMapping("/modify")
    @ApiOperation(value = "修改索赔补发订单审核记录", notes = "修改索赔补发订单审核记录")
    RestResponse<Void> modifyPlatformOrderSpAudit(@RequestBody PlatformOrderSpAuditReqDto modifyReqDto);

    /**
    * 删除索赔补发订单审核记录
    *
    * @param ids        索赔补发订单审核记录删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除索赔补发订单审核记录", notes = "删除索赔补发订单审核记录")
    RestResponse<Void> removePlatformOrderSpAudit(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
