package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderPcpExtendReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderPcpExtendRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 平台订单扩展表服务接口
*
* @author zimu
* @since 2022-05-17
*/
@Api(tags = {"平台订单扩展表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-IPlatformOrderPcpExtendQueryApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/pcp/order/extend",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPlatformOrderPcpExtendQueryApi {

    /**
    * 根据id查询平台订单扩展表
    *
    * @param id 平台订单扩展表id
    * @return   平台订单扩展表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询平台订单扩展表", notes = "根据id查询平台订单扩展表")
    RestResponse<PlatformOrderPcpExtendRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 平台订单扩展表分页数据
    *
    * @param filter   平台订单扩展表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 平台订单扩展表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "平台订单扩展表分页数据", notes = "根据filter查询条件查询平台订单扩展表数据，filter=PlatformOrderPcpExtendReqDto")
    RestResponse<PageInfo<PlatformOrderPcpExtendRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
