package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpExtReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpExtRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 索赔补发订单扩展字段服务接口
*
* @author xiuji
* @since 2022-10-28
*/
@Api(tags = {"索赔补发订单扩展字段服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-transform-api-IPlatformOrderSpExtApi",
        name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
        path = "/v1/platform/spExt",
        url = "${yundt.cube.center.transform.api:}")
public interface IPlatformOrderSpExtApi {

    /**
    * 新增索赔补发订单扩展字段
    *
    * @param addReqDto 索赔补发订单扩展字段请求对象
    * @return 处理结果
    */
    @PostMapping("/add")
    @ApiOperation(value = "新增索赔补发订单扩展字段", notes = "新增索赔补发订单扩展字段")
    RestResponse<Long> addPlatformOrderSpExt(@RequestBody PlatformOrderSpExtReqDto addReqDto);

    /**
    * 修改索赔补发订单扩展字段
    *
    * @param modifyReqDto 索赔补发订单扩展字段请求对象
    * @return 处理结果
    */
    @PostMapping("/modify")
    @ApiOperation(value = "修改索赔补发订单扩展字段", notes = "修改索赔补发订单扩展字段")
    RestResponse<Void> modifyPlatformOrderSpExt(@RequestBody PlatformOrderSpExtReqDto modifyReqDto);

    /**
    * 删除索赔补发订单扩展字段
    *
    * @param ids        索赔补发订单扩展字段删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除索赔补发订单扩展字段", notes = "删除索赔补发订单扩展字段")
    RestResponse<Void> removePlatformOrderSpExt(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);


    /**
     * 修改物流商
     *
     * @param modifyReqDto 修改物流商
     * @return 处理结果
     */
    @PostMapping("/updateTargetLogistics")
    @ApiOperation(value = "修改物流商", notes = "修改物流商")
    RestResponse<Void> updateTargetLogistics(@RequestBody PlatformOrderSpExtReqDto modifyReqDto);
}
