package com.dtyunxi.yundt.cube.center.transform.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 索赔补发订单审核状态枚举
 * @author xiuji
 */
public enum PlatformOrderAuditStatusEnum {
    /**
     * audit_pass:审核通过;audit_not_pass:审核不通过;wait_to_up:反审至待上游审核;wait_to_logistics:反审至待物流审核
     */

    AUDIT_PASS("audit_pass","审核通过"),
    AUDIT_NOT_PASS("audit_not_pass","审核不通过"),
    WAIT_TO_UP("wait_to_up","反审至待上游审核"),
    WAIT_TO_LOGISTICS("wait_to_logistics","反审至待物流审核"),
    ;


    private String code;

    private String desc;

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    PlatformOrderAuditStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static final Map<String, PlatformOrderAuditStatusEnum> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    public static final Map<String, String> CODE_DESC_MAP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));

    public static PlatformOrderAuditStatusEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }
}
