/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpExtReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpExtRespDto;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderSpExtService;
import com.dtyunxi.yundt.cube.center.transform.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.transform.dao.das.PlatformOrderSpExtDas;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.PlatformOrderSpExtEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlatformOrderSpExtServiceImpl
implements IPlatformOrderSpExtService {
    @Resource
    private PlatformOrderSpExtDas platformOrderSpExtDas;
    @Resource
    private IPlatformOrderService platformOrderService;

    @Override
    public Long addPlatformOrderSpExt(PlatformOrderSpExtReqDto addReqDto) {
        PlatformOrderSpExtEo platformOrderSpExtEo = new PlatformOrderSpExtEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)platformOrderSpExtEo);
        this.platformOrderSpExtDas.insert((BaseEo)platformOrderSpExtEo);
        return platformOrderSpExtEo.getId();
    }

    @Override
    public void modifyPlatformOrderSpExt(PlatformOrderSpExtReqDto modifyReqDto) {
        PlatformOrderSpExtEo platformOrderSpExtEo = new PlatformOrderSpExtEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)platformOrderSpExtEo);
        this.platformOrderSpExtDas.updateSelective((BaseEo)platformOrderSpExtEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePlatformOrderSpExt(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.platformOrderSpExtDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PlatformOrderSpExtRespDto queryById(Long id) {
        PlatformOrderSpExtEo platformOrderSpExtEo = (PlatformOrderSpExtEo)this.platformOrderSpExtDas.selectByPrimaryKey(id);
        PlatformOrderSpExtRespDto platformOrderSpExtRespDto = new PlatformOrderSpExtRespDto();
        DtoHelper.eo2Dto((BaseEo)platformOrderSpExtEo, (BaseVo)platformOrderSpExtRespDto);
        return platformOrderSpExtRespDto;
    }

    @Override
    public PlatformOrderSpExtRespDto queryByPlatformOrderId(Long platformOrderId) {
        PlatformOrderSpExtEo spExtEo = new PlatformOrderSpExtEo();
        spExtEo.setPlatformOrderId(platformOrderId);
        PlatformOrderSpExtEo platformOrderSpExtEo = (PlatformOrderSpExtEo)this.platformOrderSpExtDas.selectOne((BaseEo)spExtEo);
        PlatformOrderSpExtRespDto platformOrderSpExtRespDto = new PlatformOrderSpExtRespDto();
        DtoHelper.eo2Dto((BaseEo)platformOrderSpExtEo, (BaseVo)platformOrderSpExtRespDto);
        return platformOrderSpExtRespDto;
    }

    @Override
    public PageInfo<PlatformOrderSpExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PlatformOrderSpExtReqDto platformOrderSpExtReqDto = (PlatformOrderSpExtReqDto)JSON.parseObject((String)filter, PlatformOrderSpExtReqDto.class);
        PlatformOrderSpExtEo platformOrderSpExtEo = new PlatformOrderSpExtEo();
        DtoHelper.dto2Eo((BaseVo)platformOrderSpExtReqDto, (BaseEo)platformOrderSpExtEo);
        PageInfo eoPageInfo = this.platformOrderSpExtDas.selectPage((BaseEo)platformOrderSpExtEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PlatformOrderSpExtRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateTargetLogistics(PlatformOrderSpExtReqDto modifyReqDto) {
        AssertUtil.assertNotNull(modifyReqDto.getId(), "\u53c2\u6570ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull(modifyReqDto.getPlatformOrderId(), "\u53c2\u6570PlatformOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull(modifyReqDto.getTargetClaimLogisticsId(), "\u53c2\u6570TargetClaimLogisticsId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(modifyReqDto.getTargetClaimLogisticsCode(), "\u53c2\u6570TargetClaimLogisticsCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(modifyReqDto.getTargetClaimLogisticsName(), "\u53c2\u6570TargetClaimLogisticsName\u4e0d\u80fd\u4e3a\u7a7a");
        PlatformOrderSpExtEo spExtEo = (PlatformOrderSpExtEo)this.platformOrderSpExtDas.selectByPrimaryKey(modifyReqDto.getId());
        String requestUserCode = ServiceContext.getContext().getRequestUserCode();
        PlatformOrderSpExtEo platformOrderSpExtEo = new PlatformOrderSpExtEo();
        platformOrderSpExtEo.setId(modifyReqDto.getId());
        platformOrderSpExtEo.setTargetClaimLogisticsId(modifyReqDto.getTargetClaimLogisticsId());
        platformOrderSpExtEo.setTargetClaimLogisticsCode(modifyReqDto.getTargetClaimLogisticsCode());
        platformOrderSpExtEo.setTargetClaimLogisticsName(modifyReqDto.getTargetClaimLogisticsName());
        platformOrderSpExtEo.setUpdatePerson(requestUserCode);
        platformOrderSpExtEo.setUpdateTime(new Date());
        this.platformOrderSpExtDas.updateSelective((BaseEo)platformOrderSpExtEo);
        PlatformOrderRespDto platformOrderRespDto = this.platformOrderService.queryById(modifyReqDto.getPlatformOrderId());
        PlatformOrderReqDto platformOrderReqDto = new PlatformOrderReqDto();
        platformOrderReqDto.setId(modifyReqDto.getPlatformOrderId());
        platformOrderReqDto.setCustomerId(modifyReqDto.getTargetClaimLogisticsId());
        platformOrderReqDto.setCustomerCode(modifyReqDto.getTargetClaimLogisticsCode());
        platformOrderReqDto.setCustomerName(modifyReqDto.getTargetClaimLogisticsName());
        platformOrderReqDto.setUpdatePerson(requestUserCode);
        platformOrderReqDto.setUpdateTime(new Date());
        String dateFormat = "";
        if (Objects.nonNull(spExtEo.getClaimLogisticsDate())) {
            dateFormat = DateUtil.getDateFormat((Date)spExtEo.getClaimLogisticsDate(), (String)"yyyy-MM-dd");
        }
        String sellerRemark = modifyReqDto.getTargetClaimLogisticsName() + "-" + platformOrderRespDto.getActualCustomerName() + "-" + spExtEo.getClaimLogisticsNo() + "-\u6c64\u81e3\u500d\u5065\u8fd0\u8d27\u635f\u574f\u3001\u4e22\u5931\u8d54\u507f\u5355-" + dateFormat;
        platformOrderReqDto.setSellerRemark(sellerRemark);
        this.platformOrderService.modifyPlatformOrder(platformOrderReqDto);
    }
}

