/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.utils;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

@Component
public class NoGenerateUtil {
    @Resource
    private RedisTemplate<String, Serializable> redisTemplate;

    public static String getIdPrefix(LocalDateTime now) {
        return now.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private static String getOrderIdPrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }

    private long generate(String key, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        Long expire = counter.getExpire();
        if (expire == -1L) {
            counter.expireAt(expireTime);
        }
        return counter.incrementAndGet();
    }

    public String generateNo(String prefix) {
        LocalDateTime now = LocalDateTime.now();
        String idPrefix = NoGenerateUtil.getIdPrefix(now);
        String id = prefix + idPrefix + String.format("%1$06d", this.generate(prefix + idPrefix, this.getExpireAtTime(now)));
        return id;
    }

    private Date getExpireAtTime(LocalDateTime now) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = now.plusDays(1L);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public String generateTransformOrderNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGenerateUtil.getOrderIdPrefix(now, "yyyyMMdd");
        String orderId = "P" + orderIdPrefix + String.format("%1$06d", this.generate(orderIdPrefix, this.getExpireAtTime(now)));
        return orderId;
    }
}

