/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleRefundApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleRefundOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformAssert;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IDataQueryService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPcpSaleRefundService;
import com.dtyunxi.yundt.cube.center.transform.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PcpSaleRefundServiceImpl
implements IPcpSaleRefundService {
    private static final Logger logger = LoggerFactory.getLogger(PcpSaleRefundServiceImpl.class);
    @Resource
    private IDataQueryService dataQueryService;
    @Resource
    private ISaleRefundApi saleRefundApi;
    @Resource
    private ISaleRefundOptApi saleRefundOptApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;

    @Override
    public Long addSaleRefund(SaleRefundReqDto addReqDto) {
        logger.info("\u3010\u65b0\u589e\u9500\u552e\u9000\u8d27\u5355\u3011addReqDto={}", (Object)JSON.toJSONString((Object)addReqDto));
        this.checkSaveBaseParam(addReqDto);
        BizSaleRefundReqDto refundReqDto = this.refundOrderTransform(addReqDto);
        logger.info("\u3010\u9500\u552e\u9000\u8d27\u8bf7\u6c42\u7ec4\u88c5\u5b8c\u6210\u3011refundReqDto={}", (Object)JSON.toJSONString((Object)refundReqDto));
        return (Long)RestResponseHelper.extractData((RestResponse)this.saleRefundApi.addSaleRefund(refundReqDto));
    }

    @Override
    public boolean cancelSaleRefund(SaleRefundReqDto addReqDto) {
        AssertUtil.assertNotBlank(addReqDto.getPlatformRefundNo(), "\u5e73\u53f0\u5355\u53f7\u4e3a\u7a7a");
        List bizSaleRefundRespDto = (List)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryDetailByPlatformRefundNo(addReqDto.getPlatformRefundNo()));
        if (CollectionUtils.isEmpty((Collection)bizSaleRefundRespDto)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5e73\u53f0\u5355\u53f7[" + addReqDto.getPlatformRefundNo() + "]\u9000\u8d27\u8ba2\u5355\u4e0d\u5b58\u5728"});
        }
        Boolean result = true;
        ArrayList idList = Lists.newArrayList();
        for (SaleRefundRespDto saleRefundRespDto : bizSaleRefundRespDto) {
            if (Objects.equals(saleRefundRespDto.getRefundStatus(), SaleRefundStatusEnum.CANCEL.getCode()) || Objects.equals(saleRefundRespDto.getRefundStatus(), SaleRefundStatusEnum.INVALID.getCode())) continue;
            if (Objects.equals(saleRefundRespDto.getRefundStatus(), SaleRefundStatusEnum.WAIT_CHECK.getCode())) {
                idList.add(saleRefundRespDto.getId());
                continue;
            }
            String refundStatus = saleRefundRespDto.getRefundStatus();
            SaleRefundStatusEnum saleRefundStatusEnum = SaleRefundStatusEnum.forCode((String)refundStatus);
            throw PlatformExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{saleRefundStatusEnum.getDesc()});
        }
        if (!CollectionUtils.isEmpty((Collection)idList)) {
            for (Long id : idList) {
                RestResponseHelper.extractData((RestResponse)this.saleRefundOptApi.cancel(id));
            }
        }
        return result;
    }

    public BizSaleRefundReqDto refundOrderTransform(SaleRefundReqDto refundReqDto) {
        CustomerRespDto pcpCustomerRespDto = this.dataQueryService.queryAndCheckPCPCustomerRespDto(refundReqDto.getCustomerCode());
        OrgAdvDetailRespDto orgAdvDetailRespDto = this.dataQueryService.queryEasOrgDto(refundReqDto.getEasOrgId());
        PcpOrderChannelRespDto pcpOrderChannelRespDto = this.dataQueryService.queryPcpOrderChannelRespDto(refundReqDto.getOrderChannelCode());
        CsLogicWarehouseDetailRespDto csLogicWarehouseDetailRespDto = null;
        if (StringUtils.isNotEmpty((CharSequence)refundReqDto.getApplyRefundWarehouseCode())) {
            csLogicWarehouseDetailRespDto = this.dataQueryService.queryWarehouseInfo(refundReqDto.getApplyRefundWarehouseCode());
            if (Objects.nonNull(csLogicWarehouseDetailRespDto)) {
                refundReqDto.setApplyRefundWarehouseId(csLogicWarehouseDetailRespDto.getId());
                refundReqDto.setApplyRefundWarehouseName(csLogicWarehouseDetailRespDto.getWarehouseName());
            }
        } else {
            CsLogicWarehouseRespDto csLogicWarehousePageRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseQueryApi.queryReturnWarehouseByOrganizationId(orgAdvDetailRespDto.getId()));
            if (Objects.nonNull(csLogicWarehousePageRespDto)) {
                refundReqDto.setApplyRefundWarehouseId(csLogicWarehousePageRespDto.getId());
                refundReqDto.setApplyRefundWarehouseName(csLogicWarehousePageRespDto.getWarehouseName());
                refundReqDto.setApplyRefundWarehouseCode(csLogicWarehousePageRespDto.getWarehouseCode());
            }
        }
        Map<String, PcpItemRespDto> csItemRespDtoMap = this.dataQueryService.queryAndCheckItemInfo(refundReqDto.getSaleRefundOrderItemReqDtoList().stream().map(SaleRefundItemReqDto::getSkuCode).distinct().collect(Collectors.toList()));
        Map<String, PcpRegionRespDto> pcpRegionRespDtoMap = this.dataQueryService.queryAndCheckOrderAddressInfo(refundReqDto.getSaleRefundAddrReqDto().getProvinceCode(), refundReqDto.getSaleRefundAddrReqDto().getCityCode(), refundReqDto.getSaleRefundAddrReqDto().getCountyCode());
        refundReqDto.setOrderChannelId(pcpOrderChannelRespDto.getId());
        refundReqDto.setOrderChannelName(pcpOrderChannelRespDto.getChannelName());
        refundReqDto.setOrderChannelCode(pcpOrderChannelRespDto.getChannelCode());
        refundReqDto.setCustomerCode(pcpCustomerRespDto.getCode());
        refundReqDto.setCustomerName(pcpCustomerRespDto.getName());
        refundReqDto.setCustomerId(pcpCustomerRespDto.getId());
        refundReqDto.setEasCode(pcpCustomerRespDto.getEasCode());
        refundReqDto.setOrganizationId(orgAdvDetailRespDto.getId());
        refundReqDto.setOrganizationName(orgAdvDetailRespDto.getName());
        refundReqDto.setOrganizationCode(orgAdvDetailRespDto.getCode());
        refundReqDto.setSaleOrgName(orgAdvDetailRespDto.getName());
        refundReqDto.setSaleOrgId(orgAdvDetailRespDto.getId());
        refundReqDto.setSaleOrgCode(orgAdvDetailRespDto.getCode());
        if (null != pcpRegionRespDtoMap && !pcpRegionRespDtoMap.isEmpty()) {
            refundReqDto.getSaleRefundAddrReqDto().setProvince((String)Optional.ofNullable(pcpRegionRespDtoMap.get(refundReqDto.getSaleRefundAddrReqDto().getProvinceCode())).map(PcpRegionRespDto::getName).orElse(null));
            refundReqDto.getSaleRefundAddrReqDto().setCity((String)Optional.ofNullable(pcpRegionRespDtoMap.get(refundReqDto.getSaleRefundAddrReqDto().getCityCode())).map(PcpRegionRespDto::getName).orElse(null));
            refundReqDto.getSaleRefundAddrReqDto().setCounty((String)Optional.ofNullable(pcpRegionRespDtoMap.get(refundReqDto.getSaleRefundAddrReqDto().getCountyCode())).map(PcpRegionRespDto::getName).orElse(null));
        }
        BigDecimal totalGoodsNum = BigDecimal.ZERO;
        refundReqDto.setGoodsSkuTotalNum(new BigDecimal(refundReqDto.getSaleRefundOrderItemReqDtoList().stream().map(SaleRefundItemReqDto::getSkuCode).collect(Collectors.toSet()).size()));
        for (SaleRefundItemReqDto dto : refundReqDto.getSaleRefundOrderItemReqDtoList()) {
            PcpItemRespDto csItemRespDto = csItemRespDtoMap.get(dto.getSkuCode());
            PlatformAssert.notNull((Object)csItemRespDto, (PlatformExceptionCode)PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_INFO_HAD_NULL, (String[])new String[]{dto.getSkuCode()});
            if (csItemRespDto.getItemStatus() != null && csItemRespDto.getItemStatus() != 2L) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_INFO_STATUS_0.buildBizException(new Object[]{dto.getSkuCode()});
            }
            dto.setItemCode(csItemRespDto.getItemCode());
            dto.setItemName(csItemRespDto.getName());
            dto.setSkuCode(csItemRespDto.getLongCode());
            dto.setItemId(csItemRespDto.getId());
            dto.setOrganizationId(orgAdvDetailRespDto.getId());
            dto.setOrganizationCode(orgAdvDetailRespDto.getCode());
            if (StringUtils.isNotEmpty((CharSequence)refundReqDto.getApplyRefundWarehouseCode())) {
                dto.setApplyRefundWarehouseCode(refundReqDto.getApplyRefundWarehouseCode());
                dto.setApplyRefundWarehouseName(refundReqDto.getApplyRefundWarehouseName());
                dto.setRefundWarehouseCode(refundReqDto.getApplyRefundWarehouseCode());
                dto.setRefundWarehouseName(refundReqDto.getApplyRefundWarehouseName());
            }
            totalGoodsNum = totalGoodsNum.add(dto.getItemNum());
        }
        if (refundReqDto.getGoodsTotalNum() != null && totalGoodsNum.compareTo(refundReqDto.getGoodsTotalNum()) != 0) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5546\u54c1\u603b\u6570\u91cf\u4e0d\u5339\u914d"});
        }
        refundReqDto.setGoodsTotalNum(totalGoodsNum);
        return refundReqDto;
    }

    private void checkSaveBaseParam(SaleRefundReqDto refundReqDto) {
        PlatformAssert.notBlank((String)refundReqDto.getSnapshot(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5feb\u7167\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)refundReqDto.getPlatformRefundCreateTime(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u4e0a\u6e38\u4e1a\u52a1\u5355\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notBlank((String)refundReqDto.getEasOrgId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"EasOrgId\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notBlank((String)refundReqDto.getOrgId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"OrgId\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notBlank((String)refundReqDto.getRefundType(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notBlank((String)refundReqDto.getDistributionChannel(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)SaleRefundTypeEnum.enumOf((String)refundReqDto.getRefundType()), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u7c7b\u578b\u9519\u8bef"});
        PlatformAssert.notBlank((String)refundReqDto.getPlatformRefundNo(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5e73\u53f0\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notBlank((String)refundReqDto.getOrderChannelCode(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_ORDER_CHANNEL_CODE_NULL, (String[])new String[0]);
        PlatformAssert.notBlank((String)refundReqDto.getThirdPartyId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5ba2\u6237\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notBlank((String)refundReqDto.getContactPhone(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notBlank((String)refundReqDto.getContactPersonName(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8054\u7cfb\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)refundReqDto.getSaleRefundAddrReqDto(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)refundReqDto.getRefundTotalAmount(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u9000\u8d27\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)refundReqDto.getSaleRefundAddrReqDto().getReceivePhone(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u6536\u8d27\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)refundReqDto.getSaleRefundAddrReqDto().getReceiveName(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u6536\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)refundReqDto.getSaleRefundAddrReqDto().getReceiveAddress(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u6536\u8d27\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notEmpty((Collection)refundReqDto.getSaleRefundOrderItemReqDtoList(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u9000\u8d27\u5546\u54c1\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a"});
        refundReqDto.getSaleRefundOrderItemReqDtoList().forEach(dto -> {
            if (StringUtils.isBlank((CharSequence)dto.getSkuCode())) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_CODE_NULL.buildBizException();
            }
            if (StringUtils.isBlank((CharSequence)dto.getItemUnit())) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5546\u54c1\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a"});
            }
            if (dto.getPrice() == null || dto.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_PRICE_NULL.buildBizException(new Object[]{dto.getItemCode()});
            }
            if (dto.getItemNum() == null || dto.getItemNum().compareTo(BigDecimal.ZERO) <= 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_NUM_NULL.buildBizException(new Object[]{dto.getItemCode()});
            }
            if (dto.getGift() == null || dto.getGift() != 1 && dto.getGift() != 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_GIFT_TYPE_WRONG.buildBizException(new Object[]{dto.getItemCode()});
            }
        });
    }
}

