/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehouseListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformAssert;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IDataQueryService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPcpOrderChannelService;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IDataQueryServiceImpl
implements IDataQueryService {
    private static final Logger logger = LoggerFactory.getLogger(IDataQueryServiceImpl.class);
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;
    @Resource
    private IPcpOrderChannelService pcpOrderChannelService;
    @Resource
    private ICsRelWarehouseApi csRelWarehouseQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Resource
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;

    @Override
    public CustomerRespDto queryAndCheckPCPCustomerRespDto(String thirdPartyId) {
        CustomerRespDto customerRespDto = null;
        try {
            customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerByCode(thirdPartyId));
            if (Objects.isNull(customerRespDto) || Objects.isNull(customerRespDto.getId())) {
                throw PlatformExceptionCode.QUERY_CUSTOMER_INFO_IS_NULL.buildBizException(new Object[]{thirdPartyId});
            }
            logger.info("\u3010\u83b7\u53d6\u5230\u5ba2\u6237\u4fe1\u606f\u3011customerRespDto={}", (Object)JSON.toJSONString((Object)customerRespDto));
            PlatformAssert.notNull((Object)customerRespDto.getStatusId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5ba2\u6237\u8d26\u53f7\u6570\u636e\u5f02\u5e38\uff1a\u72b6\u6001\u6570\u636e\u4e3a\u7a7a"});
            CustomerStatusRespDto customerStatusRespDto = (CustomerStatusRespDto)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryById(customerRespDto.getStatusId()));
            PlatformAssert.notNull((Object)customerStatusRespDto, (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5ba2\u6237\u8d26\u53f7\u6570\u636e\u5f02\u5e38\uff1a\u72b6\u6001\u6570\u636e\u4e3a\u7a7a"});
            PlatformAssert.needEquals((Object)1, (Object)customerStatusRespDto.getAccountStatus(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5ba2\u6237\u8d26\u53f7\u5df2\u7981\u7528"});
            PlatformAssert.needEquals((Object)1, (Object)customerStatusRespDto.getRecordStatus(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5ba2\u6237\u8d26\u53f7\u5df2\u505c\u7528"});
        }
        catch (BizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.QUERY_CUSTOMER_INFO_FAIL.buildBizException(new Object[]{thirdPartyId});
        }
        return customerRespDto;
    }

    @Override
    public OrganizationDto queryAndCheckPCPOrgRespDto(String orgCode) {
        OrganizationDto organizationDto = null;
        try {
            List organizationDtoList = (List)RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.queryInfoByCodeList(Collections.singletonList(orgCode)));
            if (CollectionUtils.isEmpty((Collection)organizationDtoList)) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f\uff1a" + orgCode});
            }
            if (organizationDtoList.size() > 1) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u552f\u4e00\uff1a" + orgCode});
            }
            organizationDto = (OrganizationDto)organizationDtoList.get(0);
            logger.info("\u3010\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\u3011organizationDto={}", (Object)JSON.toJSONString((Object)organizationDto));
        }
        catch (BizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25"});
        }
        return organizationDto;
    }

    @Override
    public OrgAdvDetailRespDto queryEasOrgDto(String easOrgCode) {
        OrgAdvDetailRespDto orgAdvDetailRespDto = null;
        try {
            List organizationDtoList = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgDetailByThirdCode(Collections.singletonList(easOrgCode)));
            if (CollectionUtils.isEmpty((Collection)organizationDtoList)) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f\uff1a" + easOrgCode});
            }
            if (organizationDtoList.size() > 1) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u552f\u4e00\uff1a" + easOrgCode});
            }
            orgAdvDetailRespDto = (OrgAdvDetailRespDto)organizationDtoList.get(0);
            logger.info("\u3010\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\u3011organizationDto={}", (Object)JSON.toJSONString((Object)orgAdvDetailRespDto));
        }
        catch (BizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25"});
        }
        return orgAdvDetailRespDto;
    }

    @Override
    public PcpOrderChannelRespDto queryPcpOrderChannelRespDto(String orderChannelCode) {
        PcpOrderChannelRespDto pcpOrderChannelRespDto = this.pcpOrderChannelService.queryByShopChannelByCode(orderChannelCode);
        if (pcpOrderChannelRespDto == null) {
            throw PlatformExceptionCode.QUERY_ORDER_CHANNEL_INFO_IS_NULL.buildBizException(new Object[]{orderChannelCode});
        }
        if (!"ENABLED".equals(pcpOrderChannelRespDto.getStatus())) {
            throw PlatformExceptionCode.QUERY_ORDER_CHANNEL_INFO_STATUS_FAIL.buildBizException(new Object[]{orderChannelCode});
        }
        return pcpOrderChannelRespDto;
    }

    @Override
    public CsLogicWarehouseDetailRespDto queryWarehouseInfo(String logicWarehouseCode) {
        CsRelWarehouseQueryDto queryLogicReqDto = new CsRelWarehouseQueryDto();
        queryLogicReqDto.setWarehouseCode(logicWarehouseCode);
        queryLogicReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        List csRelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseQueryApi.queryWarehouseByConditions(queryLogicReqDto));
        PlatformAssert.notEmpty((Collection)csRelWarehouseRespDtos, (PlatformExceptionCode)PlatformExceptionCode.QUERY_ORDER_INFO_IS_NULL, (String[])new String[]{"\u903b\u8f91\u4ed3"});
        CsLogicWarehouseDetailRespDto csLogicWarehouseDetailRespDto = (CsLogicWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryDetailById(((CsRelWarehouseRespDto)csRelWarehouseRespDtos.get(0)).getWarehouseId()));
        PlatformAssert.needEquals((Object)csLogicWarehouseDetailRespDto.getWarehouseStatus(), (Object)CsValidFlagEnum.ENABLE.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{logicWarehouseCode + "\u903b\u8f91\u4ed3\u5e93\u672a\u542f\u7528"});
        return csLogicWarehouseDetailRespDto;
    }

    @Override
    public Map<String, PcpItemRespDto> queryAndCheckItemInfo(List<String> itemSkuCodes) {
        Map<String, PcpItemRespDto> csItemRespDtoMap = null;
        List csItemRespDtos = null;
        try {
            csItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(itemSkuCodes));
            if (CollectionUtils.isEmpty((Collection)csItemRespDtos)) {
                throw PlatformExceptionCode.QUERY_ITEM_INFO_IS_NULL.buildBizException();
            }
            csItemRespDtos.forEach(dto -> {
                if (StringUtils.isBlank((CharSequence)dto.getItemCode())) {
                    throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_CODE_NULL.buildBizException();
                }
            });
            csItemRespDtoMap = csItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getItemCode, Function.identity(), (v1, v2) -> v1));
        }
        catch (BizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_INFO_FAIL.buildBizException();
        }
        return csItemRespDtoMap;
    }

    @Override
    public Map<String, PcpRegionRespDto> queryAndCheckOrderAddressInfo(String provinceCode, String cityCode, String countyCode) {
        HashMap<String, PcpRegionRespDto> pcpRegionRespDtoMap = new HashMap<String, PcpRegionRespDto>();
        PcpRegionRespDto provinceAreaDto = null;
        if (StringUtils.isNotEmpty((CharSequence)provinceCode)) {
            provinceAreaDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(provinceCode));
            if (provinceAreaDto == null) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_NULL.buildBizException(new Object[]{"\u7701", provinceCode});
            }
            pcpRegionRespDtoMap.put(provinceCode, provinceAreaDto);
        }
        PcpRegionRespDto countryAreaDto = null;
        if (StringUtils.isNotBlank((CharSequence)countyCode)) {
            countryAreaDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(countyCode));
            if (countryAreaDto == null) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_NULL.buildBizException(new Object[]{"\u533a", countyCode});
            }
            pcpRegionRespDtoMap.put(countyCode, countryAreaDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)cityCode)) {
            PcpRegionRespDto cityAreaDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(cityCode));
            if (cityAreaDto == null) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_NULL.buildBizException(new Object[]{"\u5e02", cityCode});
            }
            pcpRegionRespDtoMap.put(cityCode, cityAreaDto);
            if (StringUtils.isBlank((CharSequence)cityAreaDto.getParentCode())) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_0.buildBizException(new Object[]{cityAreaDto.getCode()});
            }
            if (Objects.nonNull(countryAreaDto) && StringUtils.isBlank((CharSequence)countryAreaDto.getParentCode())) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_0.buildBizException(new Object[]{countryAreaDto.getCode()});
            }
            if (Objects.nonNull(countryAreaDto) && !countryAreaDto.getParentCode().equals(cityAreaDto.getCode())) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_1.buildBizException(new Object[]{countryAreaDto.getCode(), cityAreaDto.getCode()});
            }
            if (!cityAreaDto.getParentCode().equals(provinceAreaDto.getCode())) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_1.buildBizException(new Object[]{cityAreaDto.getCode(), provinceAreaDto.getCode()});
            }
        }
        return pcpRegionRespDtoMap;
    }

    @Override
    public void setAddOrderInfo(PcpOrderReqDto addReqDto) {
        CustomerRespDto pcpCustomerRespDto;
        try {
            PcpOrderChannelRespDto pcpOrderChannelRespDto = this.pcpOrderChannelService.queryByShopChannelByCode(addReqDto.getOrderChannelCode());
            if (Objects.nonNull(pcpOrderChannelRespDto)) {
                addReqDto.setOrderChannelId(pcpOrderChannelRespDto.getId());
                addReqDto.setOrderChannelName(pcpOrderChannelRespDto.getChannelName());
            }
        }
        catch (Exception e) {
            logger.info("\u5339\u914d\u5e76\u83b7\u53d6\u8ba2\u5355\u6e20\u9053\u4fe1\u606f:" + e.getMessage(), (Throwable)e);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)addReqDto.getCustomerCode()) && Objects.nonNull(pcpCustomerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerByCode(addReqDto.getCustomerCode())))) {
                addReqDto.setCustomerId(pcpCustomerRespDto.getId());
                addReqDto.setCustomerName(pcpCustomerRespDto.getName());
            }
        }
        catch (Exception e) {
            logger.info("\u5339\u914d\u5e76\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f:" + e.getMessage(), (Throwable)e);
        }
        try {
            ChannelWarehouseRespDto channelWarehouseRespDto;
            if (StringUtils.isNotEmpty((CharSequence)addReqDto.getChannelWarehouseCode()) && Objects.nonNull(channelWarehouseRespDto = (ChannelWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByWarehouseCode(addReqDto.getChannelWarehouseCode())))) {
                addReqDto.setChannelWarehouseId(channelWarehouseRespDto.getId());
                addReqDto.setChannelWarehouseName(channelWarehouseRespDto.getWarehouseName());
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u6e20\u9053\u4ed3\u4fe1\u606f:" + e.getMessage(), (Throwable)e);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)addReqDto.getStoragePlace())) {
                VirtualWarehouseListReqDto virtualWarehouseListReqDto = new VirtualWarehouseListReqDto();
                virtualWarehouseListReqDto.setVirtualWarehouseCodes((List)Lists.newArrayList((Object[])new String[]{addReqDto.getStoragePlace()}));
                List virtualWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseQueryApi.queryByList(virtualWarehouseListReqDto));
                if (!CollectionUtils.isEmpty((Collection)virtualWarehouseRespDtos)) {
                    VirtualWarehouseRespDto virtualWarehouseRespDto = (VirtualWarehouseRespDto)virtualWarehouseRespDtos.get(0);
                    addReqDto.setStoragePlaceId(virtualWarehouseRespDto.getId());
                    addReqDto.setStoragePlaceName(virtualWarehouseRespDto.getWarehouseName());
                }
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u4f9b\u8d27\u4ed3\u4fe1\u606f:" + e.getMessage(), (Throwable)e);
        }
        if (Objects.equals(addReqDto.getOrderType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType())) {
            try {
                ArrayList logicCodeList = Lists.newArrayList();
                if (StringUtils.isNotEmpty((CharSequence)addReqDto.getAllotOutWarehouseCode())) {
                    logicCodeList.add(addReqDto.getAllotOutWarehouseCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)addReqDto.getAllotInWarehouseCode())) {
                    logicCodeList.add(addReqDto.getAllotInWarehouseCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)addReqDto.getMyArrangeLogicalWarehouseCode())) {
                    logicCodeList.add(addReqDto.getMyArrangeLogicalWarehouseCode());
                }
                if (!CollectionUtils.isEmpty((Collection)logicCodeList)) {
                    CsLogicWarehouseParamQueryDto logicWarehouseParamQueryDto = new CsLogicWarehouseParamQueryDto();
                    logicWarehouseParamQueryDto.setWarehouseCodeList((List)logicCodeList);
                    logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u4fe1\u606f={}", JSON.toJSON((Object)logicWarehouseParamQueryDto));
                    List csLogicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(logicWarehouseParamQueryDto));
                    logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u4fe1\u606f={}", JSON.toJSON((Object)csLogicWarehousePageRespDtos));
                    if (!CollectionUtils.isEmpty((Collection)csLogicWarehousePageRespDtos)) {
                        Map<String, String> logicMap = csLogicWarehousePageRespDtos.stream().collect(Collectors.toMap(CsLogicWarehousePageRespDto::getWarehouseCode, CsLogicWarehousePageRespDto::getWarehouseName, (k1, k2) -> k1));
                        if (logicMap.containsKey(addReqDto.getAllotOutWarehouseCode())) {
                            addReqDto.setAllotOutWarehouseName(logicMap.get(addReqDto.getAllotOutWarehouseCode()));
                        }
                        if (logicMap.containsKey(addReqDto.getAllotInWarehouseCode())) {
                            addReqDto.setAllotInWarehouseName(logicMap.get(addReqDto.getAllotInWarehouseCode()));
                        }
                        if (logicMap.containsKey(addReqDto.getMyArrangeLogicalWarehouseCode())) {
                            addReqDto.setMyArrangeLogicalWarehouseName(logicMap.get(addReqDto.getMyArrangeLogicalWarehouseCode()));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u903b\u8f91\u4ed3\u4fe1\u606f:" + e.getMessage(), (Throwable)e);
            }
        }
        try {
            List organizationDtoList;
            if (StringUtils.isNotEmpty((CharSequence)addReqDto.getEasOrgId()) && !CollectionUtils.isEmpty((Collection)(organizationDtoList = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgDetailByThirdCode(Collections.singletonList(addReqDto.getEasOrgId())))))) {
                logger.info("\u3010\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\u3011organizationDto={}", (Object)JSON.toJSONString((Object)organizationDtoList));
                addReqDto.setOrganizationId(((OrgAdvDetailRespDto)organizationDtoList.get(0)).getId());
                addReqDto.setOrganizationCode(((OrgAdvDetailRespDto)organizationDtoList.get(0)).getCode());
                addReqDto.setOrganizationName(((OrgAdvDetailRespDto)organizationDtoList.get(0)).getName());
            }
        }
        catch (BizException e) {
            logger.info("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        try {
            List skuCodeList;
            List csItemRespDtos;
            if (!CollectionUtils.isEmpty((Collection)addReqDto.getItemReqDtoList()) && !CollectionUtils.isEmpty((Collection)(csItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(skuCodeList = addReqDto.getItemReqDtoList().stream().map(PlatformOrderItemReqDto::getSkuCode).distinct().collect(Collectors.toList())))))) {
                Map csItemMap = csItemRespDtos.stream().collect(Collectors.toMap(PcpItemRespDto::getItemCode, Function.identity(), (v1, v2) -> v1));
                addReqDto.getItemReqDtoList().forEach(item -> {
                    if (csItemMap.get(item.getSkuCode()) != null) {
                        item.setItemName(((PcpItemRespDto)csItemMap.get(item.getSkuCode())).getName());
                    }
                });
            }
        }
        catch (BizException e) {
            logger.info("\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)addReqDto.getActualCustomerCode()) && Objects.nonNull(pcpCustomerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerByCode(addReqDto.getActualCustomerCode())))) {
                addReqDto.setActualCustomerId(pcpCustomerRespDto.getId());
                addReqDto.setActualCustomerName(pcpCustomerRespDto.getName());
            }
        }
        catch (Exception e) {
            logger.info("\u5339\u914d\u5e76\u83b7\u53d6\u5b9e\u9645\u6536\u8d27\u5ba2\u6237\u4fe1\u606f:" + e.getMessage(), (Throwable)e);
        }
        if (Objects.nonNull(addReqDto.getPlatformOrderAddrReqDto())) {
            PlatformOrderAddrReqDto platformOrderAddrReqDto = addReqDto.getPlatformOrderAddrReqDto();
            ArrayList addressList = Lists.newArrayList();
            if (StringUtils.isNotEmpty((CharSequence)platformOrderAddrReqDto.getProvinceCode())) {
                addressList.add(platformOrderAddrReqDto.getProvinceCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)platformOrderAddrReqDto.getCityCode())) {
                addressList.add(platformOrderAddrReqDto.getCityCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)platformOrderAddrReqDto.getCountyCode())) {
                addressList.add(platformOrderAddrReqDto.getCountyCode());
            }
            if (!CollectionUtils.isEmpty((Collection)addressList)) {
                try {
                    PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
                    pcpRegionReqDto.setCodes((List)addressList);
                    List pcpRegionRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
                    if (!CollectionUtils.isEmpty((Collection)pcpRegionRespDtos)) {
                        Map regionRespDtoMap = pcpRegionRespDtos.stream().collect(Collectors.toMap(PcpRegionRespDto::getCode, Function.identity(), (k1, k2) -> k1));
                        if (StringUtils.isNotEmpty((CharSequence)platformOrderAddrReqDto.getProvinceCode()) && regionRespDtoMap.containsKey(platformOrderAddrReqDto.getProvinceCode())) {
                            platformOrderAddrReqDto.setProvince(((PcpRegionRespDto)regionRespDtoMap.get(platformOrderAddrReqDto.getProvinceCode())).getName());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)platformOrderAddrReqDto.getCityCode()) && regionRespDtoMap.containsKey(platformOrderAddrReqDto.getCityCode())) {
                            platformOrderAddrReqDto.setCity(((PcpRegionRespDto)regionRespDtoMap.get(platformOrderAddrReqDto.getCityCode())).getName());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)platformOrderAddrReqDto.getCountyCode()) && regionRespDtoMap.containsKey(platformOrderAddrReqDto.getCountyCode())) {
                            platformOrderAddrReqDto.setCounty(((PcpRegionRespDto)regionRespDtoMap.get(platformOrderAddrReqDto.getCountyCode())).getName());
                        }
                    }
                }
                catch (Exception e) {
                    logger.info("\u5339\u914d\u5e76\u83b7\u53d6\u5730\u5740\u4fe1\u606f\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

