/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderItemService;
import com.dtyunxi.yundt.cube.center.transform.dao.das.PlatformOrderItemDas;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.PlatformOrderItemEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlatformOrderItemServiceImpl
implements IPlatformOrderItemService {
    @Resource
    private PlatformOrderItemDas platformOrderItemDas;

    @Override
    public Long addPlatformOrderItem(PlatformOrderItemReqDto addReqDto) {
        PlatformOrderItemEo platformOrderItemEo = new PlatformOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)platformOrderItemEo);
        this.platformOrderItemDas.insert((BaseEo)platformOrderItemEo);
        return platformOrderItemEo.getId();
    }

    @Override
    public void modifyPlatformOrderItem(PlatformOrderItemReqDto modifyReqDto) {
        PlatformOrderItemEo platformOrderItemEo = new PlatformOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)platformOrderItemEo);
        if (null != modifyReqDto.getExtFields() && !modifyReqDto.getExtFields().isEmpty()) {
            platformOrderItemEo.setExtension(JSON.toJSONString((Object)modifyReqDto.getExtFields()));
        }
        this.platformOrderItemDas.updateSelective((BaseEo)platformOrderItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePlatformOrderItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.platformOrderItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PlatformOrderItemRespDto queryById(Long id) {
        PlatformOrderItemEo platformOrderItemEo = (PlatformOrderItemEo)this.platformOrderItemDas.selectByPrimaryKey(id);
        if (platformOrderItemEo == null) {
            return null;
        }
        PlatformOrderItemRespDto platformOrderItemRespDto = new PlatformOrderItemRespDto();
        DtoHelper.eo2Dto((BaseEo)platformOrderItemEo, (BaseVo)platformOrderItemRespDto);
        return platformOrderItemRespDto;
    }

    @Override
    public PageInfo<PlatformOrderItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PlatformOrderItemReqDto platformOrderItemReqDto = (PlatformOrderItemReqDto)JSON.parseObject((String)filter, PlatformOrderItemReqDto.class);
        PlatformOrderItemEo platformOrderItemEo = new PlatformOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)platformOrderItemReqDto, (BaseEo)platformOrderItemEo);
        PageInfo eoPageInfo = this.platformOrderItemDas.selectPage((BaseEo)platformOrderItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PlatformOrderItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<PlatformOrderItemRespDto> queryListByOrderId(Long orderId) {
        PlatformOrderItemEo platformOrderItemEo = new PlatformOrderItemEo();
        platformOrderItemEo.setOrderId(orderId);
        ArrayList<PlatformOrderItemRespDto> respDtos = new ArrayList<PlatformOrderItemRespDto>();
        List eoList = this.platformOrderItemDas.selectList((BaseEo)platformOrderItemEo, Integer.valueOf(0), Integer.valueOf(10000));
        DtoHelper.eoList2DtoList((Collection)eoList, respDtos, PlatformOrderItemRespDto.class);
        return respDtos;
    }

    @Override
    public List<PlatformOrderItemRespDto> queryListByOrderIds(List<Long> orderIdList) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEo::getDr, (Object)0);
        lambdaQueryWrapper.in(PlatformOrderItemEo::getOrderId, orderIdList);
        ArrayList<PlatformOrderItemRespDto> respDtos = new ArrayList<PlatformOrderItemRespDto>();
        List eoList = this.platformOrderItemDas.list((Wrapper)lambdaQueryWrapper);
        DtoHelper.eoList2DtoList((Collection)eoList, respDtos, PlatformOrderItemRespDto.class);
        return respDtos;
    }
}

