/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BillInfoAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BillInfoModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BillInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.InvoiceInfoAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.InvoiceInfoModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BillInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.InvoiceInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IBillInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.BillInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.InvoiceInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.BillInfoEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.InvoiceInfoEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BillInfoServiceImpl
implements IBillInfoService {
    @Resource
    private BillInfoDas billInfoDas;
    @Resource
    private InvoiceInfoDas invoiceInfoDas;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBillInfo(BillInfoAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BillInfoEo billInfoEo = new BillInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        if (null != reqDto.getIsDefault() && reqDto.getIsDefault() == 1) {
            this.billInfoDas.updateStatusByOrgInfoId(billInfoEo.getOrgInfoId(), billInfoEo.getId());
        }
        return billInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBillInfo(BillInfoModifyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BillInfoEo billInfoEo = new BillInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)billInfoEo);
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        if (null != reqDto.getIsDefault() && reqDto.getIsDefault() == 1) {
            this.billInfoDas.updateStatusByOrgInfoId(billInfoEo.getOrgInfoId(), billInfoEo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillInfo(Long id) {
        this.billInfoDas.deleteById(id);
    }

    @Override
    public BillInfoRespDto queryBillInfoById(Long id) {
        BillInfoEo billInfoEo = (BillInfoEo)this.billInfoDas.selectByPrimaryKey(id);
        if (billInfoEo == null) {
            return null;
        }
        BillInfoRespDto billInfoRespDto = new BillInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)billInfoEo, (BaseVo)billInfoRespDto);
        return billInfoRespDto;
    }

    @Override
    public PageInfo<BillInfoRespDto> queryBillInfoByPage(BillInfoQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        BillInfoEo billInfoEo = new BillInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)billInfoEo);
        PageInfo eoPageInfo = this.billInfoDas.selectPage((BaseEo)billInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addInvoiceInfo(InvoiceInfoAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"orgInfoId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InvoiceInfoEo queryEo = new InvoiceInfoEo();
        queryEo.setOrgInfoId(reqDto.getOrgInfoId());
        List invoiceInfoEos = this.invoiceInfoDas.select((BaseEo)queryEo);
        if (!CollectionUtils.isEmpty((Collection)invoiceInfoEos)) {
            this.invoiceInfoDas.getMapper().delete((Wrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)reqDto.getOrgInfoId()));
        }
        InvoiceInfoEo invoiceInfoEo = new InvoiceInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)invoiceInfoEo);
        this.invoiceInfoDas.insert((BaseEo)invoiceInfoEo);
        return invoiceInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyInvoiceInfo(InvoiceInfoModifyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InvoiceInfoEo invoiceInfoEo = new InvoiceInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)invoiceInfoEo);
        this.invoiceInfoDas.updateSelective((BaseEo)invoiceInfoEo);
    }

    @Override
    public InvoiceInfoRespDto queryInvoiceInfoByOrgInfoId(Long orgInfoId) {
        InvoiceInfoEo invoiceInfoEo = new InvoiceInfoEo();
        invoiceInfoEo.setOrgInfoId(orgInfoId);
        List invoiceInfoEos = this.invoiceInfoDas.select((BaseEo)invoiceInfoEo);
        if (CollectionUtils.isEmpty((Collection)invoiceInfoEos)) {
            return null;
        }
        InvoiceInfoRespDto invoiceInfoRespDto = new InvoiceInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)invoiceInfoEos.get(0)), (BaseVo)invoiceInfoRespDto);
        return invoiceInfoRespDto;
    }

    @Override
    public List<BillInfoRespDto> queryBillInfoListByOrgInfoId(Long orgInfoId) {
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setOrgInfoId(orgInfoId);
        List billInfoEoList = this.billInfoDas.select((BaseEo)billInfoEo);
        ArrayList<BillInfoRespDto> billInfoDtoList = new ArrayList<BillInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)billInfoEoList, billInfoDtoList, BillInfoRespDto.class);
        return billInfoDtoList;
    }

    @Override
    public BillInfoRespDto queryBillInfoByOrgInfoId(Integer type, Long orgInfoId) {
        BillInfoRespDto respDto = null;
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setOrgInfoId(orgInfoId);
        billInfoEo.setAccountType(type);
        billInfoEo.setIsDefault(Integer.valueOf(1));
        List billInfoEoList = this.billInfoDas.select((BaseEo)billInfoEo);
        ArrayList billInfoDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)billInfoEoList, billInfoDtoList, BillInfoRespDto.class);
        if (CollectionUtil.isNotEmpty(billInfoDtoList)) {
            respDto = (BillInfoRespDto)billInfoDtoList.get(0);
        }
        return respDto;
    }
}

