/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupTreeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerGroupService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerGroupDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerGroupEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerGroupServiceImpl
implements ICustomerGroupService {
    @Resource
    private CustomerGroupDas customerGroupDas;
    @Resource
    private CustomerDas customerDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CustomerGroupAddReqDto addReqDto) {
        CustomerGroupEo queryEo = new CustomerGroupEo();
        queryEo.setGroupName(addReqDto.getGroupName());
        List customerGroupEos = this.customerGroupDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)customerGroupEos)) {
            throw new BizException(CustomerExceptionCode.CUSTOMER_GROUP_NAME_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_GROUP_NAME_EXISTS.getMsg());
        }
        CustomerGroupEo customerGroupEo = new CustomerGroupEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerGroupEo);
        this.customerGroupDas.insert((BaseEo)customerGroupEo);
        return customerGroupEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modify(CustomerGroupModifyReqDto modifyReqDto) {
        List filterCustomerGroupEos;
        CustomerGroupEo queryEo = new CustomerGroupEo();
        queryEo.setGroupName(modifyReqDto.getGroupName());
        List customerGroupEos = this.customerGroupDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)customerGroupEos) && CollectionUtils.isNotEmpty(filterCustomerGroupEos = customerGroupEos.stream().filter(bean -> bean.getId() != modifyReqDto.getId()).collect(Collectors.toList()))) {
            throw new BizException(CustomerExceptionCode.CUSTOMER_GROUP_NAME_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_GROUP_NAME_EXISTS.getMsg());
        }
        CustomerGroupEo customerGroupEo = new CustomerGroupEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerGroupEo);
        this.customerGroupDas.updateSelective((BaseEo)customerGroupEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(Long id) {
        Map<Long, List<CustomerGroupEo>> customerGroupEoMap;
        ArrayList<Long> groupIds = new ArrayList<Long>();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        groupIds.add(id);
        CustomerGroupEo customerGroupEo = new CustomerGroupEo();
        List select = this.customerGroupDas.select((BaseEo)customerGroupEo);
        if (CollectionUtils.isNotEmpty((Collection)select) && null != (customerGroupEoMap = select.stream().collect(Collectors.groupingBy(bean -> null == bean.getParentGroupId() ? 0L : bean.getParentGroupId())))) {
            this.getChildrenGroupId(customerGroupEoMap, id, groupIds);
        }
        CustomerEo queryEo = new CustomerEo();
        sqlFilters.add(SqlFilter.in((String)"customer_group_id", (Object)StringUtils.join(groupIds, (String)",")));
        queryEo.setSqlFilters(sqlFilters);
        List customerEos = this.customerDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)customerEos)) {
            throw new BizException(CustomerExceptionCode.CUSTOMER_GROUP_EXIST_CUSTOMER.getCode(), CustomerExceptionCode.CUSTOMER_GROUP_EXIST_CUSTOMER.getMsg());
        }
        groupIds.stream().forEach(bean -> this.customerGroupDas.logicDeleteById(bean));
    }

    private void getChildrenGroupId(Map<Long, List<CustomerGroupEo>> customerGroupEoMap, Long parentGroupId, List<Long> groupIds) {
        List<CustomerGroupEo> customerGroupEos = customerGroupEoMap.get(parentGroupId);
        if (CollectionUtils.isNotEmpty(customerGroupEos)) {
            customerGroupEos.stream().forEach(bean -> {
                groupIds.add(bean.getId());
                this.getChildrenGroupId(customerGroupEoMap, bean.getId(), groupIds);
            });
        }
    }

    @Override
    public CustomerGroupRespDto queryById(Long id) {
        CustomerGroupEo customerGroupEo = (CustomerGroupEo)this.customerGroupDas.selectByPrimaryKey(id);
        CustomerGroupRespDto customerGroupRespDto = new CustomerGroupRespDto();
        DtoHelper.eo2Dto((BaseEo)customerGroupEo, (BaseVo)customerGroupRespDto);
        return customerGroupRespDto;
    }

    @Override
    public PageInfo<CustomerGroupRespDto> queryByPage(CustomerGroupQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        CustomerGroupEo customerGroupEo = new CustomerGroupEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)customerGroupEo);
        PageInfo eoPageInfo = this.customerGroupDas.selectPage((BaseEo)customerGroupEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerGroupRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CustomerGroupTreeRespDto> queryForTree() {
        ArrayList<CustomerGroupTreeRespDto> customerGroupTreeRespDtos = new ArrayList<CustomerGroupTreeRespDto>();
        CustomerGroupEo customerGroupEo = new CustomerGroupEo();
        List select = this.customerGroupDas.select((BaseEo)customerGroupEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            Map<Long, List<CustomerGroupEo>> customerGroupEoMap = select.stream().collect(Collectors.groupingBy(bean -> null == bean.getParentGroupId() ? 0L : bean.getParentGroupId()));
            List root = select.stream().filter(bean -> null == bean.getParentGroupId() || bean.getParentGroupId().intValue() == 0).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(root)) {
                root.stream().forEach(bean -> {
                    CustomerGroupTreeRespDto customerGroupTreeRespDto = new CustomerGroupTreeRespDto();
                    CubeBeanUtils.copyProperties((Object)customerGroupTreeRespDto, (Object)bean, (String[])new String[0]);
                    customerGroupTreeRespDtos.add(customerGroupTreeRespDto);
                    this.getChildCustomerGroup(customerGroupTreeRespDto, customerGroupEoMap);
                });
            }
        }
        return customerGroupTreeRespDtos;
    }

    private void getChildCustomerGroup(CustomerGroupTreeRespDto customerGroupTreeRespDto, Map<Long, List<CustomerGroupEo>> customerGroupEoMap) {
        List<CustomerGroupEo> customerGroupEos = customerGroupEoMap.get(customerGroupTreeRespDto.getId());
        if (CollectionUtils.isNotEmpty(customerGroupEos)) {
            ArrayList children = new ArrayList();
            DtoHelper.eoList2DtoList(customerGroupEos, children, CustomerGroupTreeRespDto.class);
            customerGroupTreeRespDto.setChildren(children);
            customerGroupEoMap.remove(customerGroupTreeRespDto.getId());
            children.stream().forEach(bean -> this.getChildCustomerGroup((CustomerGroupTreeRespDto)bean, customerGroupEoMap));
        }
    }
}

