/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.svr.rest.customer;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.VerifyCertificationDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.VerifyCertificationResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchBaseReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ExportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/customer"})
public class CustomerRest
implements ICustomerApi,
ICustomerQueryApi {
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private ICustomerApi customerApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    public RestResponse<Long> add(@RequestBody CustomerReqDto reqDto) {
        return this.customerApi.add(reqDto);
    }

    public RestResponse<Void> update(@RequestBody CustomerReqDto reqDto) {
        return this.customerApi.update(reqDto);
    }

    public RestResponse<Void> updateAccountStatus(@Valid CustomerReqDto reqDto) {
        return this.customerApi.updateAccountStatus(reqDto);
    }

    public RestResponse<Void> moveCustomerToRegion(@RequestParam(value="sourceRegionCode") String sourceRegionCode, @RequestParam(value="targetRegionCode") String targetRegionCode) {
        return this.customerApi.moveCustomerToRegion(sourceRegionCode, targetRegionCode);
    }

    public RestResponse<Void> saveCustomerExportRecord(@Valid @RequestBody ExportRecordReqDto reqDto) {
        return this.customerApi.saveCustomerExportRecord(reqDto);
    }

    public RestResponse<PageInfo<CustomerRespDto>> queryByExcel(MultipartFile file) {
        return this.customerApi.queryByExcel(file);
    }

    public RestResponse<CustomerRespDto> queryByCode(String code) {
        return this.customerQueryApi.queryByCode(code);
    }

    public RestResponse<CustomerRespDto> queryById(@PathVariable(value="id") Long id) {
        return this.customerQueryApi.queryById(id);
    }

    public RestResponse<List<CustomerNameSimpleRespDto>> queryListByIds(@RequestParam(name="ids", required=true) List<Long> ids) {
        return this.customerQueryApi.queryListByIds(ids);
    }

    public RestResponse<PageInfo<CustomerRespDto>> queryByPage(@RequestParam(name="filter", required=false) String filter, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return this.customerQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    public RestResponse<PageInfo<CustomerRespDto>> queryByPageOnPost(CustomerSearchReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        return this.customerQueryApi.queryByPageOnPost(searchReqDto, pageNum, pageSize);
    }

    public RestResponse<List<CustomerRespDto>> queryByList(@RequestParam(name="filter", required=false) String filter) {
        return this.customerQueryApi.queryByList(filter);
    }

    public RestResponse<List<CustomerRespDto>> queryPostByList(@RequestBody CustomerSearchReqDto searchReqDto) {
        return this.customerQueryApi.queryPostByList(searchReqDto);
    }

    public RestResponse<List<Long>> queryIdsBySingleFilter(CustomerSearchBaseReqDto customerSearchReqDto) {
        return this.customerQueryApi.queryIdsBySingleFilter(customerSearchReqDto);
    }

    public RestResponse<List<Long>> getCurrentUserOrOrgCustomer(Long userId, Long orgId) {
        return this.customerQueryApi.getCurrentUserOrOrgCustomer(userId, orgId);
    }

    public RestResponse<List<CustomerNameSimpleRespDto>> queryByListParent(Long customerId) {
        return this.customerQueryApi.queryByListParent(customerId);
    }

    public RestResponse<String> queryExcelDownloadUrl() {
        return this.customerQueryApi.queryExcelDownloadUrl();
    }

    @GetMapping(value={"/test"}, produces={"application/json"})
    RestResponse<Void> test() {
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(Long.valueOf(1255149301021517831L));
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        CustomerStatusEo customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(customerEo.getStatusId());
        customerRespDto.setId(customerEo.getId());
        customerRespDto.setCode(customerEo.getCode());
        customerRespDto.setName(customerEo.getName());
        customerRespDto.setCustomerTypeName("setCustomerTypeName");
        customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
        customerRespDto.setRegionId(customerEo.getRegionId());
        customerRespDto.setRegionCode(customerEo.getRegionCode());
        customerRespDto.setRegion("797979");
        customerRespDto.setStatusId(customerEo.getStatusId());
        customerRespDto.setStatusName(customerStatusEo.getName());
        customerRespDto.setCustomerId(customerEo.getId());
        customerRespDto.setId(customerEo.getId());
        this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
        return new RestResponse();
    }

    public RestResponse<List<CustomerRespDto>> queryCustomerRespDto(@RequestParam(name="shopIds", required=false) List<Long> shopIds) {
        return this.customerQueryApi.queryCustomerRespDto(shopIds);
    }

    public RestResponse<VerifyCertificationResultDto> verifyCertification(@Validated @RequestBody VerifyCertificationDto verifyCertificationDto) {
        return this.customerQueryApi.verifyCertification(verifyCertificationDto);
    }

    public RestResponse<Void> modifyCustomerUserIdByThirdPartyId(@Validated @RequestBody List<CustomerReqDto> reqDtos) {
        return this.customerApi.modifyCustomerUserIdByThirdPartyId(reqDtos);
    }
}

