/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountCustomerConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CommonImportRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.exception.AccountBusinessException;
import com.dtyunxi.yundt.cube.center.credit.api.account.exception.AccountBusinessExceptionCode;
import com.dtyunxi.yundt.cube.center.credit.biz.account.mq.MqCRAccountCustomerProduct;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountCustomerConfiV2Service;
import com.dtyunxi.yundt.cube.center.credit.biz.account.vo.AccountCustomerConfigVo;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountCustomerConfigDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountOrderDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountCustomerConfigEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountModelEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrAccountCustomerConfigServiceV2Impl
implements ICrAccountCustomerConfiV2Service {
    private static Logger logger = LoggerFactory.getLogger(CrAccountCustomerConfigServiceV2Impl.class);
    private static final Integer limitCount = 1000;
    @Resource
    private CrAccountCustomerConfigDas crAccountCustomerConfigDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private CrAccountModelDas accountModelDas;
    @Resource
    private ICreditAccountService creditAccountService;
    @Resource
    private CrAccountOrderDas accountOrderDas;
    @Resource
    private CrAccountBillDas accountBillDas;
    @Resource
    private CrAccountRecordDas accountRecordDas;
    @Resource
    MqCRAccountCustomerProduct mqSend;

    @Override
    public CommonImportRespDto importCrAccountCustomerConfig(MultipartFile file) {
        List customerConfigVos;
        CommonImportRespDto importRespDto = new CommonImportRespDto();
        boolean flag = true;
        ArrayList<String> msg = new ArrayList<String>();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setNeedVerfiy(false);
        HashMap<String, CustomerRespDto> customerRespDtoMap = new HashMap<String, CustomerRespDto>();
        HashMap<String, CrAccountModelEo> modelEoMap = new HashMap<String, CrAccountModelEo>();
        new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), AccountCustomerConfigVo.class, (ImportParams)importParams);
            customerConfigVos = result.getList();
            if (CollectionUtils.isEmpty((Collection)customerConfigVos)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception var17) {
            var17.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        ArrayList<CrAccountCustomerConfigReqDto> addList = new ArrayList<CrAccountCustomerConfigReqDto>();
        for (int i = 0; i < customerConfigVos.size(); ++i) {
            AccountCustomerConfigVo customerConfigVo = (AccountCustomerConfigVo)customerConfigVos.get(i);
            logger.info("\u7b2c{}\u884c\uff0ccustomerCode: {}, effectStarttime: {}, effectEndtime: {}", new Object[]{customerConfigVo.getCustomerCode(), customerConfigVo.getEffectStarttime(), customerConfigVo.getEffectEndtime()});
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getCustomerName())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u5ba2\u6237\u540d\u79f0\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            }
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getEffectStarttime())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u8d26\u671f\u751f\u6548\u65f6\u95f4\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            }
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getEffectEndtime())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u8d26\u671f\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            }
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getCustomerCode())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u5ba2\u6237\u7f16\u53f7\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            } else if (!customerRespDtoMap.containsKey(customerConfigVo.getCustomerCode())) {
                CustomerRespDto respDto = (CustomerRespDto)this.customerQueryApi.queryByCode(customerConfigVo.getCustomerCode()).getData();
                if (ObjectUtil.isEmpty((Object)respDto)) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5ba2\u6237\u7f16\u53f7:" + customerConfigVo.getCustomerCode() + "\u4e0d\u5b58\u5728\u3002");
                    flag = false;
                } else if (!respDto.getName().equals(customerConfigVo.getCustomerName())) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8868\u683c\u5ba2\u6237\u540d\u79f0[" + customerConfigVo.getCustomerCode() + "-" + customerConfigVo.getCustomerName() + "]\u4e0e\u7cfb\u7edf\u5ba2\u6237\u540d\u79f0[" + customerConfigVo.getCustomerCode() + "-" + respDto.getName() + "]\u4e0d\u4e00\u81f4");
                    flag = false;
                }
                customerRespDtoMap.put(customerConfigVo.getCustomerCode(), respDto);
            }
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getModelName())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u8d26\u671f\u540d\u79f0\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            } else if (!modelEoMap.containsKey(customerConfigVo.getModelName())) {
                CrAccountModelEo modelEo = new CrAccountModelEo();
                modelEo.setModelName(customerConfigVo.getModelName());
                CrAccountModelEo selectModelEo = (CrAccountModelEo)this.accountModelDas.selectOne((BaseEo)modelEo);
                if (ObjectUtil.isEmpty((Object)selectModelEo)) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8d26\u671f\u540d\u79f0:" + customerConfigVo.getModelName() + "\u4e0d\u5b58\u5728\u3002");
                    flag = false;
                }
                modelEoMap.put(customerConfigVo.getModelName(), selectModelEo);
            }
            if (!flag) continue;
            CrAccountCustomerConfigReqDto customerConfigReqDto = new CrAccountCustomerConfigReqDto();
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(customerConfigVo.getCustomerCode());
            customerConfigReqDto.setCustomerName(customerConfigVo.getCustomerName());
            customerConfigReqDto.setCustomerCode(customerConfigVo.getCustomerCode());
            customerConfigReqDto.setCustomerType(customerRespDto.getCustomerTypeName());
            customerConfigReqDto.setCustomerArea(customerRespDto.getRegionNames());
            CrAccountModelEo categoryEo = (CrAccountModelEo)modelEoMap.get(customerConfigVo.getModelName());
            customerConfigReqDto.setModelId(categoryEo.getId());
            customerConfigReqDto.setEffectStarttime((Date)DateUtil.parse((CharSequence)customerConfigVo.getEffectStarttime(), (DateParser)DatePattern.JDK_DATETIME_FORMAT));
            customerConfigReqDto.setEffectEndtime((Date)DateUtil.parse((CharSequence)customerConfigVo.getEffectEndtime(), (DateParser)DatePattern.JDK_DATETIME_FORMAT));
            CrAccountCustomerConfigEo customerConfigEo = new CrAccountCustomerConfigEo();
            customerConfigEo.setCustomerCode(customerConfigVo.getCustomerCode());
            List eoList = this.crAccountCustomerConfigDas.select((BaseEo)customerConfigEo);
            if (CollectionUtil.isNotEmpty((Collection)eoList)) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5ba2\u6237\u7f16\u53f7:" + customerConfigVo.getCustomerCode() + "\u5df2\u5b58\u5728\u8d26\u671f\u8bbe\u7f6e\uff0c\u4e0d\u9700\u5bfc\u5165\u3002");
                continue;
            }
            addList.add(customerConfigReqDto);
        }
        if (!flag) {
            importRespDto.setFlag(Boolean.valueOf(false));
            importRespDto.setMsg(msg);
            return importRespDto;
        }
        if (CollectionUtil.isNotEmpty(addList)) {
            this.addCrAccountCustomerConfig(addList);
        }
        importRespDto.setFlag(Boolean.valueOf(true));
        if (CollectionUtil.isNotEmpty(msg)) {
            importRespDto.setMsg(msg);
        }
        return importRespDto;
    }

    public void addCrAccountCustomerConfig(List<CrAccountCustomerConfigReqDto> list) {
        ArrayList<CrAccountCustomerConfigEo> eoList = new ArrayList<CrAccountCustomerConfigEo>();
        ArrayList<CrAccountCustomerConfigEo> msgList = new ArrayList<CrAccountCustomerConfigEo>();
        for (CrAccountCustomerConfigReqDto addReqDto : list) {
            CrAccountCustomerConfigEo crAccountCustomerConfigEo = new CrAccountCustomerConfigEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)crAccountCustomerConfigEo);
            crAccountCustomerConfigEo.setEffectStarttime(addReqDto.getEffectStarttime());
            crAccountCustomerConfigEo.setEffectEndtime(addReqDto.getEffectEndtime());
            if (ObjectUtil.isEmpty((Object)addReqDto.getEffectStarttime()) || ObjectUtil.isEmpty((Object)addReqDto.getEffectEndtime())) {
                throw new AccountBusinessException(AccountBusinessExceptionCode.ACCOUNT_MODEL_ADD_FAIL);
            }
            Long orgId = this.creditAccountService.queryOrgIdByUserId();
            if (ObjectUtil.isNotEmpty((Object)orgId)) {
                crAccountCustomerConfigEo.setOrgInfoId(orgId);
            }
            eoList.add(crAccountCustomerConfigEo);
            CrAccountCustomerConfigEo msg = new CrAccountCustomerConfigEo();
            msg.setEffectEndtime(addReqDto.getEffectEndtime());
            msg.setEffectStarttime(addReqDto.getEffectStarttime());
            msg.setCustomerCode(addReqDto.getCustomerCode());
            msgList.add(msg);
        }
        this.crAccountCustomerConfigDas.insertBatch(eoList);
        Stream.iterate(0, n -> n + 1).limit(this.getCount(msgList.size()).intValue()).forEach(i -> {
            List crAccountCustomerConfigEoList = msgList.stream().skip((long)i.intValue() * (long)limitCount.intValue()).limit(limitCount.intValue()).collect(Collectors.toList());
            this.mqSend.sendItemStockMessage(crAccountCustomerConfigEoList);
        });
    }

    private Integer getCount(Integer size) {
        return (limitCount + size - 1) / limitCount;
    }
}

