/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayApplyReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlansReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.OccupyConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditOrderBillStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.GeneralRuleCodeType;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CrAccountBillImportInfoReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CreditAccountImportInfoReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.dto.request.CreditRepayPlanImportInfoReqDto;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICreditRepayPlanService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditOccupyConfigService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.AccountBillRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOrderBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRepayApplyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRepayPlanDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditUsageRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.AccountBillRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountBillEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountModelEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditOrderBillEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRepayApplyEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRepayPlanEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditUsageRecordEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditRepayPlanServiceImpl
implements ICreditRepayPlanService {
    private static final String DEF_REMARK = "\u5bfc\u5165\u6570\u636e";
    @Resource
    private GenerateCode generateCode;
    @Resource
    private ICreditOccupyConfigService creditOccupyConfigService;
    @Resource
    private CreditRepayPlanDas creditRepayPlanDas;
    @Resource
    private CreditOrderBillDas creditOrderBillDas;
    @Resource
    private CreditUsageRecordDas creditUsageRecordDas;
    @Resource
    private CreditRepayApplyDas creditRepayApplyDas;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Resource
    private CrAccountModelDas crAccountModelDas;
    @Resource
    private CrAccountBillDas crAccountBillDas;
    @Resource
    private CrAccountRecordDas crAccountRecordDas;
    @Resource
    private AccountBillRecordDas accountBillRecordDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchImportPlans(List<CreditRepayPlanImportInfoReqDto> creditRepayPlanImportInfoReqDtos) {
        OccupyConfigReqDto occupyConfigReqDto = this.creditOccupyConfigService.getOccupyConfigByOrgId(creditRepayPlanImportInfoReqDtos.get(0).getOrgInfoId());
        Optional.ofNullable(occupyConfigReqDto).orElseThrow(() -> new BizException("\u989d\u5ea6\u5360\u7528\u7b56\u7565\u4e0d\u5b58\u5728"));
        ArrayList recordEos = Lists.newArrayList();
        ArrayList billEos = Lists.newArrayList();
        ArrayList planEos = Lists.newArrayList();
        for (CreditRepayPlanImportInfoReqDto plan : creditRepayPlanImportInfoReqDtos) {
            CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
            creditUsageRecordEo.setOrgInfoId(plan.getOrgInfoId());
            creditUsageRecordEo.setCreditAccountId(plan.getCreditAccountId());
            creditUsageRecordEo.setUsageType(CreditUsageTypeEnum.CONTROL.getType());
            creditUsageRecordEo.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
            creditUsageRecordEo.setFormCode(plan.getFormCode());
            creditUsageRecordEo.setQuota(plan.getPaidAmount());
            String code = this.generateCode.createCode(GeneralRuleCodeType.USAGE_RECORD);
            creditUsageRecordEo.setUsageRecordNo(code);
            creditUsageRecordEo.setRemark("\u5bfc\u5165\u8865\u5145\u9884\u5360\u8bb0\u5f55");
            creditUsageRecordEo.setRemainingQuota(BigDecimal.ZERO);
            creditUsageRecordEo.setCustomerId(plan.getCustomerId());
            recordEos.add(creditUsageRecordEo);
            CreditOrderBillEo creditOrderBillEo = new CreditOrderBillEo();
            creditOrderBillEo.setOrgInfoId(plan.getOrgInfoId());
            creditOrderBillEo.setUsageRecordNo(code);
            creditOrderBillEo.setCreditOrderBillCode(this.generateCode.createCode(GeneralRuleCodeType.XYDD));
            creditOrderBillEo.setCreditOccupyConfigId(occupyConfigReqDto.getId());
            creditOrderBillEo.setCreditAccountId(plan.getCreditAccountId());
            creditOrderBillEo.setCreditEntityId(plan.getCustomerId());
            creditOrderBillEo.setFormCode(plan.getFormCode());
            creditOrderBillEo.setCreditTermModelId(plan.getCreditTermModelId());
            creditOrderBillEo.setQuotaStrategyId(plan.getQuotaStrategyId());
            creditOrderBillEo.setOverdueStrategyId(plan.getOverdueStrategyId());
            creditOrderBillEo.setAccountQuota(plan.getOccupyQuota());
            creditOrderBillEo.setAccountUsedQuota(plan.getPaidAmount());
            creditOrderBillEo.setCreditOrderBillStatus(CreditOrderBillStatusEnum.GOOD.getCode());
            billEos.add(creditOrderBillEo);
            CreditRepayPlanEo creditRepayPlanEo = new CreditRepayPlanEo();
            BeanUtil.copyProperties((Object)plan, (Object)creditRepayPlanEo, (String[])new String[0]);
            creditRepayPlanEo.setRepayPlanNo(this.generateCode.createCode(GeneralRuleCodeType.PLAN_RECORD));
            creditRepayPlanEo.setAuditStatus("NONE");
            planEos.add(creditRepayPlanEo);
        }
        if (CollectionUtil.isNotEmpty((Collection)planEos)) {
            this.creditRepayPlanDas.insertBatch((List)planEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)billEos)) {
            this.creditOrderBillDas.insertBatch((List)billEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)recordEos)) {
            this.creditUsageRecordDas.insertBatch((List)recordEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchImportRepayApplys(List<CreditRepayApplyReqDto> creditRepayApplyReqDtos) {
        ArrayList repayApplyEos = Lists.newArrayList();
        ArrayList planIds = Lists.newArrayList();
        for (CreditRepayApplyReqDto creditRepayApplyReqDto : creditRepayApplyReqDtos) {
            CreditRepayApplyEo creditRepayApplyEo = new CreditRepayApplyEo();
            creditRepayApplyEo.setName(creditRepayApplyReqDto.getName());
            creditRepayApplyEo.setCreditRepayIds(JSON.toJSONString((Object)creditRepayApplyReqDto.getCreditRepayPlans()));
            creditRepayApplyEo.setOrganizationId(creditRepayApplyReqDto.getOrganizationId());
            creditRepayApplyEo.setApplyCode(this.generateCode.createCode(GeneralRuleCodeType.ZD));
            creditRepayApplyEo.setEntityId(creditRepayApplyReqDto.getEntityId());
            creditRepayApplyEo.setRefundAmount(creditRepayApplyReqDto.getRefundAmount());
            creditRepayApplyEo.setRemark(DEF_REMARK);
            creditRepayApplyEo.setApplyPerson(creditRepayApplyReqDto.getApplyPerson());
            creditRepayApplyEo.setAuditStatus(creditRepayApplyReqDto.getAuditStatus());
            repayApplyEos.add(creditRepayApplyEo);
            for (CreditRepayPlansReqDto creditRepayPlan : creditRepayApplyReqDto.getCreditRepayPlans()) {
                Optional.ofNullable(creditRepayPlan.getId()).ifPresent(planIds::add);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)repayApplyEos)) {
            this.creditRepayApplyDas.insertBatch((List)repayApplyEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)planIds)) {
            CreditRepayPlanEo planUpdateEo = new CreditRepayPlanEo();
            planUpdateEo.setAuditStatus(AuditStatusEnum.WAIT_AUDIT.getCode());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id", (Collection)planIds);
            int succRows = this.creditRepayPlanDas.getMapper().update((Object)planUpdateEo, (Wrapper)updateWrapper);
            if (succRows != planIds.size()) {
                throw new BizException("\u8d26\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
        }
    }

    @Override
    public void batchImportAccounts(List<CreditAccountImportInfoReqDto> creditAccountImportInfoReqDtos) {
        if (CollectionUtil.isEmpty(creditAccountImportInfoReqDtos)) {
            return;
        }
        ArrayList addEos = Lists.newArrayList();
        ArrayList updateEos = Lists.newArrayList();
        ArrayList recordEos = Lists.newArrayList();
        for (CreditAccountImportInfoReqDto account3 : creditAccountImportInfoReqDtos) {
            if (Objects.equals(1, account3.getOptType())) {
                CreditAccountEo addEo = new CreditAccountEo();
                CubeBeanUtils.copyProperties((Object)addEo, (Object)account3, (String[])new String[0]);
                addEo.setCreditAccountCode(this.generateCode.createCode(GeneralRuleCodeType.XYZH));
                addEos.add(addEo);
                continue;
            }
            CreditAccountEo updateEo = new CreditAccountEo();
            updateEo.setId(account3.getId());
            updateEo.setAccountQuota(account3.getAccountQuota().add(account3.getOldAccountQuota()));
            updateEo.setAccountUsedQuota(account3.getAccountUsedQuota().add(account3.getOldAccountUsedQuota()));
            updateEos.add(updateEo);
            CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
            creditUsageRecordEo.setOrgInfoId(account3.getOrgInfoId());
            creditUsageRecordEo.setCustomerId(account3.getCreditEntityId());
            creditUsageRecordEo.setCreditAccountId(account3.getId());
            creditUsageRecordEo.setUsageType(Integer.valueOf(1));
            creditUsageRecordEo.setCreditUsageStatus(Integer.valueOf(1));
            creditUsageRecordEo.setFormCode("");
            creditUsageRecordEo.setQuota(account3.getAccountQuota().subtract(account3.getAccountUsedQuota()));
            creditUsageRecordEo.setUsageRecordNo(this.generateCode.createCode(GeneralRuleCodeType.USAGE_RECORD));
            creditUsageRecordEo.setRemark("\u5ba2\u6237\u6863\u6848\u521d\u59cb\u5316\u5bfc\u5165\u6d41\u6c34");
            creditUsageRecordEo.setRemainingQuota(account3.getAccountQuota().add(account3.getOldAccountQuota()).subtract(account3.getOldAccountUsedQuota()).subtract(account3.getAccountUsedQuota()));
            creditUsageRecordEo.setCustomerId(account3.getCreditEntityId());
            recordEos.add(creditUsageRecordEo);
        }
        if (CollectionUtil.isNotEmpty((Collection)addEos)) {
            this.creditAccountDas.insertBatch((List)addEos);
            for (CreditAccountEo addEo : addEos) {
                CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
                creditUsageRecordEo.setOrgInfoId(addEo.getOrgInfoId());
                creditUsageRecordEo.setCustomerId(addEo.getCreditEntityId());
                creditUsageRecordEo.setCreditAccountId(addEo.getId());
                creditUsageRecordEo.setUsageType(Integer.valueOf(1));
                creditUsageRecordEo.setCreditUsageStatus(Integer.valueOf(1));
                creditUsageRecordEo.setFormCode("");
                creditUsageRecordEo.setQuota(addEo.getAccountQuota().subtract(addEo.getAccountUsedQuota()));
                creditUsageRecordEo.setUsageRecordNo(this.generateCode.createCode(GeneralRuleCodeType.USAGE_RECORD));
                creditUsageRecordEo.setRemark("\u5ba2\u6237\u6863\u6848\u521d\u59cb\u5316\u5bfc\u5165\u6d41\u6c34");
                creditUsageRecordEo.setRemainingQuota(creditUsageRecordEo.getQuota());
                creditUsageRecordEo.setCustomerId(addEo.getCreditEntityId());
                recordEos.add(creditUsageRecordEo);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)updateEos)) {
            updateEos.stream().sorted((account1, account2) -> account1.getId() - account2.getId() == 0L ? 0 : 1).forEach(account -> {
                int row = this.creditAccountDas.updateSelective((BaseEo)account);
                if (row != 1) {
                    throw new BizException("\u66f4\u65b0\u8d26\u6237\u5931\u8d25");
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)recordEos)) {
            this.creditUsageRecordDas.insertBatch((List)recordEos);
        }
    }

    @Override
    public void batchImportAccountBills(List<CrAccountBillImportInfoReqDto> crAccountBillReqDtos) {
        if (CollectionUtil.isEmpty(crAccountBillReqDtos)) {
            return;
        }
        List modelIds = crAccountBillReqDtos.stream().map(CrAccountBillImportInfoReqDto::getModelId).collect(Collectors.toList());
        List modelEos = ((ExtQueryChainWrapper)this.crAccountModelDas.filter().in((Object)"id", modelIds)).list();
        Map modelEoMap = modelEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (e1, e2) -> e1));
        ArrayList billEos = Lists.newArrayList();
        ArrayList recordEos = Lists.newArrayList();
        ArrayList billRecordEos = Lists.newArrayList();
        for (CrAccountBillImportInfoReqDto crAccountBillReqDto : crAccountBillReqDtos) {
            CrAccountModelEo crAccountModelEo = (CrAccountModelEo)modelEoMap.get(crAccountBillReqDto.getModelId());
            CrAccountBillEo crAccountBillEo = new CrAccountBillEo();
            crAccountBillEo.setBillNo(this.generateCode.createCode(GeneralRuleCodeType.ZD));
            crAccountBillEo.setStatementDate(crAccountBillReqDto.getStatementDate());
            crAccountBillEo.setBillAmount(crAccountBillReqDto.getBillAmount());
            crAccountBillEo.setCustomerName(crAccountBillReqDto.getCustomerName());
            crAccountBillEo.setCustomerCode(crAccountBillReqDto.getCustomerCode());
            crAccountBillEo.setCustomerId(crAccountBillReqDto.getCustomerId());
            if (crAccountModelEo != null) {
                crAccountBillEo.setModelType(crAccountModelEo.getModelType());
            }
            crAccountBillEo.setStatus(crAccountBillReqDto.getStatus());
            crAccountBillEo.setPayBackPerson(crAccountBillReqDto.getPayBackPerson());
            crAccountBillEo.setPayBackTime(new Date());
            crAccountBillEo.setOperateTime(new Date());
            crAccountBillEo.setLastPayBackTime(crAccountBillReqDto.getLastPayBackTime());
            crAccountBillEo.setAlreadyRepaidAmount(crAccountBillReqDto.getAlreadyRepaidAmount());
            crAccountBillEo.setNotYetAmount(crAccountBillReqDto.getNotYetAmount());
            crAccountBillEo.setOrgInfoId(Long.valueOf(crAccountBillReqDto.getOrgInfoId()));
            billEos.add(crAccountBillEo);
            CrAccountRecordEo crAccountRecordEo = new CrAccountRecordEo();
            crAccountRecordEo.setOrderNo(crAccountBillReqDto.getOrderNo());
            crAccountRecordEo.setOrderType("0");
            crAccountRecordEo.setOrderAmount(crAccountBillReqDto.getBillAmount());
            crAccountRecordEo.setBillAmount(crAccountBillReqDto.getBillAmount());
            crAccountRecordEo.setSendTime(new Date());
            crAccountRecordEo.setLastTime(crAccountBillReqDto.getLastPayBackTime());
            crAccountRecordEo.setShopId(crAccountBillReqDto.getShopId());
            crAccountRecordEo.setShop(crAccountBillReqDto.getShopName());
            crAccountRecordEo.setBillNo(crAccountBillEo.getBillNo());
            crAccountRecordEo.setOrgInfoId(crAccountBillEo.getOrgInfoId());
            recordEos.add(crAccountRecordEo);
            if (crAccountBillReqDto.getAlreadyRepaidAmount() == null || BigDecimal.ZERO.compareTo(crAccountBillReqDto.getAlreadyRepaidAmount()) >= 0) continue;
            AccountBillRecordEo accountBillRecordEo = new AccountBillRecordEo();
            accountBillRecordEo.setBillNo(crAccountBillEo.getBillNo());
            accountBillRecordEo.setSerialNo(crAccountBillEo.getBillNo());
            accountBillRecordEo.setReturnAmount(crAccountBillReqDto.getAlreadyRepaidAmount());
            accountBillRecordEo.setReturnTime(new Date());
            accountBillRecordEo.setRemark("\u5bfc\u5165\u8d26\u671f\u8d26\u5355\uff0c\u8865\u5145\u8fd8\u6b3e\u6d41\u6c34");
            accountBillRecordEo.setOperatePerson("");
            accountBillRecordEo.setOperateTime(new Date());
            accountBillRecordEo.setOrgInfoId(crAccountBillEo.getOrgInfoId());
            billRecordEos.add(accountBillRecordEo);
        }
        if (CollectionUtil.isNotEmpty((Collection)billEos)) {
            this.crAccountBillDas.insertBatch((List)billEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)recordEos)) {
            this.crAccountRecordDas.insertBatch((List)recordEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)billRecordEos)) {
            this.accountBillRecordDas.insertBatch((List)billRecordEos);
        }
    }
}

