/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.UpdateStoreSellerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreCategoryCodeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractStoreSellerServiceImpl
implements IStoreSellerService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStoreSellerServiceImpl.class);
    @Resource
    private StoreSellerDas storeSellerDas;

    @Override
    public Long addStoreSeller(StoreSellerReqDto addReqDto) {
        StoreSellerEo storeSellerEo = new StoreSellerEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storeSellerEo);
        this.storeSellerDas.insert((BaseEo)storeSellerEo);
        return storeSellerEo.getId();
    }

    @Override
    public void modifyStoreSeller(StoreSellerReqDto modifyReqDto) {
        StoreSellerEo storeSellerEo = new StoreSellerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storeSellerEo);
        this.storeSellerDas.updateSelective((BaseEo)storeSellerEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStoreSeller(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storeSellerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StoreSellerRespDto queryById(Long id) {
        StoreSellerEo storeSellerEo = (StoreSellerEo)this.storeSellerDas.selectByPrimaryKey(id);
        StoreSellerRespDto storeSellerRespDto = new StoreSellerRespDto();
        DtoHelper.eo2Dto((BaseEo)storeSellerEo, (BaseVo)storeSellerRespDto);
        return storeSellerRespDto;
    }

    @Override
    public PageInfo<StoreSellerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StoreSellerReqDto storeSellerReqDto = (StoreSellerReqDto)JSON.parseObject((String)filter, StoreSellerReqDto.class);
        StoreSellerEo storeSellerEo = new StoreSellerEo();
        DtoHelper.dto2Eo((BaseVo)storeSellerReqDto, (BaseEo)storeSellerEo);
        PageInfo eoPageInfo = this.storeSellerDas.selectPage((BaseEo)storeSellerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StoreSellerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void batchUpdateStoreSeller(UpdateStoreSellerReqDto reqDto) {
    }

    @Override
    public StoreSellerRespDto selectOne(StoreSellerReqDto storeSellerReqDto) {
        StoreSellerEo reqEo = new StoreSellerEo();
        DtoHelper.dto2Eo((BaseVo)storeSellerReqDto, (BaseEo)reqEo);
        StoreSellerEo storeSellerEo = (StoreSellerEo)this.storeSellerDas.selectOne((BaseEo)reqEo);
        StoreSellerRespDto storeSellerRespDto = new StoreSellerRespDto();
        CubeBeanUtils.copyProperties((Object)storeSellerRespDto, (Object)storeSellerEo, (String[])new String[0]);
        return storeSellerRespDto;
    }

    @Override
    public List<StoreCategoryCodeRespDto> queryStoreCategory() {
        return null;
    }

    @Override
    public List<StoreSellerRespDto> selectList(StoreSellerReqDto storeSellerReqDto) {
        QueryWrapper wrapper = new QueryWrapper();
        if (storeSellerReqDto.getSellerId() != null) {
            wrapper.eq((Object)"seller_id", (Object)storeSellerReqDto.getSellerId());
        }
        List list = this.storeSellerDas.getMapper().selectList((Wrapper)wrapper);
        ArrayList rList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)rList, (Collection)list, StoreSellerRespDto.class);
        return rList;
    }
}

