/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.mkld;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.tree.TreeBuilder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CsOrganizationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.OrganizationAdvTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CsOrganizationRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractCsOrganizationServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.BeanUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CsOrganizationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CsOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.api.constants.OrgUserConstants;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mkld_ICsOrganizationService")
public class MkldCsOrganizationServiceImpl
extends AbstractCsOrganizationServiceImpl {
    @Resource
    private CsOrganizationDas csOrganizationDas;

    private Long getTenantId(Long tenantId) {
        return tenantId == null ? ServiceContext.getContext().getRequestTenantId() : tenantId;
    }

    private Long getInstanceId(Long instanceId) {
        return instanceId == null ? ServiceContext.getContext().getRequestInstanceId() : instanceId;
    }

    @Override
    public Long addCsOrganization(CsOrganizationReqDto addReqDto) {
        CsOrganizationEo parent;
        Long tenantId = this.getTenantId(addReqDto.getTenantId());
        Long instanceId = this.getInstanceId(addReqDto.getInstanceId());
        String orgCode = addReqDto.getCode();
        CsOrganizationEo queryEo = this.queryByCode(orgCode, tenantId);
        AssertUtil.isTrue((queryEo == null ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u5355\u5143\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93");
        Long parentId = addReqDto.getParentId();
        if (parentId == null) {
            parentId = OrgUserConstants.ORG_ROOT_ID;
        } else if (!OrgUserConstants.ORG_ROOT_ID.equals(parentId) && (parent = (CsOrganizationEo)this.csOrganizationDas.selectByPrimaryKey(parentId)) == null) {
            throw new BizException("\u7236\u7ea7\u7ec4\u7ec7\u5355\u5143[parentId=" + parentId + "]\u4e0d\u5b58\u5728");
        }
        CsOrganizationEo csOrganizationEo = new CsOrganizationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csOrganizationEo);
        csOrganizationEo.setParentId(parentId);
        csOrganizationEo.setTenantId(tenantId);
        csOrganizationEo.setInstanceId(instanceId);
        if (StringUtils.isBlank((CharSequence)csOrganizationEo.getExtension())) {
            csOrganizationEo.setExtension("");
        }
        this.csOrganizationDas.insert((BaseEo)csOrganizationEo);
        return csOrganizationEo.getId();
    }

    @Override
    public void modifyCsOrganization(CsOrganizationReqDto modifyReqDto) {
        CsOrganizationEo csOrganizationEo = new CsOrganizationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csOrganizationEo);
        this.csOrganizationDas.updateSelective((BaseEo)csOrganizationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsOrganization(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csOrganizationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsOrganizationRespDto queryById(Long id) {
        CsOrganizationEo csOrganizationEo = (CsOrganizationEo)this.csOrganizationDas.selectByPrimaryKey(id);
        CsOrganizationRespDto csOrganizationRespDto = new CsOrganizationRespDto();
        BeanCopyUtil.copyProperties((Object)csOrganizationEo, (Object)csOrganizationRespDto);
        return csOrganizationRespDto;
    }

    @Override
    public CsOrganizationRespDto queryTree(OrganizationAdvTreeReqDto orgAdvTreeReqDto) {
        Long tenantId = this.getTenantId(orgAdvTreeReqDto.getTenantId());
        CsOrganizationEo queryEo = new CsOrganizationEo();
        BeanCopyUtil.copyProperties((Object)orgAdvTreeReqDto, (Object)queryEo);
        queryEo.setTenantId(tenantId);
        List organizationEos = this.csOrganizationDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(5000));
        ArrayList<CsOrganizationRespDto> orgAdvTreeRespDtos = new ArrayList<CsOrganizationRespDto>();
        for (CsOrganizationEo eo : organizationEos) {
            CsOrganizationRespDto dto = new CsOrganizationRespDto();
            BeanCopyUtil.copyProperties((Object)eo, (Object)dto);
            orgAdvTreeRespDtos.add(dto);
        }
        TreeBuilder treeBuilder = new TreeBuilder();
        Comparator<CsOrganizationRespDto> bySortASC = Comparator.comparing(CsOrganizationRespDto::getSortNO, Comparator.nullsLast(Integer::compareTo));
        List results = treeBuilder.buildByParentKey(orgAdvTreeRespDtos, Boolean.valueOf(false), bySortASC);
        return CollectionUtils.isEmpty((Collection)results) ? null : (CsOrganizationRespDto)results.get(0);
    }

    @Override
    public PageInfo<CsOrganizationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CsOrganizationReqDto csOrganizationReqDto = (CsOrganizationReqDto)JSON.parseObject((String)filter, CsOrganizationReqDto.class);
        CsOrganizationEo csOrganizationEo = new CsOrganizationEo();
        DtoHelper.dto2Eo((BaseVo)csOrganizationReqDto, (BaseEo)csOrganizationEo);
        PageInfo eoPageInfo = this.csOrganizationDas.selectPage((BaseEo)csOrganizationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(BeanUtil.copyList(eoPageInfo.getList(), CsOrganizationRespDto.class));
        return dtoPageInfo;
    }

    @Override
    public List<CsOrganizationRespDto> queryListByOrgCode(List<String> orgCodeList) {
        ArrayList orgAdvDetailRespDtoList = Lists.newArrayList();
        if (!CollectionUtil.isEmpty(orgCodeList) && !StringUtils.isEmpty((CharSequence)orgCodeList.get(0))) {
            List<CsOrganizationRespDto> thirdOrgVoList = this.queryOrgDetailByThirdCode(orgCodeList, 2);
            if (CollectionUtil.isEmpty(thirdOrgVoList)) {
                return orgAdvDetailRespDtoList;
            }
            CubeBeanUtils.copyCollection((Collection)orgAdvDetailRespDtoList, thirdOrgVoList, CsOrganizationRespDto.class);
            return orgAdvDetailRespDtoList;
        }
        return orgAdvDetailRespDtoList;
    }

    private List<CsOrganizationRespDto> queryOrgDetailByThirdCode(List<String> thirdCodeList, Integer type) {
        List csOrganizationEoList;
        ExtQueryChainWrapper filter = this.csOrganizationDas.filter();
        if (ObjectUtils.isNotEmpty((Object)type)) {
            filter.eq((Object)"type", (Object)type);
        }
        if (CollectionUtils.isNotEmpty(thirdCodeList)) {
            filter.in((Object)"code", thirdCodeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(csOrganizationEoList = filter.list()))) {
            return BeanCopyUtil.copyPropertiesForList((List)csOrganizationEoList, CsOrganizationRespDto.class);
        }
        return null;
    }

    private CsOrganizationEo queryByCode(String orgCode, Long tenantId) {
        CsOrganizationEo queryEo = new CsOrganizationEo();
        queryEo.setCode(orgCode);
        queryEo.setTenantId(tenantId);
        List results = this.csOrganizationDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1));
        return CollectionUtils.isEmpty((Collection)results) ? null : (CsOrganizationEo)results.get(0);
    }
}

