/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.PlatformStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.StockStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmpowerPlatformReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmpowerPlatformRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IEmpowerPlatformService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.customer.dao.das.ChannelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmpowerPlatformDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmpowerPlatformEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractEmpowerPlatformServiceImpl
implements IEmpowerPlatformService {
    @Resource
    private EmpowerPlatformDas empowerPlatformDas;
    @Resource
    private ChannelDas channelDas;
    private static final Logger logger = LoggerFactory.getLogger(AbstractEmpowerPlatformServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String platformImport(ImportDto importDto) {
        return "\u5e73\u53f0\u5f52\u5c5e\u6e20\u9053\u5bfc\u5165\u6210\u529f\uff01";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addEmpowerPlatform(EmpowerPlatformReqDto addReqDto) {
        List empowerPlatformEos = this.empowerPlatformDas.selectAll();
        if (empowerPlatformEos.size() > 0) {
            String name = addReqDto.getName();
            String code = addReqDto.getCode();
            Assert.isTrue(!empowerPlatformEos.stream().map(c -> c.getName()).collect(Collectors.toList()).stream().anyMatch(p -> name.equals(p)), CustomerExceptionCode.PLATFORM_NAME_REPETITION);
            Assert.isTrue(!empowerPlatformEos.stream().map(c -> c.getCode()).collect(Collectors.toList()).stream().anyMatch(p -> code.equals(p)), CustomerExceptionCode.PLATFORM_CODE_REPETITION);
        }
        EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)empowerPlatformEo);
        this.empowerPlatformDas.insert((BaseEo)empowerPlatformEo);
        return empowerPlatformEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyEmpowerPlatform(EmpowerPlatformReqDto modifyReqDto) {
        EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)empowerPlatformEo);
        this.empowerPlatformDas.updateSelective((BaseEo)empowerPlatformEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEmpowerPlatform(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.empowerPlatformDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void oaPlatformSync(List<EmpowerPlatformReqDto> empowerPlatformReqDtoList) {
        try {
            List codes = empowerPlatformReqDtoList.stream().map(c -> c.getCode()).collect(Collectors.toList());
            EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            if (CollectionUtils.isNotEmpty(codes)) {
                sqlFilterList.add(SqlFilter.in((String)"code", codes));
            }
            empowerPlatformEo.setSqlFilters(sqlFilterList);
            List empowerEoList = this.empowerPlatformDas.select((BaseEo)empowerPlatformEo);
            ArrayList platformAddList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)empowerEoList)) {
                List collect = empowerEoList.stream().map(eo -> eo.getCode()).collect(Collectors.toList());
                empowerPlatformReqDtoList.stream().forEach(e -> {
                    empowerEoList.stream().forEach(platformEo -> {
                        if (platformEo.getCode().equals(e.getCode())) {
                            EmpowerPlatformEo eo = new EmpowerPlatformEo();
                            eo.setCode(e.getCode());
                            eo.setName(e.getName());
                            eo.setStatus(e.getStatus());
                            eo.setId(platformEo.getId());
                            this.empowerPlatformDas.updateSelective((BaseEo)eo);
                        }
                    });
                    if (!collect.contains(e.getCode())) {
                        EmpowerPlatformEo eo = new EmpowerPlatformEo();
                        eo.setCode(e.getCode());
                        eo.setName(e.getName());
                        eo.setStatus(e.getStatus());
                        platformAddList.add(eo);
                    }
                });
            } else {
                CubeBeanUtils.copyCollection(platformAddList, empowerPlatformReqDtoList, EmpowerPlatformEo.class);
            }
            if (CollectionUtils.isNotEmpty(platformAddList)) {
                this.empowerPlatformDas.insertBatch(platformAddList);
            }
        }
        catch (Exception e2) {
            throw new BizException(CustomerExceptionCode.PLATFORM_SAP_FAIL.getCode(), CustomerExceptionCode.PLATFORM_SAP_FAIL.getMsg(), (Throwable)e2);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void stockRelationPlatform(List<Long> ids) {
        ids.stream().forEach(id -> {
            EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
            empowerPlatformEo.setId(id);
            empowerPlatformEo.setType(StockStatus.APPROVE_FAIL.getCode());
            this.empowerPlatformDas.updateSelective((BaseEo)empowerPlatformEo);
        });
    }

    @Override
    public void stockUpdatePlatform(List<Long> ids) {
        ids.stream().forEach(id -> {
            EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
            empowerPlatformEo.setId(id);
            empowerPlatformEo.setType(StockStatus.APPROVE_PASS.getCode());
            this.empowerPlatformDas.updateSelective((BaseEo)empowerPlatformEo);
        });
    }

    @Override
    public EmpowerPlatformRespDto queryById(Long id) {
        EmpowerPlatformEo empowerPlatformEo = (EmpowerPlatformEo)((ExtQueryChainWrapper)this.empowerPlatformDas.filter().eq((Object)"id", (Object)id)).one();
        EmpowerPlatformRespDto empowerPlatformRespDto = new EmpowerPlatformRespDto();
        DtoHelper.eo2Dto((BaseEo)empowerPlatformEo, (BaseVo)empowerPlatformRespDto);
        return empowerPlatformRespDto;
    }

    @Override
    public List<EmpowerPlatformRespDto> queryByCodes(List<String> codes) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isNotEmpty(codes)) {
            return null;
        }
        sqlFilterList.add(SqlFilter.in((String)"code", codes));
        EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
        empowerPlatformEo.setSqlFilters(sqlFilterList);
        List select = this.empowerPlatformDas.select((BaseEo)empowerPlatformEo);
        ArrayList<EmpowerPlatformRespDto> empowerPlatformRespDtoList = new ArrayList<EmpowerPlatformRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, empowerPlatformRespDtoList, EmpowerPlatformRespDto.class);
        return empowerPlatformRespDtoList;
    }

    @Override
    public List<EmpowerPlatformRespDto> queryByName(String name) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sqlFilterList.add(SqlFilter.like((String)"name", (Object)("%" + name + "%")));
        }
        EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
        empowerPlatformEo.setSqlFilters(sqlFilterList);
        List select = this.empowerPlatformDas.select((BaseEo)empowerPlatformEo);
        ArrayList<EmpowerPlatformRespDto> empowerPlatformRespDtoList = new ArrayList<EmpowerPlatformRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, empowerPlatformRespDtoList, EmpowerPlatformRespDto.class);
        return empowerPlatformRespDtoList;
    }

    @Override
    public PageInfo<EmpowerPlatformRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        EmpowerPlatformReqDto empowerPlatformReqDto = (EmpowerPlatformReqDto)JSON.parseObject((String)filter, EmpowerPlatformReqDto.class);
        EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)empowerPlatformReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + empowerPlatformReqDto.getName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)empowerPlatformReqDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + empowerPlatformReqDto.getCode() + "%")));
        }
        empowerPlatformEo.setOrderByDesc("create_time");
        empowerPlatformEo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.empowerPlatformDas.selectPage((BaseEo)empowerPlatformEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EmpowerPlatformRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<EmpowerPlatformRespDto> queryByTypePage(String filter, Integer pageNum, Integer pageSize) {
        EmpowerPlatformReqDto empowerPlatformReqDto = (EmpowerPlatformReqDto)JSON.parseObject((String)filter, EmpowerPlatformReqDto.class);
        EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"type", (Object)StockStatus.APPROVE_PASS.getCode()));
        if (StringUtils.isNotBlank((CharSequence)empowerPlatformReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + empowerPlatformReqDto.getName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)empowerPlatformReqDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + empowerPlatformReqDto.getCode() + "%")));
        }
        empowerPlatformEo.setOrderByDesc("create_time");
        empowerPlatformEo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.empowerPlatformDas.selectPage((BaseEo)empowerPlatformEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EmpowerPlatformRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<EmpowerPlatformRespDto> queryPlatform() {
        ArrayList platformRespDtoList = Lists.newArrayList();
        List platformEos = this.empowerPlatformDas.selectAll();
        DtoHelper.eoList2DtoList((Collection)platformEos, (Collection)platformRespDtoList, EmpowerPlatformRespDto.class);
        return platformRespDtoList;
    }

    @Override
    public List<EmpowerPlatformRespDto> queryPlatformByStatus() {
        ArrayList platformRespDtoList = Lists.newArrayList();
        List platformEos = ((ExtQueryChainWrapper)this.empowerPlatformDas.filter().eq((Object)"status", (Object)PlatformStatus.START.getCode())).list();
        DtoHelper.eoList2DtoList((Collection)platformEos, (Collection)platformRespDtoList, EmpowerPlatformRespDto.class);
        return platformRespDtoList;
    }

    @Override
    public List<EmpowerPlatformRespDto> queryPlatformListByTime(String updateTime) {
        ArrayList<EmpowerPlatformRespDto> empowerPlatformRespDtoList = new ArrayList<EmpowerPlatformRespDto>();
        if (StringUtils.isEmpty((CharSequence)updateTime)) {
            List empowerPlatformEos = this.empowerPlatformDas.selectAll();
            DtoHelper.eoList2DtoList((Collection)empowerPlatformEos, empowerPlatformRespDtoList, EmpowerPlatformRespDto.class);
        } else {
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.ge((String)"update_time", (Object)updateTime));
            EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
            empowerPlatformEo.setSqlFilters(sqlFilterList);
            List select = this.empowerPlatformDas.select((BaseEo)empowerPlatformEo);
            DtoHelper.eoList2DtoList((Collection)select, empowerPlatformRespDtoList, EmpowerPlatformRespDto.class);
        }
        return empowerPlatformRespDtoList;
    }

    @Override
    public List<EmpowerPlatformRespDto> queryPlatformByIds(List<Long> ids) {
        EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isNotEmpty(ids)) {
            return null;
        }
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        empowerPlatformEo.setSqlFilters(sqlFilterList);
        List select = this.empowerPlatformDas.select((BaseEo)empowerPlatformEo);
        ArrayList<EmpowerPlatformRespDto> empowerPlatformRespDtoList = new ArrayList<EmpowerPlatformRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, empowerPlatformRespDtoList, EmpowerPlatformRespDto.class);
        return empowerPlatformRespDtoList;
    }

    @Override
    public List<EmpowerPlatformRespDto> queryPlatformByChannelIds(List<Long> channelIds) {
        ExtQueryChainWrapper filter = this.empowerPlatformDas.filter();
        List empowerPlatformEoList = ((ExtQueryChainWrapper)filter.in((Object)"channel_id", channelIds)).select(new String[0]).list();
        ArrayList<EmpowerPlatformRespDto> empowerPlatformRespDtoList = new ArrayList<EmpowerPlatformRespDto>();
        DtoHelper.eoList2DtoList((Collection)empowerPlatformEoList, empowerPlatformRespDtoList, EmpowerPlatformRespDto.class);
        return empowerPlatformRespDtoList;
    }
}

