/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.adapter;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerAreaDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerAreaMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerRegionMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerAreaExtService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCustomerAreaExtServiceImpl
implements ICustomerAreaExtService {
    Logger logger = LoggerFactory.getLogger(AbstractCustomerAreaExtServiceImpl.class);
    @Resource
    private CustomerAreaDas customerAreaDas;
    @Resource
    private RCustomerRegionMapper rCustomerRegionMapper;
    @Resource
    private CustomerAreaMapper customerAreaMapper;

    @Override
    public void addCustomerArea(CustomerAreaExtReqDto customerAreaExtReqDto) {
        this.logger.info("\u65b0\u589e\u9500\u552e\u533a\u57df\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerAreaExtReqDto));
        this.validaData(customerAreaExtReqDto);
        CustomerAreaEo queryCustomerAreaEo = new CustomerAreaEo();
        queryCustomerAreaEo.setCode(customerAreaExtReqDto.getCode());
        CustomerAreaEo customerAreaEo1 = (CustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)queryCustomerAreaEo);
        if (customerAreaEo1 != null) {
            CustomerAreaExtReqDto customerUpdateReqDto = new CustomerAreaExtReqDto();
            this.updateCustomerArea(customerUpdateReqDto);
        }
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setExtension("1");
        DtoHelper.dto2Eo((BaseVo)customerAreaExtReqDto, (BaseEo)customerAreaEo);
        int count = this.customerAreaDas.insert((BaseEo)customerAreaEo);
        if (count != NumberUtils.INTEGER_ONE) {
            throw new BizException("\u65b0\u589e\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u63d2\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    @Override
    public void updateCustomerArea(CustomerAreaExtReqDto customerAreaExtReqDto) {
        this.logger.info("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerAreaExtReqDto));
        this.validaData(customerAreaExtReqDto);
        CustomerAreaEo areaQueryEo = new CustomerAreaEo();
        areaQueryEo.setCode(customerAreaExtReqDto.getCode());
        List customerAreaEos = this.customerAreaDas.select((BaseEo)areaQueryEo);
        if (CollectionUtils.isEmpty((Collection)customerAreaEos)) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u8be5\u7f16\u7801\u5bf9\u5e94\u533a\u57df\u4e0d\u5b58\u5728:" + customerAreaExtReqDto.getCode());
        }
        if (customerAreaEos.size() > NumberUtils.INTEGER_ONE) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u8be5\u7f16\u7801\u5bf9\u5e94\u591a\u4e2a\u533a\u57df");
        }
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        DtoHelper.dto2Eo((BaseVo)customerAreaExtReqDto, (BaseEo)customerAreaEo);
        customerAreaEo.setId(((CustomerAreaEo)customerAreaEos.get(0)).getId());
        customerAreaEo.setExtension("2");
        int count = this.customerAreaDas.update((BaseEo)customerAreaEo);
        if (count != NumberUtils.INTEGER_ONE) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25, \u66f4\u65b0\u6570\u636e\u5f02\u5e38");
        }
    }

    private void validaData(CustomerAreaExtReqDto customerAreaExtReqDto) {
        if (customerAreaExtReqDto == null) {
            throw new BizException("\u9500\u552e\u533a\u57df\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Assert.notNull((Object)customerAreaExtReqDto.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)customerAreaExtReqDto.getParentCode(), (String)"\u7236\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)customerAreaExtReqDto.getName(), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    public Map<Long, List<CustomerAreaRespDto>> getCustomerAreaByCustomerIdMap(List<Long> customerIdList) {
        HashMap<Long, List<CustomerAreaRespDto>> resultMap = new HashMap<Long, List<CustomerAreaRespDto>>();
        if (CollectionUtils.isEmpty(customerIdList)) {
            return resultMap;
        }
        QueryWrapper queryEo = new QueryWrapper();
        queryEo.eq((Object)"dr", (Object)0);
        queryEo.in((Object)"customer_id", customerIdList);
        List customerRegionEos = this.rCustomerRegionMapper.selectList((Wrapper)queryEo);
        if (CollectionUtils.isEmpty((Collection)customerRegionEos)) {
            return resultMap;
        }
        List regionCodeList = customerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).distinct().collect(Collectors.toList());
        QueryWrapper areaEo = new QueryWrapper();
        areaEo.eq((Object)"dr", (Object)0);
        areaEo.in((Object)"code", regionCodeList);
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEo);
        if (CollectionUtils.isEmpty((Collection)customerAreaEos)) {
            return resultMap;
        }
        Map<Long, List<RCustomerRegionEo>> customerRegionMap = customerRegionEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId));
        Map customerAreaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getCode, Function.identity(), (k1, k2) -> k1));
        for (Long customerId : customerRegionMap.keySet()) {
            ArrayList list = Lists.newArrayList();
            for (RCustomerRegionEo regionEo : customerRegionMap.get(customerId)) {
                if (!customerAreaEoMap.containsKey(regionEo.getRegionCode())) continue;
                CustomerAreaEo customerAreaEo = (CustomerAreaEo)customerAreaEoMap.get(regionEo.getRegionCode());
                CustomerAreaRespDto respDto = new CustomerAreaRespDto();
                DtoHelper.eo2Dto((BaseEo)customerAreaEo, (BaseVo)respDto);
                list.add(respDto);
            }
            resultMap.put(customerId, list);
        }
        return resultMap;
    }

    @Override
    public void saveOrUpdateSaleArea(List<CustomerAreaExtReqDto> addAreaList) {
    }
}

