/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.StockStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ChannelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.ChannelRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IChannelService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.das.ChannelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmpowerPlatformDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.ChannelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmpowerPlatformEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractChannelServiceImpl
implements IChannelService {
    @Resource
    private ChannelDas channelDas;
    @Resource
    private EmpowerPlatformDas empowerPlatformDas;
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addChannel(ChannelReqDto addReqDto) {
        List channelEos = this.channelDas.selectAll();
        if (channelEos.size() > 0) {
            String name = addReqDto.getName();
            String code = addReqDto.getCode();
            Assert.isTrue(!channelEos.stream().map(c -> c.getName()).collect(Collectors.toList()).stream().anyMatch(p -> name.equals(p)), CustomerExceptionCode.CHANNEL_NAME_REPETITION);
            Assert.isTrue(!channelEos.stream().map(c -> c.getCode()).collect(Collectors.toList()).stream().anyMatch(p -> code.equals(p)), CustomerExceptionCode.CHANNEL_CODE_REPETITION);
        }
        ChannelEo shopEo = new ChannelEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)shopEo);
        this.channelDas.insert((BaseEo)shopEo);
        return shopEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String channelImport(ImportDto importDto) {
        String url = importDto.getUrl();
        List<ChannelReqDto> channelReqDtoList = null;
        try {
            channelReqDtoList = EasyPoiExportUtil.parseImportFile(url, ChannelReqDto.class);
        }
        catch (Exception e) {
            throw new BizException(CustomerExceptionCode.CHANNEL_IMPORT_PARSING_ERROR.getCode(), CustomerExceptionCode.CHANNEL_IMPORT_PARSING_ERROR.getMsg(), (Throwable)e);
        }
        Assert.isTrue(CollectionUtils.isNotEmpty(channelReqDtoList), CustomerExceptionCode.CHANNEL_IMPORT_ERROR);
        List channelNameList = channelReqDtoList.stream().map(m -> m.getName()).collect(Collectors.toList());
        List channelCodeList = channelReqDtoList.stream().map(m -> m.getCode()).collect(Collectors.toList());
        List nameCollect = channelNameList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
        List codeCollect = channelCodeList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
        Assert.isTrue(channelReqDtoList.size() == nameCollect.size(), CustomerExceptionCode.IMPORT_CHANNEL_NAME_NULL);
        Assert.isTrue(channelReqDtoList.size() == codeCollect.size(), CustomerExceptionCode.IMPORT_CHANNEL_CODE_NULL);
        long count = channelNameList.stream().distinct().count();
        long codeCount = channelCodeList.stream().distinct().count();
        Assert.isTrue((long)channelReqDtoList.size() == count, CustomerExceptionCode.IMPORT_CHANNEL_NAME_REPETITION);
        Assert.isTrue((long)channelReqDtoList.size() == codeCount, CustomerExceptionCode.IMPORT_CHANNEL_CODE_REPETITION);
        List channelEoList = this.channelDas.selectAll();
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < channelReqDtoList.size(); ++i) {
            Integer num = i + 2;
            if (channelEoList.size() <= 0) continue;
            String name = channelReqDtoList.get(i).getName();
            String code = channelReqDtoList.get(i).getCode();
            if (channelEoList.stream().anyMatch(p -> p.getName().equals(name))) {
                resultList.add("\u7b2c" + num + "\u884c\u6570\u636e\u7684\u6e20\u9053\u540d\u79f0\u4e0e\u6570\u636e\u5e93\u91cd\u590d,\u8bf7\u4fee\u6539\u6e20\u9053\u540d\u79f0!");
            }
            if (!channelEoList.stream().anyMatch(p -> p.getCode().equals(code))) continue;
            resultList.add("\u7b2c" + num + "\u884c\u6570\u636e\u7684\u6e20\u9053\u7f16\u7801\u4e0e\u6570\u636e\u5e93\u91cd\u590d,\u8bf7\u4fee\u6539\u6e20\u9053\u7f16\u7801!");
        }
        if (resultList.size() > 0) {
            return String.join((CharSequence)",", resultList);
        }
        ArrayList channelEos = new ArrayList();
        DtoHelper.dtoList2EoList(channelReqDtoList, channelEos, ChannelEo.class);
        this.channelDas.insertBatch(channelEos);
        return "\u6e20\u9053\u5bfc\u5165\u6210\u529f\uff01";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyChannel(ChannelReqDto modifyReqDto) {
        ChannelEo channelEo = new ChannelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)channelEo);
        this.channelDas.updateSelective((BaseEo)channelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeChannel(String ids) {
        String[] removeIds = ids.split(",");
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            sqlFilters.add(SqlFilter.in((String)"channel_id", (Object)removeIds));
        }
        EmpowerPlatformEo empowerPlatformEo = new EmpowerPlatformEo();
        empowerPlatformEo.setSqlFilters(sqlFilters);
        List empowerPlatformEoList = this.empowerPlatformDas.select((BaseEo)empowerPlatformEo);
        Assert.isTrue(CollectionUtils.isEmpty((Collection)empowerPlatformEoList), CustomerExceptionCode.CHANNEL_RELATION_PLATFORM_CANNOT_DELETE);
        for (String id : removeIds) {
            this.channelDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void oaChannelSync(List<ChannelReqDto> channelSyncReqDtoList) {
        try {
            List codes = channelSyncReqDtoList.stream().map(c -> c.getCode()).collect(Collectors.toList());
            ChannelEo channelEo = new ChannelEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            if (CollectionUtils.isNotEmpty(codes)) {
                sqlFilterList.add(SqlFilter.in((String)"code", codes));
            }
            channelEo.setSqlFilters(sqlFilterList);
            List channelEos = this.channelDas.select((BaseEo)channelEo);
            ArrayList channelAddList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)channelEos)) {
                List collect = channelEos.stream().map(eo -> eo.getCode()).collect(Collectors.toList());
                channelSyncReqDtoList.stream().forEach(c -> {
                    channelEos.stream().forEach(channel -> {
                        if (channel.getCode().equals(c.getCode())) {
                            ChannelEo eo = new ChannelEo();
                            eo.setCode(c.getCode());
                            eo.setName(c.getName());
                            eo.setId(channel.getId());
                            eo.setStatus(c.getStatus());
                            this.channelDas.updateSelective((BaseEo)eo);
                        }
                    });
                    if (!collect.contains(c.getCode())) {
                        ChannelEo eo = new ChannelEo();
                        eo.setCode(c.getCode());
                        eo.setName(c.getName());
                        eo.setStatus(c.getStatus());
                        channelAddList.add(eo);
                    }
                });
            } else {
                CubeBeanUtils.copyCollection(channelAddList, channelSyncReqDtoList, ChannelEo.class);
            }
            if (CollectionUtils.isNotEmpty(channelAddList)) {
                this.channelDas.insertBatch(channelAddList);
            }
        }
        catch (Exception e) {
            throw new BizException(CustomerExceptionCode.CHANNEL_SAP_FAIL.getCode(), CustomerExceptionCode.CHANNEL_SAP_FAIL.getMsg(), (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void stockRelationChannel(List<Long> ids) {
        ids.stream().forEach(id -> {
            ChannelEo channelEo = new ChannelEo();
            channelEo.setId(id);
            channelEo.setType(StockStatus.APPROVE_FAIL.getCode());
            this.channelDas.updateSelective((BaseEo)channelEo);
        });
    }

    @Override
    public void stockUpdateChannel(List<Long> ids) {
        ids.stream().forEach(id -> {
            ChannelEo channelEo = new ChannelEo();
            channelEo.setId(id);
            channelEo.setType(StockStatus.APPROVE_PASS.getCode());
            this.channelDas.updateSelective((BaseEo)channelEo);
        });
    }

    @Override
    public ChannelRespDto queryById(Long id) {
        ChannelEo channelEo = (ChannelEo)this.channelDas.selectByPrimaryKey(id);
        ChannelRespDto channelRespDto = new ChannelRespDto();
        DtoHelper.eo2Dto((BaseEo)channelEo, (BaseVo)channelRespDto);
        return channelRespDto;
    }

    @Override
    public ChannelRespDto queryByName(String name) {
        ChannelEo channelEo = (ChannelEo)this.channelDas.selectOne((BaseEo)new ChannelEo().setName(name));
        ChannelRespDto channelRespDto = new ChannelRespDto();
        DtoHelper.eo2Dto((BaseEo)channelEo, (BaseVo)channelRespDto);
        return channelRespDto;
    }

    @Override
    public List<ChannelRespDto> queryByCodes(List<String> codes) {
        ChannelEo channelEo = new ChannelEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isNotEmpty(codes)) {
            return null;
        }
        sqlFilterList.add(SqlFilter.in((String)"code", codes));
        channelEo.setSqlFilters(sqlFilterList);
        List channelEoList = this.channelDas.select((BaseEo)channelEo);
        ArrayList<ChannelRespDto> channelRespDtoList = new ArrayList<ChannelRespDto>();
        DtoHelper.eoList2DtoList((Collection)channelEoList, channelRespDtoList, ChannelRespDto.class);
        return channelRespDtoList;
    }

    @Override
    public PageInfo<ChannelRespDto> queryByTypePage(String filter, Integer pageNum, Integer pageSize) {
        ChannelRespDto channelRespDto = (ChannelRespDto)JSON.parseObject((String)filter, ChannelRespDto.class);
        ChannelEo channelEo = new ChannelEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"type", (Object)StockStatus.APPROVE_PASS.getCode()));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)channelRespDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + channelRespDto.getName() + "%")));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)channelRespDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + channelRespDto.getCode() + "%")));
        }
        channelEo.setOrderByDesc("create_time");
        channelEo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.channelDas.selectPage((BaseEo)channelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ChannelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ChannelRespDto> queryListByIds(List<Long> ids) {
        ChannelEo channelEo = new ChannelEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isNotEmpty(ids)) {
            return null;
        }
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        channelEo.setSqlFilters(sqlFilterList);
        List channelEoList = this.channelDas.select((BaseEo)channelEo);
        ArrayList<ChannelRespDto> channelRespDtoList = new ArrayList<ChannelRespDto>();
        DtoHelper.eoList2DtoList((Collection)channelEoList, channelRespDtoList, ChannelRespDto.class);
        return channelRespDtoList;
    }

    @Override
    public List<ChannelRespDto> selectAll() {
        ArrayList<ChannelRespDto> channelRespDtoList = new ArrayList<ChannelRespDto>();
        List channelEos = this.channelDas.selectAll();
        DtoHelper.eoList2DtoList((Collection)channelEos, channelRespDtoList, ChannelRespDto.class);
        return channelRespDtoList;
    }

    @Override
    public List<ChannelRespDto> queryChannelListByTime(String updateTime) {
        ArrayList<ChannelRespDto> channelRespDtoList = new ArrayList<ChannelRespDto>();
        if (StringUtils.isEmpty((CharSequence)updateTime)) {
            List channelEos = this.channelDas.selectAll();
            DtoHelper.eoList2DtoList((Collection)channelEos, channelRespDtoList, ChannelRespDto.class);
        } else {
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.ge((String)"update_time", (Object)updateTime));
            ChannelEo channelEo = new ChannelEo();
            channelEo.setSqlFilters(sqlFilterList);
            List select = this.channelDas.select((BaseEo)channelEo);
            DtoHelper.eoList2DtoList((Collection)select, channelRespDtoList, ChannelRespDto.class);
        }
        return channelRespDtoList;
    }

    @Override
    public PageInfo<ChannelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ChannelReqDto channelReqDto = (ChannelReqDto)JSON.parseObject((String)filter, ChannelReqDto.class);
        ExtQueryChainWrapper channelFilter = this.channelDas.filter();
        if (StringUtils.isNotBlank((CharSequence)channelReqDto.getName())) {
            channelFilter.like((Object)"name", (Object)channelReqDto.getName());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)channelReqDto.getCode())) {
            channelFilter.like((Object)"code", (Object)channelReqDto.getCode());
        }
        PageInfo eoPageInfo = channelFilter.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ChannelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ChannelRespDto queryByChannelCode(String channelCode) {
        return null;
    }
}

