/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.tcbj.small;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerTypeExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.SettleStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerExtRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerV3ReqDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.mq.producer.CustomerChangeProducer;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IAddressService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IBillInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IContactsInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractCustomerExtV3Service;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.AddressDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerExportRecordDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerGroupDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerLevelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerSalesmanMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerTypeMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerSalesmanMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeCustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.AddressEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.vo.CustomerRegionNameVo;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.IAccessApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrganizationInfoExtDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tcbj_small_ICustomerExtV3Service")
public class TcbjSmailCustomerExtV3ServiceImpl
extends AbstractCustomerExtV3Service {
    private Logger logger = LoggerFactory.getLogger(TcbjSmailCustomerExtV3ServiceImpl.class);
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IContext context;
    @Resource
    private CustomerTypeMapper customerTypeMapper;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private ICacheService cacheService;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private CustomerExportRecordDas customerExportRecordDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private CustomerGroupDas customerGroupDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private CustomerLevelDas customerLevelDas;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Value(value="${yundt.cube.customer.orgRootId}")
    private Long orgRootId;
    @Resource
    private IUserApi userApi;
    @Resource
    private ICustomerService customerService;
    @Resource
    private IContactsInfoService contactsInfoService;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private IAddressService addressService;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private ICustomerAreaService customerAreaService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationApi organizationApi;
    @Resource
    private IAccessApi accessApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Value(value="${yundt.cube.customer.dealerRoleCode}")
    private String dealerRoleCode;
    @Value(value="${yundt.cube.customer.mallPattern:1}")
    private Integer mallPattern;
    @Resource
    private CustomerChangeProducer customerChangeProducer;
    @Resource
    private CustomerSalesmanDas customerSalesmanDas;
    @Resource
    private CustomerSalesmanMapper customerSalesmanMapper;
    @Resource
    private RCustomerSalesmanDas rCustomerSalesmanDas;
    @Resource
    private RCustomerSalesmanMapper rCustomerSalesmanMapper;
    @Autowired
    private IRCustomerSalesmanService rCustomerSalesmanService;
    @Resource
    private EmployeeCustomerDas employeeCustomerDas;
    @Resource
    private IOrgInfoExtQueryApi orgInfoExtQueryApi;
    @Resource
    private AddressDas addressDas;

    @Override
    public CompanyInfoDto queryCompanyByCreditCode(String creditCode) {
        Assert.notNull((Object)creditCode, (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse orgAdvInfoRestResp = this.organizationQueryExtApi.queryOrgAdvInfoByCreditCode(creditCode, this.context.tenantId(), this.context.instanceId());
        OrgAdvInfoRespDto orgAdvInfoRespDto = (OrgAdvInfoRespDto)RestResponseHelper.extractData((RestResponse)orgAdvInfoRestResp);
        if (Objects.isNull(orgAdvInfoRespDto)) {
            return null;
        }
        Long orgId = orgAdvInfoRespDto.getOrgId();
        QueryWrapper customerTypeWrapper = new QueryWrapper();
        customerTypeWrapper.eq((Object)"dr", (Object)0);
        customerTypeWrapper.eq((Object)"type", (Object)CustomerTypeExtEnum.RETAILER.getCode());
        List customerTypeEos = this.customerTypeMapper.selectList((Wrapper)customerTypeWrapper);
        if (CollectionUtil.isNotEmpty((Collection)customerTypeEos)) {
            List orgIds;
            List typeIds = customerTypeEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            QueryWrapper customerWrapper = new QueryWrapper();
            customerWrapper.eq((Object)"type", (Object)CustomerTypeEnum.RETAILER.getCode());
            customerWrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_PASS.getCode());
            customerWrapper.in((Object)"customer_type_id", typeIds);
            customerWrapper.eq((Object)"dr", (Object)0);
            List customerEos = this.customerMapper.selectList((Wrapper)customerWrapper);
            if (CollectionUtil.isNotEmpty((Collection)customerEos) && CollectionUtil.isNotEmpty(orgIds = customerEos.stream().map(StdCustomerEo::getOrgInfoId).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && orgIds.contains(orgId)) {
                throw new BizException("\u8be5\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\u5ba2\u6237");
            }
        }
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        CubeBeanUtils.copyProperties((Object)companyInfoDto, (Object)orgAdvInfoRespDto, (String[])new String[0]);
        companyInfoDto.setOrgInfoId(orgId);
        return companyInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomerAddResultDto add(CustomerReqDto reqDto) {
        CustomerEo customerEo;
        RestResponse pageInfoRestResponse;
        Long orgInfoId;
        reqDto.setId(null);
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        this.validRequestDto(reqDto);
        if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            orgInfoId = this.getCurrentUserOrgId();
            reqDto.setMerchantId(orgInfoId);
        } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getChannel())) {
                orgInfoId = this.getCurrentUserOrgId();
                reqDto.setMerchantId(orgInfoId);
            }
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (Objects.isNull(reqDto.getCompanyInfoDto().getOrgInfoId())) {
            OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
            OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
            CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
            orgAdvAddReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
            orgAdvAddReqDto.setCode(reqDto.getCode());
            orgAdvAddReqDto.setName(reqDto.getCompanyInfoDto().getOrgName());
            orgAdvAddReqDto.setEntityPropCode("company");
            orgAdvAddReqDto.setType("2");
            orgAdvAddReqDto.setParentId(this.orgRootId);
            pageInfoRestResponse = this.organizationExtApi.add(orgAdvAddReqDto);
            if (!"0".equals(pageInfoRestResponse.getResultCode())) {
                if (pageInfoRestResponse.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
                }
                throw new BizException(pageInfoRestResponse.getResultCode(), pageInfoRestResponse.getResultMsg());
            }
            orgInfoId = ((OrgAdvOpRespDto)pageInfoRestResponse.getData()).getOrgId();
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(orgInfoId);
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.addressService.addAddress(addressReqDto);
            }
        } else {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            customerEo = CustomerEo.newInstance();
            customerEo.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
            customerEo.setMerchantId(reqDto.getMerchantId());
            List customerEoList = this.customerDas.select((BaseEo)customerEo);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerEoList)) {
                if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
                }
                if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
                }
            }
            this.updateOrgInfo(reqDto.getCompanyInfoDto());
            this.addressService.removeAddressByOrgInfoIdAndType(reqDto.getCompanyInfoDto().getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.addressService.addAddress(addressReqDto);
            }
            orgInfoId = reqDto.getCompanyInfoDto().getOrgInfoId();
        }
        reqDto.setOrgInfoId(orgInfoId);
        customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        customerEo.setAuditStatus(AuditStatusEnum.DRAFT.getCode());
        customerEo.setSettleStatus(SettleStatusEnum.UNSETTLE.getCode());
        UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
        relationQueryReqDto.setOrgId(orgInfoId);
        pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            customerEo.setUserId(((UserRespDto)pageInfo.getList().get(0)).getId());
        }
        this.customerDas.insert((BaseEo)customerEo);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(customerEo.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        CustomerAddResultDto resultDto = new CustomerAddResultDto();
        resultDto.setCustomerId(customerEo.getId());
        resultDto.setOrgInfoId(orgInfoId);
        RCustomerSalesmanReqDto salesmanReqDto = new RCustomerSalesmanReqDto();
        salesmanReqDto.setCustomerId(reqDto.getId());
        salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
        salesmanReqDto.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
        this.rCustomerSalesmanService.add(salesmanReqDto);
        return resultDto;
    }

    private void validCustomerCode(CustomerReqDto reqDto, Long tenantId) {
        if (Objects.isNull(reqDto)) {
            return;
        }
        Assert.notNull((Object)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg(), (Object[])new Object[0]);
        CustomerEo customerEo = CustomerEo.newInstance();
        customerEo.setTenantId(tenantId);
        customerEo.setCode(reqDto.getCode());
        customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
        if (customerEo != null) {
            if (reqDto.getId() == null) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
            }
            if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
            }
        }
    }

    private void validRequestDto(CustomerReqDto reqDto) {
        Assert.notNull((Object)reqDto.getCompanyInfoDto(), (String)"\u4e3b\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCompanyInfoDto().getSubjectType(), (String)"\u4e3b\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e3b\u4f53\u7c7b\u578b\uff08company\uff1a\u4f01\u4e1a\uff0cindividual\uff1a\u4e2a\u4f53\u6237\uff0czooid\uff1a\u4e2a\u4eba\uff09", (Object[])new Object[0]);
        if ("company".equals(reqDto.getCompanyInfoDto().getSubjectType())) {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgName(), (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getBusinessLicenseType(), (String)"\u6267\u7167\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6267\u7167\u7c7b\u578b\uff081:\u591a\u8bc1\u5408\u4e00\u8425\u4e1a\u6267\u7167,2:\u666e\u901a\u8425\u4e1a\u6267\u7167\uff09", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getBusinessTermType(), (String)"\u8425\u4e1a\u671f\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8425\u4e1a\u671f\u9650\u7c7b\u578b\uff081:\u77ed\u671f\u6709\u6548\uff0c2\uff1a\u957f\u671f\u6709\u6548\uff09", (Object[])new Object[0]);
            if (String.valueOf(1).equals(reqDto.getCompanyInfoDto().getBusinessTermType())) {
                Assert.notNull((Object)reqDto.getCompanyInfoDto().getTermBeginTime(), (String)"\u8425\u4e1a\u671f\u9650\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Assert.notNull((Object)reqDto.getCompanyInfoDto().getTermEndTime(), (String)"\u8425\u4e1a\u671f\u9650\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getAddress(), (String)"\u4e3b\u4f53\u4fe1\u606f\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getLegalName(), (String)"\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getBussinessLicenseUrl(), (String)"\u8425\u4e1a\u6267\u7167\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgName(), (String)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Assert.notNull((Object)reqDto.getName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCustomerTypeId(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5bf9\u5e94\u5b57\u6bb5\uff1acustomerTypeId", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCode(), (String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5bf9\u5e94\u5b57\u6bb5\uff1acode", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getLevelId(), (String)"\u5ba2\u6237\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5bf9\u5e94\u5b57\u6bb5\uff1alevelId", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getStatusId(), (String)"\u5ba2\u6237\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5bf9\u5e94\u5b57\u6bb5\uff1astatusId", (Object[])new Object[0]);
    }

    public Long getCurrentUserOrgId() {
        Assert.notNull((Object)this.context.userId(), (String)"getCurrentUserOrgId\u65b9\u6cd5\uff0c\u4e0a\u4e0b\u6587\u4e2d\u627e\u4e0d\u5230userId", (Object[])new Object[0]);
        return this.queryOrgIdByUserId(this.context.userId());
    }

    @Override
    public Long queryOrgIdByUserId(Long userId) {
        String cahceKey;
        Long cacheValue;
        Assert.isTrue((userId != null ? 1 : 0) != 0, (String)"queryOrgIdByUserId\uff0c\u627e\u4e0d\u5230userId:", (Object[])new Object[0]);
        if (userId.equals(this.context.userId())) {
            ServiceContext serviceContext = ServiceContext.getContext();
            String customer = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
            if (customer != null) {
                Long customerId = Long.valueOf(customer);
                CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId);
                return customerEo.getOrgInfoId();
            }
            String object = serviceContext.getAttachment("yes.req.cus.b2b.organizationid");
            if (object != null) {
                return Long.valueOf(object);
            }
        }
        if (null != (cacheValue = (Long)this.cacheService.getCache(cahceKey = "queryOrgIdByUserId_" + userId, Long.class))) {
            return cacheValue;
        }
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        Assert.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u672a\u7ed1\u5b9a\u7ec4\u7ec7", (Object[])new Object[0]);
        this.logger.info("\u67e5\u8be2\u5230\u5173\u8054\u7684\u7ec4\u7ec7\u5173\u7cfb{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        Long orgId = pageInfo.getList().stream().filter(o -> o.getParentId().equals(this.orgRootId)).findFirst().get().getId();
        if (orgId != null) {
            this.cacheService.add(cahceKey, (Object)orgId, 86400);
        }
        return orgId;
    }

    private void initCustomerEo(CustomerReqDto reqDto, CustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
    }

    private void updateOrgInfo(CompanyInfoDto companyInfoDto) {
        OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
        orgAdvModifyReqDto.setName(companyInfoDto.getOrgName());
        orgAdvModifyReqDto.setCode(companyInfoDto.getOrgCode());
        orgAdvModifyReqDto.setId(companyInfoDto.getOrgInfoId());
        orgAdvModifyReqDto.setEntityPropCode("company");
        OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
        CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)companyInfoDto, (String[])new String[0]);
        orgAdvModifyReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
        RestResponse modify = this.organizationExtApi.modify(orgAdvModifyReqDto);
        if (!"0".equals(modify.getResultCode())) {
            if (modify.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
            }
            throw new BizException(modify.getResultCode(), modify.getResultMsg());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusBatch(CustomerV3ReqDto reqDto) {
        Assert.notNull((Object)reqDto.getStatusId(), (String)"\u72b6\u6001ID\u4e0d\u80fd\u4e3a\u7a7a[\u5c5e\u6027\u540d\uff1astatusId]", (Object[])new Object[0]);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)reqDto.getIds()), (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerEo customerEo = new CustomerEo();
        customerEo.setStatusId(reqDto.getStatusId());
        customerEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", (Object)reqDto.getIds())));
        this.customerDas.updateSelectiveSqlFilter((BaseEo)customerEo);
    }

    @Override
    public PageInfo<CustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        this.logger.info("\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u6761\u4ef6filter={}\uff0cpageNum={}\uff0cpageSize={}", new Object[]{filter, pageNum, pageSize});
        return null;
    }

    private OrgAdvDetailRespDto getOrgAdvDetailRespDto(Long id) {
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(id);
        return (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
    }

    @Override
    public List<CustomerTypeRespDto> getCustomerTypeByNames(List<String> nameList) {
        QueryWrapper customerTypeWrapper = new QueryWrapper();
        customerTypeWrapper.eq((Object)"dr", (Object)0);
        customerTypeWrapper.in((Object)"name", nameList);
        List customerTypeEos = this.customerTypeMapper.selectList((Wrapper)customerTypeWrapper);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customerTypeEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerTypeEos, (Collection)respDtos, CustomerTypeRespDto.class);
        return respDtos;
    }

    @Override
    public CompanyInfoDto queryCompanyInfoByCreditCode(String creditCode, Long merchantId, Long tenantId, Long instanceId, Long customerId) {
        List customerEos;
        Assert.notNull((Object)creditCode, (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse orgAdvInfoRestResp = this.organizationQueryExtApi.queryOrgAdvInfoByCreditCode(creditCode, tenantId, instanceId);
        OrgAdvInfoRespDto orgAdvInfoRespDto = (OrgAdvInfoRespDto)RestResponseHelper.extractData((RestResponse)orgAdvInfoRestResp);
        if (Objects.isNull(orgAdvInfoRespDto)) {
            return null;
        }
        Long orgId = orgAdvInfoRespDto.getOrgId();
        QueryWrapper customerWrapper = new QueryWrapper();
        customerWrapper.eq((Object)"merchant_id", (Object)merchantId);
        customerWrapper.eq((Object)"dr", (Object)0);
        customerWrapper.eq((Object)"org_info_id", (Object)orgId);
        if (Objects.nonNull(customerId)) {
            customerWrapper.ne((Object)"id", (Object)customerId);
        }
        if (CollectionUtil.isNotEmpty((Collection)(customerEos = this.customerMapper.selectList((Wrapper)customerWrapper)))) {
            throw new BizException("\u8be5\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\u5ba2\u6237");
        }
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        CubeBeanUtils.copyProperties((Object)companyInfoDto, (Object)orgAdvInfoRespDto, (String[])new String[0]);
        companyInfoDto.setOrgInfoId(orgId);
        return companyInfoDto;
    }

    @Override
    public PageInfo<CustomerExtRespDto> queryByPageExport(CustomerSearchExtReqDto searchReqDto) {
        List customerEos;
        List eos;
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCompanyName())) {
            OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
            orgAdvQueryReqDto.setName(searchReqDto.getCompanyName());
            RestResponse orgAdvResponse = this.organizationQueryExtApi.queryPage(orgAdvQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo orgAdvRespPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)orgAdvResponse);
            if (Objects.isNull(orgAdvRespPageInfo) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgAdvRespPageInfo.getList())) {
                return new PageInfo();
            }
            searchReqDto.setOrgInfoIds(orgAdvRespPageInfo.getList().stream().map(OrgAdvRespDto::getId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)searchReqDto.getRegionCodes())) {
            CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            eos = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            selectEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"region_code", (Object)eos)));
            List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            Set customerIdList = customerRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(customerIdList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(new ArrayList(customerIdList));
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            eo.setOrgId(searchReqDto.getUserOrgId());
            eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            customerEos = eos.stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            List idList = searchReqDto.getIdList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)idList)) {
                idList = customerEos;
            } else {
                idList.retainAll(customerEos);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(idList);
        }
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        Long currentUserOrgId = searchReqDto.getUserOrgId();
        Assert.isTrue((null != searchReqDto.getType() ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((null != searchReqDto.getChannel() ? 1 : 0) != 0, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (null != currentUserOrgId) {
            ArrayList merchantIds = Lists.newArrayList();
            if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && CollectionUtil.isNotEmpty((Collection)(customerEos = this.customerDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                    List orgIds = customerEos.stream().filter(bean -> Objects.nonNull(bean.getOrgInfoId())).map(StdCustomerEo::getOrgInfoId).collect(Collectors.toList());
                    merchantIds.addAll(orgIds);
                }
            } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                merchantIds.add(currentUserOrgId);
            }
            searchReqDto.setMerchantIds((List)merchantIds);
        }
        this.logger.info("\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u7b5b\u9009\u5bf9\u8c61searchReqDto\uff0c{}", (Object)JSON.toJSONString((Object)searchReqDto));
        PageInfo pageInfo = this.customerDas.queryPageBySearchConExt(searchReqDto.getPageNum(), searchReqDto.getPageSize(), (CustomerSearchReqDto)searchReqDto);
        PageInfo pageInfoext = new PageInfo();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return pageInfoext;
        }
        CubeBeanUtils.copyProperties((Object)pageInfoext, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)pageInfo.getList(), CustomerExtRespDto.class);
        List idList = respDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        QueryWrapper rCustomerSaleQuery = new QueryWrapper();
        rCustomerSaleQuery.in((Object)"customer_Id", idList);
        rCustomerSaleQuery.eq((Object)"org_id", (Object)searchReqDto.getUserOrgId());
        List rCustomerSalesmanEos = this.rCustomerSalesmanMapper.selectList((Wrapper)rCustomerSaleQuery);
        Map<Object, Object> salesmanNameMap = new HashMap();
        Map<Object, Object> salesmanIdsMap = new HashMap();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rCustomerSalesmanEos)) {
            List salesmanIds = rCustomerSalesmanEos.stream().map(RCustomerSalesmanEo::getSalesmanId).distinct().collect(Collectors.toList());
            salesmanIdsMap = rCustomerSalesmanEos.stream().collect(Collectors.groupingBy(RCustomerSalesmanEo::getCustomerId, Collectors.mapping(e -> e.getSalesmanId().toString(), Collectors.joining(","))));
            QueryWrapper customerQuery = new QueryWrapper();
            customerQuery.in((Object)"user_id", salesmanIds);
            customerQuery.eq((Object)"org_info_id", (Object)searchReqDto.getUserOrgId());
            List customerSalesmanEos = this.customerSalesmanMapper.selectList((Wrapper)customerQuery);
            salesmanNameMap = customerSalesmanEos.stream().collect(Collectors.toMap(StdCustomerSalesmanEo::getUserId, StdCustomerSalesmanEo::getName, (e1, e2) -> e1));
        }
        Map<Object, Object> cRegionNameMap = new HashMap();
        List customerRegionName = this.employeeCustomerDas.getCustomerRegionNameVo(idList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerRegionName)) {
            cRegionNameMap = customerRegionName.stream().collect(Collectors.groupingBy(CustomerRegionNameVo::getCustomerId));
        }
        List orgInfoIdList = respDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
        List orgInfoList = (List)RestResponseHelper.extractData((RestResponse)this.orgInfoExtQueryApi.queryOrgInfoByOrgId(orgInfoIdList));
        Map<Object, Object> orgInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)orgInfoList)) {
            orgInfoMap = orgInfoList.stream().collect(Collectors.toMap(OrganizationInfoExtDto::getOrgId, Function.identity(), (k1, k2) -> k1));
        }
        CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> this.customerTypeDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerTypeEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerTypeEo::getName)));
        CompletableFuture<Map> statusMapFuture = CompletableFuture.supplyAsync(() -> this.customerStatusDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getStatusId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity())));
        CompletableFuture<Map> levelMapFuture = CompletableFuture.supplyAsync(() -> this.customerLevelDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerLevelEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getLevelId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerLevelEo::getName)));
        CompletableFuture.allOf(levelMapFuture, statusMapFuture, typeMapFuture);
        Map levelMap = new HashMap(0);
        Map statusMap = new HashMap(0);
        Map typeMap = new HashMap(0);
        try {
            levelMap = levelMapFuture.get();
            statusMap = statusMapFuture.get();
            typeMap = typeMapFuture.get();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        for (CustomerExtRespDto customerRespDto : respDtos) {
            CustomerEo customerEo;
            CustomerStatusEo statusEo = statusMap.getOrDefault(customerRespDto.getStatusId(), new CustomerStatusEo());
            customerRespDto.setAccountStatus(statusEo.getAccountStatus());
            customerRespDto.setRecordStatus(statusEo.getRecordStatus());
            customerRespDto.setStatusName(statusEo.getName());
            customerRespDto.setCustomerTypeName(typeMap.getOrDefault(customerRespDto.getCustomerTypeId(), ""));
            customerRespDto.setLevelName(levelMap.getOrDefault(customerRespDto.getLevelId(), ""));
            if (!salesmanIdsMap.isEmpty() && salesmanIdsMap.containsKey(customerRespDto.getId())) {
                String salesmanIds = (String)salesmanIdsMap.get(customerRespDto.getId());
                String[] salesmanIdsArr = salesmanIds.split(",");
                List<String> salesmanIdList = Arrays.asList(salesmanIdsArr);
                ArrayList regionNameList = Lists.newArrayList();
                for (String salesmanId : salesmanIdList) {
                    Long id = Long.valueOf(salesmanId);
                    if (salesmanNameMap.isEmpty() || !salesmanNameMap.containsKey(id)) continue;
                    regionNameList.add(salesmanNameMap.get(id));
                }
                customerRespDto.setSalesmanNames(String.join((CharSequence)",", regionNameList));
            }
            if (!cRegionNameMap.isEmpty() && cRegionNameMap.containsKey(customerRespDto.getId())) {
                List customerRegionNameVos = (List)cRegionNameMap.get(customerRespDto.getId());
                List regionNameList = customerRegionNameVos.stream().map(CustomerRegionNameVo::getRegionName).collect(Collectors.toList());
                List regionCodeList = customerRegionNameVos.stream().map(CustomerRegionNameVo::getRegionCode).collect(Collectors.toList());
                customerRespDto.setRegionNames(StringUtils.join(regionNameList, (String)","));
                customerRespDto.setRegionCodeList(regionCodeList);
                customerRespDto.setRegionCodes(StringUtils.join(regionCodeList, (String)","));
            }
            if (customerRespDto.getParentCustomerId() != null && Objects.nonNull(customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerRespDto.getParentCustomerId()))) {
                customerRespDto.setParentCustomerName(customerEo.getName());
                customerRespDto.setParentCustomerCode(customerEo.getCode());
            }
            if (orgInfoMap.isEmpty() || !orgInfoMap.containsKey(customerRespDto.getOrgInfoId())) continue;
            List<AddressRespDto> addressList = this.queryAddressList(customerRespDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
            CompanyInfoDto companyInfoDto = new CompanyInfoDto();
            if (!CollectionUtils.isEmpty(addressList)) {
                BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
            }
            OrganizationInfoExtDto orgInfoDto = (OrganizationInfoExtDto)orgInfoMap.get(customerRespDto.getOrgInfoId());
            CubeBeanUtils.copyProperties((Object)companyInfoDto, (Object)orgInfoDto, (String[])new String[0]);
            companyInfoDto.setOrgInfoId(orgInfoDto.getId());
            customerRespDto.setCompanyInfoDto(companyInfoDto);
            customerRespDto.setOrgName(orgInfoDto.getOrgName());
            customerRespDto.setCreditCode(orgInfoDto.getCreditCode());
        }
        pageInfoext.setList((List)respDtos);
        return pageInfoext;
    }

    public List<AddressRespDto> queryAddressList(Long orgInfoId, List<String> addressTypes) {
        AddressEo addressEo = new AddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(addressTypes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"address_type", addressTypes));
            addressEo.setSqlFilters(sqlFilters);
        }
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressRespDto> addressDtoList = new ArrayList<AddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressRespDto.class);
        return addressDtoList;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByExtDtoList(CustomerSearchExtReqDto searchExtReqDto) {
        this.logger.info("queryCustomerByExtDtoList.searchExtReqDto==>{}", (Object)JSON.toJSONString((Object)searchExtReqDto));
        QueryWrapper customerEoQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)searchExtReqDto.getName())) {
            customerEoQueryWrapper.eq((Object)"name", (Object)searchExtReqDto.getName());
        }
        if (Objects.nonNull(searchExtReqDto.getType())) {
            customerEoQueryWrapper.eq((Object)"type", (Object)searchExtReqDto.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchExtReqDto.getCustomerNameLike())) {
            customerEoQueryWrapper.like((Object)"name", (Object)searchExtReqDto.getCustomerNameLike());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchExtReqDto.getCustomerCodeLike())) {
            customerEoQueryWrapper.like((Object)"code", (Object)searchExtReqDto.getCustomerCodeLike());
        }
        if (StringUtils.isNotEmpty((CharSequence)searchExtReqDto.getCode())) {
            customerEoQueryWrapper.eq((Object)"code", (Object)searchExtReqDto.getCode());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)searchExtReqDto.getCodeInList())) {
            customerEoQueryWrapper.in((Object)"code", (Collection)searchExtReqDto.getCodeInList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)searchExtReqDto.getIdList())) {
            customerEoQueryWrapper.in((Object)"id", (Collection)searchExtReqDto.getIdList());
        }
        if (Objects.nonNull(searchExtReqDto.getMerchantId())) {
            customerEoQueryWrapper.eq((Object)"merchant_id", (Object)searchExtReqDto.getMerchantId());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)searchExtReqDto.getMerchantIds())) {
            customerEoQueryWrapper.in((Object)"merchant_id", (Collection)searchExtReqDto.getMerchantIds());
        }
        if (Objects.nonNull(searchExtReqDto.getOrgInfoId())) {
            customerEoQueryWrapper.eq((Object)"org_info_id", (Object)searchExtReqDto.getOrgInfoId());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)searchExtReqDto.getOrgInfoIds())) {
            customerEoQueryWrapper.in((Object)"org_info_id", (Collection)searchExtReqDto.getOrgInfoIds());
        }
        customerEoQueryWrapper.eq((Object)"dr", (Object)"0");
        List customerEos = this.customerMapper.selectList((Wrapper)customerEoQueryWrapper);
        ArrayList respDtoList = Lists.newArrayList();
        for (CustomerEo customerEo : customerEos) {
            CustomerRespDto respDto = new CustomerRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)customerEo, (String[])new String[0]);
            respDtoList.add(respDto);
        }
        return respDtoList;
    }
}

