/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.tcbj;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EasCostOrgReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractEasCostOrgServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EasCostOrgDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EasCostOrgEo;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tcbj_IEasCostOrgService")
public class TcbjEasCostOrgServiceImpl
extends AbstractEasCostOrgServiceImpl {
    public final Logger logger = LoggerFactory.getLogger(TcbjEasCostOrgServiceImpl.class);
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private EasCostOrgDas easCostOrgDas;

    @Override
    public Long addEasCostOrg(EasCostOrgReqDto addReqDto) {
        EasCostOrgEo easCostOrgEo = new EasCostOrgEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)easCostOrgEo);
        this.easCostOrgDas.insert((BaseEo)easCostOrgEo);
        return easCostOrgEo.getId();
    }

    @Override
    public void addBatchEasCostOrg(List<EasCostOrgReqDto> easCostOrgReqDtoList) {
        this.logger.info("\u6279\u91cf\u65b0\u589eEAS\u8d22\u52a1\u7ec4\u7ec7\uff1a{}", (Object)JSON.toJSONString(easCostOrgReqDtoList));
        easCostOrgReqDtoList.forEach(dto -> {
            if (StringUtils.isBlank((CharSequence)dto.getEasId())) {
                return;
            }
            EasCostOrgEo delEo = new EasCostOrgEo();
            delEo.setEasId(dto.getEasId());
            this.easCostOrgDas.logicDelete((BaseEo)delEo);
            EasCostOrgEo intEo = new EasCostOrgEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)intEo);
            this.easCostOrgDas.insert((BaseEo)intEo);
        });
    }

    @Override
    public void modifyEasCostOrg(EasCostOrgReqDto modifyReqDto) {
        EasCostOrgEo easCostOrgEo = new EasCostOrgEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)easCostOrgEo);
        this.easCostOrgDas.updateSelective((BaseEo)easCostOrgEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEasCostOrg(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.easCostOrgDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public EasCostOrgRespDto queryById(Long id) {
        EasCostOrgEo easCostOrgEo = (EasCostOrgEo)this.easCostOrgDas.selectByPrimaryKey(id);
        EasCostOrgRespDto easCostOrgRespDto = new EasCostOrgRespDto();
        DtoHelper.eo2Dto((BaseEo)easCostOrgEo, (BaseVo)easCostOrgRespDto);
        return easCostOrgRespDto;
    }

    @Override
    public PageInfo<EasCostOrgRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        EasCostOrgReqDto easCostOrgReqDto = (EasCostOrgReqDto)JSON.parseObject((String)filter, EasCostOrgReqDto.class);
        EasCostOrgEo easCostOrgEo = new EasCostOrgEo();
        DtoHelper.dto2Eo((BaseVo)easCostOrgReqDto, (BaseEo)easCostOrgEo);
        PageInfo eoPageInfo = this.easCostOrgDas.selectPage((BaseEo)easCostOrgEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EasCostOrgRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            ArrayList orgCodeList = Lists.newArrayList((Object[])dtoList.stream().map(EasCostOrgRespDto::getEasOrgCode).toArray(String[]::new));
            this.logger.info("\u7ec4\u7ec7\u7f16\u7801\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)orgCodeList));
            List organizationDtoList = (List)this.organizationQueryApi.queryListByOrgCode(Long.valueOf(1254039287584232622L), (List)orgCodeList).getData();
            if (CollectionUtils.isNotEmpty((Collection)organizationDtoList)) {
                this.logger.info("\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7id\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)organizationDtoList));
                dtoList.forEach(dto -> organizationDtoList.forEach(org -> {
                    if (dto.getEasOrgCode().equals(org.getCode())) {
                        dto.setOrgId(org.getId());
                    }
                }));
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<EasCostOrgRespDto> queryListByPage(EasCostOrgReqDto easCostOrgReqDto) {
        this.logger.info("EAS\u8d22\u52a1\u7ec4\u7ec7\u5206\u9875\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)easCostOrgReqDto));
        if (ObjectUtils.isEmpty((Object)easCostOrgReqDto.getPageNum()) || ObjectUtils.isEmpty((Object)easCostOrgReqDto.getPageSize())) {
            easCostOrgReqDto.setPageNum(Integer.valueOf(1));
            easCostOrgReqDto.setPageSize(Integer.valueOf(10));
        }
        EasCostOrgEo easCostOrgEo = new EasCostOrgEo();
        DtoHelper.dto2Eo((BaseVo)easCostOrgReqDto, (BaseEo)easCostOrgEo);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.easCostOrgDas.filter().like(StringUtils.isNotBlank((CharSequence)easCostOrgReqDto.getEasOrgCode()), (Object)"eas_org_code", (Object)easCostOrgReqDto.getEasOrgCode())).like(StringUtils.isNotBlank((CharSequence)easCostOrgReqDto.getOrgName()), (Object)"org_name", (Object)easCostOrgReqDto.getOrgName())).ge(ObjectUtils.isNotEmpty((Object)easCostOrgReqDto.getUpdateTimeStart()), (Object)"update_time", (Object)easCostOrgReqDto.getUpdateTimeStart())).orderByDesc((Object)"create_time")).page(easCostOrgReqDto.getPageNum(), easCostOrgReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EasCostOrgRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            ArrayList orgCodeList = Lists.newArrayList((Object[])dtoList.stream().map(EasCostOrgRespDto::getEasOrgCode).toArray(String[]::new));
            this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orgCodeList));
            List organizationDtoList = (List)this.organizationQueryApi.queryListByOrgCode(Long.valueOf(1254039287584232622L), (List)orgCodeList).getData();
            if (CollectionUtils.isNotEmpty((Collection)organizationDtoList)) {
                this.logger.info("\u7ec4\u7ec7\u91cc\u8fb9\u8fd4\u56de\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)organizationDtoList));
                dtoList.forEach(dto -> organizationDtoList.forEach(org -> {
                    if (dto.getEasOrgCode().equals(org.getCode())) {
                        dto.setOrgId(org.getId());
                    }
                }));
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<EasCostOrgRespDto> queryListCodes(List<String> codes) {
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(codes), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.easCostOrgDas.filter().in((Object)"eas_org_code", codes)).eq((Object)"dr", (Object)0)).list(Integer.valueOf(codes.size()));
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)list, EasCostOrgRespDto.class);
        return list;
    }
}

