/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CreditStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CurrencyEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerCountryTypeStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerStatusType;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.EmpowerPlatformType;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.OaStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.RefundLimitStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.RefundStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.SalesModelEnums;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.SyncStatus;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ChargeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerFreezeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerQueryListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.RefundCallbackReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.SyncStatusDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.UpdateAuthorizationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.AreaDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.ChannelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerAuthInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerPropertyInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerPropertyValueDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmpowerPlatformDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmpowerPlatformInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.GradeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.AreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.ChannelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerAuthInfoEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerInfoEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerPropertyInfoEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerPropertyValueEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmpowerPlatformEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmpowerPlatformInfoEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.GradeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.vo.CustomerQueryReqVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCustomerInfoServiceImpl
implements ICustomerInfoService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCustomerInfoServiceImpl.class);
    @Resource
    private CustomerInfoDas customerInfoDas;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private ChannelDas channelDas;
    @Resource
    private AreaDas areaDas;
    @Resource
    private GradeDas gradeDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private Environment environment;
    @Value(value="${customer.user.instanceId}")
    private Long instanceId;
    @Value(value="${customer.user.tenantId}")
    private Long tenantId;
    @Resource
    private CustomerPropertyInfoDas customerPropertyInfoDas;
    @Resource
    private CustomerPropertyValueDas customerPropertyValueDas;
    @Resource
    private EmpowerPlatformDas empowerPlatformDas;
    @Resource
    private EmpowerPlatformInfoDas empowerPlatformInfoDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private CustomerAuthInfoDas customerAuthInfoDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> addList(List<CustomerInfoReqDto> customerInfoReqDtoList) {
        HashMap<String, String> map = new HashMap<String, String>(64);
        ArrayList customerInfoEoList = Lists.newArrayList();
        ArrayList customerSyncCredit = new ArrayList();
        ArrayList customerSyncPayment = new ArrayList();
        ArrayList empowerPlatformInfoEoList = new ArrayList();
        List platformCodeList = customerInfoReqDtoList.stream().map(CustomerInfoReqDto::getSalesPlatformCode).distinct().collect(Collectors.toList());
        List platformList = ((ExtQueryChainWrapper)this.empowerPlatformDas.filter().in((Object)"code", platformCodeList)).select(new String[0]).list();
        Map<String, EmpowerPlatformEo> empowerPlatformMap = platformList.stream().collect(Collectors.toMap(EmpowerPlatformEo::getCode, o -> o));
        ArrayList freezeReqDtos = Lists.newArrayList();
        customerInfoReqDtoList.forEach(customerInfoReqDto -> {
            if (!this.validOrUpdateCustomer((CustomerInfoReqDto)customerInfoReqDto, customerSyncCredit, customerSyncPayment, empowerPlatformMap).booleanValue()) {
                EmpowerPlatformEo empowerPlatformEo;
                CustomerInfoEo customerInfoEo = new CustomerInfoEo();
                DtoHelper.dto2Eo((BaseVo)customerInfoReqDto, (BaseEo)customerInfoEo);
                customerInfoEo.setOrgInfoId(customerInfoReqDto.getId());
                customerInfoEo.setInstanceId(this.instanceId);
                customerInfoEo.setTenantId(this.tenantId);
                Long userId = this.getId();
                customerInfoEo.setUserId(userId);
                Long statusId = this.defaultStatusId(customerInfoReqDto.getCustomerFreeze());
                customerInfoEo.setStatusId(statusId);
                customerInfoEo.setStatusName(Objects.nonNull(customerInfoReqDto.getCustomerFreeze()) && Objects.equals("X", customerInfoReqDto.getCustomerFreeze()) ? "\u7981\u7528" : "\u542f\u7528");
                customerInfoEo.setCustomerFreeze(customerInfoReqDto.getCustomerFreeze());
                if (Objects.nonNull(customerInfoReqDto.getCustomerFreeze()) && Objects.equals("X", customerInfoReqDto.getCustomerFreeze())) {
                    CustomerFreezeReqDto customerFreezeReqDto = new CustomerFreezeReqDto();
                    customerFreezeReqDto.setUserId(userId);
                    freezeReqDtos.add(customerFreezeReqDto);
                }
                if (StringUtils.isNotBlank((CharSequence)customerInfoReqDto.getAreaCode())) {
                    this.addAreaInfo((CustomerInfoReqDto)customerInfoReqDto, customerInfoEo);
                }
                if (StringUtils.isNotBlank((CharSequence)customerInfoEo.getGrade())) {
                    this.addGradeInfo((CustomerInfoReqDto)customerInfoReqDto, customerInfoEo);
                }
                if (StringUtils.isNotBlank((CharSequence)customerInfoEo.getSalesPlatformCode()) && (empowerPlatformEo = (EmpowerPlatformEo)empowerPlatformMap.get(customerInfoReqDto.getSalesPlatformCode())) != null) {
                    EmpowerPlatformInfoEo platformInfoEo = new EmpowerPlatformInfoEo();
                    platformInfoEo.setCustomerId(customerInfoReqDto.getId());
                    platformInfoEo.setCustomerName(customerInfoReqDto.getName());
                    platformInfoEo.setCustomerCode(customerInfoReqDto.getCode());
                    platformInfoEo.setEmpowerPlatformId(empowerPlatformEo.getId());
                    platformInfoEo.setEmpowerPlatformName(empowerPlatformEo.getName());
                    platformInfoEo.setType(EmpowerPlatformType.INITIALIZATION_CORRELATION.getCode());
                    empowerPlatformInfoEoList.add(platformInfoEo);
                }
                customerInfoReqDto.setSyncStatus(SyncStatus.CUSTOMER_ADD.getCode());
                customerSyncPayment.add(customerInfoReqDto);
                if (CreditStatus.CREDIT_STATUS.getCode().equals(customerInfoReqDto.getCreditIdentification())) {
                    customerSyncCredit.add(customerInfoReqDto);
                }
                customerInfoEoList.add(customerInfoEo);
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerInfoEoList)) {
            this.customerInfoDas.insertBatch((List)customerInfoEoList);
            for (CustomerInfoEo customerInfoEo : customerInfoEoList) {
                map.put(customerInfoEo.getCode(), customerInfoEo.getId() + "," + customerInfoEo.getUserId());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(empowerPlatformInfoEoList)) {
            this.empowerPlatformInfoDas.insertBatch(empowerPlatformInfoEoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerSyncCredit)) {
            int length;
            int i = 0;
            for (length = customerSyncCredit.size(); length > 200; length -= 200) {
                this.creditMq(customerSyncCredit.subList(i, i + 200));
                i += 200;
            }
            if (length > 0) {
                this.creditMq(customerSyncCredit.subList(i, i + length));
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerSyncPayment)) {
            int length;
            int i = 0;
            for (length = customerSyncPayment.size(); length > 200; length -= 200) {
                this.paymentMq(customerSyncPayment.subList(i, i + 200));
                i += 200;
            }
            if (length > 0) {
                this.paymentMq(customerSyncPayment.subList(i, i + length));
            }
        }
        logger.info("\u9700\u8981\u7981\u7528\u7684\u7528\u6237\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString((Object)freezeReqDtos));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)freezeReqDtos)) {
            this.customerFreeze(freezeReqDtos);
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustomerInfo(CustomerInfoReqDto addReqDto) {
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerInfoEo);
        this.customerInfoDas.insert((BaseEo)customerInfoEo);
        this.cacheService.setCache("customerInfo_userId_" + customerInfoEo.getUserId(), (Object)customerInfoEo, 3600);
        return customerInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCustomerInfo(CustomerInfoReqDto modifyReqDto) {
        CustomerInfoEo customerInfoEo = (CustomerInfoEo)this.customerInfoDas.selectByPrimaryKey(modifyReqDto.getId());
        CustomerInfoEo customerInfo = new CustomerInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerInfo);
        this.customerInfoDas.updateSelective((BaseEo)customerInfo);
        this.cacheService.delCache("customerInfo_userId_" + customerInfoEo.getUserId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerInfo(String ids) {
        String[] removeIds = ids.split(",");
        ArrayList<Long> list = new ArrayList<Long>();
        for (String removeId : removeIds) {
            list.add(Long.valueOf(removeId));
        }
        List customerInfoEos = this.customerInfoDas.selectByIds(list);
        for (String id : removeIds) {
            this.customerInfoDas.logicDeleteById(Long.valueOf(id));
        }
        for (CustomerInfoEo customerInfoEo : customerInfoEos) {
            this.cacheService.delCache("customerInfo_userId_" + customerInfoEo.getUserId());
        }
    }

    @Override
    public CustomerInfoRespDto queryById(Long id) {
        CustomerInfoEo customerInfoEo = (CustomerInfoEo)this.customerInfoDas.selectByPrimaryKey(id);
        CustomerInfoRespDto customerInfoRespDto = new CustomerInfoRespDto();
        Date now = new Date();
        List customerAuthInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAuthInfoDas.filter().eq((Object)"customer_info_id", (Object)id)).ge((Object)"auth_end_time", (Object)now)).le((Object)"auth_start_time", (Object)now)).list();
        List<Object> authValueList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerAuthInfoEoList)) {
            authValueList = customerAuthInfoEoList.stream().map(CustomerAuthInfoEo::getAuthorizationValue).collect(Collectors.toList());
        }
        DtoHelper.eo2Dto((BaseEo)customerInfoEo, (BaseVo)customerInfoRespDto);
        customerInfoRespDto.setAuthorizationValues(authValueList);
        return customerInfoRespDto;
    }

    @Override
    public CustomerInfoRespDto queryByUserId(Long userId) {
        CustomerInfoEo customerInfo = (CustomerInfoEo)this.cacheService.getCache("customerInfo_userId_" + userId, CustomerInfoEo.class);
        if (null == customerInfo) {
            CustomerInfoEo customerInfoEo = new CustomerInfoEo();
            customerInfoEo.setUserId(userId);
            customerInfo = (CustomerInfoEo)this.customerInfoDas.selectOne((BaseEo)customerInfoEo);
            if (customerInfo != null) {
                this.cacheService.setCache("customerInfo_userId_" + customerInfo.getUserId(), (Object)customerInfo, 3600);
            }
        }
        CustomerInfoRespDto customerInfoRespDto = new CustomerInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)customerInfo, (BaseVo)customerInfoRespDto);
        return customerInfoRespDto;
    }

    @Override
    public List<CustomerInfoRespDto> queryByCodes(List<String> codes) {
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(codes)) {
            return null;
        }
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codes, (String)",")));
        customerInfoEo.setSqlFilters(sqlFilters);
        List select = this.customerInfoDas.select((BaseEo)customerInfoEo);
        ArrayList<CustomerInfoRespDto> customerInfoRespDtoList = new ArrayList<CustomerInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, customerInfoRespDtoList, CustomerInfoRespDto.class);
        return customerInfoRespDtoList;
    }

    @Override
    public List<CustomerInfoRespDto> queryListByIds(List<Long> ids) {
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(ids)) {
            return null;
        }
        sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        customerInfoEo.setSqlFilters(sqlFilterList);
        List select = this.customerInfoDas.select((BaseEo)customerInfoEo);
        ArrayList<CustomerInfoRespDto> customerInfoRespDtoList = new ArrayList<CustomerInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, customerInfoRespDtoList, CustomerInfoRespDto.class);
        return customerInfoRespDtoList;
    }

    @Override
    public List<CustomerInfoRespDto> queryList(List<Long> ids) {
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(ids)) {
            return null;
        }
        sqlFilterList.add(SqlFilter.in((String)"id", ids));
        customerInfoEo.setSqlFilters(sqlFilterList);
        List select = this.customerInfoDas.select((BaseEo)customerInfoEo);
        ArrayList<CustomerInfoRespDto> customerInfoRespDtoList = new ArrayList<CustomerInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, customerInfoRespDtoList, CustomerInfoRespDto.class);
        return customerInfoRespDtoList;
    }

    @Override
    public List<CustomerInfoRespDto> queryCustomerList(String filter) {
        CustomerQueryListReqDto customerQueryListReqDto = new CustomerQueryListReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            customerQueryListReqDto = (CustomerQueryListReqDto)JSONObject.parseObject((String)filter, CustomerQueryListReqDto.class);
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (customerQueryListReqDto.getUserIds() != null) {
            sqlFilters.add(SqlFilter.in((String)"user_id", (Object)customerQueryListReqDto.getUserIds()));
        }
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        customerInfoEo.setSqlFilters(sqlFilters);
        List select = this.customerInfoDas.select((BaseEo)customerInfoEo);
        ArrayList<CustomerInfoRespDto> customerInfoRespDtoList = new ArrayList<CustomerInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, customerInfoRespDtoList, CustomerInfoRespDto.class);
        return customerInfoRespDtoList;
    }

    @Override
    public PageInfo<CustomerInfoRespDto> queryListByType(String filter, Integer pageNum, Integer pageSize) {
        CustomerInfoReqDto customerInfoReqDto = (CustomerInfoReqDto)JSON.parseObject((String)filter, CustomerInfoReqDto.class);
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)customerInfoReqDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + customerInfoReqDto.getCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)customerInfoReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + customerInfoReqDto.getName() + "%")));
        }
        ArrayList<String> salesModelList = new ArrayList<String>();
        salesModelList.add(SalesModelEnums.M005.getCode());
        salesModelList.add(SalesModelEnums.M003.getCode());
        salesModelList.add(SalesModelEnums.M009.getCode());
        sqlFilters.add(SqlFilter.in((String)"sales_model_code", salesModelList));
        customerInfoEo.setSqlFilters(sqlFilters);
        customerInfoEo.setOrderByDesc("create_time");
        PageInfo customerInfoEoPageInfo = this.customerInfoDas.selectPage((BaseEo)customerInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)customerInfoEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)customerInfoEoPageInfo.getList(), dtoList, CustomerInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<CustomerRespDto> queryCustomerInfo(ChargeCustomerReqDto customerReqDto, Integer pageNum, Integer pageSize) {
        CustomerStatusEo customerStatusEo;
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.customerInfoDas.filter().orderByDesc((Object)"id");
        if (Objects.nonNull(customerReqDto) && Objects.nonNull(customerReqDto.getCode())) {
            String regEx = "[\n`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f-]";
            StringBuilder sql = new StringBuilder();
            sql.append(" ( ");
            sql.append("code like '%" + customerReqDto.getCode().replaceAll(regEx, "") + "%' or name like '%" + customerReqDto.getCode().replaceAll(regEx, "") + "%'");
            sql.append(")");
            sqlFilters.apply(sql.toString(), new Object[0]);
        }
        if (Objects.nonNull(customerReqDto) && Objects.nonNull(customerReqDto.getName())) {
            sqlFilters.like((Object)"name", (Object)customerReqDto.getName());
        }
        if (Objects.nonNull(customerReqDto) && Objects.nonNull(customerReqDto.getSapCode())) {
            sqlFilters.like((Object)"sap_code", (Object)customerReqDto.getSapCode());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)customerReqDto.getType())) {
            sqlFilters.like((Object)"type", (Object)customerReqDto.getType());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerReqDto.getAreaIds())) {
            sqlFilters.in((Object)"area_id", (Collection)customerReqDto.getAreaIds());
        }
        if (Objects.nonNull(customerReqDto) && Objects.nonNull(customerReqDto.getStatusCode()) && Objects.nonNull(customerStatusEo = (CustomerStatusEo)((ExtQueryChainWrapper)this.customerStatusDas.filter().eq((Object)"code", (Object)customerReqDto.getStatusCode())).one())) {
            sqlFilters.eq((Object)"status_id", (Object)customerStatusEo.getId());
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), CustomerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<CustomerInfoRespDto> queryByPage(CustomerQueryConditionReqDto customerQueryConditionReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)customerQueryConditionReqDto));
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)this.customerInfoDas.filter().orderByDesc((Object)"id");
        ExtQueryChainWrapper<CustomerInfoEo> customerInfoEoExtQueryChainWrapper = this.parameterAssembly(customerQueryConditionReqDto, (ExtQueryChainWrapper<CustomerInfoEo>)filter);
        PageInfo eoPageInfo = customerInfoEoExtQueryChainWrapper.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerInfoRespDto.class);
        List ids = dtoList.stream().map(CustomerInfoRespDto::getId).collect(Collectors.toList());
        List salesChannelCodes = dtoList.stream().map(CustomerInfoRespDto::getSalesChannelCode).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List salesPlatformCodes = dtoList.stream().map(CustomerInfoRespDto::getSalesPlatformCode).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        ExtQueryChainWrapper customerPropertyInfoFilter = this.customerPropertyInfoDas.filter();
        List customerPropertyInfoList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(ids)) {
            customerPropertyInfoFilter.in((Object)"customer_id", ids);
            customerPropertyInfoList = customerPropertyInfoFilter.select(new String[0]).list();
        }
        List propertyValue = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerPropertyInfoList)) {
            List valueId = customerPropertyInfoList.stream().map(s -> s.getPropertyValueId()).distinct().collect(Collectors.toList());
            ExtQueryChainWrapper valueFilter = this.customerPropertyValueDas.filter();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(valueId)) {
                valueFilter.in((Object)"id", valueId);
            }
            propertyValue = valueFilter.select(new String[0]).list();
        }
        List channelList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(salesChannelCodes)) {
            ExtQueryChainWrapper channelFilter = this.channelDas.filter();
            channelFilter.in((Object)"code", salesChannelCodes);
            channelList = channelFilter.select(new String[0]).list();
        }
        List platformList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(salesPlatformCodes)) {
            ExtQueryChainWrapper platformFilter = this.empowerPlatformDas.filter();
            platformFilter.in((Object)"code", salesPlatformCodes);
            platformList = platformFilter.select(new String[0]).list();
        }
        Map<String, String> channel = channelList.stream().collect(Collectors.toMap(ChannelEo::getCode, ChannelEo::getName));
        Map<String, String> platform = platformList.stream().collect(Collectors.toMap(EmpowerPlatformEo::getCode, EmpowerPlatformEo::getName));
        Map<Long, List<CustomerPropertyInfoEo>> propertyInfo = customerPropertyInfoList.stream().collect(Collectors.groupingBy(CustomerPropertyInfoEo::getCustomerId));
        Map<Long, String> propertyValueList = propertyValue.stream().collect(Collectors.toMap(BaseEo::getId, CustomerPropertyValueEo::getValue));
        List customerIds = dtoList.stream().map(CustomerInfoRespDto::getId).distinct().collect(Collectors.toList());
        Map<Long, List<CustomerAuthInfoEo>> customerAuthInfoEoListMap = null;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerIds)) {
            Date now = new Date();
            List customerAuthInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAuthInfoDas.filter().in((Object)"customer_info_id", customerIds)).ge((Object)"auth_end_time", (Object)now)).le((Object)"auth_start_time", (Object)now)).list();
            customerAuthInfoEoListMap = customerAuthInfoEoList.stream().collect(Collectors.groupingBy(CustomerAuthInfoEo::getCustomerInfoId));
        }
        Map<Long, List<CustomerAuthInfoEo>> finalCustomerAuthInfoEoListMap = customerAuthInfoEoListMap;
        dtoList.forEach(customer -> {
            customer.setCurrencyEnumValue(CurrencyEnum.getTypeByAbbreviation((String)customer.getCurrency()));
            customer.setSalesChannel((String)channel.get(customer.getSalesChannelCode()));
            customer.setSalesPlatform((String)platform.get(customer.getSalesPlatformCode()));
            List customerPropertyInfoEoList = (List)propertyInfo.get(customer.getId());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerPropertyInfoEoList)) {
                ArrayList value = new ArrayList();
                customerPropertyInfoEoList.forEach(info -> value.add(propertyValueList.get(info.getPropertyValueId())));
                customer.setPropertyValue(String.join((CharSequence)",", value));
            }
            if (!CollectionUtils.isEmpty((Map)finalCustomerAuthInfoEoListMap)) {
                List<Object> authValueList = new ArrayList();
                List customerAuthInfoEos = (List)finalCustomerAuthInfoEoListMap.get(customer.getId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerAuthInfoEos)) {
                    authValueList = customerAuthInfoEos.stream().map(CustomerAuthInfoEo::getAuthorizationValue).collect(Collectors.toList());
                }
                customer.setAuthorizationValues(authValueList);
            }
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long oaRescindSync(CustomerInfoReqDto customerInfoReqDto) {
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        customerInfoEo.setSapCode(customerInfoReqDto.getSapCode());
        customerInfoEo.setCompanyCode(customerInfoReqDto.getCompanyCode());
        CustomerInfoEo customerInfo = (CustomerInfoEo)this.customerInfoDas.selectOne((BaseEo)customerInfoEo);
        Assert.notNull(customerInfo, CustomerExceptionCode.CUSTOMER_INFO_NULL);
        this.cacheService.delCache("customerInfo_userId_" + customerInfo.getUserId());
        CustomerStatusEo customerStatusEo = new CustomerStatusEo();
        customerStatusEo.setName(CustomerStatus.TERMINATION_IN_PROGRESS.getMsg());
        CustomerStatusEo statusEo = (CustomerStatusEo)this.customerStatusDas.selectOne((BaseEo)customerStatusEo);
        customerInfo.setStatusId(statusEo.getId());
        customerInfo.setStatusName(statusEo.getName());
        this.customerInfoDas.updateSelective((BaseEo)customerInfo);
        return customerInfo.getUserId();
    }

    @Override
    public Long rescindCallback(CustomerInfoReqDto customerInfoReqDto) {
        logger.info("OA\u89e3\u7ea6\u91d1\u989d\u540c\u6b65\u4e2d\u53f0customerInfoReqDto\uff1a{}", (Object)JSON.toJSONString((Object)customerInfoReqDto));
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        customerInfoEo.setSapCode(customerInfoReqDto.getSapCode());
        customerInfoEo.setCompanyCode(customerInfoReqDto.getCompanyCode());
        CustomerInfoEo customerInfo = (CustomerInfoEo)this.customerInfoDas.selectOne((BaseEo)customerInfoEo);
        Assert.notNull(customerInfo, CustomerExceptionCode.CUSTOMER_INFO_NULL);
        this.cacheService.delCache("customerInfo_userId_" + customerInfo.getUserId());
        CustomerInfoEo customerEo = new CustomerInfoEo();
        customerEo.setId(customerInfo.getId());
        customerEo.setRefundLimit(customerInfoReqDto.getRefundLimit());
        customerEo.setReturnAmountStatus(RefundLimitStatus.REFUND_CALLBACK.getCode());
        customerEo.setRegisteredCapital(customerInfoReqDto.getRegisteredCapital());
        this.customerInfoDas.updateSelective((BaseEo)customerEo);
        return customerInfo.getUserId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RefundReqDto refundCallback(RefundCallbackReqDto refundCallbackReqDto) {
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        customerInfoEo.setProcessCode(refundCallbackReqDto.getId());
        CustomerInfoEo customerInfo = (CustomerInfoEo)this.customerInfoDas.selectOne((BaseEo)customerInfoEo);
        this.cacheService.delCache("customerInfo_userId_" + customerInfo.getUserId());
        if (OaStatus.APPROVE_PASS.getCode().equals(refundCallbackReqDto.getStatus())) {
            CustomerStatusEo customerStatusEo = new CustomerStatusEo();
            customerStatusEo.setName(CustomerStatus.TO_TERMINATE_THE_CONTRACT.getMsg());
            CustomerStatusEo statusEo = (CustomerStatusEo)this.customerStatusDas.selectOne((BaseEo)customerStatusEo);
            customerInfo.setStatusId(statusEo.getId());
            customerInfo.setStatusName(statusEo.getName());
            this.customerInfoDas.updateSelective((BaseEo)customerInfo);
        } else {
            customerInfo.setRefundStatus(RefundStatus.CANCELLATION_REFUND_NOT_INITIATED.getCode());
            this.customerInfoDas.updateSelective((BaseEo)customerInfo);
        }
        RefundReqDto refundReqDto = new RefundReqDto();
        refundReqDto.setUserId(customerInfo.getUserId());
        refundReqDto.setCustomerCode(customerInfo.getCode());
        refundReqDto.setCreditIdentification(customerInfo.getCreditIdentification());
        return refundReqDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void oaAuthorizationSync(CustomerInfoReqDto customerInfoReqDto) {
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        customerInfoEo.setSapCode(customerInfoReqDto.getSapCode());
        customerInfoEo.setCompanyCode(customerInfoReqDto.getCompanyCode());
        CustomerInfoEo customerInfo = (CustomerInfoEo)this.customerInfoDas.selectOne((BaseEo)customerInfoEo);
        Assert.notNull(customerInfo, CustomerExceptionCode.CUSTOMER_INFO_NULL);
        this.cacheService.delCache("customerInfo_userId_" + customerInfo.getUserId());
        Assert.isTrue(ObjectUtil.isNotEmpty((Object)customerInfoReqDto.getAuthorizationValue()), CustomerExceptionCode.AUTH_VALUE_EMPTY);
        Assert.isTrue(ObjectUtil.isNotEmpty((Object)customerInfoReqDto.getAuthStartTime()), CustomerExceptionCode.AUTH_START_TIME_EMPTY);
        Assert.isTrue(ObjectUtil.isNotEmpty((Object)customerInfoReqDto.getAuthEndTime()), CustomerExceptionCode.AUTH_END_TIME_EMPTY);
        Date authEndTime = DateUtil.parseDate((String)customerInfoReqDto.getAuthEndTime(), (String)"yyyy-MM-dd");
        authEndTime = DateUtil.getDayEnd((Date)authEndTime);
        Date authStartTime = DateUtil.parseDate((String)customerInfoReqDto.getAuthStartTime(), (String)"yyyy-MM-dd");
        authStartTime = DateUtil.getDayBegin((Date)authStartTime);
        CustomerAuthInfoEo customerAuthInfoEo = new CustomerAuthInfoEo();
        customerAuthInfoEo.setAuthEndTime(authEndTime);
        customerAuthInfoEo.setAuthStartTime(authStartTime);
        customerAuthInfoEo.setAuthorizationValue(customerInfoReqDto.getAuthorizationValue());
        customerAuthInfoEo.setCustomerInfoId(customerInfo.getId());
        this.customerAuthInfoDas.insert((BaseEo)customerAuthInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAuthorization(UpdateAuthorizationReqDto updateAuthorizationReqDto) {
        CustomerInfoEo customerInfo = (CustomerInfoEo)this.customerInfoDas.selectByPrimaryKey(updateAuthorizationReqDto.getCustomerId());
        this.cacheService.delCache("customerInfo_userId_" + customerInfo.getUserId());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)updateAuthorizationReqDto.getAuthorizationValues())) {
            CustomerInfoEo customerInfoEo = new CustomerInfoEo();
            customerInfoEo.setId(updateAuthorizationReqDto.getCustomerId());
            customerInfoEo.setAuthorizationValue("");
            this.customerInfoDas.updateSelective((BaseEo)customerInfoEo);
        } else {
            String join = String.join((CharSequence)",", updateAuthorizationReqDto.getAuthorizationValues());
            CustomerInfoEo customerInfoEo = new CustomerInfoEo();
            customerInfoEo.setId(updateAuthorizationReqDto.getCustomerId());
            customerInfoEo.setAuthorizationValue(join);
            this.customerInfoDas.updateSelective((BaseEo)customerInfoEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void customerStateChanges(Long id, Integer status) {
        CustomerInfoEo customerInfo = (CustomerInfoEo)this.customerInfoDas.selectByPrimaryKey(id);
        Assert.notNull(customerInfo, CustomerExceptionCode.CUSTOMER_INFO_NULL);
        this.cacheService.delCache("customerInfo_userId_" + customerInfo.getUserId());
        CustomerStatusEo customerStatusEo = new CustomerStatusEo();
        if (CustomerStatus.STOP.getCode().equals(status)) {
            customerStatusEo.setName(CustomerStatus.STOP.getMsg());
        } else {
            customerStatusEo.setName(CustomerStatus.START.getMsg());
        }
        CustomerStatusEo customerStatus = (CustomerStatusEo)this.customerStatusDas.selectOne((BaseEo)customerStatusEo);
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        customerInfoEo.setId(id);
        customerInfoEo.setStatusId(customerStatus.getId());
        customerInfoEo.setStatusName(customerStatus.getName());
        if (CustomerStatus.TO_TERMINATE_THE_CONTRACT.getMsg().equals(customerInfo.getStatusName())) {
            customerInfoEo.setRefundStatus(RefundStatus.CANCELLATION_REFUND_NOT_INITIATED.getCode());
            customerInfoEo.setReturnAmountStatus(RefundLimitStatus.REFUND_NOT_CALLBACK.getCode());
            customerInfoEo.setRefundLimit(new BigDecimal(0));
            customerInfoEo.setProcessCode("");
            SyncStatusDto statusDto = new SyncStatusDto();
            statusDto.setCode(customerInfo.getCode());
            statusDto.setStatus(status);
            statusDto.setType(CustomerStatusType.CLEAR_AWAY_ENABLE.getCode());
            String syncStatus = JSON.toJSONString((Object)statusDto);
            logger.info("\u4fee\u6539\u5ba2\u6237\u72b6\u6001\u4fe1\u606f\u540c\u6b65\u652f\u4ed8\u548c\u8fd4\u5229\u4e2d\u5fc3....\u5165\u53c2syncStatus\uff1a{}", (Object)syncStatus);
            MessageResponse message = this.commonsMqService.publishMessageAsync(this.environment.resolvePlaceholders("${yundt.cube.customer.topic:SINGLE_TOPIC}"), this.environment.resolvePlaceholders("${yundt.cube.customer.tag.status:CUSTOMER_INFO_PAYMENT_STATUS_TAG}"), (Object)syncStatus);
            if (!"success".equals(message.getResultMsg())) {
                logger.error(CustomerExceptionCode.PAYMENT_STATUS_MQ_CONSUMER_FAIL.getMsg());
            }
        } else {
            SyncStatusDto statusDto = new SyncStatusDto();
            statusDto.setCode(customerInfo.getCode());
            statusDto.setStatus(status);
            statusDto.setType(CustomerStatusType.OTHER.getCode());
            String syncStatus = JSON.toJSONString((Object)statusDto);
            logger.info("\u4fee\u6539\u5ba2\u6237\u72b6\u6001\u4fe1\u606f\u540c\u6b65\u652f\u4ed8\u548c\u8fd4\u5229\u4e2d\u5fc3....\u5165\u53c2syncStatus\uff1a{}", (Object)syncStatus);
            MessageResponse message = this.commonsMqService.publishMessageAsync(this.environment.resolvePlaceholders("${yundt.cube.customer.topic:SINGLE_TOPIC}"), this.environment.resolvePlaceholders("${yundt.cube.customer.tag.status:CUSTOMER_INFO_PAYMENT_STATUS_TAG}"), (Object)syncStatus);
            if (!"success".equals(message.getResultMsg())) {
                logger.error(CustomerExceptionCode.PAYMENT_STATUS_MQ_CONSUMER_FAIL.getMsg());
            }
        }
        this.customerInfoDas.updateSelective((BaseEo)customerInfoEo);
    }

    public Boolean validOrUpdateCustomer(CustomerInfoReqDto customerInfoReqDto, List<CustomerInfoReqDto> customerSyncCredit, List<CustomerInfoReqDto> customerSyncPayment, Map<String, EmpowerPlatformEo> empowerPlatformMap) {
        if (Objects.nonNull(customerInfoReqDto)) {
            ArrayList freezeReqDtos = Lists.newArrayList();
            Assert.notNull(customerInfoReqDto.getCode(), CustomerExceptionCode.CUSTOMER_CODE_NULL);
            CustomerInfoEo customerInfoEo = new CustomerInfoEo();
            customerInfoEo.setCode(customerInfoReqDto.getCode());
            CustomerInfoEo customerEo = (CustomerInfoEo)this.customerInfoDas.selectOne((BaseEo)customerInfoEo);
            if (customerEo == null) {
                return false;
            }
            customerInfoReqDto.setId(customerEo.getId());
            CustomerInfoEo update = new CustomerInfoEo();
            if (StringUtils.isNotBlank((CharSequence)customerInfoReqDto.getAreaCode())) {
                this.addAreaInfo(customerInfoReqDto, update);
            }
            if (StringUtils.isNotBlank((CharSequence)customerInfoReqDto.getGrade())) {
                this.addGradeInfo(customerInfoReqDto, update);
            }
            this.updateEmpowerPlatformInfo(customerInfoReqDto, empowerPlatformMap);
            DtoHelper.dto2Eo((BaseVo)customerInfoReqDto, (BaseEo)update);
            customerInfoReqDto.setSyncStatus(SyncStatus.CUSTOMER_UPDATE.getCode());
            customerSyncPayment.add(customerInfoReqDto);
            if (!customerEo.getCreditIdentification().equals(customerInfoReqDto.getCreditIdentification()) || CreditStatus.CREDIT_STATUS.getCode().equals(customerInfoReqDto.getCreditIdentification())) {
                customerSyncCredit.add(customerInfoReqDto);
            }
            Long statusId = this.defaultStatusId(customerInfoReqDto.getCustomerFreeze());
            update.setStatusId(statusId);
            update.setStatusName(Objects.nonNull(customerInfoReqDto.getCustomerFreeze()) && Objects.equals("X", customerInfoReqDto.getCustomerFreeze()) ? "\u7981\u7528" : "\u542f\u7528");
            if (Objects.nonNull(customerInfoReqDto.getCustomerFreeze()) && Objects.equals("X", customerInfoReqDto.getCustomerFreeze())) {
                CustomerFreezeReqDto customerFreezeReqDto = new CustomerFreezeReqDto();
                customerFreezeReqDto.setUserId(customerEo.getUserId());
                freezeReqDtos.add(customerFreezeReqDto);
            }
            update.setCustomerFreeze(customerInfoReqDto.getCustomerFreeze());
            this.customerInfoDas.updateSelective((BaseEo)update);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)freezeReqDtos)) {
                this.customerFreeze(freezeReqDtos);
            }
        }
        return true;
    }

    public void customerFreeze(List<CustomerFreezeReqDto> freezeReqDtos) {
        String freeze = JSON.toJSON(freezeReqDtos).toString();
        logger.info("\u5c06\u7981\u7528\u7528\u6237\u4fe1\u606f\u53d1\u9001\u7ed9\u7528\u6237\u4e2d\u5fc3....\u5165\u53c2\u7528\u6237\u4fe1\u606f\u96c6\u5408freezeReqDtos\uff1a{}", (Object)freeze);
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${yundt.cube.customer.topic:SINGLE_TOPIC}"), this.environment.resolvePlaceholders("${yundt.cube.customer.tag.freeze:CUSTOMER_INFO_FREEZE_INFO_TAG}"), (Object)freeze);
        if (!"success".equals(messageResponse.getResultMsg())) {
            logger.error(CustomerExceptionCode.FREEZE_MQ_CONSUMER_FAIL.getMsg());
        }
    }

    private void addAreaInfo(CustomerInfoReqDto customerInfoReqDto, CustomerInfoEo customerInfoEo) {
        HashMap<String, Long> map = new HashMap<String, Long>(64);
        AreaEo areaEo = new AreaEo();
        String areaName = customerInfoReqDto.getArea();
        String areaCode = customerInfoReqDto.getAreaCode();
        if (map.containsKey(areaCode)) {
            customerInfoEo.setAreaId((Long)map.get(areaCode));
        } else {
            areaEo.setCode(areaCode);
            AreaEo area = (AreaEo)this.areaDas.selectOne((BaseEo)areaEo);
            if (area == null) {
                areaEo.setName(areaName);
                this.areaDas.insert((BaseEo)areaEo);
                customerInfoEo.setAreaId(areaEo.getId());
                map.put(areaEo.getCode(), areaEo.getId());
            } else {
                customerInfoEo.setAreaId(area.getId());
                if (!area.getName().equals(areaName)) {
                    area.setName(areaName);
                    this.areaDas.updateSelective((BaseEo)area);
                }
            }
        }
    }

    private void addGradeInfo(CustomerInfoReqDto customerInfoReqDto, CustomerInfoEo customerInfoEo) {
        HashMap<String, Long> map = new HashMap<String, Long>(64);
        GradeEo gradeEo = new GradeEo();
        String gradeName = customerInfoReqDto.getGrade();
        if (map.containsKey(gradeName)) {
            customerInfoEo.setGradeId((Long)map.get(gradeName));
        } else {
            gradeEo.setName(gradeName);
            GradeEo grade = (GradeEo)this.gradeDas.selectOne((BaseEo)gradeEo);
            if (grade == null) {
                this.gradeDas.insert((BaseEo)gradeEo);
                customerInfoEo.setGradeId(gradeEo.getId());
                map.put(gradeEo.getName(), gradeEo.getId());
            } else {
                customerInfoEo.setGradeId(grade.getId());
            }
        }
    }

    private void updateEmpowerPlatformInfo(CustomerInfoReqDto customerInfoReqDto, Map<String, EmpowerPlatformEo> empowerPlatformMap) {
        EmpowerPlatformEo empowerPlatformEo;
        EmpowerPlatformInfoEo empowerPlatformInfoEo = new EmpowerPlatformInfoEo();
        empowerPlatformInfoEo.setCustomerCode(customerInfoReqDto.getCode());
        empowerPlatformInfoEo.setType(EmpowerPlatformType.INITIALIZATION_CORRELATION.getCode());
        List select = this.empowerPlatformInfoDas.select((BaseEo)empowerPlatformInfoEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)select)) {
            List<Long> platformId = select.stream().map(BaseEo::getId).collect(Collectors.toList());
            platformId.forEach(id -> this.empowerPlatformInfoDas.deleteById(id));
        }
        if (StringUtils.isNotBlank((CharSequence)customerInfoReqDto.getSalesPlatformCode()) && (empowerPlatformEo = empowerPlatformMap.get(customerInfoReqDto.getSalesPlatformCode())) != null) {
            EmpowerPlatformInfoEo platformInfoEo = new EmpowerPlatformInfoEo();
            platformInfoEo.setCustomerId(customerInfoReqDto.getId());
            platformInfoEo.setCustomerName(customerInfoReqDto.getName());
            platformInfoEo.setCustomerCode(customerInfoReqDto.getCode());
            platformInfoEo.setEmpowerPlatformId(empowerPlatformEo.getId());
            platformInfoEo.setEmpowerPlatformName(empowerPlatformEo.getName());
            platformInfoEo.setType(EmpowerPlatformType.INITIALIZATION_CORRELATION.getCode());
            this.empowerPlatformInfoDas.insert((BaseEo)platformInfoEo);
        }
    }

    public Long getId() {
        return IdGenrator.getDistributedId();
    }

    private Long defaultStatusId(String status) {
        HashMap<String, Long> map = new HashMap<String, Long>(64);
        boolean flag = Objects.nonNull(status) && Objects.equals("X", status);
        if (map.containsKey(flag ? "\u7981\u7528" : "\u542f\u7528")) {
            return (Long)map.get(flag ? "\u7981\u7528" : "\u542f\u7528");
        }
        CustomerStatusEo customerStatusEo = new CustomerStatusEo();
        customerStatusEo.setName(flag ? "\u7981\u7528" : "\u542f\u7528");
        CustomerStatusEo statusEo = (CustomerStatusEo)this.customerStatusDas.selectOne((BaseEo)customerStatusEo);
        map.put(flag ? "\u7981\u7528" : "\u542f\u7528", statusEo.getId());
        return statusEo.getId();
    }

    @Override
    public PageInfo<CustomerInfoRespDto> queryPageByCustomerIds(String customerIds, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.customerInfoDas.filter().orderByDesc((Object)"create_time");
        sqlFilters.in((Object)"id", new Object[]{customerIds});
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    public void paymentMq(List<CustomerInfoReqDto> customerInfoReqDtoList) {
        String customerInfo = JSON.toJSON(customerInfoReqDtoList).toString();
        MessageResponse message = this.commonsMqService.publishMessageAsync(this.environment.resolvePlaceholders("${yundt.cube.customer.topic:SINGLE_TOPIC}"), this.environment.resolvePlaceholders("${yundt.cube.customer.add.tag:CUSTOMER_ADD_INFO_TAG}"), (Object)customerInfo);
        if (!"success".equals(message.getResultMsg())) {
            logger.error(CustomerExceptionCode.PAYMENT_MQ_CONSUMER_FAIL.getMsg());
        }
    }

    public void creditMq(List<CustomerInfoReqDto> customerInfoReqDtoList) {
        String credit = JSON.toJSON(customerInfoReqDtoList).toString();
        logger.info("\u5c06\u4fe1\u8d37\u5ba2\u6237\u4fe1\u606f\u53d1\u9001\u7ed9\u4fe1\u7528\u4e2d\u5fc3....\u5165\u53c2\u5ba2\u6237\u4fe1\u606f\u96c6\u5408customerSyncCredit\uff1a{}", (Object)credit);
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${yundt.cube.customer.topic:SINGLE_TOPIC}"), this.environment.resolvePlaceholders("${yundt.cube.customer.tag.creditInfo:CUSTOMER_INFO_CREDIT_INFO_TAG}"), (Object)credit);
        if (!"success".equals(messageResponse.getResultMsg())) {
            logger.error(CustomerExceptionCode.CREDIT_MQ_CONSUMER_FAIL.getMsg());
        }
    }

    @Override
    public PageInfo<CustomerInfoRespDto> queryUnauthorizedCustomer(CustomerQueryReqDto queryReqDto) {
        CustomerQueryReqVo reqVo = new CustomerQueryReqVo();
        CubeBeanUtils.copyProperties((Object)reqVo, (Object)queryReqDto, (String[])new String[0]);
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getName())) {
            List<String> customerNames = Arrays.asList(queryReqDto.getName().split(";"));
            reqVo.setName(customerNames.size() == 1 ? queryReqDto.getName() : String.join((CharSequence)"|", customerNames));
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getCode())) {
            List<String> customerCodes = Arrays.asList(queryReqDto.getCode().split(";"));
            reqVo.setCode(customerCodes.size() == 1 ? queryReqDto.getCode() : String.join((CharSequence)"|", customerCodes));
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getEmpowerPlatform())) {
            List<String> empowerPlatforms = Arrays.asList(queryReqDto.getEmpowerPlatform().split(","));
            reqVo.setEmpowerPlatform(empowerPlatforms.size() == 1 ? queryReqDto.getEmpowerPlatform() : String.join((CharSequence)"|", empowerPlatforms));
        }
        PageInfo customerRespVoPageInfo = this.customerInfoDas.queryUnauthorizedCustomer(reqVo, queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo infoRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)infoRespDtoPageInfo, (Object)customerRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!CollectionUtils.isEmpty((Collection)customerRespVoPageInfo.getList())) {
            List shelfListRespDtoList = customerRespVoPageInfo.getList().stream().map(v -> {
                CustomerInfoRespDto respDto = new CustomerInfoRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                return respDto;
            }).collect(Collectors.toList());
            infoRespDtoPageInfo.setList(shelfListRespDtoList);
        }
        return infoRespDtoPageInfo;
    }

    @Override
    public PageInfo<CustomerInfoRespDto> queryBySalesmanIdPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerInfoReqDto customerInfoReqDto = (CustomerInfoReqDto)JSONObject.parseObject((String)filter, CustomerInfoReqDto.class);
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (customerInfoReqDto.getSalesmanId() != null) {
            sqlFilterList.add(SqlFilter.eq((String)"salesman_id", (Object)customerInfoReqDto.getSalesmanId()));
        }
        if (StringUtils.isNotBlank((CharSequence)customerInfoReqDto.getName())) {
            sqlFilterList.add(SqlFilter.like((String)"name", (Object)customerInfoReqDto.getName()));
        }
        customerInfoEo.setSqlFilters(sqlFilterList);
        PageInfo customerInfoEoPageInfo = this.customerInfoDas.selectPage((BaseEo)customerInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)customerInfoEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)customerInfoEoPageInfo.getList(), dtoList, CustomerInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CustomerInfoRespDto> queryBySalesmanId(Long salesmanId) {
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        customerInfoEo.setSalesmanId(salesmanId);
        customerInfoEo.setStatusName("\u542f\u7528");
        List select = this.customerInfoDas.select((BaseEo)customerInfoEo);
        ArrayList<CustomerInfoRespDto> customerInfoRespDtoList = new ArrayList<CustomerInfoRespDto>();
        CubeBeanUtils.copyCollection(customerInfoRespDtoList, (Collection)select, CustomerInfoRespDto.class);
        return customerInfoRespDtoList;
    }

    @Override
    public List<CustomerInfoRespDto> queryByCustomerIds(List<Long> customerIds) {
        List customerInfoEoList = ((ExtQueryChainWrapper)this.customerInfoDas.filter().in((Object)"id", customerIds)).list();
        ArrayList customerInfoRespDtoList = Lists.newArrayListWithExpectedSize((int)customerInfoEoList.size());
        CubeBeanUtils.copyCollection((Collection)customerInfoRespDtoList, (Collection)customerInfoEoList, CustomerInfoRespDto.class);
        return customerInfoRespDtoList;
    }

    @Override
    public List<CustomerInfoRespDto> queryAllCustomerInfo(CustomerQueryReqDto queryReqDto) {
        CustomerStatusEo customerStatusEo;
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.customerInfoDas.filter().orderByDesc((Object)"create_time");
        if (Objects.nonNull(queryReqDto) && StringUtils.isNotBlank((CharSequence)queryReqDto.getCode())) {
            sqlFilters.like((Object)"code", (Object)("%" + queryReqDto.getCode() + "%"));
        }
        if (Objects.nonNull(queryReqDto) && StringUtils.isNotBlank((CharSequence)queryReqDto.getName())) {
            sqlFilters.like((Object)"name", (Object)("%" + queryReqDto.getName() + "%"));
        }
        if (Objects.nonNull(queryReqDto) && StringUtils.isNotBlank((CharSequence)queryReqDto.getSapCode())) {
            sqlFilters.eq((Object)"sap_code", (Object)queryReqDto.getSapCode());
        }
        if (Objects.nonNull(queryReqDto) && Objects.nonNull(queryReqDto.getStatusCode()) && Objects.nonNull(customerStatusEo = (CustomerStatusEo)((ExtQueryChainWrapper)this.customerStatusDas.filter().eq((Object)"code", (Object)queryReqDto.getStatusCode())).one())) {
            sqlFilters.eq((Object)"status_id", (Object)customerStatusEo.getId());
        }
        List customerInfoEos = sqlFilters.list();
        ArrayList customerInfoRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerInfoRespDtos, (Collection)customerInfoEos, CustomerInfoRespDto.class);
        return customerInfoRespDtos;
    }

    @Override
    public List<CustomerInfoRespDto> queryAcountingCustomer(CustomerQueryReqDto queryReqDto) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.customerInfoDas.filter().orderByDesc((Object)"update_time");
        if (Objects.nonNull(queryReqDto) && Objects.nonNull(queryReqDto.getCode())) {
            sqlFilters.like((Object)"code", (Object)("%" + queryReqDto.getCode() + "%"));
        }
        if (Objects.nonNull(queryReqDto) && Objects.nonNull(queryReqDto.getName())) {
            sqlFilters.like((Object)"name", (Object)("%" + queryReqDto.getName() + "%"));
        }
        if (Objects.nonNull(queryReqDto) && Objects.nonNull(queryReqDto.getUpdateTime())) {
            sqlFilters.ge((Object)"update_time", (Object)queryReqDto.getUpdateTime());
        }
        sqlFilters.eq((Object)"status_name", (Object)"\u542f\u7528");
        List customerInfoEos = sqlFilters.list();
        ArrayList customerInfoRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerInfoRespDtos, (Collection)customerInfoEos, CustomerInfoRespDto.class);
        return customerInfoRespDtos;
    }

    @Override
    public List<CustomerInfoRespDto> queryUserAcountingCustomer(CustomerQueryReqDto queryReqDto) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.customerInfoDas.filter().orderByDesc((Object)"update_time");
        if (Objects.nonNull(queryReqDto) && Objects.nonNull(queryReqDto.getCode())) {
            sqlFilters.like((Object)"code", (Object)("%" + queryReqDto.getCode() + "%"));
        }
        if (Objects.nonNull(queryReqDto) && Objects.nonNull(queryReqDto.getName())) {
            sqlFilters.like((Object)"name", (Object)("%" + queryReqDto.getName() + "%"));
        }
        if (Objects.nonNull(queryReqDto) && Objects.nonNull(queryReqDto.getUpdateTime())) {
            sqlFilters.ge((Object)"update_time", (Object)queryReqDto.getUpdateTime());
        }
        List customerInfoEos = sqlFilters.list();
        ArrayList customerInfoRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerInfoRespDtos, (Collection)customerInfoEos, CustomerInfoRespDto.class);
        return customerInfoRespDtos;
    }

    public ExtQueryChainWrapper<CustomerInfoEo> parameterAssembly(CustomerQueryConditionReqDto customerQueryConditionReqDto, ExtQueryChainWrapper<CustomerInfoEo> filter) {
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getCode())) {
            filter.like((Object)"code", (Object)customerQueryConditionReqDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getName())) {
            filter.like((Object)"name", (Object)customerQueryConditionReqDto.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getChannelCode())) {
            filter.eq((Object)"sales_channel_code", (Object)customerQueryConditionReqDto.getChannelCode());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerQueryConditionReqDto.getAreaIds())) {
            filter.in((Object)"area_id", (Collection)customerQueryConditionReqDto.getAreaIds());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerQueryConditionReqDto.getGradeIds())) {
            filter.in((Object)"grade_id", (Collection)customerQueryConditionReqDto.getGradeIds());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerQueryConditionReqDto.getStatusIds())) {
            filter.in((Object)"status_id", (Collection)customerQueryConditionReqDto.getStatusIds());
        }
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getBeginTime())) {
            filter.ge((Object)"update_time", (Object)customerQueryConditionReqDto.getBeginTime());
        }
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getEndTime())) {
            filter.le((Object)"update_time", (Object)customerQueryConditionReqDto.getEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getPropertyValue())) {
            ExtQueryChainWrapper propertyFilter = this.customerPropertyValueDas.filter();
            propertyFilter.like((Object)"value", (Object)customerQueryConditionReqDto.getPropertyValue());
            List select = propertyFilter.select(new String[0]).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)select)) {
                List collect = select.stream().map(s -> s.getId()).collect(Collectors.toList());
                ExtQueryChainWrapper InfoFilter = this.customerPropertyInfoDas.filter();
                InfoFilter.in((Object)"property_value_id", collect);
                List customer = InfoFilter.select(new String[0]).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customer)) {
                    List customerIds = customer.stream().map(c -> c.getCustomerId()).distinct().collect(Collectors.toList());
                    filter.in((Object)"id", customerIds);
                } else {
                    filter.isNull((Object)"id");
                }
            } else {
                filter.isNull((Object)"id");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getSalesmanName())) {
            filter.like((Object)"salesman_name", (Object)customerQueryConditionReqDto.getSalesmanName());
        }
        if (customerQueryConditionReqDto.getCustomerCountry() != null) {
            filter.eq((Object)"company_code", (Object)CustomerCountryTypeStatus.get((Integer)customerQueryConditionReqDto.getCustomerCountry()));
        }
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getType())) {
            filter.eq((Object)"type_code", (Object)customerQueryConditionReqDto.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)customerQueryConditionReqDto.getKeyword())) {
            ((ExtQueryChainWrapper)((ExtQueryChainWrapper)filter.like((Object)"name", (Object)customerQueryConditionReqDto.getKeyword())).or()).like((Object)"code", (Object)customerQueryConditionReqDto.getKeyword());
        }
        if (customerQueryConditionReqDto.getCreditIdentification() != null) {
            filter.eq((Object)"credit_identification", (Object)customerQueryConditionReqDto.getCreditIdentification());
        }
        if (Objects.nonNull(customerQueryConditionReqDto.getPriceFlag()) && 1 == customerQueryConditionReqDto.getPriceFlag()) {
            List customerStatusEos = ((ExtQueryChainWrapper)this.customerStatusDas.filter().eq((Object)"name", (Object)"\u542f\u7528")).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerStatusEos)) {
                List statusIds = customerStatusEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
                filter.in((Object)"status_id", statusIds);
            }
            filter.eq((Object)"sales_model_code", (Object)SalesModelEnums.M006.getCode());
        }
        return filter;
    }
}

