/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.hd;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernContentReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernContentRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractStoreSellerGovernServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.vo.StoreSellerGovernExcelVo;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerGovernDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerGovernEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="hd_IStoreSellerGovernService")
public class HdStoreSellerGovernServiceImpl
extends AbstractStoreSellerGovernServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(HdStoreSellerGovernServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private StoreSellerGovernDas storeSellerGovernDas;
    @Resource(name="${yunxi.dg.base.project}_IStoreAreaService")
    private IStoreAreaService storeAreaService;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernContentService")
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource
    private StoreDas storeDas;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerRelateService")
    private IStoreSellerRelateService storeSellerRelateService;

    @Override
    public RestResponse<StoreSellerGovernExcelRespDto> excel(MultipartFile file) {
        StoreSellerGovernExcelRespDto respDto = new StoreSellerGovernExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List storeSellerGovernExcelVoList = Lists.newArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), StoreSellerGovernExcelVo.class, (ImportParams)importParams);
            storeSellerGovernExcelVoList = result.getList();
            if (CollectionUtils.isEmpty((Collection)storeSellerGovernExcelVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        for (StoreSellerGovernExcelVo vo : storeSellerGovernExcelVoList) {
            List storeEos;
            if (StringUtils.isEmpty((CharSequence)vo.getSellerCode())) {
                errorList.add(this.excelErrorMsg(vo, "\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728"));
                continue;
            }
            StoreSellerGovernEo eo = new StoreSellerGovernEo();
            eo.setSellerCode(vo.getSellerCode());
            StoreSellerGovernEo governEo = (StoreSellerGovernEo)this.storeSellerGovernDas.selectOne((BaseEo)eo);
            if (Objects.isNull(governEo)) {
                governEo = new StoreSellerGovernEo();
                this.storeSellerGovernDas.insert((BaseEo)governEo);
            }
            if (CollectionUtils.isNotEmpty(vo.getAllArea())) {
                List<StoreAreaRespDto> list = this.storeAreaService.queryByCodes(vo.getAllArea());
                vo.setAreaList(list.stream().map(StoreAreaRespDto::getCode).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(vo.getAllSocialCreditNum()) && CollectionUtils.isNotEmpty((Collection)(storeEos = this.storeDas.queryBySocialCreditNum(vo.getAllSocialCreditNum())))) {
                vo.setStoreMap(storeEos.stream().collect(Collectors.toMap(StoreEo::getSocialCreditNum, StoreEo::getStoreId, (e1, e2) -> e1)));
            }
            try {
                List<StoreSellerGovernContentRespDto> contents = this.storeSellerGovernContentService.queryByStoreSellerId(governEo.getId());
                for (GovernTypeEnum typeEnum : GovernTypeEnum.values()) {
                    List governTypes = contents.stream().filter(e -> typeEnum.getCode().equals(e.getGovernType())).collect(Collectors.toList());
                    List<Object> governList = Lists.newArrayList();
                    if (CollectionUtils.isEmpty(governTypes)) {
                        logger.info("\u7ba1\u8f96\u5185\u5bb9{}\u5904\u7406\u524d\u4e3a\u7a7a", (Object)typeEnum.getName());
                        governList = vo.getGovernList(null, typeEnum);
                    } else {
                        List<String> contentStrs = governTypes.stream().map(StoreSellerGovernContentRespDto::getGovernContent).collect(Collectors.toList());
                        governList = vo.getGovernList(contentStrs, typeEnum);
                        List list = governTypes.stream().map(e -> e.getId().toString()).collect(Collectors.toList());
                        this.storeSellerGovernContentService.removeStoreSellerGovernContent(StringUtils.join(list, (String)","), this.context.instanceId());
                        logger.info("\u7ba1\u8f96\u5185\u5bb9{}\u5904\u7406\u524d:{}", (Object)typeEnum.getName(), (Object)JSON.toJSONString(list));
                    }
                    logger.info("\u7ba1\u8f96\u5185\u5bb9{}\u5904\u7406\u540e:{}", (Object)typeEnum.getName(), (Object)JSON.toJSONString((Object)governList));
                    for (String string : governList) {
                        StoreSellerGovernContentReqDto dto = new StoreSellerGovernContentReqDto();
                        dto.setStoreSellerId(governEo.getId());
                        dto.setGovernType(typeEnum.getCode());
                        dto.setGovernContent(string);
                        this.storeSellerGovernContentService.addStoreSellerGovernContent(dto);
                    }
                }
            }
            catch (Exception e4) {
                e4.printStackTrace();
                logger.error("\u4fe1\u606f\u5904\u7406\u6709\u8bef:{}", (Object)e4.toString());
                errorList.add(this.excelErrorMsg(vo, "\u4fe1\u606f\u5904\u7406\u6709\u8bef:" + e4.getMessage()));
                continue;
            }
            successList.add(vo);
            StoreSellerGovernEo param = governEo;
            logger.info("\u5904\u7406\u884c\u6570\u636e\u5b8c\u6210\uff0c\u51c6\u5907\u6784\u5efa\u5546\u5bb6\u7ba1\u8f96\u836f\u5e97\u7684\u5173\u8054\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)param));
            ExecutorUtils.execute(() -> this.storeSellerRelateService.buildStoreSellerRelate(param.getSellerId(), param.getOrganizationId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u836f\u5e97\u5206\u914d\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, StoreSellerGovernExcelVo.class, null, excelName, "xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e5) {
                logger.error("\u836f\u5e97\u5206\u914d\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:{}", (Object)e5.toString());
                return new RestResponse("-1", "\u836f\u5e97\u5206\u914d\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:" + e5);
            }
        }
        respDto.setNum(Integer.valueOf(storeSellerGovernExcelVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        return new RestResponse((Object)respDto);
    }

    @Override
    public PageInfo<StoreSellerGovernRespDto> queryPage(StoreSellerGovernQueryReqDto reqDto) {
        PageInfo storeSellerGovernRespDtoPageInfo = this.storeSellerGovernDas.queryPage(reqDto, Integer.valueOf(reqDto.getPageNum()), Integer.valueOf(reqDto.getPageSize()));
        if (storeSellerGovernRespDtoPageInfo.getList() == null) {
            storeSellerGovernRespDtoPageInfo.setList(new ArrayList());
            return storeSellerGovernRespDtoPageInfo;
        }
        storeSellerGovernRespDtoPageInfo.getList().forEach(dto -> {
            Map<String, Integer> governDetail = this.getGovernDetail(dto.getGovern());
            dto.setGovernAreaNum(governDetail.get(StoreGovernTypeEnum.AREA.getCode()));
            dto.setGovernStoreNum(governDetail.get(StoreGovernTypeEnum.STORE.getCode()));
            dto.setGovernBlacklistNum(governDetail.get(StoreGovernTypeEnum.BLACKLIST.getCode()));
        });
        return storeSellerGovernRespDtoPageInfo;
    }
}

