/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreModifyRecordRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRelateRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerRelateDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerRelateEo;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractStoreSellerRelateServiceImpl
implements IStoreSellerRelateService {
    Logger logger = LoggerFactory.getLogger(AbstractStoreSellerRelateServiceImpl.class);
    @Resource
    private StoreSellerRelateDas storeSellerRelateDas;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernContentService")
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernService")
    private IStoreSellerGovernService storeSellerGovernService;
    @Resource(name="${yunxi.dg.base.project}_IStoreService")
    private IStoreService storeService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void buildStoreSellerRelate(Long sellerId, Long orgId) {
    }

    @Override
    public void deleteStoreSellerRelate(Long sellerId) {
        if (ObjectUtils.isEmpty((Object)sellerId)) {
            return;
        }
        this.deleteRelate(sellerId, null);
    }

    @Override
    public void updateRelateByStoreChange(List<String> storeIds) {
    }

    @Override
    public void updateRelateByModifyRecord(List<StoreModifyRecordRespDto> storeModifyRecordRespDtos) {
    }

    @Override
    public List<StoreSellerRelateRespDto> queryStoreSellerRelateBySellerId(Long sellerId, List<String> storeIds) {
        return null;
    }

    protected void deleteRelate(Long sellerId, List<String> storeIds) {
        if (ObjectUtils.isEmpty((Object)sellerId)) {
            return;
        }
        StoreSellerRelateEo params = new StoreSellerRelateEo();
        params.setSellerId(sellerId);
        if (CollectionUtil.isNotEmpty(storeIds)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"store_id", storeIds));
            sqlFilters.add(SqlFilter.in((String)"seller_id", (Object)sellerId));
            params.setSqlFilters(sqlFilters);
        }
        this.storeSellerRelateDas.delete((BaseEo)params);
    }

    protected void deleteRelateByStore(String storeId) {
        if (StringUtils.isEmpty((CharSequence)storeId)) {
            return;
        }
        StoreSellerRelateEo params = new StoreSellerRelateEo();
        params.setStoreId(storeId);
        params.setGovernSource(GovernTypeEnum.AREA.getCode());
        this.storeSellerRelateDas.delete((BaseEo)params);
    }

    @Override
    public void buildStoreSellerRelateProcess(Long sellerId, Long orgId) {
    }
}

