/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.hd;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CreditAccountReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.biz.proxy.credit.ICreditAccountApi;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractCustomerInfoServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerInfoEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="hd_ICustomerInfoService")
public class HdCustomerInfoServiceImpl
extends AbstractCustomerInfoServiceImpl {
    @Resource
    private CustomerInfoDas customerInfoDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICreditAccountApi iCreditAccountApi;
    @Resource
    private CustomerStatusDas customerStatusDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustomerInfo(CustomerInfoReqDto addReqDto) {
        this.verifyAddCustomerInfo(addReqDto);
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerInfoEo);
        this.customerInfoDas.insert((BaseEo)customerInfoEo);
        this.cacheService.setCache("customerInfo_userId_" + customerInfoEo.getUserId(), (Object)customerInfoEo, 3600);
        this.notifyCreditUpdateAccount(customerInfoEo);
        return customerInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCustomerInfo(CustomerInfoReqDto modifyReqDto) {
        this.verifyModifyCustomerInfo(modifyReqDto);
        CustomerInfoEo customerInfoEo = (CustomerInfoEo)this.customerInfoDas.selectByPrimaryKey(modifyReqDto.getId());
        CustomerInfoEo customerInfo = new CustomerInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerInfo);
        this.customerInfoDas.updateSelective((BaseEo)customerInfo);
        this.cacheService.delCache("customerInfo_userId_" + customerInfoEo.getUserId());
        this.notifyCreditUpdateAccount(customerInfoEo);
    }

    private void verifyModifyCustomerInfo(CustomerInfoReqDto addReqDto) {
        this.verifyNotNullCustomerInfo(addReqDto);
        Assert.isTrue(addReqDto.getId() != null, CustomerExceptionCode.VERIFY_PARAMETER_COMMON_ERROR, "\u7f16\u8f91\u5ba2\u6237\u4fe1\u606f\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void notifyCreditUpdateAccount(CustomerInfoEo customerInfoEo) {
        CustomerStatusEo one = (CustomerStatusEo)((ExtQueryChainWrapper)this.customerStatusDas.filter().eq((Object)"id", (Object)customerInfoEo.getStatusId())).one();
        CreditAccountReqDto accountReqDto = new CreditAccountReqDto();
        accountReqDto.setCustomerNo(customerInfoEo.getCode());
        accountReqDto.setCustomerName(customerInfoEo.getName());
        accountReqDto.setCreditAccountStatus(Integer.valueOf(one.getCode().equals("qiyong") ? 1 : 2));
        this.iCreditAccountApi.addCreditAccount(accountReqDto);
    }

    private void verifyAddCustomerInfo(CustomerInfoReqDto addReqDto) {
        this.verifyNotNullCustomerInfo(addReqDto);
        List eoList = ((ExtQueryChainWrapper)this.customerInfoDas.filter().eq((Object)"code", (Object)addReqDto.getCode())).list();
        Assert.isTrue(CollectionUtils.isEmpty((Collection)eoList), CustomerExceptionCode.VERIFY_PARAMETER_COMMON_ERROR, "\u5ba2\u6237\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\u4e86");
    }

    private void verifyNotNullCustomerInfo(CustomerInfoReqDto addReqDto) {
        Assert.isTrue(StrUtil.isNotBlank((CharSequence)addReqDto.getCode()), CustomerExceptionCode.VERIFY_PARAMETER_COMMON_ERROR, "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue(StrUtil.isNotBlank((CharSequence)addReqDto.getName()), CustomerExceptionCode.VERIFY_PARAMETER_COMMON_ERROR, "\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue(addReqDto.getStatusId() != null, CustomerExceptionCode.VERIFY_PARAMETER_COMMON_ERROR, "\u5ba2\u6237\u72b6\u6001Id\u548c\u72b6\u6001Name\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue(StrUtil.isNotBlank((CharSequence)addReqDto.getStatusName()), CustomerExceptionCode.VERIFY_PARAMETER_COMMON_ERROR, "\u5ba2\u6237\u72b6\u6001Id\u548c\u72b6\u6001Name\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

