/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.bd;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreGovernAllotReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractStoreSellerGovernContentServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerGovernContentDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerGovernContentEo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bd_IStoreSellerGovernContentService")
public class BdStoreSellerGovernContentServiceImpl
extends AbstractStoreSellerGovernContentServiceImpl {
    private Logger logger = LoggerFactory.getLogger(BdStoreSellerGovernContentServiceImpl.class);
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernService")
    private IStoreSellerGovernService storeSellerGovernService;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerRelateService")
    private IStoreSellerRelateService storeSellerRelateService;
    @Resource
    private StoreSellerGovernContentDas storeSellerGovernContentDas;
    @Resource
    private StoreDas storeDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dealStoreGovernContent(StoreSellerGovernRespDto storeSellerGovern, StoreGovernAllotReqDto governContent) {
        this.logger.info("\u5904\u7406\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5206\u914d\u5185\u5bb9\uff1a{}==={}", (Object)JSON.toJSONString((Object)storeSellerGovern), (Object)JSON.toJSONString((Object)governContent));
        if (ObjectUtils.isEmpty((Object)storeSellerGovern) || ObjectUtils.isEmpty((Object)governContent)) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38");
        }
        ArrayList insertGovernContentList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)governContent.getAreas())) {
            governContent.getAreas().forEach(area -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.AREA.getCode());
                eo.setGovernContent(area);
                insertGovernContentList.add(eo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)governContent.getStoreIds())) {
            governContent.getStoreIds().forEach(store -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.STORE.getCode());
                eo.setGovernContent(store);
                insertGovernContentList.add(eo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)governContent.getBlacklistIds())) {
            governContent.getBlacklistIds().forEach(store -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.BLACKLIST.getCode());
                eo.setGovernContent(store);
                insertGovernContentList.add(eo);
            });
        }
        if (CollectionUtils.isNotEmpty(insertGovernContentList)) {
            this.storeSellerGovernContentDas.insertBatch(insertGovernContentList);
        }
        this.logger.info("\u7ba1\u8f96\u5185\u5bb9\u5904\u7406\u5b8c\u6210\uff0c\u51c6\u5907\u6784\u5efa\u5173\u8054\u6570\u636e");
        ExecutorUtils.execute(() -> {
            this.logger.info("\u5f02\u6b65\u6267\u884c");
            this.storeSellerRelateService.buildStoreSellerRelate(storeSellerGovern.getSellerId(), storeSellerGovern.getOrganizationId());
        });
    }
}

