/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.mkld;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerBusinessReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerBusinessRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractCustomerBusinessServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerBusinessDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerBusinessEo;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="mkld_ICustomerBusinessService")
public class MkldCustomerBusinessServiceImpl
extends AbstractCustomerBusinessServiceImpl {
    @Resource
    private CustomerBusinessDas customerBusinessDas;

    @Override
    public Long addCustomerBusiness(CustomerBusinessReqDto addReqDto) {
        CustomerBusinessEo customerBusinessEo = new CustomerBusinessEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerBusinessEo);
        this.customerBusinessDas.insert((BaseEo)customerBusinessEo);
        return customerBusinessEo.getId();
    }

    @Override
    public void modifyCustomerBusiness(CustomerBusinessReqDto modifyReqDto) {
        CustomerBusinessEo customerBusinessEo = new CustomerBusinessEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerBusinessEo);
        this.customerBusinessDas.updateSelective((BaseEo)customerBusinessEo);
    }

    @Override
    public void batchAddCustomerBusiness(List<CustomerBusinessReqDto> businessReqDtoList) {
        if (!CollectionUtils.isEmpty(businessReqDtoList)) {
            ArrayList<CustomerBusinessEo> businessEoList = new ArrayList<CustomerBusinessEo>();
            ArrayList<CustomerBusinessEo> updateBusinessEoList = new ArrayList<CustomerBusinessEo>();
            for (CustomerBusinessReqDto reqDto : businessReqDtoList) {
                CustomerBusinessEo customerBusinessEo;
                List customerBusinessEoList;
                CustomerBusinessEo businessEo = new CustomerBusinessEo();
                businessEo.setCustomerCode(reqDto.getCustomerCode());
                if (StringUtils.isNotEmpty((CharSequence)reqDto.getSaleOrgCode())) {
                    businessEo.setSaleOrgCode(reqDto.getSaleOrgCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)reqDto.getChannelCode())) {
                    businessEo.setChannelCode(reqDto.getChannelCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)reqDto.getDepartmentOrgCode())) {
                    businessEo.setDepartmentOrgCode(reqDto.getDepartmentOrgCode());
                }
                if (!CollectionUtils.isEmpty((Collection)(customerBusinessEoList = this.customerBusinessDas.select((BaseEo)businessEo)))) {
                    customerBusinessEo = new CustomerBusinessEo();
                    DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerBusinessEo);
                    customerBusinessEo.setId(((CustomerBusinessEo)customerBusinessEoList.get(0)).getId());
                    updateBusinessEoList.add(customerBusinessEo);
                    continue;
                }
                customerBusinessEo = new CustomerBusinessEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerBusinessEo);
                businessEoList.add(customerBusinessEo);
            }
            if (!CollectionUtils.isEmpty(businessEoList)) {
                this.customerBusinessDas.insertBatch(businessEoList);
            }
            if (!CollectionUtils.isEmpty(updateBusinessEoList)) {
                this.customerBusinessDas.updateBatchByIds(updateBusinessEoList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerBusiness(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerBusinessDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerBusinessRespDto queryById(Long id) {
        CustomerBusinessEo customerBusinessEo = (CustomerBusinessEo)this.customerBusinessDas.selectByPrimaryKey(id);
        CustomerBusinessRespDto customerBusinessRespDto = new CustomerBusinessRespDto();
        DtoHelper.eo2Dto((BaseEo)customerBusinessEo, (BaseVo)customerBusinessRespDto);
        return customerBusinessRespDto;
    }

    @Override
    public PageInfo<CustomerBusinessRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerBusinessReqDto customerBusinessReqDto = (CustomerBusinessReqDto)JSON.parseObject((String)filter, CustomerBusinessReqDto.class);
        CustomerBusinessEo customerBusinessEo = new CustomerBusinessEo();
        DtoHelper.dto2Eo((BaseVo)customerBusinessReqDto, (BaseEo)customerBusinessEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtil.isNotEmpty((String)customerBusinessEo.getCustomerName())) {
            sqlFilters.add(SqlFilter.like((String)"customer_name", (Object)("%" + customerBusinessEo.getCustomerName() + "%")));
            customerBusinessEo.setCustomerName(null);
        }
        if (StringUtil.isNotEmpty((String)customerBusinessEo.getSaleOrgName())) {
            sqlFilters.add(SqlFilter.like((String)"sale_org_name", (Object)("%" + customerBusinessEo.getSaleOrgName() + "%")));
            customerBusinessEo.setSaleOrgName(null);
        }
        if (StringUtil.isNotEmpty((String)customerBusinessEo.getDepartmentOrgName())) {
            sqlFilters.add(SqlFilter.like((String)"department_org_name", (Object)("%" + customerBusinessEo.getDepartmentOrgName() + "%")));
            customerBusinessEo.setDepartmentOrgName(null);
        }
        if (StringUtil.isNotEmpty((String)customerBusinessEo.getSalespersonName())) {
            sqlFilters.add(SqlFilter.like((String)"salesperson_name", (Object)("%" + customerBusinessEo.getSalespersonName() + "%")));
            customerBusinessEo.setSalespersonName(null);
        }
        customerBusinessEo.setSqlFilters(sqlFilters);
        PageInfo eoPageInfo = this.customerBusinessDas.selectPage((BaseEo)customerBusinessEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerBusinessRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CustomerBusinessRespDto> queryByCustomerCode(String customerCode) {
        CustomerBusinessEo customerBusinessEo = new CustomerBusinessEo();
        customerBusinessEo.setCustomerCode(customerCode);
        List eoPageInfo = this.customerBusinessDas.select((BaseEo)customerBusinessEo);
        ArrayList<CustomerBusinessRespDto> dtoList = new ArrayList<CustomerBusinessRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo, dtoList, CustomerBusinessRespDto.class);
        return dtoList;
    }
}

