/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerOrgPartnerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerOrgPartnerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerOrgPartnerService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerOrgPartnerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerOrgPartnerEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractCustomerOrgPartnerServiceImpl
implements ICustomerOrgPartnerService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCustomerOrgPartnerServiceImpl.class);
    @Resource
    private CustomerOrgPartnerDas customerOrgPartnerDas;

    @Override
    public Long addCustomerOrgPartner(CustomerOrgPartnerReqDto addReqDto) {
        CustomerOrgPartnerEo customerOrgPartnerEo = new CustomerOrgPartnerEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerOrgPartnerEo);
        this.customerOrgPartnerDas.insert((BaseEo)customerOrgPartnerEo);
        return customerOrgPartnerEo.getId();
    }

    @Override
    public void modifyCustomerOrgPartner(CustomerOrgPartnerReqDto modifyReqDto) {
        CustomerOrgPartnerEo customerOrgPartnerEo = new CustomerOrgPartnerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerOrgPartnerEo);
        this.customerOrgPartnerDas.updateSelective((BaseEo)customerOrgPartnerEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerOrgPartner(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerOrgPartnerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerOrgPartnerRespDto queryById(Long id) {
        CustomerOrgPartnerEo customerOrgPartnerEo = (CustomerOrgPartnerEo)this.customerOrgPartnerDas.selectByPrimaryKey(id);
        CustomerOrgPartnerRespDto customerOrgPartnerRespDto = new CustomerOrgPartnerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerOrgPartnerEo, (BaseVo)customerOrgPartnerRespDto);
        return customerOrgPartnerRespDto;
    }

    @Override
    public PageInfo<CustomerOrgPartnerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerOrgPartnerReqDto customerOrgPartnerReqDto = (CustomerOrgPartnerReqDto)JSON.parseObject((String)filter, CustomerOrgPartnerReqDto.class);
        CustomerOrgPartnerEo customerOrgPartnerEo = new CustomerOrgPartnerEo();
        DtoHelper.dto2Eo((BaseVo)customerOrgPartnerReqDto, (BaseEo)customerOrgPartnerEo);
        PageInfo eoPageInfo = this.customerOrgPartnerDas.selectPage((BaseEo)customerOrgPartnerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerOrgPartnerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncCustomerOrgPartner(List<CustomerOrgPartnerReqDto> reqDtoList) {
        this.customerOrgPartnerDas.cleanAll();
        ArrayList eoList = new ArrayList();
        DtoHelper.dtoList2EoList(reqDtoList, eoList, CustomerOrgPartnerEo.class);
        this.customerOrgPartnerDas.insertBatch(eoList);
    }

    @Override
    public CustomerOrgPartnerRespDto queryByPartnerId(String partnerId) {
        logger.info("\u6839\u636ePartnerId\u67e5\u8be2\u5ba2\u6237\u79df\u6237\u5bf9\u5e94\u4fe1\u606f\uff1a{}", (Object)partnerId);
        CustomerOrgPartnerEo params = new CustomerOrgPartnerEo();
        params.setPartnerId(partnerId);
        CustomerOrgPartnerEo customerOrgPartnerEo = (CustomerOrgPartnerEo)this.customerOrgPartnerDas.selectOne((BaseEo)params);
        CustomerOrgPartnerRespDto respDto = new CustomerOrgPartnerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerOrgPartnerEo, (BaseVo)respDto);
        return respDto;
    }

    @Override
    public void updateCustomerOrgPartner(CustomerOrgPartnerReqDto reqDto) {
        logger.info("\u66f4\u65b0\u540c\u6b65\u5ba2\u6237\u4e8c\u7ea7\u79df\u6237\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getOrgId()) || StringUtils.isBlank((CharSequence)reqDto.getPartnerId())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff0c\u79df\u6237ID\u4e0e\u7ecf\u9500\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerOrgPartnerRespDto customerOrgPartnerRespDto = this.queryByPartnerId(reqDto.getPartnerId());
        if (ObjectUtil.isNotEmpty((Object)customerOrgPartnerRespDto) && ObjectUtil.isNotEmpty((Object)customerOrgPartnerRespDto.getId())) {
            CustomerOrgPartnerEo eo = new CustomerOrgPartnerEo();
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
            eo.setId(customerOrgPartnerRespDto.getId());
            this.customerOrgPartnerDas.update((BaseEo)eo);
        } else {
            CustomerOrgPartnerEo eo = new CustomerOrgPartnerEo();
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
            this.customerOrgPartnerDas.insert((BaseEo)eo);
        }
    }
}

