/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.EmpowerPlatformType;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmpowerImportReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmpowerInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmpowerPlatformInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.PlatformReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmpowerPlatformInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IEmpowerPlatformInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmpowerPlatformDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmpowerPlatformInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerInfoEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmpowerPlatformInfoEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractEmpowerPlatformInfoServiceImpl
implements IEmpowerPlatformInfoService {
    @Resource
    private EmpowerPlatformInfoDas empowerPlatformInfoDas;
    @Resource
    private CustomerInfoDas customerInfoDas;
    @Resource
    private EmpowerPlatformDas empowerPlatformDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addEmpowerPlatformInfoList(EmpowerInfoReqDto empowerInfoReqDto) {
        Long customerId = empowerInfoReqDto.getCustomerId();
        EmpowerPlatformInfoEo empowerPlatformInfoEo = new EmpowerPlatformInfoEo();
        empowerPlatformInfoEo.setCustomerId(customerId);
        List select = this.empowerPlatformInfoDas.select((BaseEo)empowerPlatformInfoEo);
        Map<Integer, List<EmpowerPlatformInfoEo>> typeMap = select.stream().collect(Collectors.groupingBy(EmpowerPlatformInfoEo::getType));
        List<EmpowerPlatformInfoEo> manualEmpowerList = typeMap.get(EmpowerPlatformType.MANUAL_ASSOCIATION.getCode());
        List<EmpowerPlatformInfoEo> initializationEmpowerList = typeMap.get(EmpowerPlatformType.INITIALIZATION_CORRELATION.getCode());
        if (CollectionUtils.isNotEmpty(manualEmpowerList)) {
            empowerPlatformInfoEo.setType(EmpowerPlatformType.MANUAL_ASSOCIATION.getCode());
            this.empowerPlatformInfoDas.delete((BaseEo)empowerPlatformInfoEo);
        }
        List platformReqDtoList = empowerInfoReqDto.getPlatformReqDtoList();
        CustomerInfoEo customerInfoEo = new CustomerInfoEo();
        customerInfoEo.setId(customerId);
        if (CollectionUtils.isEmpty((Collection)platformReqDtoList)) {
            if (CollectionUtils.isEmpty(initializationEmpowerList)) {
                customerInfoEo.setEmpowerPlatform("");
            } else {
                customerInfoEo.setEmpowerPlatform(initializationEmpowerList.get(0).getEmpowerPlatformName());
            }
            this.customerInfoDas.updateSelective((BaseEo)customerInfoEo);
        } else {
            ArrayList<EmpowerPlatformInfoEo> empowerPlatformInfoEoList = new ArrayList<EmpowerPlatformInfoEo>();
            for (int i = 0; i < platformReqDtoList.size(); ++i) {
                EmpowerPlatformInfoEo platformInfoEo = new EmpowerPlatformInfoEo();
                CubeBeanUtils.copyProperties((Object)platformInfoEo, (Object)empowerInfoReqDto, (String[])new String[]{"id"});
                platformInfoEo.setEmpowerPlatformId(((PlatformReqDto)platformReqDtoList.get(i)).getEmpowerPlatformId());
                platformInfoEo.setEmpowerPlatformName(((PlatformReqDto)platformReqDtoList.get(i)).getEmpowerPlatformName());
                empowerPlatformInfoEoList.add(platformInfoEo);
            }
            this.empowerPlatformInfoDas.insertBatch(empowerPlatformInfoEoList);
            List stringList = platformReqDtoList.stream().map(p -> p.getEmpowerPlatformName()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(initializationEmpowerList)) {
                stringList.add(initializationEmpowerList.get(0).getEmpowerPlatformName());
            }
            String platform = String.join((CharSequence)",", stringList);
            customerInfoEo.setEmpowerPlatform(platform);
            this.customerInfoDas.updateSelective((BaseEo)customerInfoEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyEmpowerPlatformInfo(EmpowerPlatformInfoReqDto modifyReqDto) {
        EmpowerPlatformInfoEo empowerPlatformInfoEo = new EmpowerPlatformInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)empowerPlatformInfoEo);
        this.empowerPlatformInfoDas.updateSelective((BaseEo)empowerPlatformInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEmpowerPlatformInfo(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.empowerPlatformInfoDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String empowerImport(ImportDto importDto) {
        ArrayList empowerPlatformInfoEoList = new ArrayList();
        String url = importDto.getUrl();
        List<EmpowerImportReqDto> empowerList = null;
        try {
            empowerList = EasyPoiExportUtil.parseImportFile(url, EmpowerImportReqDto.class);
        }
        catch (Exception e2) {
            throw new BizException(CustomerExceptionCode.CUSTOMER_PLATFORM_IMPORT_PARSING_ERROR.getCode(), CustomerExceptionCode.PLATFORM_IMPORT_PARSING_ERROR.getMsg(), (Throwable)e2);
        }
        ArrayList customerCodes = new ArrayList();
        empowerList.forEach(customer -> {
            customerCodes.add("1220_" + customer.getCustomerCode());
            customer.setCustomerCode("1220_" + customer.getCustomerCode());
        });
        List platformCodes = empowerList.stream().map(c -> c.getEmpowerPlatformCode()).collect(Collectors.toList());
        ExtQueryChainWrapper sqlFilter = this.customerInfoDas.filter();
        sqlFilter.in((Object)"code", customerCodes);
        List customerInfoList = sqlFilter.select(new String[0]).list();
        ExtQueryChainWrapper sqlFilterList = this.empowerPlatformDas.filter();
        sqlFilterList.in((Object)"code", platformCodes);
        List platformList = sqlFilterList.select(new String[0]).list();
        empowerList.forEach(e -> customerInfoList.stream().forEach(c -> {
            if (c.getCode().equals(e.getCustomerCode())) {
                platformList.stream().forEach(p -> {
                    if (p.getCode().equals(e.getEmpowerPlatformCode())) {
                        EmpowerPlatformInfoEo empowerPlatformInfoEo = new EmpowerPlatformInfoEo();
                        empowerPlatformInfoEo.setCustomerId(c.getId());
                        empowerPlatformInfoEo.setCustomerName(c.getName());
                        empowerPlatformInfoEo.setCustomerCode(c.getCode());
                        empowerPlatformInfoEo.setEmpowerPlatformId(p.getId());
                        empowerPlatformInfoEo.setEmpowerPlatformName(p.getName());
                        empowerPlatformInfoEoList.add(empowerPlatformInfoEo);
                    }
                });
            }
        }));
        if (CollectionUtils.isNotEmpty(empowerPlatformInfoEoList)) {
            this.empowerPlatformInfoDas.insertBatch(empowerPlatformInfoEoList);
        }
        Map<Long, List<EmpowerPlatformInfoEo>> empowerPlatformMap = empowerPlatformInfoEoList.stream().collect(Collectors.groupingBy(EmpowerPlatformInfoEo::getCustomerId));
        List customerId = empowerPlatformInfoEoList.stream().map(EmpowerPlatformInfoEo::getCustomerId).distinct().collect(Collectors.toList());
        customerId.stream().forEach(id -> {
            CustomerInfoEo customerInfoEo = new CustomerInfoEo();
            customerInfoEo.setId(id);
            List empowerPlatformInfo = (List)empowerPlatformMap.get(id);
            List value = empowerPlatformInfo.stream().map(EmpowerPlatformInfoEo::getEmpowerPlatformName).collect(Collectors.toList());
            customerInfoEo.setEmpowerPlatform(String.join((CharSequence)",", value));
            this.customerInfoDas.updateSelective((BaseEo)customerInfoEo);
        });
        return "\u5ba2\u6237\u5141\u9500\u5e73\u53f0\u5bfc\u5165\u6210\u529f\uff01";
    }

    @Override
    public EmpowerPlatformInfoRespDto queryById(Long id) {
        EmpowerPlatformInfoEo empowerPlatformInfoEo = (EmpowerPlatformInfoEo)this.empowerPlatformInfoDas.selectByPrimaryKey(id);
        EmpowerPlatformInfoRespDto empowerPlatformInfoRespDto = new EmpowerPlatformInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)empowerPlatformInfoEo, (BaseVo)empowerPlatformInfoRespDto);
        return empowerPlatformInfoRespDto;
    }

    @Override
    public List<EmpowerPlatformInfoRespDto> queryByCustomerId(Long customerId) {
        EmpowerPlatformInfoEo empowerPlatformInfoEo = new EmpowerPlatformInfoEo();
        empowerPlatformInfoEo.setCustomerId(customerId);
        List select = this.empowerPlatformInfoDas.select((BaseEo)empowerPlatformInfoEo);
        ArrayList<EmpowerPlatformInfoRespDto> empowerPlatformInfoRespDtoList = new ArrayList<EmpowerPlatformInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, empowerPlatformInfoRespDtoList, EmpowerPlatformInfoRespDto.class);
        return empowerPlatformInfoRespDtoList;
    }

    @Override
    public List<EmpowerPlatformInfoRespDto> queryByCustomerIds(List<Long> customerIds) {
        EmpowerPlatformInfoEo empowerPlatformInfoEo = new EmpowerPlatformInfoEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"customer_id", customerIds));
        empowerPlatformInfoEo.setSqlFilters(sqlFilters);
        List select = this.empowerPlatformInfoDas.select((BaseEo)empowerPlatformInfoEo);
        ArrayList<EmpowerPlatformInfoRespDto> empowerPlatformInfoRespDtoList = new ArrayList<EmpowerPlatformInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, empowerPlatformInfoRespDtoList, EmpowerPlatformInfoRespDto.class);
        return empowerPlatformInfoRespDtoList;
    }

    @Override
    public List<EmpowerPlatformInfoRespDto> queryByPlatformId(Long platformId) {
        EmpowerPlatformInfoEo empowerPlatformInfoEo = new EmpowerPlatformInfoEo();
        empowerPlatformInfoEo.setEmpowerPlatformId(platformId);
        List select = this.empowerPlatformInfoDas.select((BaseEo)empowerPlatformInfoEo);
        ArrayList<EmpowerPlatformInfoRespDto> empowerPlatformInfoRespDtoList = new ArrayList<EmpowerPlatformInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, empowerPlatformInfoRespDtoList, EmpowerPlatformInfoRespDto.class);
        return empowerPlatformInfoRespDtoList;
    }

    @Override
    public List<EmpowerPlatformInfoRespDto> getCustomerPlatform(String customerCode) {
        ArrayList<EmpowerPlatformInfoRespDto> respDtoList = new ArrayList<EmpowerPlatformInfoRespDto>();
        EmpowerPlatformInfoEo eo = new EmpowerPlatformInfoEo();
        eo.setCustomerCode(customerCode);
        List channelEoList = this.empowerPlatformInfoDas.select((BaseEo)eo);
        DtoHelper.eoList2DtoList((Collection)channelEoList, respDtoList, EmpowerPlatformInfoRespDto.class);
        return respDtoList;
    }

    @Override
    public PageInfo<EmpowerPlatformInfoRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        EmpowerPlatformInfoReqDto empowerPlatformInfoReqDto = (EmpowerPlatformInfoReqDto)JSON.parseObject((String)filter, EmpowerPlatformInfoReqDto.class);
        EmpowerPlatformInfoEo empowerPlatformInfoEo = new EmpowerPlatformInfoEo();
        DtoHelper.dto2Eo((BaseVo)empowerPlatformInfoReqDto, (BaseEo)empowerPlatformInfoEo);
        PageInfo eoPageInfo = this.empowerPlatformInfoDas.selectPage((BaseEo)empowerPlatformInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EmpowerPlatformInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

