/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.GradeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.GradeRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IGradeService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.GradeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.GradeEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractGradeServiceImpl
implements IGradeService {
    @Resource
    private GradeDas gradeDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addGrade(GradeReqDto addReqDto) {
        GradeEo gradeEo = new GradeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)gradeEo);
        this.gradeDas.insert((BaseEo)gradeEo);
        return gradeEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyGrade(GradeReqDto modifyReqDto) {
        GradeEo gradeEo = new GradeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)gradeEo);
        this.gradeDas.updateSelective((BaseEo)gradeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeGrade(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.gradeDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public GradeRespDto queryById(Long id) {
        GradeEo gradeEo = (GradeEo)this.gradeDas.selectByPrimaryKey(id);
        GradeRespDto gradeRespDto = new GradeRespDto();
        DtoHelper.eo2Dto((BaseEo)gradeEo, (BaseVo)gradeRespDto);
        return gradeRespDto;
    }

    @Override
    public List<GradeRespDto> queryList() {
        ArrayList<GradeRespDto> gradeRespDtoList = new ArrayList<GradeRespDto>();
        List gradeEoList = this.gradeDas.selectAll();
        CubeBeanUtils.copyCollection(gradeRespDtoList, (Collection)gradeEoList, GradeRespDto.class);
        return gradeRespDtoList;
    }

    @Override
    public PageInfo<GradeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        GradeReqDto gradeReqDto = (GradeReqDto)JSON.parseObject((String)filter, GradeReqDto.class);
        GradeEo gradeEo = new GradeEo();
        DtoHelper.dto2Eo((BaseVo)gradeReqDto, (BaseEo)gradeEo);
        PageInfo eoPageInfo = this.gradeDas.selectPage((BaseEo)gradeEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, GradeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

