/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreGovernAllotReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernContentReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernContentRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerGovernContentDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerGovernContentEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractStoreSellerGovernContentServiceImpl
implements IStoreSellerGovernContentService {
    private Logger logger = LoggerFactory.getLogger(AbstractStoreSellerGovernContentServiceImpl.class);
    @Resource
    private StoreSellerGovernContentDas storeSellerGovernContentDas;
    @Resource
    private StoreDas storeDas;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernService")
    private IStoreSellerGovernService storeSellerGovernService;

    @Override
    public Long addStoreSellerGovernContent(StoreSellerGovernContentReqDto addReqDto) {
        StoreSellerGovernContentEo storeSellerGovernContentEo = new StoreSellerGovernContentEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storeSellerGovernContentEo);
        this.storeSellerGovernContentDas.insert((BaseEo)storeSellerGovernContentEo);
        return storeSellerGovernContentEo.getId();
    }

    @Override
    public void modifyStoreSellerGovernContent(StoreSellerGovernContentReqDto modifyReqDto) {
        StoreSellerGovernContentEo storeSellerGovernContentEo = new StoreSellerGovernContentEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storeSellerGovernContentEo);
        this.storeSellerGovernContentDas.updateSelective((BaseEo)storeSellerGovernContentEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStoreSellerGovernContent(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storeSellerGovernContentDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StoreSellerGovernContentRespDto queryById(Long id) {
        StoreSellerGovernContentEo storeSellerGovernContentEo = (StoreSellerGovernContentEo)this.storeSellerGovernContentDas.selectByPrimaryKey(id);
        StoreSellerGovernContentRespDto storeSellerGovernContentRespDto = new StoreSellerGovernContentRespDto();
        DtoHelper.eo2Dto((BaseEo)storeSellerGovernContentEo, (BaseVo)storeSellerGovernContentRespDto);
        return storeSellerGovernContentRespDto;
    }

    @Override
    public PageInfo<StoreSellerGovernContentRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StoreSellerGovernContentReqDto storeSellerGovernContentReqDto = (StoreSellerGovernContentReqDto)JSON.parseObject((String)filter, StoreSellerGovernContentReqDto.class);
        StoreSellerGovernContentEo storeSellerGovernContentEo = new StoreSellerGovernContentEo();
        DtoHelper.dto2Eo((BaseVo)storeSellerGovernContentReqDto, (BaseEo)storeSellerGovernContentEo);
        PageInfo eoPageInfo = this.storeSellerGovernContentDas.selectPage((BaseEo)storeSellerGovernContentEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StoreSellerGovernContentRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<StoreSellerGovernContentRespDto> queryByStoreSellerIds(List<Long> storeSellerId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"store_seller_id", storeSellerId);
        List result = this.storeSellerGovernContentDas.getMapper().selectList((Wrapper)wrapper);
        ArrayList<StoreSellerGovernContentRespDto> dtoList = new ArrayList<StoreSellerGovernContentRespDto>();
        DtoHelper.eoList2DtoList((Collection)result, dtoList, StoreSellerGovernContentRespDto.class);
        return dtoList;
    }

    @Override
    public List<StoreSellerGovernContentRespDto> queryByStoreSellerId(Long storeSellerId) {
        StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
        eo.setStoreSellerId(storeSellerId);
        List result = this.storeSellerGovernContentDas.select((BaseEo)eo);
        ArrayList<StoreSellerGovernContentRespDto> dtoList = new ArrayList<StoreSellerGovernContentRespDto>();
        DtoHelper.eoList2DtoList((Collection)result, dtoList, StoreSellerGovernContentRespDto.class);
        return dtoList;
    }

    @Override
    public void updateGovernContent(Long id, String governContent) {
        StoreSellerGovernContentEo eo = (StoreSellerGovernContentEo)this.storeSellerGovernContentDas.selectByPrimaryKey(id);
        if (Objects.nonNull(eo)) {
            eo.setGovernContent(governContent);
            this.storeSellerGovernContentDas.update((BaseEo)eo);
        }
    }

    @Override
    public void deleteStoreGovernContent(Long storeSellerId, String governType) {
        this.logger.info("\u6839\u636e\u5546\u5bb6\u836f\u5e97\u5206\u914d\u5220\u9664\u6307\u5b9a\u5206\u914d\u5185\u5bb9\u7c7b\u578b\u4fe1\u606f\uff1a{}=={}", (Object)storeSellerId, (Object)governType);
        if (ObjectUtils.isEmpty((Object)storeSellerId) || StringUtils.isEmpty((CharSequence)governType)) {
            return;
        }
        StoreSellerGovernContentEo params = new StoreSellerGovernContentEo();
        params.setStoreSellerId(storeSellerId);
        params.setGovernType(governType);
        this.storeSellerGovernContentDas.logicDelete((BaseEo)params);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStoreSellerGovernArea(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getAreas() == null) {
            throw new BizException("-1", "id\u3001areas\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.AREA.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStoreSellerGovernStore(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getStoreIds() == null) {
            throw new BizException("-1", "id\u3001storeIds\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.verifyRelateStatus(reqDto);
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.STORE.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    protected void verifyRelateStatus(StoreGovernAllotReqDto reqDto) {
        StoreSellerGovernRespDto storeSellerGovernRespDto = this.storeSellerGovernService.queryById(reqDto.getId());
        Assert.isTrue((boolean)storeSellerGovernRespDto.getRelateStatus().equals(GovernStatusEnum.OVER.getKey()), (String)"0001", (String)"\u5f53\u524d\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5173\u7cfb\u6b63\u5728\u751f\u6210\u4e2d");
    }

    @Override
    public void updateStoreSellerGovernStoreParent(StoreGovernAllotReqDto reqDto) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStoreSellerGovernBlacklist(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getBlacklistIds() == null) {
            throw new BizException("-1", "id\u3001blacklistIds\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.verifyRelateStatus(reqDto);
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.BLACKLIST.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dealStoreGovernContent(StoreSellerGovernRespDto storeSellerGovern, StoreGovernAllotReqDto governContent) {
    }

    @Override
    public PageInfo<StoreRespDto> querySellerGovernStore(Long id, String governType, Integer pageNum, Integer pageSize) {
        PageInfo storeRespDtoPageInfo = this.storeSellerGovernContentDas.querySellerGovernStore(id, governType, pageNum, pageSize);
        if (storeRespDtoPageInfo.getList() == null) {
            storeRespDtoPageInfo.setList(new ArrayList());
        }
        return storeRespDtoPageInfo;
    }

    @Override
    public List<StoreAreaRespDto> querySellerGovernArea(Long id) {
        List storeAreaRespDtoList = this.storeSellerGovernContentDas.querySellerGovernArea(id);
        if (storeAreaRespDtoList == null) {
            return new ArrayList<StoreAreaRespDto>();
        }
        return storeAreaRespDtoList;
    }

    @Override
    public void deleteGovernContent(Long storeSellerId) {
        if (ObjectUtils.isEmpty((Object)storeSellerId)) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        StoreSellerGovernContentEo storeSellerGovernContentEo = new StoreSellerGovernContentEo();
        storeSellerGovernContentEo.setStoreSellerId(storeSellerId);
        this.storeSellerGovernContentDas.logicDelete((BaseEo)storeSellerGovernContentEo);
    }

    @Override
    public List<StoreRespDto> queryByOrgId(Long orgId) {
        ArrayList list = Lists.newArrayList();
        List<String> storeIds = this.queryGovernContentListByOrgId(orgId);
        if (CollectionUtils.isNotEmpty(storeIds)) {
            List storeEos = this.storeDas.queryByOrgId(storeIds);
            DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)list, StoreRespDto.class);
        }
        return list;
    }

    @Override
    public List<StoreSellerGovernContentRespDto> queryGovernContentByOrgId(Long orgId) {
        if (ObjectUtils.isEmpty((Object)orgId)) {
            return new ArrayList<StoreSellerGovernContentRespDto>();
        }
        StoreSellerGovernContentEo params = new StoreSellerGovernContentEo();
        params.setOrganizationId(orgId);
        List select = this.storeSellerGovernContentDas.select((BaseEo)params);
        ArrayList<StoreSellerGovernContentRespDto> list = new ArrayList<StoreSellerGovernContentRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, StoreSellerGovernContentRespDto.class);
        return list;
    }

    @Override
    public List<String> queryGovernContentListByOrgId(Long orgId) {
        return Collections.emptyList();
    }
}

