/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.util;

import java.util.HashSet;
import liquibase.util.StringUtils;

public class StringMatchUtils {
    public static double pickAlgorithm(String str1, String str2, String strAlgorithm) {
        if (StringUtils.isEmpty((String)strAlgorithm)) {
            return StringMatchUtils.lcsSimilarity(str1, str2);
        }
        if ("LCS".equals(strAlgorithm)) {
            return StringMatchUtils.lcsSimilarity(str1, str2);
        }
        if ("LEVENSHTEIN_DISTANCE".equals(strAlgorithm)) {
            return StringMatchUtils.levenshteinDistanceSimilarity(str1, str2);
        }
        if ("HAMMING_DISTANCE".equals(strAlgorithm)) {
            return StringMatchUtils.hammingDistanceSimilarity(str1, str2);
        }
        if ("JACCARD".equals(strAlgorithm)) {
            return StringMatchUtils.jaccardSimilarity(str1, str2);
        }
        return StringMatchUtils.lcsSimilarity(str1, str2);
    }

    public static int levenshteinDistance(String str1, String str2) {
        int i;
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                int cost = str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1;
                distance[i][j] = Math.min(distance[i - 1][j] + 1, Math.min(distance[i][j - 1] + 1, distance[i - 1][j - 1] + cost));
            }
        }
        return distance[str1.length()][str2.length()];
    }

    public static double levenshteinDistanceSimilarity(String s1, String s2) {
        int levenshteinLength = StringMatchUtils.levenshteinDistance(s1, s2);
        int denominator = Math.max(s1.length(), s2.length());
        return 1.0 - (double)levenshteinLength / (double)denominator;
    }

    public static int hammingDistance(String str1, String str2) {
        if (str1.length() != str2.length()) {
            throw new IllegalArgumentException("The strings must have the same length");
        }
        int distance = 0;
        for (int i = 0; i < str1.length(); ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            ++distance;
        }
        return distance;
    }

    public static double hammingDistanceSimilarity(String s1, String s2) {
        int hammingLength = StringMatchUtils.hammingDistance(s1, s2);
        int denominator = Math.max(s1.length(), s2.length());
        return 1.0 - (double)hammingLength / (double)denominator;
    }

    public static double jaccardSimilarity(String str1, String str2) {
        HashSet<Character> set1 = new HashSet<Character>();
        HashSet<Character> set2 = new HashSet<Character>();
        for (char c : str1.toCharArray()) {
            set1.add(Character.valueOf(c));
        }
        for (char c : str2.toCharArray()) {
            set2.add(Character.valueOf(c));
        }
        HashSet intersection = new HashSet(set1);
        intersection.retainAll(set2);
        HashSet<Character> union = new HashSet<Character>(set1);
        union.addAll(set2);
        return (double)intersection.size() / (double)union.size();
    }

    public static int lcs(String s1, String s2) {
        int m = s1.length();
        int n = s2.length();
        int[][] dp = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            for (int j = 0; j <= n; ++j) {
                dp[i][j] = i == 0 || j == 0 ? 0 : (s1.charAt(i - 1) == s2.charAt(j - 1) ? dp[i - 1][j - 1] + 1 : Math.max(dp[i - 1][j], dp[i][j - 1]));
            }
        }
        return dp[m][n];
    }

    public static double lcsSimilarity(String s1, String s2) {
        int lcsLength = StringMatchUtils.lcs(s1, s2);
        int denominator = Math.max(s1.length(), s2.length());
        return (double)lcsLength / (double)denominator;
    }
}

