/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerRelationPageReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerRelationService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerRelationEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerRelationServiceImpl
implements ICustomerRelationService {
    private Logger logger = LoggerFactory.getLogger(ICustomerRelationService.class);
    @Resource
    private CustomerRelationDas customerRelationDas;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private CustomerDas customerDas;

    @Override
    public Long addCustomerRelation(CustomerRelationReqDto addReqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerRelationEo);
        this.customerRelationDas.insert((BaseEo)customerRelationEo);
        return customerRelationEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchCustomerRelation(List<CustomerRelationReqDto> dtoList) {
        if (CollectionUtil.isEmpty(dtoList)) {
            return;
        }
        List<String> codes = dtoList.stream().map(CustomerRelationReqDto::getParentThirdCode).collect(Collectors.toList());
        this.removeCustomerRelationByParentCode(codes);
        ArrayList customerRelationEos = new ArrayList();
        DtoHelper.dtoList2EoList(dtoList, customerRelationEos, CustomerRelationEo.class);
        if (CollectionUtil.isNotEmpty(customerRelationEos)) {
            List customerIds = dtoList.stream().flatMap(r -> Lists.newArrayList((Object[])new Long[]{r.getCusId(), r.getParentCusId()}).stream()).collect(Collectors.toList());
            List customerEos = ((ExtQueryChainWrapper)this.customerDas.filter().in((Object)"id", customerIds)).list();
            Map customerEoMap = customerEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (o, o1) -> o));
            customerRelationEos.forEach(r -> {
                Optional.ofNullable(customerEoMap.get(r.getParentCusId())).ifPresent(p -> {
                    r.setOrgCode(p.getThirdPartyId());
                    r.setOrgName(p.getName());
                    r.setParentThirdName(p.getName());
                    r.setBrandCode(p.getThirdParentPartyId());
                    r.setParentCode(p.getCode());
                });
                Optional.ofNullable(customerEoMap.get(r.getCusId())).ifPresent(p -> {
                    r.setThirdName(p.getName());
                    r.setCode(p.getCode());
                });
            });
        }
        Optional.ofNullable(((ExtQueryChainWrapper)this.customerDas.filter().in((Object)"third_party_id", (Collection)customerRelationEos.stream().map(CustomerRelationEo::getBrandCode).distinct().collect(Collectors.toList()))).list()).filter(CollectionUtils::isNotEmpty).ifPresent(eos -> {
            Map customerEoMap = eos.stream().collect(Collectors.toMap(StdCustomerEo::getThirdPartyId, Function.identity(), (o, o1) -> o));
            customerRelationEos.forEach(r -> Optional.ofNullable(customerEoMap.get(r.getBrandCode())).ifPresent(eo -> r.setBrandName(eo.getName())));
        });
        this.customerRelationDas.insertBatch(customerRelationEos);
    }

    @Override
    public void modifyCustomerRelation(CustomerRelationReqDto modifyReqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerRelationEo);
        this.customerRelationDas.updateSelective((BaseEo)customerRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeCustomerRelationByParentCode(List<String> codes) {
        QueryWrapper filter = new QueryWrapper();
        filter.in((Object)"parent_third_code", codes);
        int delete = this.customerRelationDas.getMapper().delete((Wrapper)filter);
    }

    @Override
    public CustomerRelationRespDto queryById(Long id) {
        CustomerRelationEo customerRelationEo = (CustomerRelationEo)this.customerRelationDas.selectByPrimaryKey(id);
        CustomerRelationRespDto customerRelationRespDto = new CustomerRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerRelationEo, (BaseVo)customerRelationRespDto);
        return customerRelationRespDto;
    }

    @Override
    public PageInfo<CustomerRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerRelationReqDto customerRelationReqDto = (CustomerRelationReqDto)JSON.parseObject((String)filter, CustomerRelationReqDto.class);
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerRelationReqDto, (BaseEo)customerRelationEo);
        PageInfo eoPageInfo = this.customerRelationDas.selectPage((BaseEo)customerRelationEo, pageNum, pageSize);
        return this.getCustomerRelationRespDtoPageInfo((PageInfo<CustomerRelationEo>)eoPageInfo);
    }

    @Override
    public CustomerRespDto queryMiddleCustomerInfo(Long smallCusId, Long greatCusId) {
        this.logger.info("\u6839\u636e\u5927\u5c0fB\u5ba2\u6237ID\u5224\u65ad\u5e76\u67e5\u8be2\u4e2dB\u4fe1\u606f\uff1a{}=={}", (Object)smallCusId, (Object)greatCusId);
        if (ObjectUtils.isEmpty((Object)smallCusId) && ObjectUtils.isEmpty((Object)greatCusId)) {
            return null;
        }
        Long cusId = null;
        cusId = ObjectUtils.isNotEmpty((Object)smallCusId) ? smallCusId : greatCusId;
        CustomerRespDto customerRespDto = this.customerService.queryById(cusId);
        if (ObjectUtils.isEmpty((Object)customerRespDto)) {
            return null;
        }
        CustomerRelationReqDto reqDto = new CustomerRelationReqDto();
        if (ObjectUtils.isNotEmpty((Object)smallCusId)) {
            reqDto.setThirdCode(customerRespDto.getThirdPartyId());
        } else {
            reqDto.setParentThirdCode(customerRespDto.getThirdPartyId());
        }
        List<CustomerRelationRespDto> customerRelationRespList = this.queryList(reqDto);
        if (CollectionUtil.isNotEmpty(customerRelationRespList)) {
            return customerRespDto;
        }
        return null;
    }

    @Override
    public List<CustomerRelationRespDto> queryList(CustomerRelationReqDto reqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerRelationEo);
        List select = this.customerRelationDas.select((BaseEo)customerRelationEo);
        ArrayList<CustomerRelationRespDto> dtoList = new ArrayList<CustomerRelationRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, dtoList, CustomerRelationRespDto.class);
        return dtoList;
    }

    @Override
    public void replenishCustomerRelation(List<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return;
        }
        List customerRelationEos = this.customerRelationDas.queryCurrentCustomerRelation(codes);
        if (CollectionUtil.isNotEmpty((Collection)customerRelationEos)) {
            customerRelationEos.forEach(eo -> this.customerRelationDas.updateSelective((BaseEo)eo));
        }
    }

    @Override
    public CustomerRelationRespDto queryByCustomer(Long customerId) {
        CustomerRelationEo customerRelationEo = this.customerRelationDas.queryByCustomer(customerId);
        CustomerRelationRespDto relationRespDto = new CustomerRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerRelationEo, (BaseVo)relationRespDto);
        if (ObjectUtils.isEmpty((Object)relationRespDto.getId())) {
            return null;
        }
        return relationRespDto;
    }

    @Override
    public PageInfo<CustomerRelationRespDto> queryByPage(CustomerRelationPageReqDto pageReqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)pageReqDto, (BaseEo)customerRelationEo);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerRelationDas.filter().in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getThirdPartyCodes()), (Object)"third_code", (Collection)pageReqDto.getThirdPartyCodes())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getBrands()), (Object)"brand_code", (Collection)pageReqDto.getBrands())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getOrgCodes()), (Object)"org_code", (Collection)pageReqDto.getOrgCodes())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getOrgLevels()), (Object)"org_level", (Collection)pageReqDto.getOrgLevels())).in(CollectionUtils.isNotEmpty((Collection)pageReqDto.getDealerCodes()), (Object)"third_party_code", (Collection)pageReqDto.getDealerCodes())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getOrgName()), (Object)"org_name", (Object)pageReqDto.getOrgName())).like(StringUtils.isNotEmpty((CharSequence)pageReqDto.getDealerName()), (Object)"third_name", (Object)pageReqDto.getDealerName())).page(pageReqDto.getPageNum(), pageReqDto.getPageSize());
        return this.getCustomerRelationRespDtoPageInfo((PageInfo<CustomerRelationEo>)eoPageInfo);
    }

    @NotNull
    private PageInfo<CustomerRelationRespDto> getCustomerRelationRespDtoPageInfo(PageInfo<CustomerRelationEo> eoPageInfo) {
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        if (CollectionUtil.isNotEmpty(dtoList)) {
            dtoList.forEach(r -> r.setParentOrgName(r.getParentThirdName()));
        }
        return dtoPageInfo;
    }
}

