/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IAddressService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerExtThreeService;
import com.yx.tcbj.center.customer.biz.service.ICustomerExtTwoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerExtTwoServiceImpl
implements ICustomerExtTwoService {
    Logger logger = LoggerFactory.getLogger(CustomerExtTwoServiceImpl.class);
    @Resource
    private CustomerDas customerDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IAddressService addressService;
    @Resource
    private ICustomerExtThreeService customerExtThreeService;

    @Override
    public CustomerAddResultDto add(CustomerReqDto reqDto) {
        reqDto.setId(null);
        this.validCustomerName(reqDto);
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        CustomerEo customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        Long id = this.customerDas.insertById(customerEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(id);
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        CustomerAddResultDto resultDto = new CustomerAddResultDto();
        resultDto.setCustomerId(id);
        return resultDto;
    }

    @Override
    public void update(CustomerReqDto reqDto) {
        Assert.notNull((Object)reqDto.getCode(), (String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCode(), (String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CustomerEo eo = new CustomerEo();
        eo.setCode(reqDto.getCode());
        eo.setName(reqDto.getName());
        CustomerEo queryEo = (CustomerEo)this.customerDas.selectOne((BaseEo)eo);
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg(), (Object[])new Object[0]);
        this.validCustomerName(reqDto);
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        CustomerEo customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        this.customerDas.updateSelective((BaseEo)customerEo);
    }

    @Override
    public void updateNewCompanyInfo(CompanyInfoDto companyInfoDto) {
        Assert.notNull((Object)companyInfoDto.getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getCustomerId(), (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(companyInfoDto.getCustomerId());
        Long orgInfoId = customerEo.getOrgInfoId();
        Assert.notNull((Object)customerEo, (String)"\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerExtThreeService.compuateRate(companyInfoDto.getOrgName(), customerEo.getName());
        this.updateOrgInfo(companyInfoDto);
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getProvinceCode())) {
            this.addressService.removeAddressByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
            AddressAddReqDto addressReqDto = new AddressAddReqDto();
            CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)companyInfoDto, (String[])new String[0]);
            addressReqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
            addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
            this.addressService.addAddress(addressReqDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getCreditCode())) {
            customerEo = new CustomerEo();
            customerEo.setOrgInfoId(orgInfoId);
            List customerEoList = this.customerDas.select((BaseEo)customerEo);
            customerEoList.forEach(n -> {
                n.setIfCertification(Integer.valueOf(1));
                this.customerDas.updateSelective((BaseEo)n);
            });
        }
    }

    private void updateOrgInfo(CompanyInfoDto companyInfoDto) {
        OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
        orgAdvModifyReqDto.setName(companyInfoDto.getOrgName());
        orgAdvModifyReqDto.setId(companyInfoDto.getOrgInfoId());
        orgAdvModifyReqDto.setEntityPropCode("company");
        OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
        CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)companyInfoDto, (String[])new String[0]);
        orgAdvModifyReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
        RestResponse modify = this.organizationExtApi.modify(orgAdvModifyReqDto);
        if (!"0".equals(modify.getResultCode())) {
            if (modify.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
            }
            throw new BizException(modify.getResultCode(), modify.getResultMsg());
        }
    }

    private void validCustomerName(CustomerReqDto reqDto) {
        Assert.notNull((Object)reqDto.getName(), (String)CustomerExceptionCode.NAME_NULL.getMsg(), (Object[])new Object[0]);
        CustomerEo eo = CustomerEo.newInstance();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        List customerEos = this.customerDas.select((BaseEo)eo);
        if (reqDto.getId() == null && !CollectionUtils.isEmpty((Collection)customerEos)) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), "\u5ba2\u6237" + CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if (reqDto.getId() != null && !CollectionUtils.isEmpty((Collection)customerEos) && !((CustomerEo)customerEos.get(0)).getId().equals(reqDto.getId())) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), "\u5ba2\u6237" + CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
    }

    private void initCustomerEo(CustomerReqDto reqDto, CustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
    }

    private void validCustomerCode(CustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.notNull((Object)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg(), (Object[])new Object[0]);
            CustomerEo customerEo = CustomerEo.newInstance();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }
}

