/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.AuditInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.AddressDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerTypeMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerSalesmanMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerExtDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeCustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.AddressEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.vo.CustomerRegionNameVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrganizationInfoExtDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerIdsRespDto;
import com.yx.tcbj.center.customer.biz.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.ICustomerSalesmanExtService;
import com.yx.tcbj.center.customer.biz.util.RestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="CustomerQueryService")
public class CustomerQueryServiceImpl
implements ICustomerQueryService {
    @Value(value="${yundt.cube.customer.orgRootId}")
    private Long orgRootId;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private AddressDas addressDas;
    @Resource
    private IContext context;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private ICustomerSalesmanExtService customerSalesmanExtService;
    @Resource
    private CustomerExtDas customerExtDas;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IOrgInfoExtQueryApi orgInfoExtQueryApi;
    @Resource
    private RCustomerSalesmanMapper rCustomerSalesmanMapper;
    @Resource
    private EmployeeCustomerDas employeeCustomerDas;
    @Resource
    private CustomerTypeMapper customerTypeMapper;

    @Override
    public List<CustomerRespDto> queryByThirdPartyIds(List<String> thirdPartyIds) {
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"third_party_id", (Object)StringUtils.join(thirdPartyIds, (String)",")));
        customerEo.setSqlFilters(sqlFilters);
        List customerEoInfo = this.customerDas.select((BaseEo)customerEo);
        ArrayList<CustomerRespDto> customerRespDto = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoInfo, customerRespDto, CustomerRespDto.class);
        return customerRespDto;
    }

    @Override
    public List<CustomerExtRespDto> queryExtByThirdPartyIds(List<String> thirdPartyIds) {
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"third_party_id", (Object)StringUtils.join(thirdPartyIds, (String)",")));
        customerEo.setSqlFilters(sqlFilters);
        List customerEoInfo = this.customerDas.select((BaseEo)customerEo);
        ArrayList<CustomerExtRespDto> customerRespDto = new ArrayList<CustomerExtRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoInfo, customerRespDto, CustomerExtRespDto.class);
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByOrgId(List<Long> orgIds) {
        QueryWrapper filter = new QueryWrapper();
        if (!CollectionUtils.isEmpty(orgIds)) {
            filter.in((Object)"org_info_id", orgIds);
        }
        filter.eq((Object)"dr", (Object)0);
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)filter);
        ArrayList<CustomerRespDto> customerRespDto = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDto, CustomerRespDto.class);
        return customerRespDto;
    }

    @Override
    public CustomerRespDto queryByOrgInfoId(Long orgInfoId) {
        CustomerEo customerEo = (CustomerEo)((ExtQueryChainWrapper)this.customerDas.filter().eq((Object)"org_info_id", (Object)orgInfoId)).one();
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        return customerRespDto;
    }

    @Override
    public List<CustomerNameSimpleRespDto> queryCustomerName() {
        ArrayList dtos = Lists.newArrayList();
        List customerEos = this.customerDas.selectAll();
        CubeBeanUtils.copyCollection((Collection)dtos, (Collection)customerEos, CustomerNameSimpleRespDto.class);
        return dtos;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByCodes(List<String> codes) {
        QueryWrapper filter = new QueryWrapper();
        if (!CollectionUtils.isEmpty(codes)) {
            filter.in((Object)"code", codes);
        }
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)filter);
        ArrayList<CustomerRespDto> customerRespDto = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDto, CustomerRespDto.class);
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByCodesAndOrg(List<String> codes, String merchantId) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", codes));
        if (StringUtils.isNotBlank((CharSequence)merchantId)) {
            sqlFilters.add(SqlFilter.eq((String)"merchant_id", (Object)merchantId));
        }
        customerEo.setSqlFilters(sqlFilters);
        List customerEoList = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerRespDtoList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoList, customerRespDtoList, CustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public CustomerRespDto queryCustomerByCode(String code) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setCode(code);
        customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        if (customerRespDto.getSalesmanId() != null) {
            this.setCustomerSalesman(customerRespDto);
        }
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerList(Integer type) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setType(type);
        List customerEos = this.customerDas.select((BaseEo)customerEo);
        ArrayList<CustomerRespDto> customerRespDtos = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDtos, CustomerRespDto.class);
        return customerRespDtos;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByUserId(Long userId) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setUserId(userId);
        List customerEos = this.customerDas.selectList((BaseEo)customerEo);
        ArrayList<CustomerRespDto> customerRespDtos = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDtos, CustomerRespDto.class);
        return customerRespDtos;
    }

    @Override
    public PageInfo<CustomerRespDto> queryCustomerInfoList(CustomerExtReqDto reqDto) {
        PageInfo pageInfo = (PageInfo)RestUtil.checkResponse(this.organizationQueryApi.queryUserOrgRelation(reqDto.getUserId(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return new PageInfo();
        }
        List organizationDtos = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)organizationDtos)) {
            return new PageInfo();
        }
        List orgIds = organizationDtos.stream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        this.logger.info("\u7ec4\u7ec7ID\u96c6\u5408\uff1a{} ", (Object)JSONObject.toJSONString(orgIds));
        CustomerEo queryEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isEmpty((Collection)reqDto.getAuditStatuss())) {
            sqlFilters.add(SqlFilter.in((String)"audit_status", (Object)reqDto.getAuditStatuss()));
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            sqlFilters.add(SqlFilter.in((String)"org_info_id", orgIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCodes())) {
            sqlFilters.add(SqlFilter.in((String)"code", (Object)reqDto.getCodes()));
        }
        queryEo.setSqlFilters(sqlFilters);
        PageInfo customerEoPageInfo = this.customerDas.selectPage((BaseEo)queryEo);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)customerEoPageInfo, (String[])new String[0]);
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)customerEoPageInfo.getList(), dtoList, CustomerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerExtDetailRespDto queryCustomerDetails(Long id) {
        CustomerExtDetailRespDto customerDetailRespDto = new CustomerExtDetailRespDto();
        CustomerRespDto customerRespDto = (CustomerRespDto)RestUtil.checkResponse(this.customerQueryApi.queryById(id));
        BeanUtils.copyProperties((Object)customerRespDto, (Object)customerDetailRespDto);
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestUtil.checkResponse(this.organizationQueryExtApi.queryById(customerRespDto.getOrgInfoId()));
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        OrgAdvInfoRespDto orgAdvInfoRespDto = orgAdvDetailRespDto.getOrgAdvInfoRespDto();
        if (Objects.nonNull(orgAdvInfoRespDto)) {
            BeanUtils.copyProperties((Object)orgAdvInfoRespDto, (Object)companyInfoDto);
        }
        companyInfoDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        List<AddressRespDto> addressList = this.queryAddressList(companyInfoDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
        if (!CollectionUtils.isEmpty(addressList)) {
            BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
        }
        customerDetailRespDto.setCompanyInfoDto(companyInfoDto);
        AuditInfoDto auditInfoDto = new AuditInfoDto();
        auditInfoDto.setAuditDesc(customerDetailRespDto.getAuditDesc());
        auditInfoDto.setApplyTime(customerDetailRespDto.getCreateTime());
        auditInfoDto.setApplyPerson(customerDetailRespDto.getCreatePerson());
        auditInfoDto.setAuditPerson(customerDetailRespDto.getCreatePerson());
        auditInfoDto.setAuditTime(customerDetailRespDto.getAuditTime());
        auditInfoDto.setAuditStatus(customerDetailRespDto.getAuditStatus());
        auditInfoDto.setApplyType("ADD");
        customerDetailRespDto.setAuditInfo(auditInfoDto);
        return customerDetailRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByCodes(List<String> codeList) {
        return this.queryCustomerListByCodesAndOrg(codeList, null);
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByCodesAndOrg(List<String> codeList, String merchantId) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Lists.newArrayList();
        }
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", codeList));
        if (StringUtils.isNotBlank((CharSequence)merchantId)) {
            sqlFilters.add(SqlFilter.eq((String)"merchant_id", (Object)merchantId));
        }
        customerEo.setSqlFilters(sqlFilters);
        List customerEoList = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerRespDtoList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoList, customerRespDtoList, CustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByIds(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", idList));
        customerEo.setSqlFilters(sqlFilters);
        List customerEoList = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerRespDtoList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoList, customerRespDtoList, CustomerRespDto.class);
        return customerRespDtoList;
    }

    public List<AddressRespDto> queryAddressList(Long orgInfoId, List<String> addressTypes) {
        AddressEo addressEo = new AddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        if (CollectionUtils.isNotEmpty(addressTypes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"address_type", addressTypes));
            addressEo.setSqlFilters(sqlFilters);
        }
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressRespDto> addressDtoList = new ArrayList<AddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressRespDto.class);
        return addressDtoList;
    }

    private void setCustomerSalesman(CustomerRespDto customerRespDto) {
        CustomerSalesmanRespDto customerSalesmanRespDto = this.customerSalesmanExtService.queryById(customerRespDto.getSalesmanId());
        if (ObjectUtils.isNotEmpty((Object)customerSalesmanRespDto)) {
            customerRespDto.setSalesmanName(customerSalesmanRespDto.getSellerName());
        }
    }

    @Override
    public CustomerIdsRespDto queryCustomerIdsBySalesmanName(String salesmanName) {
        CustomerIdsRespDto dto = new CustomerIdsRespDto();
        dto.setCustomerIds(this.customerExtDas.queryCustomerIdsBySalesmanName(salesmanName));
        return dto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByMerchantId(List<Long> merchantIds) {
        QueryWrapper filter = new QueryWrapper();
        if (!CollectionUtils.isEmpty(merchantIds)) {
            filter.in((Object)"merchant_id", merchantIds);
        }
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)filter);
        ArrayList<CustomerRespDto> customerRespDto = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerRespDto, CustomerRespDto.class);
        return customerRespDto;
    }

    @Override
    public List<CustomerRespDto> queryCustomerInfoByOrg(CustomerExtReqDto reqDto) {
        List customerNameSimpleRespDtos;
        List customerRegionName;
        QueryWrapper filter = new QueryWrapper();
        if (Objects.nonNull(reqDto.getMerchantId())) {
            filter.in((Object)"merchant_id", new Object[]{reqDto.getMerchantId()});
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getMerchantIdList())) {
            filter.in((Object)"merchant_id", (Collection)reqDto.getMerchantIdList());
        }
        if (Objects.nonNull(reqDto.getOrgInfoId())) {
            filter.in((Object)"org_info_id", new Object[]{reqDto.getOrgInfoId()});
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getOrgIdList())) {
            filter.in((Object)"org_info_id", (Collection)reqDto.getOrgIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCodes())) {
            filter.in((Object)"code", (Collection)reqDto.getCodes());
        }
        if (Objects.nonNull(reqDto.getType())) {
            filter.eq((Object)"type", (Object)reqDto.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getAuditStatus())) {
            filter.eq((Object)"audit_status", (Object)reqDto.getAuditStatus());
        }
        filter.eq((Object)"dr", (Object)0);
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)filter);
        if (CollectionUtils.isEmpty((Collection)customerEos)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerList, CustomerRespDto.class);
        List merchanIdList = customerList.stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList());
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setOrganizationIds(merchanIdList);
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryListByFeign(sellerQueryReqDto));
        Map<Object, Object> sellerInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)sellerRespDtos)) {
            sellerInfoMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, Function.identity(), (k1, k2) -> k1));
        }
        List orgInfoIdList = customerList.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
        List orgInfoList = (List)RestResponseHelper.extractData((RestResponse)this.orgInfoExtQueryApi.queryOrgInfoByOrgId(orgInfoIdList));
        Map<Object, Object> orgInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)orgInfoList)) {
            orgInfoMap = orgInfoList.stream().collect(Collectors.toMap(OrganizationInfoExtDto::getOrgId, Function.identity(), (k1, k2) -> k1));
        }
        Map<Object, Object> customerSalesmanMap = new HashMap();
        Map<Object, Object> cRegionNameMap = new HashMap();
        List customerIdList = customerList.stream().map(BaseRespDto::getId).distinct().collect(Collectors.toList());
        QueryWrapper salesmanEoQuery = new QueryWrapper();
        salesmanEoQuery.in((Object)"customer_id", customerIdList);
        salesmanEoQuery.eq((Object)"dr", (Object)0);
        List salesmanEos = this.rCustomerSalesmanMapper.selectList((Wrapper)salesmanEoQuery);
        if (CollectionUtils.isNotEmpty((Collection)salesmanEos)) {
            customerSalesmanMap = salesmanEos.stream().collect(Collectors.groupingBy(RCustomerSalesmanEo::getCustomerId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(customerRegionName = this.employeeCustomerDas.getCustomerRegionName(customerIdList)))) {
            cRegionNameMap = customerRegionName.stream().collect(Collectors.groupingBy(CustomerRegionNameVo::getCustomerId));
        }
        Map<Object, Object> customerTypeMap = new HashMap();
        List customerTypeIdList = customerList.stream().filter(dto -> Objects.nonNull(dto.getCustomerTypeId())).map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerTypeIdList) && CollectionUtils.isNotEmpty((Collection)(customerNameSimpleRespDtos = this.customerTypeMapper.queryCustomerTyperNameListByIds(customerTypeIdList)))) {
            customerTypeMap = customerNameSimpleRespDtos.stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, Function.identity()));
        }
        for (CustomerRespDto dto2 : customerList) {
            if (!customerTypeMap.isEmpty() && customerTypeMap.containsKey(dto2.getCustomerTypeId())) {
                CustomerNameSimpleRespDto customerNameSimpleRespDto = (CustomerNameSimpleRespDto)customerTypeMap.get(dto2.getCustomerTypeId());
                dto2.setCustomerTypeName(customerNameSimpleRespDto.getName());
            }
            if (!sellerInfoMap.isEmpty() && sellerInfoMap.containsKey(dto2.getMerchantId())) {
                SellerRespDto sellerRespDto = (SellerRespDto)sellerInfoMap.get(dto2.getMerchantId());
                dto2.setMerchantName(sellerRespDto.getName());
            }
            if (!cRegionNameMap.isEmpty() && cRegionNameMap.containsKey(dto2.getId())) {
                List customerRegionNameVos = (List)cRegionNameMap.get(dto2.getId());
                List regionNameList = customerRegionNameVos.stream().map(CustomerRegionNameVo::getRegionName).collect(Collectors.toList());
                List regionCodeList = customerRegionNameVos.stream().map(CustomerRegionNameVo::getRegionCode).collect(Collectors.toList());
                dto2.setRegionNames(StringUtils.join(regionNameList, (String)","));
                dto2.setRegionCodeList(regionCodeList);
                dto2.setRegionCodes(StringUtils.join(regionCodeList, (String)","));
            }
            if (!customerSalesmanMap.isEmpty() && customerSalesmanMap.containsKey(dto2.getId())) {
                List rCustomerSalesmanEos = (List)customerSalesmanMap.get(dto2.getId());
                List salesmanIds = rCustomerSalesmanEos.stream().map(RCustomerSalesmanEo::getSalesmanId).collect(Collectors.toList());
                dto2.setSalesmanIds(StringUtils.join(salesmanIds, (String)","));
            }
            if (orgInfoMap.isEmpty() || !orgInfoMap.containsKey(dto2.getOrgInfoId())) continue;
            List<AddressRespDto> addressList = this.queryAddressList(dto2.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
            CompanyInfoDto companyInfoDto = new CompanyInfoDto();
            if (!CollectionUtils.isEmpty(addressList)) {
                BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
            }
            OrganizationInfoExtDto orgInfoDto = (OrganizationInfoExtDto)orgInfoMap.get(dto2.getOrgInfoId());
            CubeBeanUtils.copyProperties((Object)companyInfoDto, (Object)orgInfoDto, (String[])new String[0]);
            companyInfoDto.setOrgInfoId(dto2.getOrgInfoId());
            dto2.setCompanyInfoDto(companyInfoDto);
        }
        return customerList;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByDto(CustomerExtReqDto reqDto) {
        QueryWrapper filter = new QueryWrapper();
        if (!CollectionUtils.isEmpty((Collection)reqDto.getMerchantIdList())) {
            filter.in((Object)"merchant_id", (Collection)reqDto.getMerchantIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrgIdList())) {
            filter.in((Object)"org_info_id", (Collection)reqDto.getOrgIdList());
        }
        filter.eq((Object)"dr", (Object)0);
        List customerEos = this.customerDas.getMapper().selectList((Wrapper)filter);
        if (CollectionUtils.isEmpty((Collection)customerEos)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEos, customerList, CustomerRespDto.class);
        return customerList;
    }

    @Override
    public List<Long> queryCustomerIds() {
        Long attachment = this.customerExtService.getCurrentUserOrgId();
        if (ObjectUtils.isEmpty((Object)attachment)) {
            throw new BizException("\u83b7\u53d6\u53c2\u6570\u5f02\u5e38");
        }
        CustomerEo params = new CustomerEo();
        params.setMerchantId(Long.valueOf(attachment));
        params.setDr(0);
        List customerEos = this.customerDas.select((BaseEo)params);
        if (CollectionUtil.isEmpty((Collection)customerEos)) {
            return new ArrayList<Long>();
        }
        List<Long> collect = customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<Long> queryCustomerIdsByThirdParentId(String thirdParentId) {
        if (StringUtils.isEmpty((CharSequence)thirdParentId)) {
            return null;
        }
        CustomerEo params = new CustomerEo();
        params.setThirdParentPartyId(thirdParentId);
        params.setDr(0);
        List customerEos = this.customerDas.select((BaseEo)params);
        if (CollectionUtil.isEmpty((Collection)customerEos)) {
            return new ArrayList<Long>();
        }
        return customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    public List<CustomerRespDto> queryUpstreamOrgIdsByUserId(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId == null) {
            return Lists.newArrayList();
        }
        if (userId.equals(this.context.userId()) && StringUtils.isNotEmpty((CharSequence)(object = (String)(serviceContext = ServiceContext.getContext()).get("yes.req.cus.b2b.sellerorgid")))) {
            Long customerId;
            CustomerEo customerEo;
            CustomerStatusEo customerStatusEo;
            String customer = (String)serviceContext.get("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer) && (customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey((customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId = Long.valueOf(customer))).getStatusId())) != null && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) {
                CustomerRespDto customerRespDto = new CustomerRespDto();
                BeanUtils.copyProperties((Object)customerEo, (Object)customerRespDto);
                customerRespDto.setCustomerId(customerEo.getId());
                return Collections.singletonList(customerRespDto);
            }
            return Lists.newArrayList();
        }
        Long currentUserOrgId = this.customerExtService.queryOrgIdByUserId(userId);
        AssertUtil.isTrue((currentUserOrgId != null ? 1 : 0) != 0, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId));
        List customerEoList = ((ExtQueryChainWrapper)this.customerDas.filter().eq((Object)"org_info_id", (Object)currentUserOrgId)).list();
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList customerRespDtoList = Lists.newArrayList();
        Map statusMap = ((ExtQueryChainWrapper)this.customerStatusDas.filter().in((Object)"id", (Collection)customerEoList.stream().map(StdCustomerEo::getStatusId).collect(Collectors.toSet()))).list().stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CustomerEo customerEo : customerEoList) {
            CustomerStatusEo customerStatusEo = (CustomerStatusEo)statusMap.get(customerEo.getStatusId());
            if (customerStatusEo == null || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) continue;
            CustomerRespDto customerRespDto = new CustomerRespDto();
            BeanUtils.copyProperties((Object)customerEo, (Object)customerRespDto);
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDtoList.add(customerRespDto);
        }
        return customerRespDtoList;
    }
}

