/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreIsFirstParentEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IAddressService;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.StoreMapper;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationThreeApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.QueryOrgByCreditReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerExtThreeService;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.ICustomerSyncCreditService;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import com.yx.tcbj.center.customer.biz.util.RestUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerSyncCreditServiceImpl
implements ICustomerSyncCreditService {
    private static final Logger log = LoggerFactory.getLogger(CustomerSyncCreditServiceImpl.class);
    @Resource
    private IOrganizationThreeApi organizationThreeApi;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private ICustomerExtThreeService customerExtThreeService;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IAddressService addressService;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private IStoreService storeService;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private StoreMapper storeMapper;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public List<CustomerRespDto> syncStoreState2Customer(StoreReqDto reqDto) {
        log.info("\u540c\u6b65\u5168\u91cf\u5e93\u836f\u5e97\u72b6\u6001(\u8f6c\u6362\u540e)\u5230\u5c0fb\u96f6\u552e\u5546 start. param={}", (Object)reqDto.toString());
        List<CustomerRespDto> customerRespDtoList = this.findCustomerByCredit(reqDto.getSocialCreditNum(), CustomerTypeEnum.RETAILER);
        if (customerRespDtoList == null || customerRespDtoList.isEmpty()) {
            log.info("\u540c\u6b65\u5168\u91cf\u5e93\u836f\u5e97\u72b6\u6001(\u8f6c\u6362\u540e)\u5230\u5c0fb\u96f6\u552e\u5546 customerRespDtoList == null. end");
            return null;
        }
        for (CustomerRespDto customerRespDto : customerRespDtoList) {
            this.updateCustomerStatus(reqDto, customerRespDto);
        }
        log.info("\u540c\u6b65\u5168\u91cf\u5e93\u836f\u5e97\u72b6\u6001(\u8f6c\u6362\u540e)\u5230\u5c0fb\u96f6\u552e\u5546 end.");
        return null;
    }

    private void updateCustomerStatus(StoreReqDto reqDto, CustomerRespDto customerRespDto) {
        List storeEos = this.storeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StoreEo::getSocialCreditNum, (Object)reqDto.getSocialCreditNum())).eq(BaseEo::getDr, (Object)"0"));
        if (storeEos == null || storeEos.isEmpty() || storeEos.get(0) == null) {
            return;
        }
        CustomerStatusExtEnum customerStatusExtEnum = StoreStatusEnum.findCustomerStatus((String)((StoreEo)storeEos.get(0)).getState());
        log.info("\u5168\u91cf\u5e93\u836f\u5e97\u72b6\u6001->\u5c0fb\u96f6\u552e\u5546\u72b6\u6001 \u8f6c\u6362\u5b8c\u6210\uff1astoreState={}; -> customerState={}", (Object)((StoreEo)storeEos.get(0)).getState(), (Object)customerStatusExtEnum);
        this.customerExtThreeService.updateCustomerStatus(customerRespDto.getId(), customerStatusExtEnum.getCode());
    }

    @Override
    public List<CustomerRespDto> syncStoreNewCredit2Customer(StoreReqDto reqDto) {
        log.info("\u5173\u8054\u65e7\u4fe1\u7528\u4ee3\u7801 \u540c\u6b65\u836f\u5e97\u65b0\u4fe1\u7528\u4ee3\u7801(\u53ca\u5176\u4ed6\u5b57\u6bb5)\u5230\u65e7\u4fe1\u7528\u4ee3\u7801\u5bf9\u5e94\u7684\u5c0fb\u96f6\u552e\u5546 start. param={}", (Object)reqDto.toString());
        List storeEos = this.storeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StoreEo::getOldSocialCreditNum, (Object)reqDto.getOldSocialCreditNum())).ne(StoreEo::getSocialCreditNum, (Object)reqDto.getSocialCreditNum())).eq(BaseEo::getDr, (Object)"0"));
        if (storeEos != null && !storeEos.isEmpty()) {
            throw new BizException("\u8be5\u65e7\u4fe1\u7528\u4ee3\u7801[" + reqDto.getOldSocialCreditNum() + "]\u5df2\u88ab\u5176\u4ed6\u836f\u5e97" + JSONObject.toJSONString(storeEos.stream().map(StoreEo::getStoreName).collect(Collectors.toList())) + "\u5173\u8054");
        }
        List<CustomerRespDto> customerRespDtoList = this.findCustomerByCredit(reqDto.getOldSocialCreditNum(), CustomerTypeEnum.RETAILER);
        if (customerRespDtoList == null || customerRespDtoList.isEmpty()) {
            log.info("\u5173\u8054\u65e7\u4fe1\u7528\u4ee3\u7801 \u540c\u6b65\u836f\u5e97\u65b0\u4fe1\u7528\u4ee3\u7801(\u53ca\u5176\u4ed6\u5b57\u6bb5)\u5230\u65e7\u4fe1\u7528\u4ee3\u7801\u5bf9\u5e94\u7684\u5c0fb\u96f6\u552e\u5546 customerRespDtoList == null. end");
            return null;
        }
        for (CustomerRespDto customerRespDto : customerRespDtoList) {
            this.checkCreditByCustomerCode(reqDto, customerRespDto);
        }
        ((ICustomerSyncCreditService)this.applicationContext.getBean(ICustomerSyncCreditService.class)).syncStoreNewCreditUpdateField(customerRespDtoList, reqDto);
        return null;
    }

    private void checkCreditByCustomerCode(StoreReqDto storeDto, CustomerRespDto customerDto) {
        CustomerRespDto customerRespDto = this.customerQueryService.queryCustomerByCode(customerDto.getCode());
        log.info("\u5f53\u524d\u6821\u9a8c\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDto));
        StoreRespDto storeRespDto = this.storeService.queryStoreRespDtoByCreditNum(storeDto.getSocialCreditNum());
        log.info("\u836f\u5e97\u3010{}\u3011\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)storeDto.getSocialCreditNum(), (Object)JSON.toJSONString((Object)storeRespDto));
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{storeRespDto})) {
            Assert.isTrue((boolean)storeRespDto.getIsCustomer().equals(IsCustomerEnum.NOT_CUSTOMER.getCode()), (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u4e3a\u5927\u5ba2\u6237!!!");
            Assert.isTrue((!StoreStatusEnum.findCustomerStatus((String)storeRespDto.getState()).equals((Object)CustomerStatusExtEnum.CANCEL) ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u5df2\u6ce8\u9500!!!");
            Assert.isTrue((boolean)storeRespDto.getIsFirstPartner().equals(StoreIsFirstParentEnum.NOT_FIRST_PARENT.getCode()), (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u4e3a\u4e00\u7ea7\u7ecf\u9500\u5546!!!");
        }
        CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
        customerExtReqDto.setCreditCode(storeDto.getSocialCreditNum());
        customerExtReqDto.setMerchantId(customerRespDto.getMerchantId());
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerList(customerExtReqDto));
        List customerCodes = customerRespDtoList.stream().filter(c -> c.getType().equals(CustomerTypeEnum.RETAILER.getCode())).map(CustomerRespDto::getCode).filter(code -> !code.equals(customerDto.getCode())).collect(Collectors.toList());
        log.info("\u6821\u9a8c\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u5ba2\u6237\u7ed3\u679c\u96c6\uff1a{}", (Object)JSON.toJSONString(customerCodes));
        Assert.isTrue((boolean)CollectionUtils.isEmpty(customerCodes), (String)"0001", (String)("\u5546\u5bb6\u5df2\u5b58\u5728\u8be5\u96f6\u552e\u5546\u5ba2\u6237[" + StringUtils.join(customerCodes, (String)" | ") + "],\u8bf7\u68c0\u67e5\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801"));
        this.customerExtThreeService.compuateRate(storeDto.getStoreName(), customerDto.getName());
    }

    @Override
    @Async
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void syncStoreNewCreditUpdateField(List<CustomerRespDto> customerRespDtoList, StoreReqDto reqDto) {
        log.info("\u5b57\u6bb5\u540c\u6b65\u5f00\u59cb customerRespDtoList={}", customerRespDtoList);
        for (CustomerRespDto customerRespDto : customerRespDtoList) {
            log.info("\u5b57\u6bb5\u540c\u6b65\u5f00\u59cb record: customerRespDto={}", (Object)customerRespDto);
            this.updateOrgInfo(reqDto, customerRespDto);
            this.updateOrgAddress(reqDto, customerRespDto);
            this.updateCustomerStatus(reqDto, customerRespDto);
            log.info("\u5b57\u6bb5\u540c\u6b65\u7ed3\u675f record: customerRespDto");
        }
        log.info("\u5173\u8054\u65e7\u4fe1\u7528\u4ee3\u7801 \u540c\u6b65\u836f\u5e97\u65b0\u4fe1\u7528\u4ee3\u7801(\u53ca\u5176\u4ed6\u5b57\u6bb5)\u5230\u65e7\u4fe1\u7528\u4ee3\u7801\u5bf9\u5e94\u7684\u5c0fb\u96f6\u552e\u5546 end.");
    }

    @Override
    public Void updateOrgAddress(StoreReqDto reqDto, CustomerRespDto customerRespDto) {
        log.info("\u66f4\u65b0\u516c\u53f8\u4fe1\u606f\u5730\u5740 updateOrgAddress. reqDto={}, customerRespDto={}", (Object)JSONObject.toJSONString((Object)reqDto), (Object)JSONObject.toJSONString((Object)customerRespDto));
        this.addressService.removeAddressByOrgInfoIdAndType(customerRespDto.getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getProvinceCode())) {
            AddressAddReqDto addressReqDto = new AddressAddReqDto();
            addressReqDto.setOrgInfoId(customerRespDto.getOrgInfoId());
            addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
            addressReqDto.setProvince(reqDto.getProvince());
            addressReqDto.setProvinceCode(reqDto.getProvinceCode());
            addressReqDto.setCity(reqDto.getCity());
            addressReqDto.setCityCode(reqDto.getCityCode());
            addressReqDto.setDistrict(reqDto.getDistrict());
            addressReqDto.setDistrictCode(reqDto.getDistrictCode());
            addressReqDto.setDetailAddr(reqDto.getStoreRegisterAddr());
            addressReqDto.setLocationX(reqDto.getLog());
            addressReqDto.setLocationY(reqDto.getLat());
            this.addressService.addAddress(addressReqDto);
        }
        log.info("\u66f4\u65b0\u516c\u53f8\u4fe1\u606f\u5730\u5740 updateOrgAddress \u7ed3\u675f");
        return null;
    }

    private void updateOrgInfo(StoreReqDto storeReqDto, CustomerRespDto customerRespDto) {
        OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
        orgAdvModifyReqDto.setId(customerRespDto.getOrgInfoId());
        orgAdvModifyReqDto.setEntityPropCode("company");
        orgAdvModifyReqDto.setTenantId(customerRespDto.getTenantId());
        orgAdvModifyReqDto.setName(storeReqDto.getStoreName());
        OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
        orgAdvInfoReqDto.setCreditCode(storeReqDto.getSocialCreditNum());
        orgAdvInfoReqDto.setLegalName(storeReqDto.getLegalPersonName());
        orgAdvInfoReqDto.setAddress(storeReqDto.getStoreRegisterAddr());
        orgAdvModifyReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
        RestResponse modify = this.organizationExtApi.modify(orgAdvModifyReqDto);
        if (!"0".equals(modify.getResultCode())) {
            if (modify.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                log.error("updateOrgInfo\u5f02\u5e38 \u516c\u53f8\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u8f93. modifyResult={}; orgAdvModifyReqDto={}", (Object)modify, (Object)orgAdvModifyReqDto);
            } else {
                log.error("updateOrgInfo\u5f02\u5e38. modifyResult={}; orgAdvModifyReqDto={}", (Object)modify, (Object)orgAdvModifyReqDto);
            }
        }
    }

    @Override
    public List<CustomerRespDto> findCustomerByCredit(String socialCreditNum, CustomerTypeEnum customerTypeEnum) {
        log.info("\u6839\u636e\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2customer\u5f00\u59cb socialCreditNum={}\uff0c customerTypeEnum={}", (Object)socialCreditNum, (Object)customerTypeEnum);
        if (StringUtils.isEmpty((CharSequence)socialCreditNum)) {
            log.error("\u5168\u91cf\u5e93\u836f\u5e97\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a");
            return new ArrayList<CustomerRespDto>();
        }
        List orgAdvInfoRespDto = (List)RestUtil.checkResponse(this.organizationThreeApi.queryOrgByCredit(QueryOrgByCreditReqDto.builder().credit(socialCreditNum).build()));
        List<Long> orgInfoIds = orgAdvInfoRespDto.stream().map(OrgAdvInfoRespDto::getOrgId).collect(Collectors.toList());
        if (orgInfoIds.isEmpty()) {
            return new ArrayList<CustomerRespDto>();
        }
        List<Object> customerRespDtos = this.customerQueryService.queryCustomerByOrgId(orgInfoIds);
        if (customerTypeEnum != null) {
            customerRespDtos = customerRespDtos.stream().filter(customerRespDto -> customerTypeEnum.getCode().equals(customerRespDto.getType())).collect(Collectors.toList());
        }
        return customerRespDtos;
    }
}

