/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ITradeInfoApi;
import com.dtyunxi.tcbj.api.dto.request.QueryProgressTradeByCustomerIdReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrganizationInfoExtTemporaryDto;
import com.dtyunxi.tcbj.api.dto.response.QueryProgressTradeByCustomerIdRespDto;
import com.dtyunxi.tcbj.api.query.IUserExtV2QueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CheckPatternTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerTypeExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.SettleStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.UserAccountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.EditCustomerSaveTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.OrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IAddressService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IBillInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IContactsInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IEmployeeCustomerService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.AddressDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerGroupDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerLevelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerSalesmanMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerSalesmanMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerExtDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeCustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreAreaDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.AddressEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.CustomerExtMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerGroupEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IAuthItemRuleApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BizOrganizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.ComputeCustomerNameRateReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerBatchUpReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtReqTemporaryDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto;
import com.yx.tcbj.center.customer.api.dto.request.DrCustomersReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtV2DetailRespDto;
import com.yx.tcbj.center.customer.api.dto.response.ImportParseCustomerRespDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.dto.vo.CustomerExcelForPromotionVo;
import com.yx.tcbj.center.customer.biz.service.ICustomerExtThreeService;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import com.yx.tcbj.center.customer.biz.util.ProviceCityUtils;
import com.yx.tcbj.center.customer.biz.util.StringMatchUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="customerV3Service")
public class CustomerExtThreeServiceImpl
implements ICustomerExtThreeService {
    private static final Logger log = LoggerFactory.getLogger(CustomerExtThreeServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(CustomerExtThreeServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private IContext context;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Value(value="${yundt.cube.customer.orgRootId}")
    private Long orgRootId;
    @Resource
    private IAddressService addressService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Autowired
    private IRCustomerSalesmanService rCustomerSalesmanService;
    @Resource
    private RCustomerSalesmanMapper rCustomerSalesmanMapper;
    @Resource
    private CustomerSalesmanMapper customerSalesmanMapper;
    @Resource
    private CustomerLevelDas customerLevelDas;
    @Resource
    private EmployeeCustomerDas employeeCustomerDas;
    @Resource
    private IUserExtV2QueryApi userExtV2QueryApi;
    @Resource
    private AddressDas addressDas;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private ICustomerAreaService customerAreaService;
    @Resource
    private CustomerSalesmanDas customerSalesmanDas;
    @Resource
    private RCustomerSalesmanDas rCustomerSalesmanDas;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private CustomerGroupDas customerGroupDas;
    @Resource
    private CustomerExtDas customerExtDas;
    @Value(value="${cancel.status.id:1256288052503004818}")
    private Long CANCEL_STATUS_ID;
    @Resource
    private CustomerExtMapper customerExtMapper;
    @Resource
    private IStoreService storeService;
    @Resource
    private StoreAreaDas storeAreaDas;
    @Resource
    private ICustomerCheckRelationService customerCheckRelationService;
    @Resource
    private ICustomerExtService iCustomerExtService;
    @Resource
    private IContext iContext;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IContactsInfoService contactsInfoService;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private ICustomerService customerService;
    @Resource
    private ITradeInfoApi tradeInfoApi;
    @Resource
    private ICustomerExtThreeService customerExtThreeService;
    @Resource
    private IEmployeeCustomerService employeeCustomerService;
    @Resource
    private IAuthItemRuleApi authItemRuleApi;
    private static final List<String> verifyWhiteList = Lists.newArrayList((Object[])new String[]{"TCBJ20220701000001", "TCBJ20220701000002"});

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public void update(CustomerReqExtDto reqDto) {
        this.logger.info("update customer params : {} .", (Object)JSON.toJSONString((Object)reqDto));
        Assert.notNull((Object)reqDto.getId(), (String)CustomerExceptionCode.PK_ID_NULL.getMsg(), (Object[])new Object[0]);
        com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo queryEo = (com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)this.customerExtDas.selectByPrimaryKey(reqDto.getId());
        this.logger.info("queryEo={}", (Object)JSON.toJSONString((Object)queryEo));
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg(), (Object[])new Object[0]);
        this.validCustomerCode((CustomerReqDto)reqDto, reqDto.getTenantId());
        if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        this.logger.info("\u6e90\u5ba2\u6237\u6570\u636e\uff1a{} ", (Object)JSON.toJSONString((Object)queryEo));
        if (EditCustomerSaveTypeEnum.COMPANY.getCode().equals(reqDto.getSaveType())) {
            this.updateCompany(reqDto);
            com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo updateCusEo = new com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo();
            updateCusEo.setId(reqDto.getId());
            updateCusEo.setIfCertification(Integer.valueOf(1));
            this.customerExtDas.updateSelective((BaseEo)updateCusEo);
        } else if (EditCustomerSaveTypeEnum.CUSTOMER.getCode().equals(reqDto.getSaveType())) {
            this.updateCustomer(reqDto, queryEo);
        } else {
            this.updateCompany(reqDto);
            this.updateCustomer(reqDto, queryEo);
        }
    }

    private void updateCompany(CustomerReqExtDto reqDto) {
        CompanyInfoDto companyInfoDto = reqDto.getCompanyInfoDto();
        Assert.notNull((Object)companyInfoDto.getSubjectType(), (String)"\u4e3b\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getBusinessLicenseType(), (String)"\u6267\u7167\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getProvinceCode(), (String)"\u6240\u5c5e\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(companyInfoDto.getOrgInfoId());
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u4e3a:{}", (Object)JSONObject.toJSONString((Object)orgAdvDetailRespDto));
        companyInfoDto.setOrgCode(orgAdvDetailRespDto.getCode());
        companyInfoDto.setTenantId(reqDto.getTenantId());
        Assert.notNull((Object)companyInfoDto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.compuateRate(companyInfoDto.getOrgName(), reqDto.getName(), companyInfoDto.getCreditCode());
        StoreRespDto storeRespDto = this.storeService.queryStoreRespDtoByCreditNum(companyInfoDto.getCreditCode());
        if (ObjectUtils.isNotEmpty((Object)storeRespDto) && IsCustomerEnum.IS_CUSTOMER.getCode().equals(storeRespDto.getIsCustomer()) && CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            throw new BizException("20089", "\u5927\u5ba2\u6237\u4e0d\u80fd\u6ce8\u518c\u4e3a\u5c0fB");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_info_id", (Object)companyInfoDto.getOrgInfoId());
        queryWrapper.eq((Object)"merchant_id", (Object)reqDto.getMerchantId());
        queryWrapper.ne((Object)"id", (Object)reqDto.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List customerEoList = this.customerExtDas.getMapper().selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)customerEoList)) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)customerEoList.get(0)).getCode()));
            }
            if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)customerEoList.get(0)).getCode()));
            }
        }
        this.updateOrgInfo(companyInfoDto);
        this.addressService.removeAddressByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getProvinceCode())) {
            AddressAddReqDto addressReqDto = new AddressAddReqDto();
            CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)companyInfoDto, (String[])new String[0]);
            addressReqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
            addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
            this.addressService.addAddress(addressReqDto);
        }
        reqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
    }

    private String getNameHasArea(String name) {
        List replaceList;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name}) && CollectionUtils.isNotEmpty((Collection)(replaceList = this.storeAreaDas.queryByNameForReplace(name)))) {
            for (String replaceStr : replaceList) {
                name = name.replace(replaceStr, "");
            }
        }
        return name;
    }

    @Override
    public void compuateRate(String OrgName, String CusName, String creditCode) {
        if (verifyWhiteList.contains(creditCode)) {
            log.info("\u4fe1\u7528\u4ee3\u7801\u4e3a\u6821\u9a8c\u767d\u540d\u5355\uff0c\u8df3\u8fc7\u6821\u9a8c code={}", (Object)creditCode);
            return;
        }
        String afterOrgName = ProviceCityUtils.remove(this.getNameHasArea(OrgName));
        String afterCusName = ProviceCityUtils.remove(this.getNameHasArea(CusName));
        long pipeiRate = Math.round(100.0 * StringMatchUtils.pickAlgorithm(afterOrgName, afterCusName, null));
        this.logger.info("\u539f\u7ec4\u7ec7\u540d\u79f0{}\uff0c\u539f\u5ba2\u6237\u540d{}\uff0c\u7ecf\u8fc7\u5904\u7406\u540e\u7684\u516c\u53f8\u540d={}\uff0c\u5ba2\u6237\u540d={}\uff0c\u5339\u914d\u7387\u4e3a={}", new Object[]{OrgName, CusName, afterOrgName, afterCusName, pipeiRate});
        if (StringUtils.isNotBlank((CharSequence)afterOrgName) && StringUtils.isNotBlank((CharSequence)afterCusName)) {
            Assert.isFalse((pipeiRate < 50L ? 1 : 0) != 0, (String)("\u4fdd\u5b58\u5931\u8d25\uff0c\u516c\u53f8\u540d\u79f0[" + OrgName + "]\u4e0e\u5ba2\u6237\u540d\u79f0[" + CusName + "]\u5339\u914d\u5ea6\u8f83\u4f4e"), (Object[])new Object[0]);
        }
    }

    private void updateCustomer(CustomerReqExtDto reqDto, com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo queryEo) {
        Assert.notNull((Object)reqDto.getName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList()), (String)"\u5ba2\u6237\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqDto.getCityCode(), (String)"\u6240\u5c5e\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getStatusId(), (String)"\u5ba2\u6237\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        reqDto.setOrgInfoId((Long)null);
        this.initCustomerEo(reqDto, queryEo);
        queryEo.setIfWholeCasePurchase(reqDto.getIfWholeCasePurchase());
        this.setIsWarehouseEnable(queryEo, reqDto);
        if (!Objects.equals(reqDto.getStatusId(), queryEo.getStatusId())) {
            queryEo.setRelationChangeTime(new Date());
        }
        queryEo.setCode(StringUtils.isBlank((CharSequence)queryEo.getCode()) ? reqDto.getCode() : queryEo.getCode());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDistrictCodeExt())) {
            queryEo.setDistrictCodeExt(reqDto.getDistrictCodeExt());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDistrictNameExt())) {
            queryEo.setDistrictNameExt(reqDto.getDistrictNameExt());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRegionCodeExt())) {
            queryEo.setRegionCodeExt(reqDto.getRegionCodeExt());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRegionNameExt())) {
            queryEo.setRegionNameExt(reqDto.getRegionNameExt());
        }
        this.logger.info("\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)queryEo));
        this.customerExtDas.update((BaseEo)queryEo);
        RCustomerRegionEo deleteEo = new RCustomerRegionEo();
        deleteEo.setCustomerId(reqDto.getId());
        this.rCustomerRegionDas.delete((BaseEo)deleteEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(reqDto.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        RCustomerSalesmanReqDto salesmanReqDto = new RCustomerSalesmanReqDto();
        salesmanReqDto.setCustomerId(reqDto.getId());
        salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
        salesmanReqDto.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
        if (!CollectionUtils.isEmpty((Collection)reqDto.getSalesmanIds())) {
            this.rCustomerSalesmanService.update(salesmanReqDto);
        }
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)queryEo, (String[])new String[0]);
        String regionCodes = StringUtils.join((Iterable)reqDto.getRegionCodeList(), (String)",");
        String regionNames = StringUtils.join((Iterable)reqDto.getRegionNameList(), (String)",");
        this.sendMq(queryEo, regionNames, regionCodes);
    }

    private void setIsWarehouseEnable(com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo updateCustomerEo, CustomerReqExtDto reqDto) {
        this.logger.info("setIsWarehouseEnable updateCustomerEo={}, reqDto={}", (Object)JSONObject.toJSONString((Object)updateCustomerEo), (Object)JSONObject.toJSONString((Object)reqDto));
        if (reqDto.getIsWarehouseEnable() == null) {
            this.logger.info("reqDto.getIsWarehouseEnable() == null");
            return;
        }
        CustomerExtRespDto sourceCustomerEo = this.customerExtThreeService.queryById(String.valueOf(reqDto.getId()));
        this.logger.info("sourceCustomerEo={}", (Object)JSON.toJSONString((Object)sourceCustomerEo));
        if (sourceCustomerEo.getIsWarehouseEnable() != null && sourceCustomerEo.getIsWarehouseEnable().equals(reqDto.getIsWarehouseEnable())) {
            this.logger.info("sourceCustomerEo.getIsWarehouseEnable() != null && sourceCustomerEo.getIsWarehouseEnable().equals(reqDto.getIsWarehouseEnable())");
            return;
        }
        List progressTradeList = (List)this.tradeInfoApi.queryProgressTradeByCustomerId(QueryProgressTradeByCustomerIdReqDto.builder().jxs_cus(reqDto.getId()).build()).getData();
        this.logger.info("progressTradeList={}", (Object)JSONObject.toJSONString((Object)progressTradeList));
        if (progressTradeList != null && !progressTradeList.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder("\u8bbe\u7f6e\u53d1\u8d27\u4ed3\u5e93\u5b57\u6bb5\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u5355\u636e\u9884\u5360\u5e93\u5b58\uff1a\r\n");
            for (QueryProgressTradeByCustomerIdRespDto progressTrade : progressTradeList) {
                errorMsg.append("\u5ba2\u6237: ").append(progressTrade.getLssCustomerName()).append("[").append(progressTrade.getLssCusCode()).append("]  ").append("\u8ba2\u5355\u53f7: ").append(progressTrade.getTradeNo()).append("  \u8ba2\u5355\u72b6\u6001: ").append(progressTrade.getOrderTradeStatusMapped()).append("\r\n");
            }
            throw new BizException(errorMsg.toString());
        }
        updateCustomerEo.setIsWarehouseEnable(reqDto.getIsWarehouseEnable());
    }

    public void sendMq(com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo customerEo, String regionNames, String regionCodes) {
        CustomerRespDto customerRespDto = new CustomerRespDto();
        this.logger.info("\u53d1\u9001mq\u5f53\u524d\u7c7b=CustomerServiceImpl.sendMq()customerEo = [" + customerEo + "], regionNames = [" + regionNames + "], regionNames = [" + regionCodes + "]");
        try {
            if (customerEo.getCustomerTypeId() != null) {
                CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerEo.getCustomerTypeId());
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            if (customerEo.getStatusId() != null) {
                CustomerStatusEo customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(customerEo.getStatusId());
                customerRespDto.setStatusName(customerStatusEo.getName());
            }
            customerRespDto.setStatusId(customerEo.getStatusId());
            customerRespDto.setId(customerEo.getId());
            customerRespDto.setCode(customerEo.getCode());
            customerRespDto.setName(customerEo.getName());
            customerRespDto.setRegionId(customerEo.getRegionId());
            customerRespDto.setRegionCode(regionCodes);
            customerRespDto.setRegion(regionNames);
            customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDto.setId(customerEo.getId());
            this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
            this.logger.info("\u53d1\u9001\u5ba2\u6237\u66f4\u65b0\u5e7f\u64ad\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)customerRespDto));
            this.commonsMqService.publishMessageAsync("CUSTOMER_UPDATE_PUBLISH", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        catch (Exception var6) {
            this.logger.debug(var6.getMessage());
        }
    }

    public Long queryOrgIdByUserId(Long userId) {
        String cahceKey;
        Long cacheValue;
        AssertUtil.isTrue((userId != null ? 1 : 0) != 0, (String)"queryOrgIdByUserId\uff0c\u627e\u4e0d\u5230userId:");
        if (userId.equals(this.context.userId())) {
            ServiceContext serviceContext = ServiceContext.getContext();
            String customer = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer)) {
                Long customerId = Long.valueOf(customer);
                return Optional.ofNullable(this.customerExtDas.selectByPrimaryKey(customerId)).map(StdCustomerEo::getOrgInfoId).orElse(null);
            }
            String object = serviceContext.getAttachment("yes.req.cus.b2b.organizationid");
            if (StringUtils.isNotEmpty((CharSequence)object)) {
                return Long.valueOf(object);
            }
        }
        if (null != (cacheValue = (Long)this.cacheService.getCache(cahceKey = "queryOrgIdByUserId_" + userId, Long.class))) {
            return cacheValue;
        }
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        AssertUtil.isTrue((!CollectionUtils.isEmpty((Collection)pageInfo.getList()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u672a\u7ed1\u5b9a\u7ec4\u7ec7");
        this.logger.info("\u67e5\u8be2\u5230\u5173\u8054\u7684\u7ec4\u7ec7\u5173\u7cfb{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        Long orgId = pageInfo.getList().stream().filter(o -> this.orgRootId.equals(o.getParentId())).findFirst().orElse(new OrganizationDto()).getId();
        if (orgId != null) {
            this.cacheService.setCache(cahceKey, (Object)orgId, 86400);
        }
        return orgId;
    }

    private void initCustomerEo(CustomerReqExtDto reqDto, com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo customerEo) {
        this.logger.info("initCustomerEo reqDto={}, customerEo={}", (Object)JSONObject.toJSONString((Object)reqDto), (Object)JSONObject.toJSONString((Object)customerEo));
        BeanUtil.copyProperties((Object)reqDto, (Object)customerEo, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true));
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
        if (Objects.nonNull(reqDto.getCompanyInfoDto()) && StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        customerEo.setEffectiveStartTime(reqDto.getEffectiveStartTime());
        customerEo.setEffectiveEndTime(reqDto.getEffectiveEndTime());
        this.logger.info("customerEo.setIsShortClose reqDto.getIsShortClose()={}", (Object)reqDto.getIsShortClose());
        customerEo.setIsShortClose(reqDto.getIsShortClose());
        this.logger.info("customerEo={}", (Object)JSONObject.toJSONString((Object)customerEo));
    }

    private void validCustomerCode(CustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.notNull((Object)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg(), (Object[])new Object[0]);
            com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo customerEo = com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo.newInstance();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)this.customerExtDas.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }

    private void updateOrgInfo(CompanyInfoDto companyInfoDto) {
        OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
        orgAdvModifyReqDto.setName(companyInfoDto.getOrgName());
        orgAdvModifyReqDto.setCode(companyInfoDto.getOrgCode());
        orgAdvModifyReqDto.setId(companyInfoDto.getOrgInfoId());
        orgAdvModifyReqDto.setEntityPropCode("company");
        orgAdvModifyReqDto.setTenantId(companyInfoDto.getTenantId());
        OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
        CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)companyInfoDto, (String[])new String[0]);
        orgAdvModifyReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
        RestResponse modify = this.organizationExtApi.modify(orgAdvModifyReqDto);
        if (!"0".equals(modify.getResultCode())) {
            if (modify.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
            }
            throw new BizException(modify.getResultCode(), modify.getResultMsg());
        }
    }

    @Override
    public PageInfo<CustomerExtRespDto> queryByPageExport(CustomerSearchExtReqTemporaryDto searchReqDto) {
        String queryStr = JSON.toJSONString((Object)searchReqDto);
        this.logger.info("\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u7b5b\u9009\u5bf9\u8c61searchReqDto\uff0c{}", (Object)queryStr);
        this.logger.info("\u3010web\u7ebf\u7a0b\u5ba2\u6237\u5206\u9875\u5bfc\u51fa\u4e0a\u4e0b\u6587={}\uff0ckeys={}\uff0cgetattachments={},userID={}\u3011", new Object[]{ServiceContext.getContext().getKeys(), ServiceContext.getContext().getAttachments(), this.context.userId()});
        PageInfo<CustomerExtRespDto> pageInfo = this.queryByPage(queryStr, searchReqDto.getPageNum(), searchReqDto.getPageSize());
        if (CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            return pageInfo;
        }
        List respDtos = pageInfo.getList();
        List orgInfoIdList = respDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
        List orgInfoList = (List)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.userExtV2QueryApi.queryOrgInfoByOrgId(orgInfoIdList));
        Map<Object, Object> orgInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)orgInfoList)) {
            orgInfoMap = orgInfoList.stream().collect(Collectors.toMap(OrganizationInfoExtTemporaryDto::getOrgId, Function.identity(), (k1, k2) -> k1));
        }
        List merchantList = respDtos.stream().map(e -> e.getMerchantId()).distinct().collect(Collectors.toList());
        this.logger.info("\u67e5\u8be2\u8bf7\u6c42\u6240\u5c5e\u5546\u5bb6\u7684id\u94fe\u8868\u4e3a:{}", merchantList);
        RestResponse orgResp = this.organizationQueryApi.queryOrgAndOrgInfoByIds(merchantList);
        List orgInfoRespDtos = (List)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)orgResp);
        this.logger.info("\u67e5\u8be2\u8bf7\u6c42\u6240\u5c5e\u5546\u5bb6\u7684\u4fe1\u606f\u4e3a:{}", (Object)orgInfoRespDtos);
        Map<Object, Object> merchantNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)orgInfoRespDtos)) {
            merchantNameMap = orgInfoRespDtos.stream().collect(Collectors.toMap(e -> e.getOrganizationDto().getId(), e -> e, (e1, e2) -> e1));
        }
        for (CustomerExtRespDto customerExtRespDto : respDtos) {
            OrgAndOrgInfoRespDto mechatDto;
            com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo customerEo;
            if (customerExtRespDto.getParentCustomerId() != null && Objects.nonNull(customerEo = (com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)this.customerExtDas.selectByPrimaryKey(customerExtRespDto.getParentCustomerId()))) {
                customerExtRespDto.setParentCustomerName(customerEo.getName());
                customerExtRespDto.setRemark(customerEo.getCode());
            }
            if (!orgInfoMap.isEmpty() && orgInfoMap.containsKey(customerExtRespDto.getOrgInfoId())) {
                List<AddressRespDto> addressList = this.queryAddressList(customerExtRespDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
                CompanyInfoDto companyInfoDto = new CompanyInfoDto();
                if (!CollectionUtils.isEmpty(addressList)) {
                    BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
                }
                OrganizationInfoExtTemporaryDto orgInfoDto = (OrganizationInfoExtTemporaryDto)orgInfoMap.get(customerExtRespDto.getOrgInfoId());
                CubeBeanUtils.copyProperties((Object)companyInfoDto, (Object)orgInfoDto, (String[])new String[0]);
                companyInfoDto.setOrgInfoId(orgInfoDto.getId());
                customerExtRespDto.setCompanyInfoDto(companyInfoDto);
                customerExtRespDto.setOrgName(orgInfoDto.getOrgName());
                customerExtRespDto.setCreditCode(orgInfoDto.getCreditCode());
            }
            if (!ObjectUtils.isNotEmpty((Object)(mechatDto = (OrgAndOrgInfoRespDto)merchantNameMap.get(customerExtRespDto.getMerchantId()))) || !ObjectUtils.isNotEmpty((Object)mechatDto.getOrganizationDto())) continue;
            customerExtRespDto.setMerchantName(mechatDto.getOrganizationDto().getName());
        }
        return pageInfo;
    }

    public List<AddressRespDto> queryAddressList(Long orgInfoId, List<String> addressTypes) {
        AddressEo addressEo = new AddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        if (CollectionUtils.isNotEmpty(addressTypes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"address_type", addressTypes));
            addressEo.setSqlFilters(sqlFilters);
        }
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressRespDto> addressDtoList = new ArrayList<AddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressRespDto.class);
        return addressDtoList;
    }

    private void peekData(CustomerSearchReqDto searchReqDto, Map<Long, String> idRegionCodeMap, Map<Long, String> salesmanNameMap, Map<Long, String> salesmanIdsMap, Map<Long, String> customerNameMap, Map<Long, String> orgNameMap, Map<Long, String> groupNameMap, Map<Long, String> creditCodeMap, Map<String, String> regionNameMap, Map<Long, String> levelMap, Map<Long, CustomerStatusEo> statusMap, Map<Long, String> typeMap, CustomerRespDto customerRespDto) {
        CustomerStatusEo statusEo = statusMap.getOrDefault(customerRespDto.getStatusId(), new CustomerStatusEo());
        customerRespDto.setAccountStatus(statusEo.getAccountStatus());
        customerRespDto.setRecordStatus(statusEo.getRecordStatus());
        customerRespDto.setStatusName(statusEo.getName());
        customerRespDto.setCustomerTypeName(typeMap.getOrDefault(customerRespDto.getCustomerTypeId(), ""));
        customerRespDto.setLevelName(levelMap.getOrDefault(customerRespDto.getLevelId(), ""));
        customerRespDto.setRegionCodes(idRegionCodeMap.get(customerRespDto.getId()));
        if (StringUtils.isNotEmpty((CharSequence)salesmanIdsMap.get(customerRespDto.getId()))) {
            customerRespDto.setSalesmanIds(salesmanIdsMap.get(customerRespDto.getId()));
            ArrayList<String> regionNameList = new ArrayList<String>();
            for (String code : customerRespDto.getSalesmanIds().split(",")) {
                regionNameList.add(salesmanNameMap.get(Long.valueOf(code)));
            }
            customerRespDto.setSalesmanNames(String.join((CharSequence)",", regionNameList));
        }
        if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) {
            String code;
            String[] var16 = customerRespDto.getRegionCodes().split(",");
            code = var16[0];
            String regionNames = regionNameMap.get(code);
            customerRespDto.setRegionNames(regionNames);
        }
        if (null != customerRespDto.getOrgInfoId() && creditCodeMap != null) {
            customerRespDto.setOrgName(orgNameMap.getOrDefault(customerRespDto.getOrgInfoId(), ""));
            customerRespDto.setCreditCode(creditCodeMap.getOrDefault(customerRespDto.getOrgInfoId(), ""));
        }
        if (customerRespDto.getParentCustomerId() != null) {
            customerRespDto.setParentCustomerName(customerNameMap.getOrDefault(customerRespDto.getParentCustomerId(), ""));
        }
        if (StatusEnum.ENABLED.getCode().equals(customerRespDto.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerRespDto.getAccountStatus())) {
            customerRespDto.setValetFlag(StatusEnum.ENABLED.getCode());
        } else {
            customerRespDto.setValetFlag(StatusEnum.DISABLED.getCode());
        }
        if (null != customerRespDto.getCustomerGroupId()) {
            customerRespDto.setCustomerGroupName(groupNameMap.getOrDefault(customerRespDto.getCustomerGroupId(), ""));
        }
        if (!searchReqDto.getListFlag().booleanValue()) {
            customerRespDto.setApplyTime(customerRespDto.getCreateTime());
            customerRespDto.setApplyPerson(customerRespDto.getCreatePerson());
            customerRespDto.setApplyType("ADD");
        }
    }

    public Long getCurrentUserOrgId() {
        AssertUtil.isTrue((this.context.userId() != null ? 1 : 0) != 0, (String)"getCurrentUserOrgId\u65b9\u6cd5\uff0c\u4e0a\u4e0b\u6587\u4e2d\u627e\u4e0d\u5230userId");
        return this.queryOrgIdByUserId(this.context.userId());
    }

    @Override
    public void updateCustomerStatus(Long id, Long statusId) {
        com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo queryEo = (com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)this.customerExtDas.selectByPrimaryKey(id);
        Assert.notNull((Object)queryEo, (String)"\u627e\u4e0d\u5230\u8be5\u5ba2\u6237\u6570\u636e\uff0c\u8bf7\u91cd\u8bd5\u3002", (Object[])new Object[0]);
        CustomerStatusEo statusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(statusId);
        Assert.notNull((Object)statusEo, (String)"\u72b6\u6001\u503c\u9519\u8bef\uff0c\u975e\u6709\u6548\u72b6\u6001\u503c\u3002", (Object[])new Object[0]);
        com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo upEo = new com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo();
        upEo.setId(id);
        upEo.setStatusId(statusId);
        if (!Objects.equals(statusId, queryEo.getStatusId())) {
            upEo.setRelationChangeTime(new Date());
        }
        this.customerExtDas.updateSelective((BaseEo)upEo);
        RCustomerRegionEo regionEo = new RCustomerRegionEo();
        regionEo.setCustomerId(id);
        List rCustomerRegionEoList = this.rCustomerRegionDas.selectList((BaseEo)regionEo);
        String regionCodes = null;
        String regionNames = null;
        if (CollectionUtils.isNotEmpty((Collection)rCustomerRegionEoList)) {
            List<String> regionCodeList = rCustomerRegionEoList.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            regionCodes = StringUtils.join(regionCodeList, (String)",");
            CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(regionCodeList);
            Map<String, String> regionNameMap = this.customerAreaService.queryForList(customerAreaListReqDto).stream().collect(Collectors.toMap(CustomerAreaRespDto::getCode, CustomerAreaRespDto::getName, (o, o1) -> o));
            ArrayList regionNameList = new ArrayList();
            regionCodeList.forEach(e -> {
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)regionNameMap.get(e)))) {
                    regionNameList.add(regionNameMap.get(e));
                }
            });
            regionNames = StringUtils.join(regionNameList, (String)",");
        }
        if (CustomerTypeEnum.DEALER.getCode().equals(queryEo.getType()) && !CustomerStatusExtEnum.ENABLED.getCode().equals(statusId)) {
            this.customerCheckRelationService.disableRelationByOrgId(String.valueOf(queryEo.getOrgInfoId()));
        }
        this.sendMq(queryEo, regionNames, regionCodes);
    }

    public Boolean headerBigB() {
        String bigB = this.request.getHeader("big-b-request-flag");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\uff0c\u5224\u65ad\u662f\u5426\u4e3a\u54c1\u724c\u65b9\uff1a{}", (Object)bigB);
        if (ObjectUtils.isNotEmpty((Object)bigB)) {
            return Boolean.valueOf(bigB);
        }
        return false;
    }

    @Override
    public CustomerAddResultDto add(CustomerReqExtDto reqDto) {
        OrganizationInfoDto organizationInfoDto;
        RestResponse listRestResponse;
        com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo customerEo;
        RestResponse pageInfoRestResponse;
        Long orgInfoId;
        String code = reqDto.getCode();
        reqDto.setId((Long)null);
        this.validCustomerCode((CustomerReqDto)reqDto, reqDto.getTenantId());
        Assert.notNull((Object)reqDto.getCompanyInfoDto(), (String)"\u516c\u53f8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCompanyInfoDto().getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getCompanyInfoDto().getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            orgInfoId = this.getCurrentUserOrgId();
            reqDto.setMerchantId(orgInfoId);
        } else if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getChannel())) {
                orgInfoId = this.getCurrentUserOrgId();
                reqDto.setMerchantId(orgInfoId);
            }
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else if (CustomerTypeExtEnum.JUNIOR_RETAILER.getCode().equals(reqDto.getType())) {
            orgInfoId = reqDto.getMerchantId();
        }
        if (Objects.isNull(reqDto.getCompanyInfoDto().getOrgInfoId())) {
            OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
            OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
            CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
            orgAdvAddReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
            orgAdvAddReqDto.setCode(code);
            orgAdvAddReqDto.setName(reqDto.getCompanyInfoDto().getOrgName());
            orgAdvAddReqDto.setEntityPropCode("company");
            orgAdvAddReqDto.setType("2");
            orgAdvAddReqDto.setParentId(this.orgRootId);
            pageInfoRestResponse = this.organizationExtApi.add(orgAdvAddReqDto);
            if (!"0".equals(pageInfoRestResponse.getResultCode())) {
                if (pageInfoRestResponse.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
                }
                throw new BizException(pageInfoRestResponse.getResultCode(), pageInfoRestResponse.getResultMsg());
            }
            orgInfoId = ((OrgAdvOpRespDto)pageInfoRestResponse.getData()).getOrgId();
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(orgInfoId);
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.addressService.addAddress(addressReqDto);
            }
        } else {
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)reqDto.getCompanyInfoDto().getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            customerEo = com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo.newInstance();
            customerEo.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
            customerEo.setMerchantId(reqDto.getMerchantId());
            List customerEoList = this.customerExtDas.select((BaseEo)customerEo);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
                if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)customerEoList.get(0)).getCode()));
                }
                if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)customerEoList.get(0)).getCode()));
                }
            }
            this.updateOrgInfo(reqDto.getCompanyInfoDto());
            this.addressService.removeAddressByOrgInfoIdAndType(reqDto.getCompanyInfoDto().getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getProvinceCode())) {
                AddressAddReqDto addressReqDto = new AddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)reqDto.getCompanyInfoDto(), (String[])new String[0]);
                addressReqDto.setOrgInfoId(reqDto.getCompanyInfoDto().getOrgInfoId());
                addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
                this.addressService.addAddress(addressReqDto);
            }
            orgInfoId = reqDto.getCompanyInfoDto().getOrgInfoId();
        }
        reqDto.setOrgInfoId(orgInfoId);
        customerEo = com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        customerEo.setAuditStatus(AuditStatusEnum.DRAFT.getCode());
        customerEo.setSettleStatus(SettleStatusEnum.UNSETTLE.getCode());
        UserOrgRelationQueryReqDto relationQueryReqDto = new UserOrgRelationQueryReqDto();
        relationQueryReqDto.setOrgId(orgInfoId);
        pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(relationQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            customerEo.setUserId(((UserRespDto)pageInfo.getList().get(0)).getId());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)((Collection)(listRestResponse = this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)Lists.newArrayList((Object[])new Long[]{orgInfoId}))).getData())) && (organizationInfoDto = ((OrgAndOrgInfoRespDto)((List)listRestResponse.getData()).get(0)).getOrganizationInfoDto()) != null && StringUtils.isNotEmpty((CharSequence)organizationInfoDto.getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDistrictCodeExt())) {
            customerEo.setDistrictCodeExt(reqDto.getDistrictCodeExt());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDistrictNameExt())) {
            customerEo.setDistrictNameExt(reqDto.getDistrictNameExt());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRegionCodeExt())) {
            customerEo.setRegionCodeExt(reqDto.getRegionCodeExt());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRegionNameExt())) {
            customerEo.setRegionNameExt(reqDto.getRegionNameExt());
        }
        this.customerExtDas.insert((BaseEo)customerEo);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(customerEo.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        CustomerAddResultDto resultDto = new CustomerAddResultDto();
        resultDto.setCustomerId(customerEo.getId());
        resultDto.setOrgInfoId(orgInfoId);
        RCustomerSalesmanReqDto salesmanReqDto = new RCustomerSalesmanReqDto();
        salesmanReqDto.setCustomerId(reqDto.getId());
        salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
        salesmanReqDto.setOrgId(orgInfoId);
        this.rCustomerSalesmanService.add(salesmanReqDto);
        this.updateCustomerThirdId(customerEo.getId());
        return resultDto;
    }

    private void updateCustomerThirdId(Long customerId) {
        String object;
        this.logger.info("\u65b0\u589e\u5ba2\u6237updateCustomerThirdId\uff1a{}", (Object)customerId);
        com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo customerEo = (com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)this.customerExtDas.selectByPrimaryKey(customerId);
        if (StringUtils.isBlank((CharSequence)customerEo.getThirdPartyId())) {
            customerEo.setThirdPartyId(customerEo.getCode());
        }
        if (StringUtils.isBlank((CharSequence)customerEo.getThirdParentPartyId()) && ObjectUtils.isNotEmpty((Object)(object = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid")))) {
            String merchantId = object.toString();
            this.logger.info("\u65b0\u589e\u5ba2\u6237updateCustomerThirdId\uff0cmerchantId\uff1a{}", (Object)merchantId);
            PageInfo pageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerExtDas.filter().eq((Object)"merchant_id", (Object)merchantId)).isNotNull((Object)"third_parent_party_id")).page(Integer.valueOf(1), Integer.valueOf(1));
            if (ObjectUtils.isNotEmpty((Object)pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
                String thirdParentPartyId = ((com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)pageInfo.getList().get(0)).getThirdParentPartyId();
                customerEo.setThirdParentPartyId(thirdParentPartyId);
            }
        }
        this.customerExtDas.updateSelective((BaseEo)customerEo);
    }

    @Override
    public ImportParseCustomerRespDto parseExcelCustomer(MultipartFile file, String customerCodes, String organizationId) {
        List excelVoList;
        HashSet<String> hasImportCustomerSet = StringUtils.isBlank((CharSequence)customerCodes) ? new HashSet<String>() : Arrays.stream(customerCodes.split(",")).collect(Collectors.toSet());
        ImportParseCustomerRespDto respDto = new ImportParseCustomerRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        try {
            ImportParams params = new ImportParams();
            params.setTitleRows(0);
            params.setHeadRows(1);
            excelVoList = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), CustomerExcelForPromotionVo.class, (ImportParams)params);
            if (CollectionUtils.isEmpty((Collection)excelVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        List customerCodeList = excelVoList.stream().map(e -> StringUtils.trim((String)e.getCustomerCode())).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerCodeList)) {
            throw new BizException("\u89e3\u6790\u5931\u8d25\uff1a\u5ba2\u6237\u7f16\u7801\u5168\u4e3a\u7a7a");
        }
        this.setSerialNumber(excelVoList);
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setSortCodeList(customerCodeList);
        Long orgId = null;
        if (StringUtils.isEmpty((CharSequence)organizationId)) {
            this.logger.info("parseExcelCustomer - \u4f7f\u7528\u767b\u5f55\u7528\u6237\u7684organizationId={}", (Object)this.getCurrentUserOrgId());
            orgId = this.getCurrentUserOrgId();
        } else {
            this.logger.info("parseExcelCustomer - \u4f7f\u7528\u63a5\u53e3\u4f20\u5165\u7684organizationId={}", (Object)organizationId);
            orgId = Long.valueOf(organizationId);
        }
        ArrayList<Long> merchatIds = new ArrayList<Long>();
        merchatIds.add(orgId);
        searchReqDto.setMerchantIds(merchatIds);
        List customerRespDtoList = this.customerDas.queryListBySearchCon(searchReqDto);
        Map<String, CustomerRespDto> existCustomerMap = customerRespDtoList.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e));
        ArrayList<CustomerExcelForPromotionVo> errorList = new ArrayList<CustomerExcelForPromotionVo>();
        ArrayList<CustomerRespDto> successList = new ArrayList<CustomerRespDto>();
        for (CustomerExcelForPromotionVo excelVo : excelVoList) {
            CustomerRespDto cusDto;
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)excelVo.getCustomerCode())) {
                builder.append("\u5ba2\u6237\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff1b");
            }
            if ((cusDto = (CustomerRespDto)customerRespDtoList.stream().filter(r -> r.getCode().contains(excelVo.getCustomerCode() + "_")).findFirst().orElse(null)) == null) {
                builder.append("\u8be5\u5ba2\u6237\u7f16\u53f7\u7684\u5ba2\u6237\u4e0d\u5b58\u5728\uff1b");
            }
            if (hasImportCustomerSet.contains(excelVo.getCustomerCode())) {
                builder.append("\u8be5\u5ba2\u6237\u7f16\u53f7\u5df2\u5bfc\u5165\uff0c\u8bf7\u52ff\u91cd\u590d\u5bfc\u5165\uff1b");
            } else {
                hasImportCustomerSet.add(excelVo.getCustomerCode());
            }
            if (StringUtils.isNotBlank((CharSequence)builder.toString())) {
                excelVo.setErrorMsg(builder.toString());
                errorList.add(excelVo);
                continue;
            }
            successList.add(cusDto);
        }
        if (CollectionUtils.isNotEmpty(errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            respDto.setCustomerErrorList(errorList);
            String excelName = "cube/\u5ba2\u6237\u5bfc\u5165\u89e3\u6790\u5931\u8d25\u4fe1\u606f_\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, CustomerExcelForPromotionVo.class, null, (String)excelName, (String)"xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e3) {
                this.logger.error("\u5ba2\u6237\u5bfc\u5165\u89e3\u6790\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:{}", (Object)e3.toString());
                throw new BizException("-1", "\u5ba2\u6237\u5bfc\u5165\u89e3\u6790\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:" + e3);
            }
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            List regionCodes;
            List customerEos = this.rCustomerRegionDas.selectCodeByCusList(successList.stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            Map<Object, Object> idRegionCodeMap = new HashMap(0);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
                idRegionCodeMap = customerEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId, Collectors.mapping(StdRCustomerRegionEo::getRegionCode, Collectors.joining(","))));
            }
            List finalRegionCodes = regionCodes = customerEos.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            CompletableFuture<Map> regionNameMapFuture = CompletableFuture.supplyAsync(() -> {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)finalRegionCodes)) {
                    return new HashMap();
                }
                CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
                customerAreaListReqDto.setCodes(finalRegionCodes);
                return this.customerAreaService.queryForList(customerAreaListReqDto).stream().collect(Collectors.toMap(CustomerAreaRespDto::getCode, CustomerAreaRespDto::getName, (o, o1) -> o));
            });
            CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> this.customerTypeDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerTypeEo::getName}).in(BaseEo::getId, (Collection)successList.stream().map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerTypeEo::getName)));
            Map regionNameMap = new HashMap(0);
            Map typeMap = new HashMap(0);
            CompletableFuture.allOf(typeMapFuture, regionNameMapFuture);
            try {
                regionNameMap = regionNameMapFuture.get();
                typeMap = typeMapFuture.get();
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            for (CustomerRespDto customerRespDto : successList) {
                customerRespDto.setCustomerTypeName(typeMap.getOrDefault(customerRespDto.getCustomerTypeId(), ""));
                customerRespDto.setRegionCodes((String)idRegionCodeMap.get(customerRespDto.getId()));
                if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) {
                    ArrayList regionNameList = new ArrayList();
                    for (String code : customerRespDto.getRegionCodes().split(",")) {
                        regionNameList.add(regionNameMap.get(code));
                    }
                    customerRespDto.setRegionNames(String.join((CharSequence)",", regionNameList));
                }
                customerRespDto.setCustomerId(customerRespDto.getId());
                customerRespDto.setCustomerName(customerRespDto.getName());
            }
        }
        respDto.setCustomerSuccessList(successList);
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        respDto.setNum(Integer.valueOf(excelVoList.size()));
        return respDto;
    }

    private void setSerialNumber(List<CustomerExcelForPromotionVo> excelVoList) {
        if (CollectionUtil.isNotEmpty(excelVoList)) {
            AtomicInteger row = new AtomicInteger(1);
            for (CustomerExcelForPromotionVo vo : excelVoList) {
                vo.setSerialNumber(Integer.valueOf(row.incrementAndGet()));
            }
        }
    }

    @Override
    public PageInfo<CustomerExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        UserDto userDto;
        Integer adminFlag;
        CustomerSearchExtThreeReqDto searchReqDto = new CustomerSearchExtThreeReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchExtThreeReqDto)JSONObject.parseObject((String)filter, CustomerSearchExtThreeReqDto.class);
        }
        if (Objects.isNull(adminFlag = (Integer)this.cacheService.hget("COMMON", "USER_ADMIN_KEY", ServiceContext.getContext().getRequestUserId() + "", Integer.class)) && Objects.equals((userDto = (UserDto)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.userQueryApi.queryById(ServiceContext.getContext().getRequestUserId(), "{}"))).getUserType(), 11)) {
            adminFlag = 1;
            this.cacheService.hset("COMMON", "USER_ADMIN_KEY", ServiceContext.getContext().getRequestUserId() + "", (Object)1, 0);
        }
        if (Objects.equals(adminFlag, 1)) {
            searchReqDto.setSalesmanId(null);
        }
        searchReqDto.setListFlag((Boolean)ObjectUtils.defaultIfNull((Object)searchReqDto.getListFlag(), (Object)false));
        if (searchReqDto.getListFlag().booleanValue() && !Objects.equals(adminFlag, 1) && !this.headerBigB().booleanValue()) {
            searchReqDto.setIsAdmin(Integer.valueOf(0));
            EmployeeExtQueryReqDto reqDto = new EmployeeExtQueryReqDto();
            reqDto.setOrganizationId(searchReqDto.getMerchantId());
            reqDto.setUserIds((List)Lists.newArrayList((Object[])new Long[]{ServiceContext.getContext().getRequestUserId()}));
            List employeeExtRespDtos = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeByUserOrgList(reqDto))).map(d -> d.stream().filter(r -> Objects.equals(1, r.getStatus())).collect(Collectors.toList())).orElse(new ArrayList());
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)employeeExtRespDtos)) {
                return new PageInfo();
            }
            ArrayList empIds = new ArrayList();
            empIds.addAll(employeeExtRespDtos.stream().map(com.dtyunxi.dto.BaseRespDto::getId).collect(Collectors.toSet()));
            searchReqDto.setEmployeeIds(empIds);
            String toDayTime = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd");
            searchReqDto.setToDayTime(toDayTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getCompanyName())) {
            OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
            orgAdvQueryReqDto.setName(searchReqDto.getCompanyName());
            RestResponse orgAdvResponse = this.organizationQueryExtApi.queryPage(orgAdvQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo orgAdvRespPageInfo = (PageInfo)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)orgAdvResponse);
            if (!Objects.nonNull(orgAdvRespPageInfo) || org.springframework.util.CollectionUtils.isEmpty((Collection)orgAdvRespPageInfo.getList())) {
                return new PageInfo();
            }
            searchReqDto.setOrgInfoIds(orgAdvRespPageInfo.getList().stream().map(OrgAdvRespDto::getId).collect(Collectors.toList()));
        }
        if (StrUtil.isNotBlank((CharSequence)searchReqDto.getCreditCode())) {
            List orgAdvInfoRespDtos = (List)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgAdvInfoListByCreditCode(searchReqDto.getCreditCode()));
            if (CollectionUtils.isEmpty((Collection)orgAdvInfoRespDtos)) {
                return new PageInfo();
            }
            if (CollectionUtil.isNotEmpty((Collection)searchReqDto.getOrgInfoIds())) {
                searchReqDto.getOrgInfoIds().add(((OrgAdvInfoRespDto)orgAdvInfoRespDtos.get(0)).getOrgId());
            } else {
                searchReqDto.setOrgInfoIds((List)Lists.newArrayList((Object[])new Long[]{((OrgAdvInfoRespDto)orgAdvInfoRespDtos.get(0)).getOrgId()}));
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            List eos = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", (Object)eos));
            selectEo.setSqlFilters(sqlFilters);
            List regionCodes = this.rCustomerRegionDas.select((BaseEo)selectEo);
            Set customerIdList = regionCodes.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            if (org.springframework.util.CollectionUtils.isEmpty(customerIdList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(new ArrayList(customerIdList));
        }
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        Assert.isTrue((null != searchReqDto.getType() ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((null != searchReqDto.getChannel() ? 1 : 0) != 0, (String)"\u6e20\u9053\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long currentUserOrgId = this.getCurrentUserOrgId();
        ArrayList merchantIds = Lists.newArrayList();
        if (ObjectUtils.isEmpty((Object)searchReqDto.getCheckPatternType())) {
            if (null != currentUserOrgId) {
                if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                    List customerEos;
                    if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                        merchantIds.add(currentUserOrgId);
                    } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEos = this.customerExtDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                        merchantIds.addAll(customerEos.stream().filter(bean -> null != bean.getOrgInfoId()).map(StdCustomerEo::getOrgInfoId).collect(Collectors.toList()));
                    }
                } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                }
            }
        } else {
            CheckPatternTypeEnum checkPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)searchReqDto.getCheckPatternType());
            AssertUtil.isTrue((null != checkPatternTypeEnum ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u8003\u6838\u65b9\u5f0f");
            BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode((String)currentUserOrgId.toString());
            merchantIds.addAll(bizChannelEnum.getBizTypes());
        }
        if (CollectionUtil.isEmpty((Collection)searchReqDto.getMerchantIds())) {
            searchReqDto.setMerchantIds((List)merchantIds);
        }
        if (Objects.nonNull(pageInfo = this.customerExtDas.queryPageBySearchConExtV3(pageNum, pageSize, searchReqDto)) && !org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List customerEos = this.rCustomerRegionDas.selectCodeByCusList(pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            HashMap<Long, String> idRegionCodeMap = new HashMap(0);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerEos)) {
                idRegionCodeMap = customerEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId, Collectors.mapping(StdRCustomerRegionEo::getRegionCode, Collectors.joining(","))));
            }
            List regionCodes = customerEos.stream().map(StdRCustomerRegionEo::getRegionCode).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList());
            List customerIds = pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList());
            RCustomerSalesmanEo rCustomerSalesmanEo = new RCustomerSalesmanEo();
            LambdaQueryWrapper queryRWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper((BaseEo)rCustomerSalesmanEo).in(RCustomerSalesmanEo::getCustomerId, customerIds)).eq(RCustomerSalesmanEo::getOrgId, (Object)this.queryOrgIdByUserId(this.context.userId()));
            List rCustomerSalesmanEos = this.rCustomerSalesmanDas.getMapper().selectList((Wrapper)queryRWrapper);
            HashMap<Long, String> salesmanNameMap = new HashMap();
            HashMap<Long, String> salesmanIdsMap = new HashMap();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)rCustomerSalesmanEos)) {
                List salesmanIds = rCustomerSalesmanEos.stream().map(RCustomerSalesmanEo::getSalesmanId).distinct().collect(Collectors.toList());
                salesmanIdsMap = rCustomerSalesmanEos.stream().collect(Collectors.groupingBy(RCustomerSalesmanEo::getCustomerId, Collectors.mapping(e -> e.getSalesmanId().toString(), Collectors.joining(","))));
                CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper((BaseEo)customerSalesmanEo).in(StdCustomerSalesmanEo::getUserId, salesmanIds)).eq(StdCustomerSalesmanEo::getOrgInfoId, (Object)this.queryOrgIdByUserId(this.context.userId()));
                List customerSalesmanEos = this.customerSalesmanDas.getMapper().selectList((Wrapper)queryWrapper);
                salesmanNameMap = customerSalesmanEos.stream().collect(Collectors.toMap(StdCustomerSalesmanEo::getUserId, StdCustomerSalesmanEo::getName, (e1, e2) -> e1));
            }
            CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> this.customerTypeDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerTypeEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerTypeEo::getName)));
            CompletableFuture<Map> statusMapFuture = CompletableFuture.supplyAsync(() -> this.customerStatusDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getStatusId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity())));
            CompletableFuture<Map> levelMapFuture = CompletableFuture.supplyAsync(() -> this.customerLevelDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerLevelEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getLevelId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerLevelEo::getName)));
            List finalRegionCodes = regionCodes;
            CompletableFuture<Map> regionNameMapFuture = CompletableFuture.supplyAsync(() -> {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)finalRegionCodes)) {
                    return new HashMap();
                }
                List customerAreaByCodesList = this.employeeCustomerDas.getCustomerAreaByCodes(finalRegionCodes);
                return customerAreaByCodesList.stream().collect(Collectors.toMap(item -> (String)item.get("current_code"), item -> {
                    String currentName = Optional.ofNullable(item.get("current_name")).orElse("");
                    String parentName = Optional.ofNullable(item.get("parent_name")).orElse("");
                    String topName = Optional.ofNullable(item.get("top_name")).orElse("");
                    StringBuilder result = new StringBuilder();
                    if (StringUtils.isNotEmpty((CharSequence)topName)) {
                        result.append(topName);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)parentName)) {
                        if (result.length() > 0) {
                            result.append("/");
                        }
                        result.append(parentName);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)currentName)) {
                        if (result.length() > 0) {
                            result.append("/");
                        }
                        result.append(currentName);
                    }
                    return result.toString();
                }));
            });
            CompletableFuture<Map> customerNameMapFuture = CompletableFuture.supplyAsync(() -> Optional.of(pageInfo.getList().stream().map(CustomerRespDto::getParentCustomerId).filter(Objects::nonNull).distinct().collect(Collectors.toList())).filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).map(parentIds -> this.customerDas.queryListByIds(parentIds).stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, CustomerNameSimpleRespDto::getName))).orElse(new HashMap(0)));
            CompletableFuture<Map> orgNameMapFuture = CompletableFuture.supplyAsync(() -> ((List)this.bizOrganizationQueryApi.getOrganizationsByIds(pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList())).getData()).stream().collect(Collectors.toMap(OrganizationDto::getId, OrganizationDto::getName)));
            CompletableFuture<Map> groupNameMapFuture = CompletableFuture.supplyAsync(() -> {
                List groupIds = pageInfo.getList().stream().map(CustomerRespDto::getCustomerGroupId).distinct().collect(Collectors.toList());
                return org.springframework.util.CollectionUtils.isEmpty(groupIds) ? new HashMap(0) : this.customerGroupDas.selectByIds(groupIds).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerGroupEo::getGroupName));
            });
            CompletableFuture<Map> creditCodeMapFuture = CompletableFuture.supplyAsync(() -> {
                HashMap<Long, String> map = new HashMap<Long, String>();
                RestResponse orgList = this.organizationQueryApi.queryOrgAndOrgInfoByIds(pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList()));
                if (orgList.getData() == null) {
                    return map;
                }
                for (OrgAndOrgInfoRespDto a : (List)orgList.getData()) {
                    if (a.getOrganizationInfoDto() == null || !StringUtils.isNotEmpty((CharSequence)a.getOrganizationInfoDto().getCreditCode())) continue;
                    map.putIfAbsent(a.getOrganizationDto().getId(), a.getOrganizationInfoDto().getCreditCode());
                }
                return map;
            });
            CompletableFuture.allOf(customerNameMapFuture, orgNameMapFuture, groupNameMapFuture, levelMapFuture, statusMapFuture, typeMapFuture, creditCodeMapFuture, regionNameMapFuture);
            HashMap<Long, String> customerNameMap = new HashMap(0);
            HashMap<Long, String> orgNameMap = new HashMap(0);
            HashMap<Long, String> groupNameMap = new HashMap(0);
            HashMap<Long, String> creditCodeMap = new HashMap(0);
            HashMap<String, String> regionNameMap = new HashMap(0);
            HashMap<Long, String> levelMap = new HashMap(0);
            Map<Long, Object> statusMap = new HashMap<Long, CustomerStatusEo>(0);
            Map typeMap = new HashMap(0);
            try {
                regionNameMap = regionNameMapFuture.get();
                customerNameMap = customerNameMapFuture.get();
                orgNameMap = orgNameMapFuture.get();
                groupNameMap = groupNameMapFuture.get();
                creditCodeMap = creditCodeMapFuture.get();
                levelMap = levelMapFuture.get();
                statusMap = statusMapFuture.get();
                typeMap = typeMapFuture.get();
            }
            catch (Exception var34) {
                var34.printStackTrace();
            }
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                this.peekData((CustomerSearchReqDto)searchReqDto, idRegionCodeMap, salesmanNameMap, salesmanIdsMap, customerNameMap, orgNameMap, groupNameMap, creditCodeMap, regionNameMap, levelMap, statusMap, typeMap, customerRespDto);
            }
        }
        return pageInfo;
    }

    @Override
    public List<String> batchUpCusIfWholePurchase(CustomerBatchUpReqDto reqDto) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCustomerIds())) {
            for (Long id : reqDto.getCustomerIds()) {
                this.commonUpdateWay(result, id, reqDto, null);
            }
        } else if (CollectionUtils.isNotEmpty((Collection)reqDto.getCustomerCodes()) && reqDto.getBelongMerchantId() != null) {
            List customerEos = this.customerExtDas.queryIdByCustomerCodes(reqDto.getCustomerCodes().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()), reqDto.getBelongMerchantId(), reqDto.getMerchantIds());
            if (CollectionUtils.isEmpty((Collection)customerEos)) {
                result.add("\u65e0\u6cd5\u67e5\u8be2\u83b7\u53d6\u5230\u4efb\u4f55\u5ba2\u6237\uff0c\u8bf7\u786e\u8ba4");
            } else {
                com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo existEo = null;
                Map<String, com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo> codeMap = null;
                try {
                    codeMap = customerEos.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e));
                }
                catch (Exception e2) {
                    result.add("\u540c\u4e2a\u79df\u6237\u4e0b\u5b58\u5728\u4e24\u6761\u76f8\u540c\u7684\u5ba2\u6237\u7f16\u7801\u7684\u5ba2\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5\u5904\u7406");
                    return result;
                }
                for (String customerCode : reqDto.getCustomerCodes()) {
                    existEo = codeMap.get(customerCode);
                    if (existEo != null) {
                        this.commonUpdateWay(result, existEo.getId(), reqDto, existEo.getCode());
                        continue;
                    }
                    result.add("\u5ba2\u6237\u7f16\u7801=" + customerCode + ",\u66f4\u65b0\u5931\u8d25,\u5ba2\u6237\u4e0d\u5b58\u5728");
                }
            }
        } else if (CollectionUtils.isNotEmpty((Collection)reqDto.getMerchantIds())) {
            List customerEos = this.customerExtDas.queryIdByCustomerCodes(null, null, reqDto.getMerchantIds());
            if (CollectionUtils.isEmpty((Collection)customerEos)) {
                result.add("\u79df\u6237\u4e0b\u6ca1\u6709\u5ba2\u6237\uff0c\u8bf7\u786e\u8ba4");
            } else {
                for (com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo existEo : customerEos) {
                    this.commonUpdateWay(result, existEo.getId(), reqDto, existEo.getCode());
                }
            }
        } else if (CollectionUtils.isNotEmpty((Collection)reqDto.getDrCustomerLists())) {
            for (DrCustomersReqDto drCus : reqDto.getDrCustomerLists()) {
                com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo searchEo = (com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)this.customerExtDas.selectByPrimaryKey(drCus.getId());
                if (ObjectUtils.isEmpty((Object)searchEo)) {
                    result.add("\u5ba2\u6237\u5220\u9664\u5931\u8d25,\u5ba2\u6237\u4e0d\u5b58\u5728");
                    continue;
                }
                CustomerStatusEo statusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(searchEo.getStatusId());
                if (statusEo.getCode().equals(CustomerStatusEnum.ENABLED.getCode())) {
                    result.add("\u5ba2\u6237\u7f16\u7801=" + searchEo.getCode() + " \u5220\u9664\u5931\u8d25,\u542f\u7528\u4e2d\u7684\u5ba2\u6237\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u5148\u7981\u7528");
                    continue;
                }
                if (statusEo.getCode().equals(CustomerStatusEnum.FREEZE.getCode()) && reqDto.getIsAdmin() != 1) {
                    result.add("\u5ba2\u6237id=" + drCus.getId() + " \u5220\u9664\u5931\u8d25,\u51bb\u7ed3\u4e2d\u7684\u5ba2\u6237\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u8fdb\u884c\u5220\u9664");
                    continue;
                }
                com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo upEo = new com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo();
                upEo.setId(drCus.getId());
                upEo.setRelationChangeTime(new Date());
                upEo.setStatusId(this.CANCEL_STATUS_ID);
                if (this.customerExtDas.updateSelective((BaseEo)upEo) >= 1) continue;
                result.add("\u5ba2\u6237id=" + drCus.getId() + " \u66f4\u65b0\u5931\u8d25,\u8bf7\u5355\u72ec\u66f4\u65b0\u8be5\u5ba2\u6237");
            }
        } else {
            result.add("\u8bf7\u6c42\u53c2\u6570\u4e0d\u5bf9\uff0c\u65e0\u4efb\u4f55\u66f4\u65b0");
        }
        if (CollectionUtils.isEmpty((Collection)result)) {
            result.add("\u66f4\u65b0\u6210\u529f\uff0c\u65e0\u4efb\u4f55\u5f02\u5e38");
        }
        return result;
    }

    private void commonUpdateWay(List<String> result, Long id, CustomerBatchUpReqDto reqDto, String customerCode) {
        com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo upEo = new com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo();
        upEo.setId(id);
        upEo.setIfWholeCasePurchase(reqDto.getIfWholeCasePurchase());
        upEo.setStatusId(reqDto.getStatusId());
        upEo.setDeliverMethod(reqDto.getDeliverMethod());
        if (this.customerExtDas.updateSelective((BaseEo)upEo) < 1) {
            if (StringUtils.isNotBlank((CharSequence)customerCode)) {
                result.add("\u5ba2\u6237\u7f16\u7801=" + customerCode + " \u66f4\u65b0\u5931\u8d25,\u8bf7\u5355\u72ec\u66f4\u65b0\u8be5\u5ba2\u6237");
            } else {
                result.add("\u5ba2\u6237id=" + id + " \u66f4\u65b0\u5931\u8d25,\u8bf7\u5355\u72ec\u66f4\u65b0\u8be5\u5ba2\u6237");
            }
        }
    }

    @Override
    public PageInfo<OrgInfoRespDto> queryOrgInfoPageByUserId(Long userId, String orgName, Integer pageNum, Integer pageSize) {
        this.logger.info("H5\u7aef\u6839\u636e\u7528\u6237\u67e5\u8be2\u5ba2\u6237\u4fe1\u606fuserId={},orgName={}", (Object)userId, (Object)orgName);
        if (Objects.isNull(userId)) {
            userId = this.context.userId();
        }
        Assert.notNull((Object)userId, (String)"queryOrgInfoPageByUserId\uff0c\u627e\u4e0d\u5230userId", (Object[])new Object[0]);
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo pageInfo = (PageInfo)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (!Objects.isNull(pageInfo) && !org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List orgIdList;
            JSONObject jsonObject = new JSONObject();
            ArrayList filters = Lists.newArrayList();
            filters.add(SqlFilter.in((String)"id", pageInfo.getList().stream().map(OrganizationDto::getId).collect(Collectors.toList())));
            if (StringUtils.isNotEmpty((CharSequence)orgName)) {
                filters.add(SqlFilter.like((String)"name", (Object)("%" + orgName + "%")));
            }
            jsonObject.put("filters", (Object)filters);
            RestResponse pageInfoRestResp = this.bizOrganizationQueryApi.queryBizOrganizationByPagePost(jsonObject.toJSONString(), pageNum, pageSize);
            PageInfo bizOrgPageInfo = (PageInfo)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
            List orgPageInfoList = bizOrgPageInfo.getList();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)orgPageInfoList)) {
                return new PageInfo();
            }
            PageInfo listRespDtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)bizOrgPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList listRespDtoList = Lists.newArrayList();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)orgPageInfoList) && !org.springframework.util.CollectionUtils.isEmpty(orgIdList = orgPageInfoList.stream().map(BizOrganizationRespDto::getId).collect(Collectors.toList()))) {
                filters = Lists.newArrayList();
                filters.add(SqlFilter.in((String)"org_info_id", orgIdList));
                CustomerEo customerEo = new CustomerEo();
                customerEo.setSqlFilters((List)filters);
                customerEo.setDr(0);
                customerEo.setType(CustomerTypeEnum.RETAILER.getCode());
                List customerEoList = this.customerDas.select((BaseEo)customerEo);
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerEoList)) {
                    return new PageInfo();
                }
                List merchantIdList = customerEoList.stream().map(StdCustomerEo::getMerchantId).collect(Collectors.toList());
                jsonObject = new JSONObject();
                filters = Lists.newArrayList();
                filters.add(SqlFilter.in((String)"id", merchantIdList));
                jsonObject.put("filters", (Object)filters);
                RestResponse pageInfoOrgRestResp = this.bizOrganizationQueryApi.queryBizOrganizationByPagePost(jsonObject.toJSONString(), pageNum, pageSize);
                List organizationRespDtoList = ((PageInfo)pageInfoOrgRestResp.getData()).getList();
                Map<Long, String> orgMap = organizationRespDtoList.stream().collect(Collectors.toMap(BizOrganizationRespDto::getId, BizOrganizationRespDto::getName));
                Map<Long, List<CustomerEo>> customerMap = customerEoList.stream().collect(Collectors.groupingBy(StdCustomerEo::getOrgInfoId));
                List orgIds = orgPageInfoList.stream().map(BizOrganizationRespDto::getId).collect(Collectors.toList());
                List orgAndOrgInfoByIds = (List)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgAndOrgInfoByIds(orgIds));
                for (BizOrganizationRespDto bizOrganizationRespDto : orgPageInfoList) {
                    List<CustomerEo> eoList;
                    OrgInfoRespDto orgInfoDto = new OrgInfoRespDto();
                    orgInfoDto.setOrgInfoId(bizOrganizationRespDto.getId());
                    orgInfoDto.setOrgName(bizOrganizationRespDto.getName());
                    orgInfoDto.setOrgCode(bizOrganizationRespDto.getCode());
                    orgInfoDto.setId(bizOrganizationRespDto.getId());
                    OrgAndOrgInfoRespDto orgAndOrgInfoRespDto = orgAndOrgInfoByIds.stream().filter(e -> bizOrganizationRespDto.getId().equals(e.getOrganizationDto().getId())).findAny().orElse(null);
                    if (orgAndOrgInfoRespDto != null && orgAndOrgInfoRespDto.getOrganizationInfoDto() != null) {
                        orgInfoDto.setOrganizationName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
                    }
                    if (!org.springframework.util.CollectionUtils.isEmpty(eoList = customerMap.get(bizOrganizationRespDto.getId()))) {
                        StringBuffer stringBuffer = new StringBuffer();
                        eoList.forEach(n -> {
                            String sellerName = (String)orgMap.get(n.getMerchantId());
                            stringBuffer.append(sellerName).append(",");
                        });
                        orgInfoDto.setSellerName(stringBuffer.substring(0, stringBuffer.toString().length() - 1));
                    }
                    listRespDtoList.add(orgInfoDto);
                }
            }
            listRespDtoPageInfo.setList((List)listRespDtoList);
            return listRespDtoPageInfo;
        }
        return new PageInfo();
    }

    @Override
    public PageInfo<OrgInfoRespDto> queryOrgInfoPageByUserIdNew(Long userId, String orgName, Integer pageNum, Integer pageSize) {
        this.logger.info("H5\u7aef\u6839\u636e\u7528\u6237\u67e5\u8be2\u5ba2\u6237\u4fe1\u606fuserId={},orgName={}", (Object)userId, (Object)orgName);
        if (Objects.isNull(userId)) {
            userId = this.context.userId();
        }
        Assert.notNull((Object)userId, (String)"queryOrgInfoPageByUserId\uff0c\u627e\u4e0d\u5230userId", (Object[])new Object[0]);
        ArrayList orgIdListAll = Lists.newArrayList();
        PageInfo organizationDtoPageInfo = (PageInfo)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        if (CollectionUtils.isNotEmpty((Collection)organizationDtoPageInfo.getList())) {
            List orgIds = organizationDtoPageInfo.getList().stream().map(OrganizationDto::getId).collect(Collectors.toList());
            this.logger.info("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u7684\u7ec4\u7ec7id:{}", (Object)JSON.toJSONString(orgIds));
            orgIdListAll.addAll(orgIds);
        }
        List orgIdList = (List)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeOrgIdByUserId(userId));
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u4eba\u5458\u6709\u6548\u7684\u7ec4\u7ec7id:{}", (Object)JSON.toJSONString((Object)orgIdList));
        if (CollectionUtils.isNotEmpty((Collection)orgIdList)) {
            orgIdListAll.addAll(orgIdList);
            String toDayTime = DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd");
            CustomerSearchExtReqDto searchReqDto = new CustomerSearchExtReqDto();
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
            searchReqDto.setToDayTime(toDayTime);
            searchReqDto.setSalesmanId(userId);
            searchReqDto.setMerchantIds(orgIdList);
            this.logger.info("\u67e5\u8be2\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u4e0b\u7684\u7ed1\u5b9a\u7684\u6709\u6548\u5ba2\u6237\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)searchReqDto));
            List customerOrgId = this.employeeCustomerDas.queryValidCustomerOrgId(searchReqDto);
            if (CollectionUtils.isNotEmpty((Collection)customerOrgId)) {
                orgIdListAll.addAll(customerOrgId);
            }
        }
        if (CollectionUtils.isEmpty(orgIdList = orgIdListAll.stream().distinct().collect(Collectors.toList()))) {
            return new PageInfo();
        }
        JSONObject jsonObject = new JSONObject();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"id", orgIdList));
        if (StringUtils.isNotEmpty((CharSequence)orgName)) {
            filters.add(SqlFilter.like((String)"name", (Object)("%" + orgName + "%")));
        }
        jsonObject.put("filters", (Object)filters);
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5165\u53c2={}", (Object)jsonObject);
        PageInfo orgPageInfoList = (PageInfo)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.queryBizOrganizationByPagePost(jsonObject.toJSONString(), pageNum, pageSize));
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u51fa\u53c2={}", (Object)JSONObject.toJSONString((Object)orgPageInfoList.getList()));
        if (CollectionUtils.isEmpty((Collection)orgPageInfoList.getList())) {
            return new PageInfo();
        }
        orgIdList = new ArrayList(orgPageInfoList.getList().stream().map(BizOrganizationRespDto::getId).collect(Collectors.toSet()));
        if (CollectionUtils.isEmpty(orgIdList)) {
            return new PageInfo();
        }
        LambdaQueryWrapper customerQuery = new LambdaQueryWrapper();
        customerQuery.eq(BaseEo::getDr, (Object)0);
        customerQuery.eq(StdCustomerEo::getType, (Object)CustomerTypeEnum.RETAILER.getCode());
        customerQuery.in(StdCustomerEo::getOrgInfoId, orgIdList);
        List customerEoList = this.customerExtDas.getMapper().selectList((Wrapper)customerQuery);
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u7684\u96f6\u552e\u5546\u5ba2\u6237\u4fe1\u606f={}", (Object)customerEoList.size());
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return new PageInfo();
        }
        Map<Object, Object> orgMap = new HashMap();
        Map<Long, List<com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo>> customerMap = customerEoList.stream().collect(Collectors.groupingBy(StdCustomerEo::getOrgInfoId));
        List merchantIdList = customerEoList.stream().map(StdCustomerEo::getMerchantId).collect(Collectors.toList());
        jsonObject = new JSONObject();
        filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"id", merchantIdList));
        jsonObject.put("filters", (Object)filters);
        List organizationRespDtoList = ((PageInfo)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.queryBizOrganizationByPagePost(jsonObject.toJSONString(), pageNum, Integer.valueOf(merchantIdList.size())))).getList();
        if (CollectionUtils.isNotEmpty((Collection)organizationRespDtoList)) {
            orgMap = organizationRespDtoList.stream().collect(Collectors.toMap(BizOrganizationRespDto::getId, BizOrganizationRespDto::getName));
        }
        List orgAndOrgInfoByIds = (List)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgAndOrgInfoByIds(orgIdList));
        ArrayList listRespDtoList = Lists.newArrayList();
        for (BizOrganizationRespDto bizOrganizationRespDto : orgPageInfoList.getList()) {
            List<com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo> eoList;
            OrgInfoRespDto orgInfoDto = new OrgInfoRespDto();
            orgInfoDto.setOrgInfoId(bizOrganizationRespDto.getId());
            orgInfoDto.setOrgName(bizOrganizationRespDto.getName());
            orgInfoDto.setOrgCode(bizOrganizationRespDto.getCode());
            orgInfoDto.setId(bizOrganizationRespDto.getId());
            OrgAndOrgInfoRespDto orgAndOrgInfoRespDto = orgAndOrgInfoByIds.stream().filter(e -> bizOrganizationRespDto.getId().equals(e.getOrganizationDto().getId())).findAny().orElse(null);
            if (orgAndOrgInfoRespDto != null && orgAndOrgInfoRespDto.getOrganizationInfoDto() != null) {
                orgInfoDto.setOrganizationName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
            }
            if (!CollectionUtils.isEmpty(eoList = customerMap.get(bizOrganizationRespDto.getId()))) {
                StringBuffer stringBuffer = new StringBuffer();
                Map<Object, Object> finalOrgMap = orgMap;
                eoList.forEach(n -> {
                    String sellerName = (String)finalOrgMap.get(n.getMerchantId());
                    stringBuffer.append(sellerName).append(",");
                });
                orgInfoDto.setSellerName(stringBuffer.substring(0, stringBuffer.toString().length() - 1));
            }
            listRespDtoList.add(orgInfoDto);
        }
        PageInfo listRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)orgPageInfoList, (String[])new String[]{"list", "navigatepageNums"});
        listRespDtoPageInfo.setList((List)listRespDtoList);
        return listRespDtoPageInfo;
    }

    @Override
    public Long addCustomerExtThree(CustomerReqExtDto reqDto) {
        int insert;
        OrganizationInfoDto organizationInfoDto;
        reqDto.setId((Long)null);
        this.logger.info("addCustomerExtThree \u65b0\u589e\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)reqDto));
        this.validCustomerCode((CustomerReqDto)reqDto, reqDto.getTenantId());
        com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo customerEo = com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        RestResponse listRestResponse = this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)Lists.newArrayList((Object[])new Long[]{reqDto.getOrgInfoId()}));
        if (!CollectionUtils.isEmpty((Collection)((Collection)listRestResponse.getData())) && (organizationInfoDto = ((OrgAndOrgInfoRespDto)((List)listRestResponse.getData()).get(0)).getOrganizationInfoDto()) != null && StringUtils.isNotEmpty((CharSequence)organizationInfoDto.getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        Assert.isTrue(((insert = this.customerExtDas.insert((BaseEo)customerEo)) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u5ba2\u6237\u5931\u8d25!! addCustomerExtThree reqDto:+", (Object[])new Object[]{JSONObject.toJSONString((Object)reqDto)});
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(customerEo.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        return customerEo.getId();
    }

    @Override
    public PageInfo<CustomerRespDto> queryByPage(CustomerSearchExtThreeReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        List idNotInList;
        this.logger.info("\u5ba2\u6237\u67e5\u8be2\u5217\u8868 \u5165\u53c2 {}", (Object)JSON.toJSONString((Object)searchReqDto));
        if (searchReqDto.getType() != null && searchReqDto.getType() == 2 && CollectionUtils.isNotEmpty((Collection)searchReqDto.getMerchantIds())) {
            searchReqDto.setIsFilterDownstreamCustomersByCurrentUser(Boolean.valueOf(false));
            List orgInfoByOrgInfos = (List)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgAndOrgInfoByIds(Collections.singletonList(searchReqDto.getMerchantIds().get(0))));
            this.logger.info("\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)orgInfoByOrgInfos));
            if (CollectionUtils.isNotEmpty((Collection)orgInfoByOrgInfos)) {
                searchReqDto.setThirdParentPartyId(((OrgAndOrgInfoRespDto)orgInfoByOrgInfos.get(0)).getOrganizationDto().getCode());
            }
        }
        List<Object> idList = new ArrayList();
        if (searchReqDto.getIsFilterDownstreamCustomersByCurrentUser().booleanValue()) {
            idList = this.getDownstreamCustomerIdsByCurrentUser(searchReqDto.getStatusId());
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getIdList())) {
                idList.retainAll(searchReqDto.getIdList());
            }
        } else if (CollUtil.isNotEmpty((Collection)searchReqDto.getIdList())) {
            idList = searchReqDto.getIdList();
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            List eos = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", (Object)eos));
            selectEo.setSqlFilters(sqlFilters);
            List regionCodes = this.rCustomerRegionDas.select((BaseEo)selectEo);
            List customerIdList = regionCodes.stream().map(StdRCustomerRegionEo::getCustomerId).distinct().collect(Collectors.toList());
            if (org.springframework.util.CollectionUtils.isEmpty(customerIdList)) {
                return new PageInfo();
            }
            if (CollUtil.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
        }
        if (Objects.equals(searchReqDto.getOrgFilter(), 1)) {
            Long currentUserOrgId = this.iCustomerExtService.getCurrentUserOrgId();
            if (Objects.isNull(currentUserOrgId)) {
                return new PageInfo();
            }
            Integer adminFlag = (Integer)this.cacheService.hget("COMMON", "USER_ADMIN_KEY", this.iContext.userId() + "", Integer.class);
            this.setMerchantIds((CustomerSearchReqDto)searchReqDto, currentUserOrgId);
            if (Objects.isNull(adminFlag)) {
                searchReqDto.setSalesmanUserId(this.iContext.userId());
            }
        }
        if (Objects.nonNull(searchReqDto.getSalesmanUserId())) {
            idNotInList = this.getCurrentUserOrOrgCustomer(searchReqDto.getSalesmanUserId(), null, false);
            if (org.springframework.util.CollectionUtils.isEmpty(idNotInList)) {
                return new PageInfo();
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                idList = idNotInList;
            } else {
                idList.retainAll(idNotInList);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            List select = this.rCustomerSalesmanDas.select((BaseEo)eo);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)select)) {
                return new PageInfo();
            }
            List rCustomerRegionEos = select.stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                idList = rCustomerRegionEos;
            } else {
                idList.retainAll(rCustomerRegionEos);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(idList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)searchReqDto.getCustomerGroupIds())) {
            ArrayList<Long> allCustomerGroupIds = new ArrayList<Long>();
            for (Long groupId : searchReqDto.getCustomerGroupIds()) {
                allCustomerGroupIds.add(groupId);
                this.customerGroupDas.getChildCustomerGroupId(groupId, allCustomerGroupIds);
            }
            searchReqDto.setCustomerGroupIds(allCustomerGroupIds);
        }
        idNotInList = searchReqDto.getIdNotInList();
        if (CollUtil.isNotEmpty(idList) && CollUtil.isNotEmpty((Collection)idNotInList)) {
            idList.removeAll(idNotInList);
            if (CollUtil.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdNotInList((List)null);
        }
        if (!idList.isEmpty() && searchReqDto.getStatusId() != null) {
            this.logger.info("\u5546\u5bb6\u9009\u62e9\u767b\u5f55\u5ba2\u6237\u65f6\u5c4f\u853d\u7981\u7528\u7684\u5ba2\u6237");
            idList = this.customerExtMapper.filterDisableCustomer(idList, searchReqDto.getStatusId());
            this.logger.info("\u5546\u5bb6\u9009\u62e9\u767b\u5f55\u5ba2\u6237\u65f6\u5c4f\u853d\u7981\u7528\u7684\u5ba2\u6237 idList={}", idList);
        }
        searchReqDto.setIdList(idList);
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        if (Objects.nonNull(pageInfo = this.customerDas.queryPageBySearchCon(pageNum, pageSize, (CustomerSearchReqDto)searchReqDto)) && !org.springframework.util.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List rCustomerRegionEoList = this.rCustomerRegionDas.selectCodeByCusList(pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            Map<Object, Object> idRegionCodeMap = new HashMap(0);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)rCustomerRegionEoList)) {
                idRegionCodeMap = rCustomerRegionEoList.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId, Collectors.mapping(StdRCustomerRegionEo::getRegionCode, Collectors.joining(","))));
            }
            List regionCodeList = rCustomerRegionEoList.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> {
                CustomerTypeEo customerTypeEo = new CustomerTypeEo();
                customerTypeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", pageInfo.getList().stream().map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))}));
                return this.customerTypeDas.select((BaseEo)customerTypeEo).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerTypeEo::getName));
            });
            CompletableFuture<Map> statusMapFuture = CompletableFuture.supplyAsync(() -> this.customerStatusDas.selectByIds(pageInfo.getList().stream().map(CustomerRespDto::getStatusId).distinct().collect(Collectors.toList())).stream().collect(Collectors.toMap(BaseEo::getId, v -> v)));
            CompletableFuture<Map> levelMapFuture = CompletableFuture.supplyAsync(() -> {
                CustomerLevelEo customerLevelEo = new CustomerLevelEo();
                customerLevelEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", pageInfo.getList().stream().map(CustomerRespDto::getLevelId).distinct().collect(Collectors.toList()))}));
                return this.customerLevelDas.select((BaseEo)customerLevelEo).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerLevelEo::getName));
            });
            CompletableFuture<Map> regionNameMapFuture = CompletableFuture.supplyAsync(() -> {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)regionCodeList)) {
                    return new HashMap(0);
                }
                CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
                customerAreaListReqDto.setCodes(regionCodeList);
                return this.customerAreaService.queryForList(customerAreaListReqDto).stream().collect(Collectors.toMap(CustomerAreaRespDto::getCode, CustomerAreaRespDto::getName, (o, o1) -> o));
            });
            CompletableFuture<Map> customerNameMapFuture = CompletableFuture.supplyAsync(() -> Optional.of(pageInfo.getList().stream().map(CustomerRespDto::getParentCustomerId).filter(Objects::nonNull).distinct().collect(Collectors.toList())).filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).map(parentIds -> this.customerDas.queryListByIds(parentIds).stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, CustomerNameSimpleRespDto::getName))).orElse(new HashMap(0)));
            CompletableFuture<Map> groupNameMapFuture = CompletableFuture.supplyAsync(() -> {
                List groupIds = pageInfo.getList().stream().map(CustomerRespDto::getCustomerGroupId).distinct().collect(Collectors.toList());
                return org.springframework.util.CollectionUtils.isEmpty(groupIds) ? new HashMap(0) : this.customerGroupDas.selectByIds(groupIds).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerGroupEo::getGroupName));
            });
            CompletableFuture.allOf(customerNameMapFuture, levelMapFuture, statusMapFuture, typeMapFuture, groupNameMapFuture, regionNameMapFuture);
            Map customerNameMap = new HashMap(0);
            Map groupNameMap = new HashMap(0);
            Map regionNameMap = new HashMap(0);
            Map levelMap = new HashMap(0);
            Map statusMap = new HashMap(0);
            Map typeMap = new HashMap(0);
            try {
                regionNameMap = regionNameMapFuture.get();
                customerNameMap = customerNameMapFuture.get();
                groupNameMap = groupNameMapFuture.get();
                levelMap = levelMapFuture.get();
                statusMap = statusMapFuture.get();
                typeMap = typeMapFuture.get();
            }
            catch (Exception var31) {
                var31.printStackTrace();
            }
            Iterator var23 = pageInfo.getList().iterator();
            while (true) {
                if (!var23.hasNext()) {
                    return pageInfo;
                }
                CustomerRespDto customerRespDto = (CustomerRespDto)var23.next();
                CustomerStatusEo statusEo = statusMap.getOrDefault(customerRespDto.getStatusId(), new CustomerStatusEo());
                customerRespDto.setAccountStatus(statusEo.getAccountStatus());
                customerRespDto.setRecordStatus(statusEo.getRecordStatus());
                customerRespDto.setStatusName(statusEo.getName());
                customerRespDto.setCustomerTypeName(((Map)typeMap).getOrDefault(customerRespDto.getCustomerTypeId(), ""));
                customerRespDto.setLevelName(levelMap.getOrDefault(customerRespDto.getLevelId(), ""));
                customerRespDto.setRegionCodes((String)idRegionCodeMap.get(customerRespDto.getId()));
                if (customerRespDto.getParentCustomerId() != null) {
                    customerRespDto.setParentCustomerName(customerNameMap.getOrDefault(customerRespDto.getParentCustomerId(), ""));
                }
                if (StatusEnum.ENABLED.getCode().equals(customerRespDto.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerRespDto.getAccountStatus())) {
                    customerRespDto.setValetFlag(StatusEnum.ENABLED.getCode());
                } else {
                    customerRespDto.setValetFlag(StatusEnum.DISABLED.getCode());
                }
                if (null != customerRespDto.getCustomerGroupId()) {
                    customerRespDto.setCustomerGroupName(groupNameMap.getOrDefault(customerRespDto.getCustomerGroupId(), ""));
                }
                if (!StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes()) || !StringUtils.isNotBlank((CharSequence)customerRespDto.getRegionCodes())) continue;
                ArrayList<String> regionNameList = new ArrayList<String>();
                for (String code : customerRespDto.getRegionCodes().split(",")) {
                    regionNameList.add(regionNameMap.containsKey(code) ? regionNameMap.get(code).toString() : "");
                }
                customerRespDto.setRegionNames(String.join((CharSequence)",", regionNameList));
            }
        }
        return pageInfo;
    }

    private List<Long> getDownstreamCustomerIdsByCurrentUser(Long statusId) {
        Long currentUserOrgId = this.iCustomerExtService.getCurrentUserOrgId();
        List<Long> longs = this.queryDownstreamCustomerIdsByOrgIdsWithStatus(Collections.singletonList(currentUserOrgId), statusId);
        return new ArrayList<Long>(longs);
    }

    public List<Long> queryDownstreamCustomerIdsByOrgIdsWithStatus(List<Long> orgIds, Long statusId) {
        List<CustomerRespDto> customerRespDtos = this.queryDownstreamCustomerListByOrgIds(orgIds, statusId);
        List<Long> collect = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        return collect;
    }

    public List<CustomerRespDto> queryDownstreamCustomerListByOrgIds(List<Long> orgIds, Long statusId) {
        ArrayList list = Lists.newArrayList();
        CustomerEo customerDto = new CustomerEo();
        customerDto.setDr(0);
        QueryWrapper query = new QueryWrapper((Object)customerDto);
        query.in((Object)"merchant_id", orgIds);
        if (statusId != null) {
            query.eq((Object)"status_id", (Object)statusId);
        }
        List org = this.customerDas.getMapper().selectList((Wrapper)query);
        DtoHelper.eoList2DtoList((Collection)org, (Collection)list, CustomerRespDto.class);
        return list;
    }

    private void setMerchantIds(CustomerSearchReqDto searchReqDto, Long currentUserOrgId) {
        if (Objects.nonNull(searchReqDto.getChannel())) {
            ArrayList merchantIds = Lists.newArrayList();
            if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                List customerEos;
                if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(customerEos = this.customerDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                    merchantIds.addAll(customerEos.stream().filter(bean -> null != bean.getOrgInfoId()).map(StdCustomerEo::getOrgInfoId).collect(Collectors.toList()));
                }
            } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                merchantIds.add(currentUserOrgId);
            }
            searchReqDto.setMerchantIds((List)merchantIds);
        } else {
            searchReqDto.setMerchantIds((List)com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList((Object[])new Long[]{currentUserOrgId}));
        }
    }

    public List<Long> getCurrentUserOrOrgCustomer(Long userId, Long orgId, boolean filterOrg) {
        if (filterOrg && Objects.isNull(orgId)) {
            orgId = this.iCustomerExtService.getCurrentUserOrgId();
        }
        if (Objects.isNull(orgId) && Objects.isNull(userId)) {
            return com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        }
        CustomerSalesmanEo customerSalesmanEo = new CustomerSalesmanEo();
        customerSalesmanEo.setStatus(Integer.valueOf(1));
        customerSalesmanEo.setUserId(userId);
        customerSalesmanEo.setOrgInfoId(orgId);
        Set realSalesmanIds = this.customerSalesmanDas.select((BaseEo)customerSalesmanEo).stream().map(BaseEo::getId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(realSalesmanIds)) {
            return Lists.newArrayList();
        }
        RCustomerSalesmanEo rCustomerSalesmanEo = new RCustomerSalesmanEo();
        rCustomerSalesmanEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"real_salesman_id", realSalesmanIds)}));
        rCustomerSalesmanEo.setOrgId(orgId);
        return this.rCustomerSalesmanDas.select((BaseEo)rCustomerSalesmanEo).stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
    }

    @Override
    public Void updateCustomerByDto(CustomerReqExtDto reqDto) {
        if (reqDto.getId() == null) {
            throw new BizException("updateCustomerByDto-id\u4e0d\u80fd\u4e3anull");
        }
        com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo updateCusEo = new com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)updateCusEo);
        updateCusEo.setUpdatePerson("batchVerify");
        this.customerExtDas.updateSelective((BaseEo)updateCusEo);
        return null;
    }

    @Override
    public Void computeCustomerNameRate(ComputeCustomerNameRateReqDto reqDto) {
        this.compuateRate(reqDto.getOrgName(), reqDto.getCusName(), reqDto.getCreditCode());
        return null;
    }

    private UserAccountRespDto createUserAccount(Long userId, Long orgInfoId) {
        UserDto userDto = null;
        try {
            RestResponse userRestResp = this.userQueryApi.queryById(userId, "{}");
            userDto = (UserDto)com.dtyunxi.icommerce.utils.RestResponseHelper.extractData((RestResponse)userRestResp);
        }
        catch (Exception var5) {
            Exception e = var5;
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (Objects.nonNull(userDto)) {
            UserAccountRespDto userAccount = new UserAccountRespDto();
            userAccount.setUserId(userId);
            userAccount.setUserName(userDto.getUserName());
            userAccount.setOrgInfoId(orgInfoId);
            return userAccount;
        }
        return null;
    }

    @Override
    public List<CustomerExtRespDto> queryByCodeList(List<String> codeList) {
        ArrayList respDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(codeList)) {
            return respDtoList;
        }
        codeList = codeList.stream().distinct().collect(Collectors.toList());
        List customerEosList = this.customerDas.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).in(StdCustomerEo::getCode, codeList));
        DtoHelper.eoList2DtoList((Collection)customerEosList, (Collection)respDtoList, CustomerExtRespDto.class);
        return respDtoList;
    }

    @Override
    public List<CustomerExtRespDto> queryByOrgIdList(List<Long> orgIdList) {
        ArrayList respDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(orgIdList)) {
            return respDtoList;
        }
        orgIdList = orgIdList.stream().distinct().collect(Collectors.toList());
        List customerEosList = this.customerExtDas.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).in(StdCustomerEo::getOrgInfoId, orgIdList));
        log.info("customerEosList={}", (Object)JSONObject.toJSONString((Object)customerEosList));
        DtoHelper.eoList2DtoList((Collection)customerEosList, (Collection)respDtoList, CustomerExtRespDto.class);
        if (customerEosList != null && customerEosList.size() == 1) {
            log.info("\u8bbe\u7f6erespDtoList\u7b2c\u4e00\u4e2a\u5143\u7d20\u7684IsShortClose\u5c5e\u6027");
            log.info("customerEosList.get(0).getIsShortClose()={}", (Object)JSONObject.toJSONString((Object)((com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)customerEosList.get(0)).getIsShortClose()));
            ((CustomerExtRespDto)respDtoList.get(0)).setIsShortClose(((com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerEo)customerEosList.get(0)).getIsShortClose());
        }
        log.info("respDtoList={}", (Object)JSONObject.toJSONString((Object)respDtoList));
        return respDtoList;
    }

    @Override
    public CustomerExtRespDto queryById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        List customerEosList = this.customerExtDas.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id));
        if (customerEosList == null || customerEosList.isEmpty()) {
            return null;
        }
        CustomerExtRespDto customerExtRespDto = new CustomerExtRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)customerEosList.get(0)), (BaseVo)customerExtRespDto);
        return customerExtRespDto;
    }

    @Override
    public CustomerExtV2DetailRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        List customerEosList = this.customerExtDas.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id));
        if (customerEosList == null || customerEosList.isEmpty()) {
            return null;
        }
        CustomerExtV2DetailRespDto customerExtRespDto = new CustomerExtV2DetailRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)customerEosList.get(0)), (BaseVo)customerExtRespDto);
        return customerExtRespDto;
    }

    @Override
    public PageInfo<CustomerRespDto> queryByPageSimple(CustomerExtReqDto customerExtReqDto) {
        ExtQueryChainWrapper filter = this.customerExtDas.filter();
        if (CollectionUtils.isNotEmpty((Collection)customerExtReqDto.getSortCustomerCodeList())) {
            filter.in((Object)"sort_customer_code", (Collection)customerExtReqDto.getSortCustomerCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)customerExtReqDto.getCodes())) {
            filter.in((Object)"customer_code", (Collection)customerExtReqDto.getCodes());
        }
        PageInfo page = filter.page(customerExtReqDto.getPageNum(), customerExtReqDto.getPageSize());
        PageInfo customerRespDtoPageInfo = (PageInfo)BeanUtil.copyProperties((Object)page, PageInfo.class, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)page.getList())) {
            customerRespDtoPageInfo.setList(page.getList().stream().map(r -> (CustomerRespDto)BeanUtil.copyProperties((Object)r, CustomerRespDto.class, (String[])new String[0])).collect(Collectors.toList()));
        }
        return customerRespDtoPageInfo;
    }

    @Override
    public void initAuthItemRule() {
        PageInfo pageInfo;
        Integer pageNum = 1;
        Integer pageSize = 1000;
        CustomerSearchExtThreeReqDto searchReqDto = new CustomerSearchExtThreeReqDto();
        searchReqDto.setType(Integer.valueOf(3));
        searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        while (!Objects.isNull(pageInfo = this.customerExtDas.queryPageBySearchConExtV3(pageNum, pageSize, searchReqDto)) && !CollUtil.isEmpty((Collection)pageInfo.getList())) {
            ArrayList authItemRuleReqDtoList = Lists.newArrayList();
            for (CustomerExtRespDto customerExtRespDto : pageInfo.getList()) {
                AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
                authItemRuleReqDto.setCustomerId(customerExtRespDto.getId());
                authItemRuleReqDto.setCustomerCode(customerExtRespDto.getCode());
                authItemRuleReqDto.setCustomerName(customerExtRespDto.getName());
                authItemRuleReqDto.setAuthType(Integer.valueOf(0));
                authItemRuleReqDto.setOrganizationId(customerExtRespDto.getMerchantId());
                authItemRuleReqDto.setTenantId(customerExtRespDto.getTenantId());
                authItemRuleReqDto.setInstanceId(customerExtRespDto.getInstanceId());
                authItemRuleReqDtoList.add(authItemRuleReqDto);
            }
            this.authItemRuleApi.initAuthItemRule((List)authItemRuleReqDtoList);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
    }
}

