/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerBlacklistRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IEmployeeCustomerBlacklistService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IEmployeeCustomerService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerTypeMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeCustomerBlacklistDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmployeeCustomerBlacklistEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeCustomerBlacklistServiceImpl
implements IEmployeeCustomerBlacklistService {
    public final Logger logger = LoggerFactory.getLogger(EmployeeCustomerBlacklistServiceImpl.class);
    @Resource
    private EmployeeCustomerBlacklistDas employeeCustomerBlacklistDas;
    @Resource
    private IEmployeeCustomerService employeeCustomerService;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private CustomerTypeMapper customerTypeMapper;
    @Resource
    private HttpServletRequest request;

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public Long addEmployeeCustomerBlacklist(EmployeeCustomerBlacklistReqDto addReqDto) {
        EmployeeCustomerBlacklistEo employeeCustomerBlacklistEo = new EmployeeCustomerBlacklistEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)employeeCustomerBlacklistEo);
        this.employeeCustomerBlacklistDas.insert((BaseEo)employeeCustomerBlacklistEo);
        return employeeCustomerBlacklistEo.getId();
    }

    @Override
    public void modifyEmployeeCustomerBlacklist(EmployeeCustomerBlacklistReqDto modifyReqDto) {
        EmployeeCustomerBlacklistEo employeeCustomerBlacklistEo = new EmployeeCustomerBlacklistEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)employeeCustomerBlacklistEo);
        this.employeeCustomerBlacklistDas.updateSelective((BaseEo)employeeCustomerBlacklistEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEmployeeCustomerBlacklist(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.employeeCustomerBlacklistDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public EmployeeCustomerBlacklistRespDto queryById(Long id) {
        EmployeeCustomerBlacklistEo employeeCustomerBlacklistEo = (EmployeeCustomerBlacklistEo)this.employeeCustomerBlacklistDas.selectByPrimaryKey(id);
        EmployeeCustomerBlacklistRespDto employeeCustomerBlacklistRespDto = new EmployeeCustomerBlacklistRespDto();
        DtoHelper.eo2Dto((BaseEo)employeeCustomerBlacklistEo, (BaseVo)employeeCustomerBlacklistRespDto);
        return employeeCustomerBlacklistRespDto;
    }

    @Override
    public PageInfo<EmployeeCustomerBlacklistRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        EmployeeCustomerBlacklistReqDto employeeCustomerBlacklistReqDto = (EmployeeCustomerBlacklistReqDto)JSON.parseObject((String)filter, EmployeeCustomerBlacklistReqDto.class);
        EmployeeCustomerBlacklistEo employeeCustomerBlacklistEo = new EmployeeCustomerBlacklistEo();
        DtoHelper.dto2Eo((BaseVo)employeeCustomerBlacklistReqDto, (BaseEo)employeeCustomerBlacklistEo);
        PageInfo eoPageInfo = this.employeeCustomerBlacklistDas.selectPage((BaseEo)employeeCustomerBlacklistEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EmployeeCustomerBlacklistRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<EmployeeCustomerBlacklistRespDto> queryEmployeeCustomerBlackList(EmployeeCustomerBlacklistQueryReqDto queryReqDto) {
        List customerNameSimpleRespDtos;
        this.logger.info("\u67e5\u8be2\u4eba\u5458\u6240\u5c5e\u5ba2\u6237\u9ed1\u540d\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        String attachment = ServiceContext.getContext().getAttachment("yes-req-cus-b2b-organizationId");
        if (Objects.isNull(queryReqDto.getMerchantId()) && StringUtils.isNotEmpty((CharSequence)attachment)) {
            queryReqDto.setMerchantId(Long.valueOf(attachment));
        }
        EmployeeCustomerBlacklistEo customerBlacklistEo = EmployeeCustomerBlacklistEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)customerBlacklistEo);
        List eoList = this.employeeCustomerBlacklistDas.select((BaseEo)customerBlacklistEo);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)respDtos, EmployeeCustomerBlacklistRespDto.class);
        List<Long> customerIdList = respDtos.stream().map(EmployeeCustomerBlacklistRespDto::getCustomerId).distinct().collect(Collectors.toList());
        List<CustomerRespDto> customerDtoList = this.employeeCustomerService.queryCustomerByIdList(customerIdList);
        Map<Object, Object> customerDtoMap = new HashMap(customerDtoList.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty(customerDtoList)) {
            customerDtoMap = customerDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        Map<Object, Object> customerTypeMap = new HashMap();
        List customerTypeIdList = customerDtoList.stream().filter(dto -> Objects.nonNull(dto.getCustomerTypeId())).map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerTypeIdList) && CollectionUtils.isNotEmpty((Collection)(customerNameSimpleRespDtos = this.customerTypeMapper.queryCustomerTyperNameListByIds(customerTypeIdList)))) {
            customerTypeMap = customerNameSimpleRespDtos.stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        for (EmployeeCustomerBlacklistRespDto respDto : respDtos) {
            if (customerDtoMap.isEmpty() || !customerDtoMap.containsKey(respDto.getCustomerId())) continue;
            CustomerRespDto customerRespDto = (CustomerRespDto)customerDtoMap.get(respDto.getCustomerId());
            respDto.setCustomerCode(customerRespDto.getCode());
            respDto.setCustomerName(customerRespDto.getName());
            respDto.setCustomerRegionNames(customerRespDto.getRegionNames());
            respDto.setCustomerTypeId(customerRespDto.getCustomerTypeId());
            if (customerTypeMap.isEmpty() || !Objects.nonNull(customerRespDto.getCustomerTypeId()) || !customerTypeMap.containsKey(customerRespDto.getCustomerTypeId())) continue;
            CustomerNameSimpleRespDto customerTypeDto = (CustomerNameSimpleRespDto)customerTypeMap.get(customerRespDto.getCustomerTypeId());
            respDto.setCustomerTypeName(customerTypeDto.getName());
        }
        return respDtos;
    }
}

