/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.biz.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class StoreAndSalesmanHelper {
    public static List<String> BIZ_CHANNEL_CODE = Arrays.stream(BizChannelEnum.values()).map(c -> c.getChannelCode()).collect(Collectors.toList());
    @Resource
    private ICustomerQueryService customerQueryService;

    public BizChannelEnum calculateBizChannel(String thirdPartyId) {
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)thirdPartyId) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ecf\u9500\u5546ID\u4e3a\u7a7a!");
        List<CustomerExtRespDto> customerRespDtoList = this.customerQueryService.queryExtByThirdPartyIds(Lists.newArrayList((Object[])new String[]{thirdPartyId}));
        AssertUtil.isTrue((!CollectionUtils.isEmpty(customerRespDtoList) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728!");
        CustomerExtRespDto customerRespDto = (CustomerExtRespDto)((Object)customerRespDtoList.stream().findFirst().get());
        if (BIZ_CHANNEL_CODE.contains(customerRespDto.getMerchantId().toString())) {
            return BizChannelEnum.enumOfChannelCode((String)customerRespDto.getMerchantId().toString());
        }
        return this.calculateBizChannel(customerRespDto.getThirdParentPartyId());
    }
}

