package com.yx.demo.center.data.biz.service.query.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaEo;
import com.dtyunxi.yundt.cube.center.data.dao.mapper.AreaMapper;
import com.google.common.collect.Lists;
import com.yx.demo.center.data.biz.service.query.IAreaExtQueryService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 区域查询实现类
 * @Author: xiuji
 * @Date: 2022/3/21 9:35 AM
 */
@Service
public class AreaExtQueryServiceImpl implements IAreaExtQueryService {

    @Resource
    private AreaMapper areaMapper;

    @Override
    public List<AreaDto> getAreaByNames(List<String> names){
        if(CollectionUtils.isEmpty(names)){
            return Lists.newArrayList();
        }
        List<AreaDto> areaDtoList = Lists.newArrayList();
        QueryWrapper<AreaEo> queryWrapper = new QueryWrapper<AreaEo>();
        queryWrapper.in("name",names);
        List<AreaEo> areaEos = areaMapper.selectList(queryWrapper);
        if(CollectionUtils.isEmpty(areaEos)){
            return areaDtoList;
        }
        DtoHelper.eoList2DtoList(areaEos,areaDtoList,AreaDto.class);
        return areaDtoList;
    }

}
