/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.enums;

import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicInventoryBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicTradeBusinessTypeEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum SapCenterTypeEnum {
    DICT_ALLOT_STAFF_BORROW("71003", "Z31", "\u5458\u5de5\u501f\u673a", PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_OPPORTUNITY.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_OPPORTUNITY.getStatement()),
    DICT_ALLOT_STAFF_RETURN("71004", "Z32", "\u5458\u5de5\u8fd8\u673a", PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_ALSO.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_ALSO.getStatement()),
    DICT_ALLOT_PRODUCTION_BORROW("71001", "Z31", "\u8bd5\u4ea7\u673a\u501f\u7528", PcpBasicInventoryBusinessTypeEnum.TRANSFER_BORROW_MACHINE.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_BORROW_MACHINE.getStatement()),
    DICT_ALLOT_PRODUCTION_RETURN("71002", "Z32", "\u8bd5\u4ea7\u673a\u5f52\u8fd8", PcpBasicInventoryBusinessTypeEnum.TRANSFER_RETURN_PILOT_MACHINE.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_RETURN_PILOT_MACHINE.getStatement()),
    DICT_ALLOT_PURCHASE_101("61001", "101", "\u91c7\u8d2d\u5165\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_IN.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_IN.getStatement()),
    DICT_ALLOT_PURCHASE_105("61001", "105", "\u91c7\u8d2d\u5165\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_IN.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_IN.getStatement()),
    DICT_ALLOT_PURCHASE_162("61001", "162", "\u91c7\u8d2d\u5165\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_IN.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_IN.getStatement()),
    DICT_ALLOT_PURCHASE_123("61001", "123", "\u91c7\u8d2d\u5165\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_IN.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_IN.getStatement()),
    DICT_ALLOT_PURCHASE_RETURN_102("61002", "102", "\u91c7\u8d2d\u9000\u8d27", PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_OUT.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_OUT.getStatement()),
    DICT_ALLOT_PURCHASE_RETURN_106("61002", "106", "\u91c7\u8d2d\u9000\u8d27", PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_OUT.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_OUT.getStatement()),
    DICT_ALLOT_PURCHASE_RETURN_161("61002", "161", "\u91c7\u8d2d\u9000\u8d27", PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_OUT.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_OUT.getStatement()),
    DICT_ALLOT_PURCHASE_RETURN_122("61002", "122", "\u91c7\u8d2d\u9000\u8d27", PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_OUT.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_PURCHASE_OUT.getStatement()),
    DICT_ALLOT_COST_CENTER_IN("61004", "202", "\u6210\u672c\u4e2d\u5fc3\u5165\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_COST_CENTER_IN.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_COST_CENTER_IN.getStatement()),
    DICT_ALLOT_COST_CENTER_OUT("61003", "201", "\u6210\u672c\u4e2d\u5fc3\u51fa\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_COST_CENTER_OUT.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_COST_CENTER_OUT.getStatement()),
    DICT_ALLOT_ONE_STEP_TRANSFER("61005", "311", "\u4e00\u6b65\u8c03\u62e8", PcpBasicInventoryBusinessTypeEnum.SAP_STEP_TO_ALLOCATE.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_STEP_TO_ALLOCATE.getStatement()),
    DICT_ALLOT_ONE_STEP_TRANSFER_WRITE_OFF("61014", "312", "SAP\u4e00\u6b65\u8c03\u62e8\u51b2\u9500", PcpBasicInventoryBusinessTypeEnum.SAP_STEP_TO_ALLOCATE_WRITE_OFF.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_STEP_TO_ALLOCATE_WRITE_OFF.getStatement()),
    DICT_ALLOT_TUO_WAI_OUT("61006", "541", "\u6258\u5916\u51fa\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_ENTRUST_OUT.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_ENTRUST_OUT.getStatement()),
    DICT_ALLOT_SCRAP_IN("61013", "552", "\u62a5\u5e9f\u51fa\u5e93\u51b2\u9500", PcpBasicInventoryBusinessTypeEnum.SAP_JOE_FOR_OUTBOUND.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_JOE_FOR_OUTBOUND.getStatement()),
    DICT_ALLOT_TUO_WAI_IN("61012", "542", "\u6258\u5916\u5165\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_JOE_OUTSIDE_IN.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_JOE_OUTSIDE_IN.getStatement()),
    DICT_ALLOT_SCRAP_OUT("61007", "551", "\u62a5\u5e9f\u51fa\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_SCRAP_OUT.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_SCRAP_OUT.getStatement()),
    DICT_ALLOT_INVENTORY_PROFIT("61009", "702", "\u76d8\u76c8", PcpBasicInventoryBusinessTypeEnum.SAP_INVENTORY_LOSSES_IN.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_INVENTORY_LOSSES_IN.getStatement()),
    DICT_ALLOT_INVENTORY_LOSSES("61008", "701", "\u76d8\u4e8f", PcpBasicInventoryBusinessTypeEnum.SAP_INVENTORY_LOSSES_OUT.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_INVENTORY_LOSSES_OUT.getStatement()),
    DICT_ALLOT_DISMANTLE_OUT("61010", "Z01", "\u62c6\u673a\u51fa\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_FINISHED_PRODUCT_IN_STORAGE.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_FINISHED_PRODUCT_IN_STORAGE.getStatement()),
    DICT_ALLOT_DISMANTLE_IN("61011", "Z02", "\u62c6\u673a\u5165\u5e93", PcpBasicInventoryBusinessTypeEnum.SAP_DISMANTLE_IN.getGroupCode(), PcpBasicInventoryBusinessTypeEnum.SAP_DISMANTLE_IN.getStatement()),
    DEMO_RECIPIENTS("1021", "Z76", "\u6f14\u793a\u9886\u7528", PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_DEMONSTRATE_RECIPIENTS.getGroupCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_DEMONSTRATE_RECIPIENTS.getStatement()),
    PACKAGE_RECIPIENTS("1022", "Z35", "\u5305\u6750\u9886\u7528", PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getGroupCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getStatement()),
    DEVLOPMENT_RECIPIENTS("1023", "Z29", "\u7814\u53d1\u9886\u7528", PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_DEVELOPMENT_ACQUISITION.getGroupCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_DEVELOPMENT_ACQUISITION.getStatement()),
    SALES_OUTBOUND_MAINTENANCE_MATERIALS("1016", "Z33", "\u7ef4\u4fee\u9886\u6599", PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_MAINTENANCE_MATERIALS.getGroupCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_MAINTENANCE_MATERIALS.getStatement()),
    REFUND_ORDER_MAINTENANCE_MATERIALS("21016", "Z34", "\u7ef4\u4fee\u9886\u6599", PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_MAINTENANCE_MATERIALS.getGroupCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_MAINTENANCE_MATERIALS.getStatement()),
    REFUND_ORDER_DEMONSTRATE_RECIPIENTS("21021", "Z77", "\u6f14\u793a\u9886\u7528", PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_DEMONSTRATE_RECIPIENTS.getGroupCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_DEMONSTRATE_RECIPIENTS.getStatement()),
    REFUND_ORDER_PACKAGING_RECIPIENTS("21022", "Z36", "\u5305\u6750\u9886\u7528", PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_PACKAGING_RECIPIENTS.getGroupCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_PACKAGING_RECIPIENTS.getStatement()),
    REFUND_ORDER_DEVELOPMENT_ACQUISITION("21023", "Z30", "\u7814\u53d1\u9886\u6599", PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_DEVELOPMENT_ACQUISITION.getGroupCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_DEVELOPMENT_ACQUISITION.getStatement()),
    ALLOT_PRODUCTION_RECEIVE_OUT("1020", "Z94", "\u8bd5\u4ea7\u673a\u53d1\u8d27", PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_TRIAL_PRODUCTION.getGroupCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_TRIAL_PRODUCTION.getStatement()),
    ALLOT_PRODUCTION_RECEIVE_IN("21020", "Z95", "\u8bd5\u4ea7\u673a\u53d1\u8d27", PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_TRIAL_PRODUCTION.getGroupCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_TRIAL_PRODUCTION.getStatement()),
    SALES_OUTBOUND_MARKETING_MATERIAL("1013", "Z76", "\u8425\u9500\u7269\u6599", PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_MARKETING_MATERIAL.getGroupCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_MARKETING_MATERIAL.getStatement());

    private String centerType;
    private String sapType;
    private String desc;
    private String jumpDocumentType;
    private String jumpDocumentName;
    private static final Map<String, String> CENTER_MAP;
    private static final Map<String, String> SAP_MAP;
    private static final Map<String, String> RECIPIENTS_MAP;

    public static String getSapType(String centerTpe) {
        return RECIPIENTS_MAP.get(centerTpe);
    }

    public static String getSapTypeByCenterType(String centerTpe) {
        return CENTER_MAP.get(centerTpe);
    }

    public static String getSCenterTypeBySapType(String sapType) {
        return SAP_MAP.get(sapType);
    }

    public static SapCenterTypeEnum getBySapType(String sapType) {
        for (SapCenterTypeEnum typeEnum : SapCenterTypeEnum.values()) {
            if (!Objects.equals(sapType, typeEnum.getSapType())) continue;
            return typeEnum;
        }
        return null;
    }

    private SapCenterTypeEnum(String centerType, String sapType, String desc, String jumpDocumentType, String jumpDocumentName) {
        this.centerType = centerType;
        this.sapType = sapType;
        this.desc = desc;
        this.jumpDocumentType = jumpDocumentType;
        this.jumpDocumentName = jumpDocumentName;
    }

    public String getCenterType() {
        return this.centerType;
    }

    public void setCenterType(String centerType) {
        this.centerType = centerType;
    }

    public String getSapType() {
        return this.sapType;
    }

    public void setSapType(String sapType) {
        this.sapType = sapType;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getJumpDocumentType() {
        return this.jumpDocumentType;
    }

    public String getJumpDocumentName() {
        return this.jumpDocumentName;
    }

    static {
        CENTER_MAP = new HashMap<String, String>();
        SAP_MAP = new HashMap<String, String>();
        RECIPIENTS_MAP = new HashMap<String, String>();
        for (SapCenterTypeEnum typeEnum : SapCenterTypeEnum.values()) {
            CENTER_MAP.put(typeEnum.getCenterType(), typeEnum.getSapType());
            SAP_MAP.put(typeEnum.getSapType(), typeEnum.getCenterType());
            RECIPIENTS_MAP.put(typeEnum.getCenterType(), typeEnum.getSapType());
        }
    }
}

