/**
 * @(#)CsRelWarehouseAddReqDto.java 1.0 2022/01/10 11:13
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
* @Description CsRelWarehouseAddReqDto
*
* @author jingran
* @Date: 2022/01/10 11:13
* @since 1.0.0
*/
@ApiModel(value = "csRelWarehouseAddReqDto", description = "新增Dto")
public class CsRelWarehouseAddReqDto implements Serializable {

    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 */
    @ApiModelProperty(name="warehouseClassify",value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /** 仓库对应于不同层级仓库的类型 */
    @ApiModelProperty(name="warehouseType",value = "仓库对应于不同层级仓库的类型")
    private String warehouseType;
    /** 关联仓库ID */
    @ApiModelProperty(name="refWarehouseId",value = "关联仓库ID")
    private Long refWarehouseId;
    /** 关联仓库编码 */
    @ApiModelProperty(name="refWarehouseCode",value = "关联仓库编码")
    private String refWarehouseCode;
    /** 关联仓库名称 */
    @ApiModelProperty(name="refWarehouseName",value = "关联仓库名称")
    private String refWarehouseName;
    /** 关联仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓 */
    @ApiModelProperty(name="refWarehouseClassify",value = "关联仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String refWarehouseClassify;
    /** 关联仓库,对应于不同层级仓库的类型 */
    @ApiModelProperty(name="refWarehouseType",value = "关联仓库,对应于不同层级仓库的类型")
    private String refWarehouseType;
    /** 是否有效 enable-有效 disable-无效 */
    @ApiModelProperty(name="validFlag",value = "是否有效 enable-有效 disable-无效")
    private String validFlag;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseClassify() {
        return warehouseClassify;
    }

    public void setWarehouseClassify(String warehouseClassify) {
        this.warehouseClassify = warehouseClassify;
    }

    public String getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(String warehouseType) {
        this.warehouseType = warehouseType;
    }

    public Long getRefWarehouseId() {
        return refWarehouseId;
    }

    public void setRefWarehouseId(Long refWarehouseId) {
        this.refWarehouseId = refWarehouseId;
    }

    public String getRefWarehouseCode() {
        return refWarehouseCode;
    }

    public void setRefWarehouseCode(String refWarehouseCode) {
        this.refWarehouseCode = refWarehouseCode;
    }

    public String getRefWarehouseName() {
        return refWarehouseName;
    }

    public void setRefWarehouseName(String refWarehouseName) {
        this.refWarehouseName = refWarehouseName;
    }

    public String getRefWarehouseClassify() {
        return refWarehouseClassify;
    }

    public void setRefWarehouseClassify(String refWarehouseClassify) {
        this.refWarehouseClassify = refWarehouseClassify;
    }

    public String getRefWarehouseType() {
        return refWarehouseType;
    }

    public void setRefWarehouseType(String refWarehouseType) {
        this.refWarehouseType = refWarehouseType;
    }

    public String getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(String validFlag) {
        this.validFlag = validFlag;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}