package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 库存货品区分，主要是区分普通商品和活动商品
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/18 4:31 下午
 */
public enum CsInventoryCargoTypeEnum {

    /** 普通商品 **/
    COMMON("common","普通商品"),

    /** 活动商品 **/
    ACTIVITY("activity","活动商品"),
    ;

    private String code;

    private String desc;

    CsInventoryCargoTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsInventoryCargoTypeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsInventoryCargoTypeEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
