/**
 * @(#)CsInventoryAdjustApi.java 1.0 2022/01/15 15:59
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInventoryAdjustAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInventoryAdjustAuditReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * CsInventoryAdjustApi
 *
 * @author jingran
 * @Date: 2022/01/15 15:59
 * @since 1.0.0
 */
@Api(tags = {"库存调整单接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInventoryAdjust", url = "${yundt.cube.center.inventory.api:}")
public interface
ICsInventoryAdjustApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "新增库存调整单", notes = "新增库存调整单")
    RestResponse<Long> add(@Validated @RequestBody CsInventoryAdjustAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改库存调整单", notes = "修改库存调整单")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsInventoryAdjustAddReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除 - 【单元测试】", notes = "删除 - 【单元测试】")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    @PostMapping(value = "/audit", produces = "application/json")
    @ApiOperation(value = "批量审核调整单", notes = "批量审核调整单")
    RestResponse<Void> audit(@Validated @RequestBody CsInventoryAdjustAuditReqDto auditReqDto);


}